/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.openliberty.grpc.internal.client.config.GrpcClientConfigHolder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;

public class LibertyHeaderPropagationSupport {
    private static final TraceComponent tc = Tr.register(LibertyHeaderPropagationSupport.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.resources.grpcclientmessages");

    public static void handleHeaderPropagation(String host, MethodDescriptor method, Metadata headerMap) {
        List<String> headerNames;
        String headersToPropagate = GrpcClientConfigHolder.getHeaderPropagationSupport(host, method.getFullMethodName());
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checking header propagation for " + host + "$" + method.getFullMethodName()), (Object[])new Object[0]);
        }
        if (headersToPropagate == null || headersToPropagate.isEmpty()) {
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("no header propagation configured for " + host + "/" + method.getFullMethodName()), (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("propagating headers: " + headersToPropagate), (Object[])new Object[0]);
        }
        if (!(headerNames = Arrays.asList(headersToPropagate.split("\\s*,\\s*"))).isEmpty()) {
            for (String headerName : headerNames) {
                Enumeration<String> headerValues = LibertyHeaderPropagationSupport.getThreadLocalRequestHeaders(headerName);
                if (headerValues == null) continue;
                while (headerValues.hasMoreElements()) {
                    String headerValue = headerValues.nextElement();
                    LibertyHeaderPropagationSupport.addHeader(headerName, headerValue, headerMap);
                }
            }
        }
    }

    private static Enumeration<String> getThreadLocalRequestHeaders(String headerName) {
        WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)false);
        Enumeration headerValues = null;
        if (reqState != null) {
            headerValues = reqState.getCurrentThreadsIExtendedRequest().getIRequest().getHeaders(headerName.toLowerCase());
        }
        return headerValues;
    }

    private static void addHeader(String headerName, String headerValue, Metadata headers) {
        Metadata.Key key = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        headers.put(key, (Object)headerValue);
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addHeader " + headerName + " with value " + headerValue), (Object[])new Object[0]);
        }
    }
}

