/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.DebugUtils;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATEndpoint;
import com.ibm.ws.wsat.common.impl.WSATParticipantState;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATParticipant
extends WSATEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = WSATParticipant.class.getName();
    private static final TraceComponent TC = Tr.register(WSATParticipant.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private final String globalId;
    private final String participantId;
    private transient WSATParticipantState state = WSATParticipantState.ACTIVE;
    private transient WSATCoordinator coordinator;

    public WSATParticipant(String tranId, String partId, EndpointReferenceType epr) {
        super(epr);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"WSATParticipant:\nglobalId:\n{0}\nparticipantId:\n{1}\nEPR:\n{2}", (Object[])new Object[]{tranId, partId, DebugUtils.printEPR(epr)});
        }
        this.globalId = tranId;
        this.participantId = partId;
    }

    @Trivial
    public String getId() {
        return this.participantId;
    }

    @Trivial
    public String getGlobalId() {
        return this.globalId;
    }

    @Trivial
    public WSATCoordinator getCoordinator() {
        return this.coordinator;
    }

    @Trivial
    public void setCoordinator(WSATCoordinator coord) {
        this.coordinator = coord;
    }

    public synchronized void setState(WSATParticipantState newState) {
        this.state = newState;
    }

    public synchronized void setResponse(WSATParticipantState newState) {
        this.state = newState;
        this.notifyAll();
    }

    public synchronized WSATParticipantState waitResponse(long timeoutMills, WSATParticipantState ... responses) {
        List<WSATParticipantState> responseList = Arrays.asList(responses);
        if (timeoutMills <= 0L) {
            while (!responseList.contains((Object)this.state)) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.common.impl.WSATParticipant", (String)"98", (Object)this, (Object[])new Object[]{timeoutMills, responses});
                }
            }
        } else {
            long now = System.nanoTime() / 1000000L;
            long expiry = now + timeoutMills;
            while (now < expiry && !responseList.contains((Object)this.state)) {
                try {
                    this.wait(expiry - now);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.common.impl.WSATParticipant", (String)"107", (Object)this, (Object[])new Object[]{timeoutMills, responses});
                }
                now = System.nanoTime() / 1000000L;
            }
        }
        return responseList.contains((Object)this.state) ? this.state : WSATParticipantState.TIMEOUT;
    }

    public void remove() {
        WSATTransaction tran = WSATTransaction.getCoordTran(this.globalId);
        if (tran != null) {
            tran.removeParticipant(this.participantId);
        }
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && other instanceof WSATParticipant) {
            WSATParticipant otherPart = (WSATParticipant)other;
            result = this.globalId.equals(otherPart.globalId) && this.participantId.equals(otherPart.participantId);
        }
        return result;
    }

    public int hashCode() {
        return this.globalId.hashCode() * 31 + this.participantId.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.globalId + "/" + this.participantId + " (" + (Object)((Object)this.state) + ")";
    }
}

