/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.JavaScriptUtils;
import com.ibm.ws.security.common.web.WebSSOUtils;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.pkce.ProofKeyForCodeExchangeHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequest;
import io.openliberty.security.oidcclientcore.authentication.AuthorizationRequestParameters;
import io.openliberty.security.oidcclientcore.exceptions.OidcUrlNotHttpsException;
import io.openliberty.security.oidcclientcore.storage.CookieBasedStorage;
import io.openliberty.security.oidcclientcore.storage.CookieStorageProperties;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.StorageProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcAuthorizationRequest
extends AuthorizationRequest {
    public static final TraceComponent tc = Tr.register(OidcAuthorizationRequest.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    ConvergedClientConfig clientConfig;
    WebSSOUtils webSsoUtils = new WebSSOUtils();
    static final long serialVersionUID = -1417936827918701085L;

    public OidcAuthorizationRequest(HttpServletRequest request, HttpServletResponse response, ConvergedClientConfig clientConfig) {
        super(request, response, clientConfig.getClientId());
        this.clientConfig = clientConfig;
        this.storage = new CookieBasedStorage(request, response);
    }

    @FFDCIgnore(value={OidcUrlNotHttpsException.class, Exception.class})
    public ProviderAuthenticationResult sendRequest() {
        try {
            return super.sendRequest();
        }
        catch (OidcUrlNotHttpsException e) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{e.getUrl()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"ERROR_SENDING_AUTHORIZATION_REQUEST", (Object[])new Object[]{this.clientId, e.getMessage()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
    }

    protected String getAuthorizationEndpoint() throws OidcUrlNotHttpsException {
        String authorizationEndpoint = this.clientConfig.getAuthorizationEndpointUrl();
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(this.clientConfig, authorizationEndpoint)) {
            throw new OidcUrlNotHttpsException(authorizationEndpoint, this.clientId);
        }
        return authorizationEndpoint;
    }

    protected String getRedirectUrl() throws OidcUrlNotHttpsException {
        String redirectUrl = OIDCClientAuthenticatorUtil.setRedirectUrlIfNotDefined(this.request, this.clientConfig);
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(this.clientConfig, redirectUrl)) {
            throw new OidcUrlNotHttpsException(redirectUrl, this.clientId);
        }
        return redirectUrl;
    }

    protected boolean shouldCreateSession() {
        return this.clientConfig.createSession();
    }

    protected String createStateValueForStorage(String state) {
        return OidcStorageUtils.createStateStorageValue((String)state, (String)this.clientConfig.getClientSecret());
    }

    protected String createNonceValueForStorage(String nonce, String state) {
        return OidcStorageUtils.createNonceStorageValue((String)nonce, (String)state, (String)this.clientConfig.getClientSecret());
    }

    protected StorageProperties getStateStorageProperties() {
        CookieStorageProperties props = new CookieStorageProperties();
        props.setStorageLifetimeSeconds((int)this.clientConfig.getAuthenticationTimeLimitInSeconds());
        if (this.shouldCookiesBeSecure()) {
            props.setSecure(true);
        }
        return props;
    }

    protected StorageProperties getNonceStorageProperties() {
        CookieStorageProperties props = new CookieStorageProperties();
        return props;
    }

    protected StorageProperties getOriginalRequestUrlStorageProperties() {
        CookieStorageProperties props = new CookieStorageProperties();
        props.setStorageLifetimeSeconds((int)this.clientConfig.getAuthenticationTimeLimitInSeconds());
        if (this.shouldCookiesBeSecure()) {
            props.setSecure(true);
        }
        return props;
    }

    private boolean shouldCookiesBeSecure() {
        boolean isHttpsRequest = this.request.getScheme().toLowerCase().contains("https");
        return this.clientConfig.isHttpsRequired() && isHttpsRequest;
    }

    /*
     * WARNING - void declaration
     */
    protected ProviderAuthenticationResult redirectToAuthorizationEndpoint(String state, String redirectUrl) {
        String authzEndPointUrlWithQuery = null;
        try {
            ProviderAuthenticationResult result = this.checkIfOpenIdScopeIsMissing();
            if (result != null) {
                return result;
            }
            String acr_values = this.request.getParameter("acr_values");
            authzEndPointUrlWithQuery = this.buildAuthorizationUrlWithQuery((OidcClientRequest)this.request.getAttribute("com.ibm.wsspi.security.oidc.client.request"), state, redirectUrl, acr_values);
            this.savePostParameters();
            if (this.clientConfig.isClientSideRedirect()) {
                String domain = this.webSsoUtils.getSsoDomain(this.request);
                this.doClientSideRedirect(authzEndPointUrlWithQuery, state, domain);
            } else {
                this.storeOriginalRequestUrl(state);
            }
        }
        catch (UnsupportedEncodingException result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcAuthorizationRequest", (String)"160", (Object)((Object)this), (Object[])new Object[]{state, redirectUrl});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_AUTHORIZE_ERR", (Object[])new Object[]{this.clientId, e.getLocalizedMessage(), "UTF-8"});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        catch (IOException e) {
            void ioe;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcAuthorizationRequest", (String)"163", (Object)((Object)this), (Object[])new Object[]{state, redirectUrl});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_AUTHORIZE_ERR", (Object[])new Object[]{this.clientId, ioe.getLocalizedMessage(), "UTF-8"});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return new ProviderAuthenticationResult(AuthResult.REDIRECT_TO_PROVIDER, 200, null, null, null, authzEndPointUrlWithQuery);
    }

    ProviderAuthenticationResult checkIfOpenIdScopeIsMissing() {
        boolean scopeMissing;
        boolean openidScopeMissing = !this.clientConfig.isSocial() && !this.isOpenIDScopeSpecified();
        boolean bl = scopeMissing = this.clientConfig.getScope() == null || this.clientConfig.getScope().length() == 0;
        if (openidScopeMissing || scopeMissing) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_REQUEST_MISSING_OPENID_SCOPE", (Object[])new Object[]{this.clientId, this.clientConfig.getScope()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return null;
    }

    private boolean isOpenIDScopeSpecified() {
        String scope = null;
        scope = this.clientConfig.getScope();
        return scope.contains("openid");
    }

    String buildAuthorizationUrlWithQuery(OidcClientRequest oidcClientRequest, String state, String redirect_url, String acr_values) throws UnsupportedEncodingException {
        String strResponse_type = "code";
        boolean isImplicit = false;
        if ("implicit".equals(this.clientConfig.getGrantType())) {
            isImplicit = true;
            strResponse_type = this.clientConfig.getResponseType();
        }
        String clientIdParam = this.clientId == null ? "" : this.clientId;
        AuthorizationRequestParameters authzParameters = new AuthorizationRequestParameters(this.clientConfig.getAuthorizationEndpointUrl(), this.clientConfig.getScope(), strResponse_type, clientIdParam, redirect_url, state);
        this.addOptionalParameters(authzParameters, oidcClientRequest, state, acr_values, isImplicit);
        return authzParameters.buildRequestUrl();
    }

    void addOptionalParameters(AuthorizationRequestParameters authzParameters, OidcClientRequest oidcClientRequest, String state, String acr_values, boolean isImplicit) throws UnsupportedEncodingException {
        String resources;
        String pkceCodeChallengeMethod;
        if (this.clientConfig.isNonceEnabled() || isImplicit) {
            String nonceValue = OidcUtil.generateRandom(20);
            this.storeNonceValue(nonceValue, state);
            authzParameters.addParameter("nonce", nonceValue);
        }
        if (acr_values != null && !acr_values.isEmpty()) {
            authzParameters.addParameter("acr_values", acr_values);
        } else if (this.isACRConfigured()) {
            authzParameters.addParameter("acr_values", this.clientConfig.getAuthContextClassReference());
        }
        if (this.clientConfig.getPrompt() != null) {
            authzParameters.addParameter("prompt", this.clientConfig.getPrompt());
        }
        if ((pkceCodeChallengeMethod = this.clientConfig.getPkceCodeChallengeMethod()) != null && !"disabled".equals(pkceCodeChallengeMethod)) {
            this.addPkceParameters(pkceCodeChallengeMethod, state, authzParameters);
        }
        if (isImplicit) {
            this.addImplicitParameters(authzParameters);
        }
        if ((resources = this.getResourcesParameter()) != null) {
            authzParameters.addParameter("resource", resources);
        }
        this.addCustomParams(authzParameters);
        this.addForwardLoginParams(authzParameters);
    }

    private boolean isACRConfigured() {
        boolean isACR = false;
        String acr_values = null;
        acr_values = this.clientConfig.getAuthContextClassReference();
        if (acr_values != null && !acr_values.isEmpty()) {
            isACR = true;
        }
        return isACR;
    }

    void addPkceParameters(String codeChallengeMethod, String state, AuthorizationRequestParameters authzParameters) {
        ProofKeyForCodeExchangeHelper pkceHelper = new ProofKeyForCodeExchangeHelper();
        pkceHelper.generateAndAddPkceParametersToAuthzRequest(codeChallengeMethod, state, authzParameters);
    }

    void addImplicitParameters(AuthorizationRequestParameters authzParameters) throws UnsupportedEncodingException {
        authzParameters.addParameter("response_mode", "form_post");
    }

    String getResourcesParameter() throws UnsupportedEncodingException {
        String resources = OIDCClientAuthenticatorUtil.getResources(this.clientConfig);
        if (resources != null && !resources.isEmpty()) {
            return resources;
        }
        return null;
    }

    private void addCustomParams(AuthorizationRequestParameters authzParameters) {
        HashMap<String, String> customParams = this.clientConfig.getAuthzRequestParams();
        if (customParams != null && !customParams.isEmpty()) {
            Set<Map.Entry<String, String>> entries = customParams.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                authzParameters.addParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    void addForwardLoginParams(AuthorizationRequestParameters authzParameters) {
        List<String> forwardAuthzParams = this.clientConfig.getForwardLoginParameter();
        if (forwardAuthzParams == null || forwardAuthzParams.isEmpty()) {
            return;
        }
        for (String entry : forwardAuthzParams) {
            String value;
            if (entry == null || (value = this.request.getParameter(entry)) == null) continue;
            authzParameters.addParameter(entry, value);
        }
    }

    void savePostParameters() {
        WebAppSecurityConfig webAppSecConfig = WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig();
        PostParameterHelper pph = new PostParameterHelper(webAppSecConfig);
        pph.save(this.request, this.response);
    }

    private void doClientSideRedirect(String loginURL, String state, String domain) throws IOException {
        this.response.setStatus(200);
        PrintWriter pw = this.response.getWriter();
        pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        pw.println("<head>");
        pw.println(this.createJavaScriptForRedirect(loginURL, state, domain));
        pw.println("<title>Redirect To OP</title> ");
        pw.println("</head>");
        pw.println("<body></body>");
        pw.println("</html>");
        this.response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, private, max-age=0");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("text/html; charset=UTF-8");
        pw.close();
    }

    private String createJavaScriptForRedirect(String loginURL, String state, String domain) {
        String cookieName = OidcStorageUtils.getOriginalReqUrlStorageKey((String)state);
        StringBuilder sb = new StringBuilder();
        String strDomain = "";
        if (domain != null && !domain.isEmpty()) {
            strDomain = "domain=" + domain + ";";
        }
        sb.append("<script type=\"text/javascript\" language=\"javascript\">").append("var loc=window.location.href;").append("document.cookie=\"").append(cookieName).append("=\"").append("+loc+").append("\";" + strDomain + " path=/;");
        JavaScriptUtils jsUtils = new JavaScriptUtils();
        String cookieProps = jsUtils.createHtmlCookiePropertiesString(jsUtils.getWebAppSecurityConfigCookieProperties());
        sb.append(cookieProps);
        sb.append("\"</script>");
        sb.append("<script type=\"text/javascript\" language=\"javascript\">").append("window.location.replace(\"" + loginURL + "\")").append("</script>");
        String js = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createJavaScriptForRedirect returns [" + js + "]"), (Object[])new Object[0]);
        }
        return js;
    }
}

