/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.krb5.Krb5Common;
import com.ibm.ws.security.s4u2proxy.KerberosExtService;
import com.ibm.ws.security.token.krb5.Krb5Helper;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={SpnegoHelperProxy.class}, name="SpnegoHelperProxy", configurationPid={"com.ibm.ws.security.spnego.internal.SpnegoHelperProxy"}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class SpnegoHelperProxy {
    private static Map<String, Object> delegateSubjectCache;
    private static final int MAX_CACHE = 10;
    static final String KEY_KERBEROS_EXT_SERVICE = "KerberosExtService";
    static boolean supportJDK;
    protected static final AtomicServiceReference<KerberosExtService> kerberosExtServiceRef;
    static final long serialVersionUID = -2247750394980578397L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static GSSCredential getDelegateGSSCredUsingS4U2proxy(String userPrincipalName, GSSContext delegateGSSContext, String delegateServiceSpn) throws GSSException {
        Krb5Helper.checkUpn(userPrincipalName);
        KerberosExtService kerberosExtService = SpnegoHelperProxy.getKerberosExtService();
        return kerberosExtService.getDelegateGSSCredUsingS4U2proxy(userPrincipalName, delegateGSSContext, delegateServiceSpn);
    }

    public static Subject doKerberosLogin(String delegateSpn, String krb5Keytab) throws LoginException, GSSException {
        KerberosExtService kerberosExtService = SpnegoHelperProxy.getKerberosExtService();
        return kerberosExtService.doKerberosLogin(delegateSpn, krb5Keytab);
    }

    public static boolean isS4U2proxyEnabled() {
        KerberosExtService kerberosExtService = (KerberosExtService)kerberosExtServiceRef.getService();
        if (kerberosExtService != null) {
            return kerberosExtService.isS4U2proxyEnable();
        }
        return false;
    }

    private static KerberosExtService getKerberosExtService() throws GSSException {
        KerberosExtService kerberosExtService;
        if (delegateSubjectCache == null) {
            delegateSubjectCache = new HashMap<String, Object>(10);
        }
        if ((kerberosExtService = (KerberosExtService)kerberosExtServiceRef.getService()) == null) {
            Krb5Helper.serviceNotAvailableException();
        }
        Krb5Helper.unsuportJdkErrorMsg(supportJDK);
        return kerberosExtService;
    }

    @Reference(service=KerberosExtService.class, name="KerberosExtService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC)
    protected void setKerberosExtService(ServiceReference<KerberosExtService> ref) {
        kerberosExtServiceRef.setReference(ref);
    }

    protected void unsetKerberosExtService(ServiceReference<KerberosExtService> ref) {
        kerberosExtServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        boolean bl = supportJDK = Krb5Common.IBM_KRB5_LOGIN_MODULE_AVAILABLE || Krb5Common.OTHER_KRB5_LOGIN_MODULE_AVAILABLE;
        if (supportJDK) {
            kerberosExtServiceRef.activate(cc);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        kerberosExtServiceRef.deactivate(cc);
        supportJDK = false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.spnego.internal.SpnegoHelperProxy", SpnegoHelperProxy.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
        delegateSubjectCache = null;
        supportJDK = false;
        kerberosExtServiceRef = new AtomicServiceReference(KEY_KERBEROS_EXT_SERVICE);
    }
}

