/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.se;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.scanner.ResourceScanner;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.core.se.ResteasySeConfiguration;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServers;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyDeployment;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ResteasySeInstance
implements SeBootstrap.Instance {
    private static final Logger LOGGER;
    private final EmbeddedServer server;
    private final SeBootstrap.Configuration configuration;
    private final ExecutorService executor;
    static final long serialVersionUID = 3769862252526719942L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ResteasySeInstance(EmbeddedServer server, SeBootstrap.Configuration configuration, ExecutorService executor) {
        this.server = server;
        this.configuration = configuration;
        this.executor = executor;
    }

    public static CompletionStage<SeBootstrap.Instance> create(Application application, SeBootstrap.Configuration configuration) {
        ContextualExecutorService executor = ContextualExecutors.threadPool();
        return CompletableFuture.supplyAsync(() -> {
            try {
                SeBootstrap.Configuration config = ResteasySeConfiguration.from(configuration);
                EmbeddedServer server = EmbeddedServers.findServer(config);
                ResteasyDeployment deployment = server.getDeployment();
                deployment.setRegisterBuiltin((Boolean)ConfigurationOption.REGISTER_BUILT_INS.getValue(config));
                deployment.setApplication(application);
                try {
                    ResteasySeInstance.scanForResources(deployment, application, config);
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.failedToScanResources(e);
                }
                deployment.start();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Application %s used for %s", (Object)deployment.getApplication(), (Object)server);
                    deployment.getResourceClasses().forEach(name -> LOGGER.debugf("Resource %s found for %s", name, (Object)server));
                    deployment.getProviderClasses().forEach(name -> LOGGER.debugf("Provider %s found for %s", name, (Object)server));
                }
                server.start(config);
                return new ResteasySeInstance(server, config, executor);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }, executor);
    }

    public static CompletionStage<SeBootstrap.Instance> create(Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
        ContextualExecutorService executor = ContextualExecutors.threadPool();
        return CompletableFuture.supplyAsync(() -> {
            try {
                SeBootstrap.Configuration config = ResteasySeConfiguration.from(configuration);
                EmbeddedServer server = EmbeddedServers.findServer(config);
                ResteasyDeployment deployment = server.getDeployment();
                deployment.setRegisterBuiltin((Boolean)ConfigurationOption.REGISTER_BUILT_INS.getValue(config));
                deployment.setApplicationClass(applicationClass.getName());
                deployment.start();
                Application application = deployment.getApplication();
                try {
                    ResteasySeInstance.scanForResources(deployment, application, config);
                    deployment.registration();
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.failedToScanResources(e);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Application %s used for %s", (Object)deployment.getApplication(), (Object)server);
                    deployment.getResourceClasses().forEach(name -> LOGGER.debugf("Resource %s found for %s", name, (Object)server));
                    deployment.getProviderClasses().forEach(name -> LOGGER.debugf("Provider %s found for %s", name, (Object)server));
                }
                server.start(config);
                return new ResteasySeInstance(server, config, executor);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }, executor);
    }

    public SeBootstrap.Configuration configuration() {
        return this.configuration;
    }

    public CompletionStage<SeBootstrap.Instance.StopResult> stop() {
        CompletableFuture cf = new CompletableFuture();
        this.executor.submit(() -> {
            try {
                this.server.stop();
                cf.complete(new SeBootstrap.Instance.StopResult(){
                    static final long serialVersionUID = -4718765811980537213L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public <T> T unwrap(Class<T> nativeClass) {
                        if (nativeClass != null && nativeClass.isInstance(ResteasySeInstance.this.server)) {
                            return nativeClass.cast(ResteasySeInstance.this.server);
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.se.ResteasySeInstance$1", 1.class, null, null);
                    }
                });
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        });
        return cf.whenComplete((stopResult, throwable) -> this.executor.shutdownNow());
    }

    public <T> T unwrap(Class<T> nativeClass) {
        if (nativeClass != null && nativeClass.isInstance(this.server)) {
            return nativeClass.cast(this.server);
        }
        return null;
    }

    private static void scanForResources(ResteasyDeployment deployment, Application application, SeBootstrap.Configuration configuration) throws IOException {
        if (application.getClasses() != null && !application.getClasses().isEmpty() || application.getSingletons() != null && !application.getSingletons().isEmpty()) {
            return;
        }
        Index index = (Index)ConfigurationOption.JANDEX_INDEX.getValue(configuration);
        ResourceScanner resourceScanner = index == null ? ResourceScanner.fromClassPath(ResteasySeInstance.classLoader(application.getClass()), (Predicate)ConfigurationOption.JANDEX_CLASS_PATH_FILTER.getValue(configuration)) : ResourceScanner.of(index);
        if (ResteasySeInstance.loadServices(application.getProperties())) {
            Set resources = resourceScanner.getResources().stream().filter(name -> !AsynchronousDispatcher.class.getName().equals(name)).collect(Collectors.toSet());
            deployment.getScannedResourceClasses().addAll(resources);
            deployment.getScannedProviderClasses().addAll(resourceScanner.getProviders());
        }
    }

    private static ClassLoader classLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ResteasySeInstance.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ResteasySeInstance.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }

    private static ClassLoader classLoader(Class<?> c) {
        if (c == null) {
            return ResteasySeInstance.classLoader();
        }
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(c::getClassLoader);
    }

    private static boolean loadServices(Map<String, Object> props) {
        Object value = props.get("jakarta.ws.rs.loadServices");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.se.ResteasySeInstance", ResteasySeInstance.class, null, null);
        LOGGER = Logger.getLogger(ResteasySeInstance.class);
    }
}

