/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import org.jboss.resteasy.spi.config.Configuration;
import org.jboss.resteasy.spi.config.ConfigurationFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class PortProvider {
    private static final int DEFAULT_PORT = 8081;
    private static final String ENV_VAR_NAME = "RESTEASY_PORT";
    private static final String PROPERTY_NAME = "org.jboss.resteasy.port";
    private static final String DEFAULT_HOST = "localhost";
    private static final String ENV_VAR_HOSTNAME = "RESTEASY_HOST";
    private static final String PROPERTY_HOSTNAME = "org.jboss.resteasy.host";
    static final long serialVersionUID = 5739253195780241687L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static int getPort() {
        Configuration configuration = ConfigurationFactory.getInstance().getConfiguration();
        int port = -1;
        String property = configuration.getOptionalValue(ENV_VAR_NAME, String.class).orElse(null);
        if (property != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1 && (property = (String)configuration.getOptionalValue(PROPERTY_NAME, String.class).orElse(null)) != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1) {
            port = 8081;
        }
        return port;
    }

    public static String getHost() {
        Configuration configuration = ConfigurationFactory.getInstance().getConfiguration();
        String host = null;
        String property = configuration.getOptionalValue(ENV_VAR_HOSTNAME, String.class).orElse(null);
        if (property != null) {
            host = property;
        }
        if (host == null && (property = (String)configuration.getOptionalValue(PROPERTY_HOSTNAME, String.class).orElse(null)) != null) {
            host = property;
        }
        if (host == null) {
            host = DEFAULT_HOST;
        }
        return host;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.util.PortProvider", PortProvider.class, null, null);
    }
}

