/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.common.impl.WSATTransaction;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.WSATFault;
import com.ibm.ws.wsat.service.WSATFaultException;
import com.ibm.ws.wsat.service.WSATUtil;
import com.ibm.ws.wsat.service.WebClient;
import com.ibm.ws.wsat.service.impl.ProtocolImpl;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.ReferenceParametersType;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RegistrationImpl {
    private static final TraceComponent TC = Tr.register(RegistrationImpl.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final RegistrationImpl INSTANCE = new RegistrationImpl();
    private static final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private final ProtocolImpl protocolService = ProtocolImpl.getInstance();
    private static String ourRecoveryId;
    private EndpointReferenceType registrationEndpoint;
    static final long serialVersionUID = -6369875547101149898L;

    public static RegistrationImpl getInstance() {
        if (ourRecoveryId == null) {
            ourRecoveryId = tranService.getRecoveryId();
        }
        return INSTANCE;
    }

    public synchronized void setRegistrationEndpoint(EndpointReferenceType epr) {
        this.registrationEndpoint = epr;
        this.notifyAll();
    }

    public synchronized EndpointReferenceType getRegistrationEndpoint(String globalId) throws WSATException {
        while (this.registrationEndpoint == null) {
            try {
                this.wait(30000L);
                if (this.registrationEndpoint != null) continue;
                throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"NO_SERVICE_ENDPOINT_CWLIB0209", (Object[])new Object[0]));
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsat.service.impl.RegistrationImpl", (String)"81", (Object)this, (Object[])new Object[]{globalId});
            }
        }
        EndpointReferenceType epr = EndpointReferenceUtils.duplicate((EndpointReferenceType)this.registrationEndpoint);
        ReferenceParametersType refs = new ReferenceParametersType();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)globalId));
        String recoveryId = tranService.getRecoveryId();
        if (recoveryId != null && !recoveryId.isEmpty()) {
            refs.getAny().add(new JAXBElement(Constants.WS_WSAT_REC_REF, String.class, (Object)recoveryId));
        }
        epr.setReferenceParameters(refs);
        return epr;
    }

    public WSATContext activate(String globalId, long timeout, boolean recovery) throws WSATException {
        if (timeout < 0L) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"WSAT_TRAN_EXPIRED_CWLIB0203", (Object[])new Object[0]));
        }
        WSATTransaction wsatTran = new WSATTransaction(globalId, timeout, recovery);
        wsatTran.setRegistration(this.getRegistrationEndpoint(globalId));
        wsatTran.setCoordinator(this.protocolService.getCoordinatorEndpoint(globalId));
        WSATTransaction.putTran(wsatTran);
        return wsatTran.getContext();
    }

    public WSATTransaction activate(String globalId, EndpointReferenceType registration, long timeout, boolean recovery) throws WSATException {
        if (timeout < 0L) {
            throw new WSATException(Tr.formatMessage((TraceComponent)TC, (String)"WSAT_TRAN_EXPIRED_CWLIB0203", (Object[])new Object[0]));
        }
        WSATTransaction wsatTran = new WSATTransaction(globalId, timeout, recovery);
        wsatTran.setRegistration(registration);
        WSATTransaction.putTran(wsatTran);
        return wsatTran;
    }

    public EndpointReferenceType register(Map<String, String> wsatProperties, String globalId, EndpointReferenceType partEpr, String recoveryId) throws WSATException {
        if (recoveryId != null && ourRecoveryId != null && !recoveryId.equals(ourRecoveryId)) {
            EndpointReferenceType epr = this.rerouteRegistration(wsatProperties, globalId, partEpr);
            if (epr != null) {
                return epr;
            }
        } else {
            WSATTransaction wsatTran = WSATTransaction.getCoordTran(globalId);
            if (wsatTran != null) {
                WSATParticipant participant = wsatTran.addParticipant(partEpr);
                tranService.registerParticipant(globalId, participant);
                return participant.getCoordinator().getEndpointReference();
            }
        }
        throw new WSATFaultException(WSATFault.getCannotRegisterParticipant(Tr.formatMessage((TraceComponent)TC, (String)"NO_WSAT_TRAN_CWLIB0201", (Object[])new Object[]{globalId})));
    }

    /*
     * WARNING - void declaration
     */
    private EndpointReferenceType rerouteRegistration(Map<String, String> wsatProperties, String globalId, EndpointReferenceType epr) throws WSATException {
        String newAddr;
        String recoveryId;
        block4: {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)("REROUTE REGISTRATION Originally sent to: " + wsatProperties.get(Names.WSA_TO_QNAME.getLocalPart())), (Object[])new Object[0]);
            }
            recoveryId = wsatProperties.get(Constants.WS_WSAT_REC_REF.getLocalPart());
            newAddr = null;
            try {
                newAddr = tranService.getAddress(recoveryId);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsat.service.impl.RegistrationImpl", (String)"190", (Object)this, (Object[])new Object[]{wsatProperties, globalId, epr});
                if (!TC.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)TC, (String)"Can't get address for {0} {1}", (Object[])new Object[]{recoveryId, e});
            }
        }
        if (newAddr == null) {
            return null;
        }
        String toAddr = WSATUtil.createRedirectAddr(wsatProperties.get(Names.WSA_TO_QNAME.getLocalPart()), newAddr);
        EndpointReferenceType toEpr = WSATUtil.createEpr(toAddr, new String[0]);
        ReferenceParametersType refs = toEpr.getReferenceParameters();
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_CTX_REF, String.class, (Object)globalId));
        refs.getAny().add(new JAXBElement(Constants.WS_WSAT_REC_REF, String.class, (Object)recoveryId));
        WSATCoordinator coord = new WSATCoordinator(globalId, toEpr);
        WebClient webClient = WebClient.getWebClient(coord, null);
        webClient.setMisrouting(false);
        return webClient.register(epr);
    }

    public void registerParticipant(String globalId, WSATTransaction wsatTran) throws WSATException {
        EndpointReferenceType participant = this.protocolService.getParticipantEndpoint(globalId);
        WSATCoordinator wsatCoord = wsatTran.getRegistration();
        WebClient webClient = WebClient.getWebClient(wsatCoord, null);
        EndpointReferenceType coordinator = webClient.register(participant);
        WSATCoordinator remoteCoord = wsatTran.setCoordinator(coordinator);
        tranService.registerCoordinator(globalId, remoteCoord);
    }
}

