/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.DestinationSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.BrowserProxyQueue;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BrowserSessionProxy
extends DestinationSessionProxy
implements BrowserSession {
    private static String CLASS_NAME = BrowserSessionProxy.class.getName();
    private static final TraceComponent tc = SibTr.register(BrowserSessionProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private BrowserProxyQueue proxyQueue;
    private ReentrantReadWriteLock closeLock = null;
    private Object lock = new Object();

    protected BrowserSessionProxy(Conversation con, ConnectionProxy cp, CommsByteBuffer data, BrowserProxyQueue proxy, SIDestinationAddress destAddr) {
        super(con, cp);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{con, cp, data, proxy, destAddr});
        }
        this.setDestinationAddress(destAddr);
        this.inflateData(data);
        this.closeLock = cp.closeLock;
        this.proxyQueue = proxy;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage next() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"next");
        }
        this.checkAlreadyClosed();
        JsMessage message = null;
        Object object = this.lock;
        synchronized (object) {
            block12: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        message = this.proxyQueue.next();
                    }
                    catch (MessageDecodeFailedException mde) {
                        FFDCFilter.processException((Throwable)mde, (String)(CLASS_NAME + ".next"), (String)"1-005-0001", (Object)this);
                        SIResourceException coreException = new SIResourceException((Throwable)mde);
                        throw coreException;
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) break block12;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"interrupted exception");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"next", (Object)message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException, SIConnectionDroppedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        Object object = this.lock;
        synchronized (object) {
            block11: {
                if (!this.isClosed()) {
                    try {
                        this.closeLock.writeLock().lockInterruptibly();
                        try {
                            this.proxyQueue.close();
                            this.setClosed();
                        }
                        finally {
                            this.closeLock.writeLock().unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        if (!tc.isDebugEnabled()) break block11;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"interrupted exception");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        this.checkAlreadyClosed();
        Object object = this.lock;
        synchronized (object) {
            block10: {
                try {
                    this.closeLock.readLock().lockInterruptibly();
                    try {
                        this.proxyQueue.reset();
                    }
                    finally {
                        this.closeLock.readLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) break block10;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"interrupted exception");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }
}

