/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.api.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.MediaType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.SimpleViolationsContainer;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.validation.ConstraintTypeUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public abstract class ResteasyViolationException
extends ConstraintViolationException {
    private static final long serialVersionUID = 2623733139912277260L;
    public static final String SUPPRESS_VIOLATION_PATH = "resteasy.validation.suppress.path";
    private volatile List<CloneableMediaType> accept;
    private volatile Exception exception;
    private volatile List<ResteasyConstraintViolation> propertyViolations;
    private volatile List<ResteasyConstraintViolation> classViolations;
    private volatile List<ResteasyConstraintViolation> parameterViolations;
    private volatile List<ResteasyConstraintViolation> returnValueViolations;
    private volatile List<ResteasyConstraintViolation> allViolations;
    private volatile List<List<ResteasyConstraintViolation>> violationLists;
    private transient ConstraintTypeUtil util = this.getConstraintTypeUtil();
    private boolean suppressPath;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ResteasyViolationException(Set<? extends ConstraintViolation<?>> constraintViolations) {
        super(constraintViolations);
        this.checkSuppressPath();
        this.accept = new ArrayList<CloneableMediaType>();
        this.accept.add(CloneableMediaType.TEXT_PLAIN_TYPE);
    }

    public ResteasyViolationException(Set<? extends ConstraintViolation<?>> constraintViolations, List<MediaType> accept) {
        super(constraintViolations);
        this.checkSuppressPath();
        this.accept = ResteasyViolationException.toCloneableMediaTypeList(accept);
    }

    public ResteasyViolationException(SimpleViolationsContainer container) {
        this(container.getViolations());
        this.setException(container.getException());
    }

    public ResteasyViolationException(SimpleViolationsContainer container, List<MediaType> accept) {
        this(container.getViolations(), accept);
        this.setException(container.getException());
    }

    public ResteasyViolationException(String stringRep) {
        super(null);
        this.checkSuppressPath();
        this.convertFromString(stringRep);
    }

    public abstract ConstraintTypeUtil getConstraintTypeUtil();

    public List<MediaType> getAccept() {
        return ResteasyViolationException.toMediaTypeList(this.accept);
    }

    public void setAccept(List<MediaType> accept) {
        this.accept = ResteasyViolationException.toCloneableMediaTypeList(accept);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
        this.initCause(exception);
    }

    public List<ResteasyConstraintViolation> getViolations() {
        this.convertViolations();
        if (this.allViolations == null) {
            this.allViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
            this.allViolations.addAll(this.propertyViolations);
            this.allViolations.addAll(this.classViolations);
            this.allViolations.addAll(this.parameterViolations);
            this.allViolations.addAll(this.returnValueViolations);
        }
        return this.allViolations;
    }

    public List<ResteasyConstraintViolation> getPropertyViolations() {
        this.convertViolations();
        return this.propertyViolations;
    }

    public List<ResteasyConstraintViolation> getClassViolations() {
        this.convertViolations();
        return this.classViolations;
    }

    public List<ResteasyConstraintViolation> getParameterViolations() {
        this.convertViolations();
        return this.parameterViolations;
    }

    public List<ResteasyConstraintViolation> getReturnValueViolations() {
        this.convertViolations();
        return this.returnValueViolations;
    }

    public int size() {
        return this.getViolations().size();
    }

    public List<List<ResteasyConstraintViolation>> getViolationLists() {
        this.convertViolations();
        return this.violationLists;
    }

    public String toString() {
        this.convertViolations();
        StringBuffer sb = new StringBuffer();
        for (List<ResteasyConstraintViolation> violations : this.violationLists) {
            for (ResteasyConstraintViolation violation : violations) {
                sb.append(violation.toString()).append('\r');
            }
        }
        return sb.toString();
    }

    protected void convertFromString(String stringRep) {
        this.convertViolations();
        ByteArrayInputStream is = new ByteArrayInputStream(stringRep.getBytes());
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line = br.readLine();
            while (line != null) {
                ConstraintType.Type type = ConstraintType.Type.valueOf(line.substring(1, line.length() - 1));
                line = br.readLine();
                String path = line.substring(1, line.length() - 1);
                line = br.readLine();
                String message = line.substring(1, line.length() - 1);
                line = br.readLine();
                String value = line.substring(1, line.length() - 1);
                ResteasyConstraintViolation rcv = new ResteasyConstraintViolation(type, path, message, value);
                switch (type) {
                    case PROPERTY: {
                        this.propertyViolations.add(rcv);
                        break;
                    }
                    case CLASS: {
                        this.classViolations.add(rcv);
                        break;
                    }
                    case PARAMETER: {
                        this.parameterViolations.add(rcv);
                        break;
                    }
                    case RETURN_VALUE: {
                        this.returnValueViolations.add(rcv);
                        break;
                    }
                    default: {
                        throw new RuntimeException(Messages.MESSAGES.unexpectedViolationType(type));
                    }
                }
                line = br.readLine();
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.MESSAGES.unableToParseException());
        }
        ArrayList<List<ResteasyConstraintViolation>> violationLists = new ArrayList<List<ResteasyConstraintViolation>>();
        violationLists.add(this.propertyViolations);
        violationLists.add(this.classViolations);
        violationLists.add(this.parameterViolations);
        violationLists.add(this.returnValueViolations);
        this.violationLists = new CopyOnWriteArrayList<List<ResteasyConstraintViolation>>(violationLists);
    }

    protected int getField(int start, String line) {
        int beginning = line.indexOf(91, start);
        if (beginning == -1) {
            throw new RuntimeException(Messages.MESSAGES.exceptionHasInvalidFormat(line));
        }
        int index = beginning;
        int bracketCount = 1;
        while (++index < line.length()) {
            char c = line.charAt(index);
            if (c == '[') {
                ++bracketCount;
            } else if (c == ']') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            break;
        }
        if (bracketCount != 0) {
            throw new RuntimeException(Messages.MESSAGES.exceptionHasInvalidFormat(line));
        }
        return index;
    }

    protected abstract ResteasyConfiguration getResteasyConfiguration();

    protected void checkSuppressPath() {
        String s;
        ResteasyConfiguration context = this.getResteasyConfiguration();
        if (context != null && (s = context.getParameter(SUPPRESS_VIOLATION_PATH)) != null) {
            this.suppressPath = Boolean.parseBoolean(s);
        }
    }

    protected void convertViolations() {
        if (this.violationLists != null) {
            return;
        }
        this.propertyViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
        this.classViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
        this.parameterViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
        this.returnValueViolations = new CopyOnWriteArrayList<ResteasyConstraintViolation>();
        if (this.getConstraintViolations() != null) {
            Iterator it = this.getConstraintViolations().iterator();
            block6: while (it.hasNext()) {
                ResteasyConstraintViolation rcv = this.convertViolation((ConstraintViolation)it.next());
                switch (rcv.getConstraintType()) {
                    case PROPERTY: {
                        this.propertyViolations.add(rcv);
                        continue block6;
                    }
                    case CLASS: {
                        this.classViolations.add(rcv);
                        continue block6;
                    }
                    case PARAMETER: {
                        this.parameterViolations.add(rcv);
                        continue block6;
                    }
                    case RETURN_VALUE: {
                        this.returnValueViolations.add(rcv);
                        continue block6;
                    }
                }
                throw new RuntimeException(Messages.MESSAGES.unexpectedViolationType(rcv.getConstraintType()));
            }
        }
        this.violationLists = new CopyOnWriteArrayList<List<ResteasyConstraintViolation>>();
        this.violationLists.add(this.propertyViolations);
        this.violationLists.add(this.classViolations);
        this.violationLists.add(this.parameterViolations);
        this.violationLists.add(this.returnValueViolations);
    }

    protected ResteasyConstraintViolation convertViolation(ConstraintViolation<?> violation) {
        ConstraintType.Type ct = this.util.getConstraintType(violation);
        String path = this.suppressPath ? "*" : violation.getPropertyPath().toString();
        return new ResteasyConstraintViolation(ct, path, violation.getMessage(), ResteasyViolationException.convertArrayToString(violation.getInvalidValue()));
    }

    protected static String convertArrayToString(Object o) {
        String result = null;
        if (o instanceof Object[]) {
            Object[] array = (Object[])Object[].class.cast(o);
            if (array.length == 0) {
                return "[]";
            }
            StringBuffer sb = new StringBuffer("[").append(ResteasyViolationException.convertArrayToString(array[0]));
            for (int i = 1; i < array.length; ++i) {
                sb.append(", ").append(ResteasyViolationException.convertArrayToString(array[i]));
            }
            sb.append("]");
            result = sb.toString();
        } else {
            result = o == null ? "" : o.toString();
        }
        return result;
    }

    protected static List<CloneableMediaType> toCloneableMediaTypeList(List<MediaType> list) {
        ArrayList<CloneableMediaType> cloneableList = new ArrayList<CloneableMediaType>();
        Iterator<MediaType> it = list.iterator();
        while (it.hasNext()) {
            cloneableList.add(new CloneableMediaType(it.next()));
        }
        return cloneableList;
    }

    protected static List<MediaType> toMediaTypeList(List<CloneableMediaType> cloneableList) {
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (CloneableMediaType cmt : cloneableList) {
            list.add(new MediaType(cmt.type, cmt.subtype, cmt.parameters));
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.api.validation.ResteasyViolationException", ResteasyViolationException.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class CloneableMediaType
    implements Serializable {
        public static final CloneableMediaType TEXT_PLAIN_TYPE;
        private static final long serialVersionUID = 9179565449557464429L;
        private String type;
        private String subtype;
        private Map<String, String> parameters;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        CloneableMediaType(MediaType mediaType) {
            this.type = mediaType.getType();
            this.subtype = mediaType.getSubtype();
            this.parameters = new HashMap<String, String>(mediaType.getParameters());
        }

        CloneableMediaType(String type, String subtype) {
            this.type = type;
            this.subtype = subtype;
        }

        public MediaType toMediaType() {
            return new MediaType(this.type, this.subtype, this.parameters);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.api.validation.ResteasyViolationException$CloneableMediaType", CloneableMediaType.class, null, null);
            TEXT_PLAIN_TYPE = new CloneableMediaType("plain", "text");
        }
    }
}

