/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.annotations.ContentEncoding;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.ServerContentEncodingAnnotationFilter;

@ConstrainedTo(value=RuntimeType.SERVER)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ServerContentEncodingAnnotationFeature
implements DynamicFeature {
    static final long serialVersionUID = 4772870405114920421L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Class declaring = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        if (declaring == null || method == null) {
            return;
        }
        Set<String> encodings = this.getEncodings(method.getAnnotations());
        if (encodings.size() <= 0 && (encodings = this.getEncodings(declaring.getAnnotations())).size() <= 0) {
            return;
        }
        if (!this.isGZipRegistered(configurable.getConfiguration())) {
            encodings.remove("gzip");
        }
        configurable.register((Object)this.createFilter(encodings));
    }

    protected boolean isGZipRegistered(Configuration configuration) {
        return configuration.isRegistered(GZIPEncodingInterceptor.class);
    }

    protected ServerContentEncodingAnnotationFilter createFilter(Set<String> encodings) {
        return new ServerContentEncodingAnnotationFilter(encodings);
    }

    protected Set<String> getEncodings(Annotation[] annotations) {
        HashSet<String> encodings = new HashSet<String>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ContentEncoding.class)) continue;
            encodings.add(annotation.annotationType().getAnnotation(ContentEncoding.class).value().toLowerCase());
        }
        return encodings;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.ServerContentEncodingAnnotationFeature", ServerContentEncodingAnnotationFeature.class, null, null);
    }
}

