/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.activation.DataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.plugins.server.Cleanable;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.NoContent;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class DataSourceProvider
extends AbstractEntityProvider<DataSource> {
    static final long serialVersionUID = -3759009829624247732L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static DataSource readDataSource(InputStream in, MediaType mediaType) throws IOException {
        byte[] buffer;
        int count;
        byte[] memoryBuffer = new byte[4096];
        int readCount = in.read(memoryBuffer, 0, memoryBuffer.length);
        Path tempFile = null;
        if (readCount > 0 && (count = in.read(buffer = new byte[4096], 0, buffer.length)) > -1) {
            tempFile = Files.createTempFile("resteasy-provider-datasource", null, new FileAttribute[0]);
            try (OutputStream fos = Files.newOutputStream(tempFile, new OpenOption[0]);){
                Cleanables cleanables = ResteasyContext.getContextData(Cleanables.class);
                if (cleanables != null) {
                    cleanables.addCleanable(new TempFileCleanable(tempFile));
                }
                fos.write(buffer, 0, count);
                ProviderHelper.writeTo(in, fos);
            }
        }
        if (readCount == -1) {
            readCount = 0;
        }
        return new SequencedDataSource(memoryBuffer, 0, readCount, tempFile, mediaType.toString());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", this.getClass().getName());
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return DataSourceProvider.readDataSource(new ByteArrayInputStream(new byte[0]), mediaType);
        }
        return DataSourceProvider.readDataSource(entityStream, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DataSource dataSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", this.getClass().getName());
        try (InputStream in = dataSource.getInputStream();){
            ProviderHelper.writeTo(in, entityStream);
        }
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(DataSource dataSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", this.getClass().getName());
        try {
            InputStream in = dataSource.getInputStream();
            return ProviderHelper.writeToAndCloseInput(in, entityStream);
        }
        catch (IOException e) {
            return ProviderHelper.completedException(e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.DataSourceProvider", DataSourceProvider.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class TempFileCleanable
    implements Cleanable {
        private final Path tempFile;
        static final long serialVersionUID = -2346244971578572049L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        TempFileCleanable(Path tempFile) {
            this.tempFile = tempFile;
        }

        @Override
        public void clean() throws Exception {
            Files.deleteIfExists(this.tempFile);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.DataSourceProvider$TempFileCleanable", TempFileCleanable.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected static class SequencedDataSource
    implements DataSource {
        private final byte[] byteBuffer;
        private final int byteBufferOffset;
        private final int byteBufferLength;
        private final Path tempFile;
        private final String type;
        static final long serialVersionUID = -6995620052404695849L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected SequencedDataSource(byte[] byteBuffer, int byteBufferOffset, int byteBufferLength, File tempFile, String type) {
            this(byteBuffer, byteBufferOffset, byteBufferLength, tempFile.toPath(), type);
        }

        protected SequencedDataSource(byte[] byteBuffer, int byteBufferOffset, int byteBufferLength, Path tempFile, String type) {
            this.byteBuffer = byteBuffer;
            this.byteBufferOffset = byteBufferOffset;
            this.byteBufferLength = byteBufferLength;
            this.tempFile = tempFile;
            this.type = type;
        }

        public String getContentType() {
            return this.type;
        }

        public InputStream getInputStream() throws IOException {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.byteBuffer, this.byteBufferOffset, this.byteBufferLength);
            if (this.tempFile == null) {
                return bis;
            }
            return new SequenceInputStream(bis, Files.newInputStream(this.tempFile, new OpenOption[0]));
        }

        public String getName() {
            return "";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException(Messages.MESSAGES.noOutputStreamAllowed());
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.DataSourceProvider$SequencedDataSource", SequencedDataSource.class, null, null);
        }
    }
}

