/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.NoContent;
import org.jboss.resteasy.util.TypeConverter;

@Provider
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class DefaultTextPlain
implements MessageBodyReader,
AsyncMessageBodyWriter {
    static final long serialVersionUID = 1504167016373274656L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !String.class.equals((Object)type) && TypeConverter.isConvertable(type);
    }

    public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        InputStream delegate = NoContent.noContentCheck((MultivaluedMap<String, String>)httpHeaders, entityStream);
        String value = ProviderHelper.readString(delegate, mediaType);
        return TypeConverter.getType(type, value);
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !String.class.equals((Object)type) && !type.isArray();
    }

    public long getSize(Object o, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset != null) {
            try {
                return o.toString().getBytes(charset).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return o.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    public void writeTo(Object o, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            entityStream.write(o.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            entityStream.write(o.toString().getBytes(charset));
        }
    }

    public CompletionStage<Void> asyncWriteTo(Object o, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, AsyncOutputStream entityStream) {
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            return entityStream.asyncWrite(o.toString().getBytes(StandardCharsets.UTF_8));
        }
        try {
            return entityStream.asyncWrite(o.toString().getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            return ProviderHelper.completedException(e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.DefaultTextPlain", DefaultTextPlain.class, null, null);
    }
}

