/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.InvalidTopicSyntaxException;
import com.ibm.ws.sib.matchspace.tools.TopicSyntaxChecker;
import com.ibm.ws.sib.matchspace.utils.NLS;

public class MQSITopicSyntaxChecker
implements TopicSyntaxChecker {
    @Override
    public boolean checkTopicSyntax(String topic) throws InvalidTopicSyntaxException {
        this.checkTopicNotNull(topic);
        char[] chars = topic.toCharArray();
        boolean acceptHash = true;
        boolean acceptWild = true;
        boolean acceptOrdinary = true;
        boolean hasWild = false;
        for (int i = 0; i < chars.length; ++i) {
            char cand = chars[i];
            if (cand == '+') {
                if (acceptWild) {
                    hasWild = true;
                    acceptOrdinary = false;
                    acceptWild = false;
                    continue;
                }
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_MQSI_TOPIC_ERROR_CWSIH0008", (Object[])new Object[]{topic, new Integer(i + 1)}));
            }
            if (cand == '#') {
                if (acceptWild && acceptHash) {
                    hasWild = true;
                    acceptOrdinary = false;
                    acceptHash = false;
                    acceptWild = false;
                    continue;
                }
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_MQSI_TOPIC_ERROR_CWSIH0009", (Object[])new Object[]{topic}));
            }
            if (cand == '/') {
                if (acceptWild && i > 0) {
                    throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_MQSI_TOPIC_ERROR_CWSIH0010", (Object[])new Object[]{topic}));
                }
                acceptWild = true;
                acceptOrdinary = true;
                continue;
            }
            if (!acceptOrdinary) {
                throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_MQSI_TOPIC_ERROR_CWSIH0011", (Object[])new Object[]{topic}));
            }
            acceptWild = false;
        }
        return hasWild;
    }

    private final void checkTopicNotNull(String topic) throws InvalidTopicSyntaxException {
        if (topic == null) {
            throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0005", (Object[])new Object[]{topic}));
        }
    }

    @Override
    public void checkEventTopicSyntax(String topic) throws InvalidTopicSyntaxException {
        this.checkTopicNotNull(topic);
        if (topic.indexOf(43) > -1 || topic.indexOf(35) > -1) {
            throw new InvalidTopicSyntaxException(NLS.format((String)"INVALID_TOPIC_ERROR_CWSIH0006", (Object[])new Object[]{topic}));
        }
    }
}

