/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.concurrent.internal.ManagedCompletableFuture;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AsyncMethod<I, T>
extends ManagedCompletableFuture<T> {
    private final BiFunction<I, CompletableFuture<T>, CompletionStage<T>> asyncMethodImpl;
    private final ThreadContextDescriptor contextDescriptor;
    private final I invocation;
    private final AtomicBoolean started = new AtomicBoolean(false);
    static final long serialVersionUID = -3214465815383086121L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AsyncMethod(BiFunction<I, CompletableFuture<T>, CompletionStage<T>> invoker, I invocation, Executor executor) {
        super(executor, AsyncMethod.supportsAsync(executor));
        if (JAVA8) {
            throw new UnsupportedOperationException();
        }
        this.asyncMethodImpl = invoker;
        this.contextDescriptor = ((WSManagedExecutorService)((Object)executor)).captureThreadContext(null);
        this.invocation = invocation;
        ((Executor)((Object)this.futureRef)).execute(this::runIfNotStarted);
    }

    private void complete(T result, Throwable failure) {
        if (failure == null) {
            this.complete(result);
        } else {
            this.completeExceptionally(failure);
        }
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        this.runIfNotStarted();
        return super.get();
    }

    @Override
    public T join() {
        this.runIfNotStarted();
        return super.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={CompletionException.class, Error.class, RuntimeException.class})
    private void runIfNotStarted() {
        if (this.isDone()) return;
        if (!this.started.compareAndSet(false, true)) return;
        Throwable failure = null;
        ArrayList contextApplied = null;
        try {
            CompletionStage<Object> asyncMethodResultStage;
            if (this.contextDescriptor != null) {
                contextApplied = this.contextDescriptor.taskStarting();
            }
            if ((asyncMethodResultStage = this.asyncMethodImpl.apply(this.invocation, this)) == this) return;
            if (asyncMethodResultStage == null) {
                this.complete(null);
                return;
            }
            if (asyncMethodResultStage instanceof ManagedCompletableFuture) {
                ((ManagedCompletableFuture)asyncMethodResultStage).super_whenComplete(this::complete);
                return;
            }
            asyncMethodResultStage.whenComplete(this::complete);
            return;
        }
        catch (CompletionException x) {
            Throwable cause = x.getCause();
            failure = cause == null ? x : cause;
            return;
        }
        catch (RuntimeException x) {
            failure = x;
            return;
        }
        catch (Error x) {
            failure = x;
            return;
        }
        finally {
            try {
                if (contextApplied != null) {
                    this.contextDescriptor.taskStopping(contextApplied);
                }
            }
            catch (RuntimeException x) {
                failure = x;
            }
            finally {
                if (failure != null) {
                    this.completeExceptionally(failure);
                }
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.concurrent.internal.AsyncMethod", AsyncMethod.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    }
}

