/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.TriggerService;
import com.ibm.ws.concurrent.internal.LastExecutionImpl;
import com.ibm.ws.concurrent.internal.ManagedScheduledExecutorServiceImpl;
import com.ibm.ws.concurrent.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.ScheduledCustomExecutorTask;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import jakarta.enterprise.concurrent.AbortedException;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import jakarta.enterprise.concurrent.SkippedException;
import jakarta.enterprise.concurrent.Trigger;
import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ScheduledTask<T>
implements Callable<T>,
ScheduledCustomExecutorTask {
    private static final TraceComponent tc = Tr.register(ScheduledTask.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final Long fixedDelay;
    private final Long fixedRate;
    final FutureImpl future = new FutureImpl();
    private final Long initialDelay;
    private final boolean isCallable;
    private volatile LastExecution lastExecution;
    private final ManagedTaskListener listener;
    private final ManagedScheduledExecutorServiceImpl managedExecSvc;
    private static final Duration MAX_DELAY = Duration.of(Long.MAX_VALUE, ChronoUnit.NANOS);
    private volatile ZonedDateTime nextExecutionTime;
    private final AtomicReference<Result> resultRef = new AtomicReference<Result>(new Result());
    private final Object task;
    private final ZonedDateTime taskScheduledTime;
    private final ThreadContextDescriptor threadContextDescriptor;
    private final Trigger trigger;
    private final ChronoUnit unit;
    static final long serialVersionUID = -4001825194550596072L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    ScheduledTask(ManagedScheduledExecutorServiceImpl managedExecSvc, Object task, boolean isCallable, long initialDelay, Long fixedDelay, Long fixedRate, TimeUnit timeunit) {
        Status status;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.fixedDelay = fixedDelay;
        this.fixedRate = fixedRate;
        this.initialDelay = initialDelay;
        this.isCallable = isCallable;
        this.listener = task instanceof ManagedTask ? ((ManagedTask)task).getManagedTaskListener() : null;
        this.managedExecSvc = managedExecSvc;
        this.taskScheduledTime = ZonedDateTime.now();
        this.trigger = null;
        this.unit = ScheduledTask.toChronoUnit(timeunit);
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)task;
            this.task = a.getAction();
            this.threadContextDescriptor = a.getContextDescriptor();
        } else {
            this.task = task;
            Map<String, String> execProps = managedExecSvc.getExecutionProperties(task);
            try {
                this.threadContextDescriptor = managedExecSvc.captureThreadContext(execProps);
            }
            catch (NullPointerException nullPointerException) {
                void x;
                FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"273", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, initialDelay, fixedDelay, fixedRate, timeunit});
                throw x;
            }
            catch (Throwable x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"275", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, initialDelay, fixedDelay, fixedRate, timeunit});
                throw new RejectedExecutionException(x);
            }
        }
        Duration delay = Duration.of(initialDelay, this.unit);
        if (delay.compareTo(MAX_DELAY) > 0) {
            delay = MAX_DELAY;
        }
        this.nextExecutionTime = this.taskScheduledTime.plus(delay);
        Result result = this.resultRef.get();
        if (this.listener != null) {
            ThreadContext tranContextRestorer = managedExecSvc.suspendTransaction();
            try {
                result.executionThread = Thread.currentThread();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskSubmitted", (Object[])new Object[]{managedExecSvc, this.task});
                }
                this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)managedExecSvc, this.task);
            }
            finally {
                result.executionThread = null;
                if (tranContextRestorer != null) {
                    tranContextRestorer.taskStopping();
                }
            }
        }
        if ((status = result.getStatus()).type == Status.Type.NONE && result.compareAndSet(status, Status.of(Status.Type.SUBMITTED))) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("schedule " + delay + " from now"), (Object[])new Object[0]);
            }
            ScheduledExecutorService scheduledExecSvc = managedExecSvc.scheduledExecSvc;
            ScheduledFuture scheduledFuture = scheduledExecSvc.schedule(this, delay.toNanos(), TimeUnit.NANOSECONDS);
            this.future.scheduledFutureRef.set(scheduledFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    ScheduledTask(ManagedScheduledExecutorServiceImpl managedExecSvc, Object task, boolean isCallable, Trigger trigger) {
        Status status;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        TriggerService triggerSvc = managedExecSvc.concurrencySvc.triggerSvc;
        this.fixedDelay = null;
        this.fixedRate = null;
        this.initialDelay = null;
        this.isCallable = isCallable;
        this.listener = task instanceof ManagedTask ? ((ManagedTask)task).getManagedTaskListener() : null;
        this.managedExecSvc = managedExecSvc;
        this.taskScheduledTime = ZonedDateTime.now(triggerSvc.getZoneId(trigger));
        this.trigger = trigger;
        this.unit = ChronoUnit.NANOS;
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)task;
            this.task = a.getAction();
            this.threadContextDescriptor = a.getContextDescriptor();
        } else {
            this.task = task;
            Map<String, String> execProps = managedExecSvc.getExecutionProperties(task);
            try {
                this.threadContextDescriptor = managedExecSvc.captureThreadContext(execProps);
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"347", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, trigger});
                throw new RejectedExecutionException((Throwable)x);
            }
        }
        try {
            this.nextExecutionTime = triggerSvc.getNextRunTime(null, this.taskScheduledTime, trigger);
        }
        catch (Throwable execProps) {
            void x;
            FFDCFilter.processException((Throwable)execProps, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"354", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, trigger});
            throw new RejectedExecutionException((Throwable)x);
        }
        if (this.nextExecutionTime == null) {
            throw new RejectedExecutionException("Trigger.getNextRunTime: null");
        }
        long delay = this.taskScheduledTime.until(this.nextExecutionTime, ChronoUnit.NANOS);
        Result result = this.resultRef.get();
        if (this.listener != null) {
            ThreadContext tranContextRestorer = managedExecSvc.suspendTransaction();
            try {
                result.executionThread = Thread.currentThread();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskSubmitted", (Object[])new Object[]{managedExecSvc, this.task});
                }
                this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)managedExecSvc, this.task);
            }
            finally {
                result.executionThread = null;
                if (tranContextRestorer != null) {
                    tranContextRestorer.taskStopping();
                }
            }
        }
        if ((status = result.getStatus()).type == Status.Type.NONE && result.compareAndSet(status, Status.of(Status.Type.SUBMITTED))) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("schedule " + Duration.of(delay, ChronoUnit.NANOS) + " from now"), (Object[])new Object[0]);
            }
            ScheduledExecutorService scheduledExecSvc = managedExecSvc.scheduledExecSvc;
            ScheduledFuture scheduledFuture = scheduledExecSvc.schedule(this, delay, TimeUnit.NANOSECONDS);
            this.future.scheduledFutureRef.set(scheduledFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @FFDCIgnore(value={Throwable.class})
    public T call() throws Exception {
        block86: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (this.future.isCancelled()) {
                if (trace && ScheduledTask.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"canceled - not running the task", (Object[])new Object[0]);
                }
                return null;
            }
            triggerSvc = this.managedExecSvc.concurrencySvc.triggerSvc;
            resultForThisExecution = result = this.resultRef.get();
            skipped = null;
            done = false;
            taskResult = null;
            contextAppliedToThread = null;
            Result.access$802(resultForThisExecution, Thread.currentThread());
            try {
                contextAppliedToThread = this.threadContextDescriptor.taskStarting();
                if (this.trigger != null) {
                    try {
                        if (triggerSvc.skipRun(this.lastExecution, this.nextExecutionTime, this.trigger)) {
                            skipped = Status.access$000(Status.Type.SKIPPED);
                        }
                    }
                    catch (Throwable x) {
                        Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1103.skip.run.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                        skipped = Status.access$1200(Status.Type.SKIPPED, x);
                    }
                }
                computedNextExecution = null;
                if (skipped == null) {
                    if (this.listener != null) {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskStarting", (Object[])new Object[]{this.managedExecSvc, this.task});
                            }
                            this.listener.taskStarting((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task);
                        }
                        catch (Throwable var11_12) {
                            done = Status.access$200(Result.access$900(result)) == Status.Type.CANCELED;
                            throw var11_12;
                        }
                        done = Status.access$200(Result.access$900(result)) == Status.Type.CANCELED;
                    }
                    if (Status.access$200(status = Result.access$900(result)) == Status.Type.SUBMITTED && Result.access$1000(result, status, Status.access$000(Status.Type.STARTED))) {
                        try {
                            if (this.trigger == null) {
                                if (this.isCallable) {
                                    taskResult = (T)((Callable)this.task).call();
                                } else {
                                    ((Runnable)this.task).run();
                                }
                            } else {
                                startTime = ZonedDateTime.now(this.taskScheduledTime.getZone());
                                if (this.isCallable) {
                                    taskResult = (T)((Callable)this.task).call();
                                } else {
                                    ((Runnable)this.task).run();
                                }
                                endTime = ZonedDateTime.now(this.taskScheduledTime.getZone());
                                execProps = this.threadContextDescriptor.getExecutionProperties();
                                if (this.managedExecSvc.eeVersion < 9) {
                                    identityName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                                    if (identityName == null) {
                                        identityName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                                    }
                                } else {
                                    identityName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                                    if (identityName == null) {
                                        identityName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                                    }
                                }
                                this.lastExecution = new LastExecutionImpl(identityName, this.nextExecutionTime, startTime, endTime, taskResult);
                            }
                        }
                        catch (Throwable x) {
                            Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                            status = Result.access$900(result);
                            if (Status.access$200(status) == Status.Type.CANCELED) {
                                Result.access$1000(result, status, Status.access$1200(Status.Type.CANCELED, x));
                            } else if (Status.access$200(status) == Status.Type.STARTED) {
                                Result.access$1000(result, status, Status.access$1200(Status.Type.DONE, x));
                            }
                            Result.access$1300(result).countDown();
                        }
                        status = Result.access$900(result);
                        if (Status.access$200(status) == Status.Type.STARTED) {
                            if (this.trigger == null) {
                                Result.access$1000(result, status, Status.access$1400(taskResult, this.fixedDelay == null && this.fixedRate == null));
                            } else {
                                computedNextExecution = triggerSvc.getNextRunTime(this.lastExecution, this.taskScheduledTime, this.trigger);
                                Result.access$1000(result, status, Status.access$1400(taskResult, computedNextExecution == null));
                            }
                            Result.access$1300(result).countDown();
                        }
                        done = true;
                        if (this.listener != null) {
                            try {
                                if (Status.access$200(status) == Status.Type.CANCELED) {
                                    try {
                                        cancelX = new CancellationException(Tr.formatMessage((TraceComponent)ScheduledTask.tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                                        if (trace && ScheduledTask.tc.isEventEnabled()) {
                                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskCanceled", (Object[])new Object[]{this.managedExecSvc, this.task, cancelX});
                                        }
                                        this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)cancelX);
                                    }
                                    catch (Throwable x) {
                                        Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                                    }
                                }
                                failure = Status.access$500(Result.access$900(result));
                                if (trace && ScheduledTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, failure});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, failure);
                            }
                            catch (Throwable x) {
                                Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                            }
                        }
                    }
                } else {
                    try {
                        status = Result.access$900(result);
                        if (Status.access$200(status) == Status.Type.SUBMITTED) {
                            Result.access$1000(result, status, skipped);
                        }
                        if ((computedNextExecution = triggerSvc.getNextRunTime(this.lastExecution, this.taskScheduledTime, this.trigger)) == null) {
                            Result.access$1000(result, skipped, Status.access$1500(skipped));
                        }
                        Result.access$1300(result).countDown();
                        ** if (this.listener == null) goto lbl-1000
                    }
                    catch (Throwable var15_24) {
                        Result.access$1300(result).countDown();
                        if (this.listener != null) {
                            if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskAborted(skipped)", (Object[])new Object[]{this.managedExecSvc, this.task});
                            }
                            this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)new SkippedException(Status.access$500(skipped)));
                        }
                        throw var15_24;
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskAborted(skipped)", (Object[])new Object[]{this.managedExecSvc, this.task});
                        }
                        this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)new SkippedException(Status.access$500(skipped)));
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    if (this.listener != null) {
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone(skipped)", (Object[])new Object[]{this.managedExecSvc, this.task});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, null);
                    }
                }
                if (Status.access$1600(status = Result.access$900(result)) || Status.access$200(status) != Status.Type.DONE && Status.access$200(status) != Status.Type.SKIPPED || !Result.access$1000(result, status, Status.access$1700(status)) || !this.resultRef.compareAndSet(result, nextResult = new Result())) break block86;
                result = nextResult;
                done = false;
                if (trace && ScheduledTask.tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)((Status.access$200(status) == Status.Type.DONE ? "DONE" : "SKIPPED") + "-->NONE (reset for next result)"), (Object[])new Object[0]);
                }
                now = ZonedDateTime.now(this.taskScheduledTime.getZone());
                if (this.fixedDelay != null) {
                    delay = Duration.of(this.fixedDelay, this.unit);
                    this.nextExecutionTime = now.plus(delay);
                } else if (this.fixedRate != null) {
                    newExecutionTime = this.nextExecutionTime.plus(this.fixedRate, this.unit);
                    newDelay = Duration.between(now, newExecutionTime);
                    if (newDelay.compareTo(Duration.ZERO) > 0) {
                        this.nextExecutionTime = newExecutionTime;
                        delay = newDelay;
                    } else {
                        if (trace && ScheduledTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"overlapped next fixed-rate execution, computing next from", (Object[])new Object[]{this.taskScheduledTime + " scheduleAtFixedRate invoked at", this.nextExecutionTime + " current execution was expected at", newExecutionTime + " target for subsequent execution overlapped by " + newDelay.negated(), now + " current time", Duration.between(this.taskScheduledTime, now) + " elapsed from scheduleAtFixedRate", this.initialDelay + " " + this.unit + " initial delay"});
                        }
                        elapsed = Duration.between(this.taskScheduledTime, now).minus(this.initialDelay, this.unit);
                        rate = Duration.of(this.fixedRate, this.unit);
                        count = ScheduledTask.divide(elapsed, rate);
                        delay = rate.multipliedBy(count + 1L).minus(elapsed);
                        this.nextExecutionTime = now.plus(delay);
                        if (trace && ScheduledTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"next fixed-rate execution computed as", (Object[])new Object[]{elapsed + " elapsed from expected start of first execution", this.fixedRate + " " + this.unit + " fixed rate is " + rate, count + 1L + " executions would have occurred if no overlaps or slowdowns", delay + " delay until next execution", this.nextExecutionTime + " expected next execution"});
                        }
                    }
                } else {
                    delay = Duration.between(now, computedNextExecution);
                    this.nextExecutionTime = computedNextExecution;
                }
                if (delay.isNegative()) {
                    delay = Duration.ZERO;
                }
                if (this.listener != null) {
                    try {
                        Result.access$802(result, Thread.currentThread());
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskSubmitted", (Object[])new Object[]{this.managedExecSvc, this.task});
                        }
                        this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task);
                    }
                    finally {
                        Result.access$802(result, null);
                    }
                }
                if (Status.access$200(status = Result.access$900(result)) == Status.Type.NONE && Result.access$1000(result, status, Status.access$000(Status.Type.SUBMITTED))) {
                    if (trace && ScheduledTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)("reschedule " + delay + " from now"), (Object[])new Object[0]);
                    }
                    scheduledFuture = this.managedExecSvc.scheduledExecSvc.schedule(this, delay.toNanos(), TimeUnit.NANOSECONDS);
                    FutureImpl.access$1100(this.future).set(scheduledFuture);
                }
            }
            catch (Throwable x) {
                if (contextAppliedToThread == null && x instanceof IllegalStateException && FrameworkState.isStopping()) {
                    if (trace && ScheduledTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"Task not started due to server shutdown", (Object[])new Object[]{this.getName(), x});
                    }
                } else {
                    Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                }
                if (Status.access$300(status = Result.access$900(result)) == null) {
                    abortedOrDone = Status.access$200(status) == Status.Type.STARTED ? Status.Type.DONE : Status.Type.ABORTED;
                    Result.access$1000(result, status, Status.access$1200(abortedOrDone, x));
                }
                Result.access$1300(result).countDown();
                if (this.listener != null && !done) {
                    try {
                        block88: {
                            try {
                                if (skipped != null || Status.access$200(status) == Status.Type.STARTED) break block88;
                                if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc});
                                }
                                this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)new AbortedException(x));
                            }
                            catch (Throwable var21_30) {
                                if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
                                throw var21_30;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
                    }
                    catch (Throwable t) {
                        Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                    }
                }
                if (x instanceof Exception) {
                    throw (Exception)x;
                }
                throw (Error)x;
            }
            finally {
                Result.access$802(resultForThisExecution, null);
                if (contextAppliedToThread != null) {
                    this.threadContextDescriptor.taskStopping(contextAppliedToThread);
                }
            }
        }
        return taskResult;
    }

    @Trivial
    private static final long divide(Duration numerator, Duration denominator) {
        BigInteger num = BigInteger.valueOf(numerator.getSeconds()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(numerator.getNano()));
        BigInteger denom = BigInteger.valueOf(denominator.getSeconds()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(denominator.getNano()));
        return num.divide(denom).longValueExact();
    }

    @Trivial
    public Executor getExecutor() {
        return this.managedExecSvc.policyExecutor.getVirtualThreadExecutor();
    }

    @Trivial
    final String getName() {
        Map execProps = this.threadContextDescriptor.getExecutionProperties();
        String taskName = null;
        if (execProps != null) {
            if (this.managedExecSvc.eeVersion < 9) {
                taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                if (taskName == null) {
                    taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                }
            } else {
                taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                if (taskName == null) {
                    taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                }
            }
        }
        return taskName == null ? this.task.toString() : taskName;
    }

    @Trivial
    private static final ChronoUnit toChronoUnit(TimeUnit timeunit) {
        switch (timeunit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
        }
        throw new IllegalArgumentException(timeunit.toString());
    }

    @Trivial
    private class FutureImpl
    implements ScheduledFuture<T> {
        private final AtomicReference<ScheduledFuture<?>> scheduledFutureRef = new AtomicReference();
        private final ScheduledTask<T> task = ScheduledTask.this;

        private FutureImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry(this.task, (TraceComponent)tc, (String)"cancel", (Object[])new Object[]{mayInterruptIfRunning});
            }
            boolean canceled = false;
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            while (!canceled && !status.isFinalExecutionComplete()) {
                if (!Boolean.TRUE.equals(status.hasNext) && result.compareAndSet(status, Status.of(Status.Type.CANCELED))) {
                    Future future = this.scheduledFutureRef.get();
                    if (future != null) {
                        future.cancel(mayInterruptIfRunning);
                    }
                    result.latch.countDown();
                    if ((status.type == Status.Type.NONE || status.type == Status.Type.SUBMITTED) && ScheduledTask.this.listener != null) {
                        Throwable failure = null;
                        ThreadContext tranContextRestorer = ScheduledTask.this.managedExecSvc.suspendTransaction();
                        try {
                            try {
                                CancellationException cancelX = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{ScheduledTask.this.managedExecSvc, this.task.task, cancelX});
                                }
                                ScheduledTask.this.listener.taskAborted((Future)this, (ManagedExecutorService)ScheduledTask.this.managedExecSvc, this.task.task, (Throwable)cancelX);
                            }
                            catch (Error x) {
                                try {
                                    failure = x;
                                    throw x;
                                    catch (RuntimeException x2) {
                                        failure = x2;
                                        throw x2;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (trace && tc.isEventEnabled()) {
                                        Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{ScheduledTask.this.managedExecSvc, this.task.task, failure});
                                    }
                                    ScheduledTask.this.listener.taskDone((Future)this, (ManagedExecutorService)ScheduledTask.this.managedExecSvc, this.task.task, failure);
                                    throw throwable;
                                }
                            }
                            if (trace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{ScheduledTask.this.managedExecSvc, this.task.task, failure});
                            }
                            ScheduledTask.this.listener.taskDone((Future)this, (ManagedExecutorService)ScheduledTask.this.managedExecSvc, this.task.task, failure);
                        }
                        finally {
                            if (tranContextRestorer != null) {
                                tranContextRestorer.taskStopping();
                            }
                        }
                    }
                    canceled = true;
                    continue;
                }
                Thread.yield();
                result = (Result)ScheduledTask.this.resultRef.get();
                status = result.getStatus();
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit(this.task, (TraceComponent)tc, (String)"cancel", (Object)canceled);
            }
            return canceled;
        }

        @Override
        public int compareTo(Delayed delayed) {
            int result;
            if (delayed instanceof FutureImpl) {
                ZonedDateTime value1 = ScheduledTask.this.nextExecutionTime;
                ZonedDateTime value2 = ((FutureImpl)delayed).task.nextExecutionTime;
                int n = result = this == delayed || value1 == value2 ? 0 : value1.compareTo(value2);
                result = result < 0 ? -1 : (result > 0 ? 1 : 0);
            } else {
                long diff = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
                int n = diff < -100L ? -1 : (result = diff > 100L ? 1 : 0);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(this.task, (TraceComponent)tc, (String)"compareTo", (Object[])new Object[]{this, delayed, result});
            }
            return result;
        }

        @Override
        public Throwable exceptionNow() {
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            switch (status.type) {
                case DONE: {
                    if (status.failure == null) {
                        throw new IllegalStateException("SUCCESS");
                    }
                    return status.failure;
                }
                case ABORTED: {
                    throw new IllegalStateException((Throwable)new AbortedException(status.failure));
                }
                case CANCELED: {
                    throw new IllegalStateException(new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name})));
                }
                case NONE: 
                case SUBMITTED: 
                case STARTED: {
                    throw new IllegalStateException();
                }
                case SKIPPED: {
                    throw new IllegalStateException((Throwable)new SkippedException(status.failure));
                }
            }
            throw new IllegalStateException(status.type.toString());
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry(this.task, (TraceComponent)tc, (String)"get", (Object[])new Object[0]);
            }
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            Exception x = null;
            if (status.type == Status.Type.CANCELED) {
                x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
            } else if ((status.type == Status.Type.NONE || status.type == Status.Type.SUBMITTED) && result.executionThread != null && Thread.currentThread().equals(result.executionThread)) {
                x = new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
            } else {
                result.latch.await();
                status = result.getStatus();
                switch (status.type) {
                    case DONE: {
                        if (status.failure == null) {
                            if (trace && tc.isEntryEnabled()) {
                                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)status.value);
                            }
                            return status.value;
                        }
                        x = new ExecutionException(status.failure);
                        break;
                    }
                    case ABORTED: {
                        x = new AbortedException(status.failure);
                        break;
                    }
                    case CANCELED: {
                        x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
                        break;
                    }
                    case SKIPPED: {
                        x = new SkippedException(status.failure);
                        break;
                    }
                    default: {
                        x = new IllegalStateException(status.type.name());
                    }
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)Utils.toString(x));
            }
            if (x instanceof ExecutionException) {
                throw (ExecutionException)x;
            }
            if (x instanceof InterruptedException) {
                throw x;
            }
            throw (RuntimeException)x;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry(this.task, (TraceComponent)tc, (String)"get", (Object[])new Object[]{timeout, unit});
            }
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            Exception x = null;
            if (status.type == Status.Type.CANCELED) {
                x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
            } else if ((status.type == Status.Type.NONE || status.type == Status.Type.SUBMITTED) && result.executionThread != null && Thread.currentThread().equals(result.executionThread)) {
                x = new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
            } else if (!result.latch.await(timeout, unit)) {
                x = new TimeoutException();
            } else {
                status = result.getStatus();
                switch (status.type) {
                    case DONE: {
                        if (status.failure == null) {
                            if (trace && tc.isEntryEnabled()) {
                                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)status.value);
                            }
                            return status.value;
                        }
                        x = new ExecutionException(status.failure);
                        break;
                    }
                    case ABORTED: {
                        x = new AbortedException(status.failure);
                        break;
                    }
                    case CANCELED: {
                        x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
                        break;
                    }
                    case SKIPPED: {
                        x = new SkippedException(status.failure);
                        break;
                    }
                    default: {
                        x = new IllegalStateException(status.type.name());
                    }
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)Utils.toString(x));
            }
            if (x instanceof ExecutionException) {
                throw (ExecutionException)x;
            }
            if (x instanceof InterruptedException) {
                throw (InterruptedException)x;
            }
            if (x instanceof TimeoutException) {
                throw x;
            }
            throw (RuntimeException)x;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = ZonedDateTime.now(ScheduledTask.this.taskScheduledTime.getZone()).until(ScheduledTask.this.nextExecutionTime, ScheduledTask.toChronoUnit(unit));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(this.task, (TraceComponent)tc, (String)"getDelay", (Object[])new Object[]{unit, delay});
            }
            return delay;
        }

        public final int hashCode() {
            return this.task.hashCode();
        }

        @Override
        public boolean isCancelled() {
            Status status = ((Result)ScheduledTask.this.resultRef.get()).getStatus();
            if (status.type == Status.Type.CANCELED) {
                return true;
            }
            if (status.isFinalExecutionComplete()) {
                return false;
            }
            Future future = this.scheduledFutureRef.get();
            if (future != null && future.isCancelled()) {
                future.cancel(true);
                return true;
            }
            return false;
        }

        @Override
        public boolean isDone() {
            Status status = ((Result)ScheduledTask.this.resultRef.get()).getStatus();
            return status.type == Status.Type.ABORTED || status.type == Status.Type.DONE || status.type == Status.Type.SKIPPED || this.isCancelled();
        }

        @Override
        public T resultNow() {
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            switch (status.type) {
                case DONE: {
                    if (status.failure == null) {
                        return status.value;
                    }
                    throw new IllegalStateException(status.failure);
                }
                case ABORTED: {
                    throw new IllegalStateException((Throwable)new AbortedException(status.failure));
                }
                case CANCELED: {
                    throw new IllegalStateException(new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name})));
                }
                case NONE: 
                case SUBMITTED: 
                case STARTED: {
                    throw new IllegalStateException();
                }
                case SKIPPED: {
                    throw new IllegalStateException((Throwable)new SkippedException(status.failure));
                }
            }
            throw new IllegalStateException(status.type.toString());
        }
    }

    @Trivial
    private class Result {
        private volatile Thread executionThread;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final AtomicReference<Status<T>> statusRef = new AtomicReference<Status>(Status.access$000(Status.Type.NONE));

        private Result() {
        }

        private final boolean compareAndSet(Status<T> expectedStatus, Status<T> newStatus) {
            boolean updated = this.statusRef.compareAndSet(expectedStatus, newStatus);
            if (updated && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                StringBuilder sb = new StringBuilder(60).append((Object)expectedStatus.type).append("-->").append((Object)newStatus.type).append(' ');
                if (Boolean.TRUE.equals(newStatus.hasNext)) {
                    sb.append("[has next] ");
                } else if (Boolean.FALSE.equals(newStatus.hasNext)) {
                    sb.append("[final] ");
                }
                if (newStatus.value != null) {
                    sb.append(newStatus.value).append(' ');
                }
                if (newStatus.failure != null) {
                    sb.append(newStatus.failure);
                }
                Tr.event((Object)ScheduledTask.this, (TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
            }
            return updated;
        }

        private final Status<T> getStatus() {
            return this.statusRef.get();
        }
    }

    @Trivial
    private static class Status<T> {
        private final Throwable failure;
        private final Boolean hasNext;
        private final Type type;
        private final T value;

        private Status(Type type, T value, Throwable failure, Boolean hasNext) {
            this.failure = failure;
            this.hasNext = hasNext;
            this.type = type;
            this.value = value;
        }

        private final boolean isFinalExecutionComplete() {
            return Boolean.FALSE.equals(this.hasNext);
        }

        private static final <T> Status<T> done(T resultValue, boolean isFinalExecution) {
            return new Status<T>(Type.DONE, resultValue, null, isFinalExecution ? Boolean.valueOf(false) : null);
        }

        private static final <T> Status<T> of(Type type) {
            Boolean hasNext = type == Type.ABORTED || type == Type.CANCELED || type == Type.DONE ? Boolean.valueOf(false) : null;
            return new Status<Object>(type, null, null, hasNext);
        }

        private static final <T> Status<T> of(Type type, Throwable failure) {
            Boolean hasNext = type == Type.ABORTED || type == Type.CANCELED || type == Type.DONE ? Boolean.valueOf(false) : null;
            return new Status<Object>(type, null, failure, hasNext);
        }

        private Status<T> withNextExecution() {
            return new Status<T>(this.type, this.value, this.failure, true);
        }

        private Status<T> withoutNextExecution() {
            return new Status<T>(this.type, this.value, this.failure, false);
        }

        static /* synthetic */ Status access$1200(Type x0, Throwable x1) {
            return Status.of(x0, x1);
        }

        static /* synthetic */ Status access$1400(Object x0, boolean x1) {
            return Status.done(x0, x1);
        }

        static /* synthetic */ Status access$1500(Status x0) {
            return x0.withoutNextExecution();
        }

        static /* synthetic */ Status access$1700(Status x0) {
            return x0.withNextExecution();
        }

        @Trivial
        private static enum Type {
            ABORTED,
            CANCELED,
            DONE,
            NONE,
            SKIPPED,
            STARTED,
            SUBMITTED;

        }
    }
}

