/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import jakarta.data.Sort;
import jakarta.data.exceptions.DataException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.PageRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CursoredPageImpl<T>
implements CursoredPage<T> {
    private static final TraceComponent tc = Tr.register(CursoredPageImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Object[] args;
    private final boolean isForward;
    private final PageRequest<T> pageRequest;
    private final QueryInfo queryInfo;
    private final List<T> results;
    private long totalElements = -1L;
    static final long serialVersionUID = 6872149858593441232L;

    @FFDCIgnore(value={Exception.class})
    CursoredPageImpl(QueryInfo queryInfo, PageRequest<T> pageRequest, Object[] args) {
        this.args = args;
        this.queryInfo = queryInfo;
        this.pageRequest = pageRequest == null ? PageRequest.ofSize((int)100) : pageRequest;
        this.isForward = this.pageRequest.mode() != PageRequest.Mode.CURSOR_PREVIOUS;
        Optional keysetCursor = this.pageRequest.cursor();
        int maxPageSize = this.pageRequest.size();
        int firstResult = this.pageRequest.mode() == PageRequest.Mode.OFFSET ? RepositoryImpl.computeOffset(this.pageRequest) : 0;
        try (EntityManager em = queryInfo.entityInfo.builder.createEntityManager();){
            String jpql = keysetCursor.isEmpty() ? queryInfo.jpql : (this.isForward ? queryInfo.jpqlAfterKeyset : queryInfo.jpqlBeforeKeyset);
            TypedQuery query = em.createQuery(jpql, queryInfo.entityInfo.entityClass);
            queryInfo.setParameters((Query)query, args);
            if (keysetCursor.isPresent()) {
                queryInfo.setKeysetParameters((Query)query, (PageRequest.Cursor)keysetCursor.get());
            }
            query.setFirstResult(firstResult);
            query.setMaxResults(maxPageSize + (maxPageSize == Integer.MAX_VALUE ? 0 : 1));
            this.results = query.getResultList();
            if (!this.isForward) {
                int size = this.results.size();
                int i = 0;
                for (int j = size - (size > maxPageSize ? 2 : 1); i < j; ++i, --j) {
                    Collections.swap(this.results, i, j);
                }
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    private long countTotalElements() {
        if (!this.pageRequest.requestTotal()) {
            throw new IllegalStateException("A total count of elements and pages is not retreived from the database because the " + this.pageRequest + " page request specifies a value of 'false' for 'requestTotal'. To request a page with the total count included, use the PageRequest.withTotal method instead of the PageRequest.withoutTotal method.");
        }
        try (EntityManager em = this.queryInfo.entityInfo.builder.createEntityManager();){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("query for count: " + this.queryInfo.jpqlCount), (Object[])new Object[0]);
            }
            TypedQuery query = em.createQuery(this.queryInfo.jpqlCount, Long.class);
            this.queryInfo.setParameters((Query)query, this.args);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    public List<T> content() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? new ResultList(max) : this.results;
    }

    /*
     * WARNING - void declaration
     */
    public PageRequest.Cursor cursor(int index) {
        if (index < 0 || index >= this.pageRequest.size()) {
            throw new IllegalArgumentException("index: " + index);
        }
        T entity = this.results.get(index);
        Object[] keyValues = new Object[this.queryInfo.sorts.size()];
        int k = 0;
        for (Sort<Object> keyInfo : this.queryInfo.sorts) {
            try {
                List<Member> accessors = this.queryInfo.entityInfo.attributeAccessors.get(keyInfo.property());
                Object value = entity;
                for (Member accessor : accessors) {
                    if (accessor instanceof Method) {
                        value = ((Method)accessor).invoke(value, new Object[0]);
                        continue;
                    }
                    value = ((Field)accessor).get(value);
                }
                keyValues[k++] = value;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException accessors) {
                void x;
                FFDCFilter.processException((Throwable)accessors, (String)"io.openliberty.data.internal.persistence.CursoredPageImpl", (String)"154", (Object)this, (Object[])new Object[]{index});
                throw new DataException(x.getCause());
            }
        }
        return PageRequest.Cursor.forKey((Object[])keyValues);
    }

    public boolean hasNext() {
        int minToHaveNextPage = this.isForward ? this.pageRequest.size() + (this.pageRequest.size() == Integer.MAX_VALUE ? 0 : 1) : 1;
        return this.results.size() >= minToHaveNextPage;
    }

    public boolean hasPrevious() {
        int minToHavePreviousPage = this.isForward ? 1 : this.pageRequest.size() + (this.pageRequest.size() == Integer.MAX_VALUE ? 0 : 1);
        return this.results.size() >= minToHavePreviousPage;
    }

    public boolean hasTotals() {
        return this.pageRequest.requestTotal();
    }

    public int numberOfElements() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? max : size;
    }

    public PageRequest<T> pageRequest() {
        return this.pageRequest;
    }

    public <E> PageRequest<E> pageRequest(Class<E> entityClass) {
        return this.pageRequest;
    }

    public long totalElements() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements;
    }

    public long totalPages() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements / (long)this.pageRequest.size() + (long)(this.totalElements % (long)this.pageRequest.size() > 0L ? 1 : 0);
    }

    public boolean hasContent() {
        return !this.results.isEmpty();
    }

    public Iterator<T> iterator() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? new ResultIterator(max) : this.results.iterator();
    }

    public PageRequest<T> nextPageRequest() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Cannot request a next page. To avoid this error, check for a true result of CursoredPage.hasNext before attempting this method.");
        }
        PageRequest p = this.pageRequest.page() == Long.MAX_VALUE ? this.pageRequest : this.pageRequest.page(this.pageRequest.page() + 1L);
        return p.afterKey(this.queryInfo.getKeysetValues(this.results.get(Math.min(this.results.size(), this.pageRequest.size()) - 1)));
    }

    public <E> PageRequest<E> nextPageRequest(Class<E> entityClass) {
        return this.nextPageRequest();
    }

    public PageRequest<T> previousPageRequest() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Cannot request a previous page. To avoid this error, check for a true result of CursoredPage.hasPrevious before attempting this method.");
        }
        PageRequest p = this.pageRequest.page() == 1L ? this.pageRequest : this.pageRequest.page(this.pageRequest.page() - 1L);
        return p.beforeKey(this.queryInfo.getKeysetValues(this.results.get(0)));
    }

    public <E> PageRequest<E> previousPageRequest(Class<E> entityClass) {
        return this.previousPageRequest();
    }

    public Stream<T> stream() {
        return this.content().stream();
    }

    @Trivial
    private class ResultList
    extends AbstractList<T>
    implements RandomAccess {
        private final int size;

        private ResultList(int size) {
            this.size = size;
        }

        @Override
        public T get(int index) {
            if (index < this.size) {
                return CursoredPageImpl.this.results.get(index);
            }
            throw new IndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Trivial
    private class ResultIterator
    implements Iterator<T> {
        private int index;
        private final Iterator<T> iterator;
        private final int size;

        private ResultIterator(int size) {
            this.size = size;
            this.iterator = CursoredPageImpl.this.results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("Element at index " + this.index);
            }
            Object result = this.iterator.next();
            ++this.index;
            return result;
        }
    }
}

