/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import jakarta.data.Sort;
import jakarta.data.exceptions.MappingException;
import jakarta.persistence.Inheritance;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class EntityInfo {
    static final String FAILED = "ERROR!";
    final Map<String, List<Member>> attributeAccessors;
    final Map<String, String> attributeNames;
    final SortedMap<String, Class<?>> attributeTypes;
    final EntityManagerBuilder builder;
    final Map<String, Class<?>> collectionElementTypes;
    final Class<?> entityClass;
    final Class<?> idType;
    final SortedMap<String, Member> idClassAttributeAccessors;
    final boolean inheritance;
    final String name;
    final Class<?> recordClass;
    final String versionAttributeName;
    final Map<Class<?>, List<String>> relationAttributeNames;
    static final long serialVersionUID = 2892790458583105183L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    EntityInfo(String entityName, Class<?> entityClass, Class<?> recordClass, Map<String, List<Member>> attributeAccessors, Map<String, String> attributeNames, SortedMap<String, Class<?>> attributeTypes, Map<String, Class<?>> collectionElementTypes, Map<Class<?>, List<String>> relationAttributeNames, Class<?> idType, SortedMap<String, Member> idClassAttributeAccessors, String versionAttributeName, EntityManagerBuilder entityManagerBuilder) {
        this.name = entityName;
        this.builder = entityManagerBuilder;
        this.entityClass = entityClass;
        this.attributeAccessors = attributeAccessors;
        this.attributeNames = attributeNames;
        this.attributeTypes = attributeTypes;
        this.collectionElementTypes = collectionElementTypes;
        this.relationAttributeNames = relationAttributeNames;
        this.idType = idType;
        this.idClassAttributeAccessors = idClassAttributeAccessors;
        this.recordClass = recordClass;
        this.versionAttributeName = versionAttributeName;
        this.inheritance = entityClass.getAnnotation(Inheritance.class) != null;
    }

    Object getAttribute(Object entity, String attributeName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<Member> accessors = this.attributeAccessors.get(attributeName);
        if (accessors == null) {
            throw new IllegalArgumentException(attributeName);
        }
        Object value = entity;
        for (Member accessor : accessors) {
            Class<?> type = accessor.getDeclaringClass();
            if (type.isInstance(value)) {
                if (accessor instanceof Method) {
                    value = ((Method)accessor).invoke(value, new Object[0]);
                    continue;
                }
                value = ((Field)accessor).get(value);
                continue;
            }
            throw new MappingException("Value of type " + value.getClass().getName() + " is incompatible with attribute type " + type.getName());
        }
        return value;
    }

    String getAttributeName(String name, boolean failIfNotFound) {
        String lowerName = name.toLowerCase();
        String attributeName = this.attributeNames.get(lowerName);
        if (attributeName == null) {
            if ("#id".equals(lowerName)) {
                if (this.idClassAttributeAccessors == null && failIfNotFound) {
                    throw new MappingException("Entity class " + this.getType().getName() + " does not have a property named " + name + " or which is designated as the @Id.");
                }
                attributeName = null;
            } else {
                if (name.length() == 0) {
                    throw new MappingException("Error parsing method name or entity property name is missing.");
                }
                attributeName = this.attributeNames.get(lowerName = lowerName.replace('.', '_'));
                if (attributeName == null && (attributeName = this.attributeNames.get(lowerName = lowerName.replace("_", ""))) == null && failIfNotFound) {
                    throw new MappingException("Entity class " + this.getType().getName() + " does not have a property named " + name + ". The following are valid property names for the entity: " + this.attributeTypes.keySet());
                }
            }
        }
        return attributeName;
    }

    Collection<String> getAttributeNames() {
        return this.attributeNames.values();
    }

    LinkedHashSet<String> getAttributeNamesForEntityUpdate() {
        LinkedHashSet<String> names = new LinkedHashSet<String>(this.attributeNames.size());
        for (String name : this.attributeTypes.keySet()) {
            names.add(name);
        }
        names.remove("#id");
        names.remove(this.attributeNames.get("#id"));
        names.remove(this.versionAttributeName);
        for (String name : this.attributeTypes.keySet()) {
            int ldot = name.lastIndexOf(46);
            if (ldot <= 0) continue;
            names.remove(name.substring(0, ldot));
        }
        return names;
    }

    @Trivial
    Class<?> getType() {
        return this.recordClass == null ? this.entityClass : this.recordClass;
    }

    @Trivial
    <T> Sort<T> getWithAttributeName(String name, Sort<T> sort) {
        if ((name = this.getAttributeName(name, true)) == sort.property()) {
            return sort;
        }
        return sort.isAscending() ? (sort.ignoreCase() ? Sort.ascIgnoreCase((String)name) : Sort.asc((String)name)) : (sort.ignoreCase() ? Sort.descIgnoreCase((String)name) : Sort.desc((String)name));
    }

    @Trivial
    static CompletableFuture<EntityInfo> newFuture(Class<?> entityClass) {
        return new CompletableFuture<EntityInfo>();
    }

    @Trivial
    final Object toRecord(Object entity) throws Exception {
        RecordComponent[] components = this.recordClass.getRecordComponents();
        Class[] argTypes = new Class[components.length];
        Object[] args = new Object[components.length];
        int a = 0;
        for (RecordComponent component : components) {
            PropertyDescriptor desc = new PropertyDescriptor(component.getName(), entity.getClass());
            argTypes[a] = component.getType();
            args[a++] = desc.getReadMethod().invoke(entity, new Object[0]);
        }
        return this.recordClass.getConstructor(argTypes).newInstance(args);
    }

    @Trivial
    public String toString() {
        return "EntityInfo@" + Integer.toHexString(this.hashCode()) + ' ' + this.name + ' ' + this.attributeTypes.keySet();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.data.internal.persistence.EntityInfo", EntityInfo.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    }
}

