/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.internal.persistence.model.Model;
import jakarta.data.repository.Query;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class EntityManagerBuilder
implements Runnable {
    private static final TraceComponent tc = Tr.register(EntityManagerBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    protected final Set<Class<?>> entities = new HashSet();
    final ConcurrentHashMap<Class<?>, CompletableFuture<EntityInfo>> entityInfoMap = new ConcurrentHashMap();
    private final ClassLoader repositoryClassLoader;
    static final long serialVersionUID = 3189863001647595513L;

    @Trivial
    protected EntityManagerBuilder(ClassLoader repositoryClassLoader) {
        this.repositoryClassLoader = repositoryClassLoader;
    }

    @Trivial
    public void add(Class<?> entityClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("add: " + entityClass.getName()), (Object[])new Object[0]);
        }
        this.entities.add(entityClass);
    }

    public abstract EntityManager createEntityManager();

    @Trivial
    protected Class<?> getRecordClass(Class<?> generatedEntityClass) {
        return null;
    }

    @Trivial
    @FFDCIgnore(value={RuntimeException.class})
    private static Type<?> getIdType(EntityType<?> entityType) {
        Type idType;
        try {
            idType = entityType.getIdType();
        }
        catch (RuntimeException x) {
            if ("ConversionException".equals(x.getClass().getSimpleName())) {
                idType = null;
            }
            throw x;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(entityType.getName() + " getIdType: " + idType), (Object[])new Object[0]);
        }
        return idType;
    }

    @Trivial
    protected ClassLoader getRepositoryClassLoader() {
        return this.repositoryClassLoader;
    }

    @Trivial
    protected abstract void initialize() throws Exception;

    public void populateStaticMetamodelClasses(Map<Class<?>, List<Class<?>>> staticMetamodels) {
        for (Class<?> entityClass : this.entities) {
            List<Class<?>> metamodelClasses;
            if (Query.class.equals(entityClass) || (metamodelClasses = staticMetamodels.get(entityClass)) == null) continue;
            CompletableFuture entityInfoFuture = this.entityInfoMap.computeIfAbsent(entityClass, EntityInfo::newFuture);
            EntityInfo entityInfo = (EntityInfo)entityInfoFuture.join();
            for (Class<?> metamodelClass : metamodelClasses) {
                Model.initialize(metamodelClass, entityInfo.attributeNames);
            }
        }
    }

    @Override
    @Trivial
    @ManualTrace
    public void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"run: define entities", (Object[])new Object[]{this.entities});
        }
        try (EntityManager em = null;){
            this.initialize();
            em = this.createEntityManager();
            Metamodel model = em.getMetamodel();
            for (EntityType entityType : model.getEntities()) {
                Set idClassAttributes;
                Type<?> idClassType;
                Attribute attr2;
                HashMap<String, String> attributeNames = new HashMap<String, String>();
                HashMap<String, List<Member>> attributeAccessors = new HashMap<String, List<Member>>();
                TreeMap attributeTypes = new TreeMap();
                HashMap collectionElementTypes = new HashMap();
                HashMap relationAttributeNames = new HashMap();
                LinkedList<Attribute> relationships = new LinkedList<Attribute>();
                LinkedList<Object> relationPrefixes = new LinkedList<Object>();
                LinkedList<List<Member>> relationAccessors = new LinkedList<List<Member>>();
                Class<?> recordClass = this.getRecordClass(entityType.getJavaType());
                Class idType = null;
                TreeMap<String, Member> idClassAttributeAccessors = null;
                String versionAttrName = null;
                for (Attribute attr2 : entityType.getAttributes()) {
                    SingularAttribute singleAttr;
                    String attributeName = attr2.getName();
                    Attribute.PersistentAttributeType attributeType = attr2.getPersistentAttributeType();
                    if (Attribute.PersistentAttributeType.EMBEDDED.equals((Object)attributeType) || Attribute.PersistentAttributeType.ONE_TO_ONE.equals((Object)attributeType) || Attribute.PersistentAttributeType.MANY_TO_ONE.equals((Object)attributeType)) {
                        relationAttributeNames.put(attr2.getJavaType(), new ArrayList());
                        relationships.add(attr2);
                        relationPrefixes.add(attributeName);
                        relationAccessors.add(Collections.singletonList(attr2.getJavaMember()));
                    }
                    Member accessor = recordClass == null ? attr2.getJavaMember() : recordClass.getMethod(attributeName, new Class[0]);
                    attributeNames.put(attributeName.toLowerCase(), attributeName);
                    attributeAccessors.put(attributeName, Collections.singletonList(accessor));
                    attributeTypes.put(attributeName, attr2.getJavaType());
                    if (attr2.isCollection()) {
                        if (!(attr2 instanceof PluralAttribute)) continue;
                        collectionElementTypes.put(attributeName, ((PluralAttribute)attr2).getElementType().getJavaType());
                        continue;
                    }
                    SingularAttribute singularAttribute = singleAttr = attr2 instanceof SingularAttribute ? (SingularAttribute)attr2 : null;
                    if (singleAttr != null && singleAttr.isId()) {
                        attributeNames.put("#id", attributeName);
                        idType = singleAttr.getJavaType();
                        continue;
                    }
                    if (singleAttr != null && singleAttr.isVersion()) {
                        versionAttrName = attributeName;
                        continue;
                    }
                    if (!Collection.class.isAssignableFrom(attr2.getJavaType())) continue;
                    collectionElementTypes.put(attributeName, Object.class);
                }
                HashSet<Class> entityTypeClasses = new HashSet<Class>();
                entityTypeClasses.add(entityType.getJavaType());
                while ((attr2 = (Attribute)relationships.poll()) != null) {
                    String prefix = (String)relationPrefixes.poll();
                    List accessors = (List)relationAccessors.poll();
                    ManagedType relation = model.managedType(attr2.getJavaType());
                    if (relation instanceof EntityType && !entityTypeClasses.add(attr2.getJavaType())) break;
                    List relAttributeList = (List)relationAttributeNames.get(attr2.getJavaType());
                    for (Attribute relAttr : relation.getAttributes()) {
                        String relationAttributeName = relAttr.getName();
                        String fullAttributeName = prefix + "." + relationAttributeName;
                        LinkedList<Member> relAccessors = new LinkedList<Member>(accessors);
                        relAccessors.add(relAttr.getJavaMember());
                        relAttributeList.add(fullAttributeName);
                        Attribute.PersistentAttributeType attributeType = relAttr.getPersistentAttributeType();
                        if (Attribute.PersistentAttributeType.EMBEDDED.equals((Object)attributeType) || Attribute.PersistentAttributeType.ONE_TO_ONE.equals((Object)attributeType) || Attribute.PersistentAttributeType.MANY_TO_ONE.equals((Object)attributeType)) {
                            relationAttributeNames.put(relAttr.getJavaType(), new ArrayList());
                            relationships.add(relAttr);
                            relationPrefixes.add(fullAttributeName);
                            relationAccessors.add(relAccessors);
                        }
                        relationAttributeName = relationAttributeName.toLowerCase();
                        attributeNames.putIfAbsent(relationAttributeName, fullAttributeName);
                        relationAttributeName = fullAttributeName.toLowerCase();
                        attributeNames.put(relationAttributeName, fullAttributeName);
                        String relationAttributeName_ = relationAttributeName.replace('.', '_');
                        attributeNames.putIfAbsent(relationAttributeName_, fullAttributeName);
                        String relationAttributeNameUndelimited = relationAttributeName.replace(".", "");
                        attributeNames.putIfAbsent(relationAttributeNameUndelimited, fullAttributeName);
                        attributeAccessors.put(fullAttributeName, relAccessors);
                        attributeTypes.put(fullAttributeName, relAttr.getJavaType());
                        if (relAttr.isCollection()) {
                            if (!(relAttr instanceof PluralAttribute)) continue;
                            collectionElementTypes.put(fullAttributeName, ((PluralAttribute)relAttr).getElementType().getJavaType());
                            continue;
                        }
                        if (!(relAttr instanceof SingularAttribute)) continue;
                        SingularAttribute singleAttr = (SingularAttribute)relAttr;
                        if (singleAttr.isId() && attributeNames.putIfAbsent("#id", fullAttributeName) == null) {
                            idType = singleAttr.getJavaType();
                            continue;
                        }
                        if (!singleAttr.isVersion()) continue;
                        versionAttrName = relationAttributeName_;
                    }
                }
                if (!entityType.hasSingleIdAttribute() && (idClassType = EntityManagerBuilder.getIdType(entityType)) != null && (idClassAttributes = entityType.getIdClassAttributes()) != null) {
                    attributeNames.remove("#id");
                    idType = idClassType.getJavaType();
                    idClassAttributeAccessors = new TreeMap<String, Member>();
                    for (SingularAttribute attr3 : idClassAttributes) {
                        Member entityMember = attr3.getJavaMember();
                        Field idClassMember = entityMember instanceof Field ? idType.getField(entityMember.getName()) : idType.getMethod(entityMember.getName(), new Class[0]);
                        idClassAttributeAccessors.put(attr3.getName().toLowerCase(), idClassMember);
                    }
                }
                Class entityClass = entityType.getJavaType();
                EntityInfo entityInfo = new EntityInfo(entityType.getName(), entityClass, this.getRecordClass(entityClass), attributeAccessors, attributeNames, attributeTypes, collectionElementTypes, relationAttributeNames, idType, idClassAttributeAccessors, versionAttrName, this);
                this.entityInfoMap.computeIfAbsent(entityClass, EntityInfo::newFuture).complete(entityInfo);
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run: define entities");
            }
        }
    }
}

