/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PageImpl<T>
implements Page<T> {
    private static final TraceComponent tc = Tr.register(PageImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Object[] args;
    private final PageRequest<?> pageRequest;
    private final QueryInfo queryInfo;
    private final List<T> results;
    private long totalElements = -1L;
    static final long serialVersionUID = 3376185077620121610L;

    @FFDCIgnore(value={Exception.class})
    PageImpl(QueryInfo queryInfo, PageRequest<T> pageRequest, Object[] args) {
        this.queryInfo = queryInfo;
        this.pageRequest = pageRequest == null ? PageRequest.ofSize((int)100) : pageRequest;
        this.args = args;
        if (pageRequest == null && queryInfo.paramCount == 0 && queryInfo.method.getParameterCount() == 1 && PageRequest.class.equals(queryInfo.method.getParameterTypes()[0])) {
            throw new NullPointerException("PageRequest: null");
        }
        try (EntityManager em = queryInfo.entityInfo.builder.createEntityManager();){
            TypedQuery query = em.createQuery(queryInfo.jpql, queryInfo.entityInfo.entityClass);
            queryInfo.setParameters((Query)query, args);
            int maxPageSize = pageRequest.size();
            query.setFirstResult(RepositoryImpl.computeOffset(pageRequest));
            query.setMaxResults(maxPageSize + (maxPageSize == Integer.MAX_VALUE ? 0 : 1));
            this.results = query.getResultList();
        }
    }

    @FFDCIgnore(value={Exception.class})
    private long countTotalElements() {
        if (!this.pageRequest.requestTotal()) {
            throw new IllegalStateException("A total count of elements and pages is not retreived from the database because the " + this.pageRequest + " page request specifies a value of 'false' for 'requestTotal'. To request a page with the total count included, use the PageRequest.withTotal method instead of the PageRequest.withoutTotal method.");
        }
        if (this.pageRequest.page() == 1L && this.results.size() <= this.pageRequest.size() && this.pageRequest.size() < Integer.MAX_VALUE) {
            return this.results.size();
        }
        try (EntityManager em = this.queryInfo.entityInfo.builder.createEntityManager();){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("query for count: " + this.queryInfo.jpqlCount), (Object[])new Object[0]);
            }
            TypedQuery query = em.createQuery(this.queryInfo.jpqlCount, Long.class);
            this.queryInfo.setParameters((Query)query, this.args);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    public List<T> content() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? new ResultList(max) : this.results;
    }

    public boolean hasContent() {
        return !this.results.isEmpty();
    }

    public boolean hasNext() {
        return this.results.size() > this.pageRequest.size() || this.pageRequest.size() == Integer.MAX_VALUE && this.results.size() == this.pageRequest.size();
    }

    public boolean hasPrevious() {
        return this.pageRequest.page() > 1L;
    }

    public boolean hasTotals() {
        return this.pageRequest.requestTotal();
    }

    public Iterator<T> iterator() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? new ResultIterator(max) : this.results.iterator();
    }

    public int numberOfElements() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? max : size;
    }

    public PageRequest<T> pageRequest() {
        return this.pageRequest;
    }

    public <E> PageRequest<E> pageRequest(Class<E> entityClass) {
        return this.pageRequest;
    }

    public PageRequest<T> nextPageRequest() {
        if (this.hasNext()) {
            return this.pageRequest.next();
        }
        throw new NoSuchElementException("Cannot request a next page. To avoid this error, check for a true result of Page.hasNext before attempting this method.");
    }

    public <E> PageRequest<E> nextPageRequest(Class<E> entityClass) {
        if (this.hasNext()) {
            return this.pageRequest.next();
        }
        throw new NoSuchElementException("Cannot request a next page. To avoid this error, check for a true result of Page.hasNext before attempting this method.");
    }

    public PageRequest<T> previousPageRequest() {
        if (this.pageRequest.page() > 1L) {
            return this.pageRequest.previous();
        }
        throw new NoSuchElementException("Cannot request a page number prior to " + this.pageRequest.page() + ". To avoid this error, check for a true result of Page.hasPrevious before attempting this method.");
    }

    public <E> PageRequest<E> previousPageRequest(Class<E> entityClass) {
        if (this.pageRequest.page() > 1L) {
            return this.pageRequest.previous();
        }
        throw new NoSuchElementException("Cannot request a page number prior to " + this.pageRequest.page() + ". To avoid this error, check for a true result of Page.hasPrevious before attempting this method.");
    }

    public Stream<T> stream() {
        return this.content().stream();
    }

    public long totalElements() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements;
    }

    public long totalPages() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements / (long)this.pageRequest.size() + (long)(this.totalElements % (long)this.pageRequest.size() > 0L ? 1 : 0);
    }

    @Trivial
    private class ResultList
    extends AbstractList<T>
    implements RandomAccess {
        private final int size;

        private ResultList(int size) {
            this.size = size;
        }

        @Override
        public T get(int index) {
            if (index < this.size) {
                return PageImpl.this.results.get(index);
            }
            throw new IndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Trivial
    private class ResultIterator
    implements Iterator<T> {
        private int index;
        private final Iterator<T> iterator;
        private final int size;

        private ResultIterator(int size) {
            this.size = size;
            this.iterator = PageImpl.this.results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("Element at index " + this.index);
            }
            Object result = this.iterator.next();
            ++this.index;
            return result;
        }
    }
}

