/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.repository.Count;
import io.openliberty.data.repository.Exists;
import io.openliberty.data.repository.Select;
import jakarta.data.Order;
import jakarta.data.Sort;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Find;
import jakarta.data.repository.Insert;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Query;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class QueryInfo {
    private static final TraceComponent tc = Tr.register(QueryInfo.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final Set<Class<?>> RETURN_TYPES_FOR_DELETE_ONLY = Set.of(Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Number.class);
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Void.TYPE, Void.class);
    EntityInfo entityInfo;
    final Class<?> entityParamType;
    String entityVar = "o";
    String entityVar_ = "o.";
    boolean hasWhere;
    String jpql;
    String jpqlAfterKeyset;
    String jpqlBeforeKeyset;
    String jpqlCount;
    String jpqlDelete;
    int maxResults;
    public final Method method;
    int paramCount;
    int paramAddedCount;
    List<String> paramNames;
    final Class<?> returnArrayType;
    final List<Class<?>> returnTypeAtDepth;
    List<Sort<Object>> sorts;
    Type type;
    boolean validateParams;
    boolean validateResult;
    static final long serialVersionUID = -4486845912288269639L;

    public QueryInfo(Method method, Class<?> entityParamType, Class<?> returnArrayType, List<Class<?>> returnTypeAtDepth) {
        this.method = method;
        this.entityParamType = entityParamType;
        this.returnArrayType = returnArrayType;
        this.returnTypeAtDepth = returnTypeAtDepth;
    }

    public QueryInfo(Method method, Type type) {
        this.method = method;
        this.entityParamType = null;
        this.returnArrayType = null;
        this.returnTypeAtDepth = null;
        this.type = type;
    }

    @Trivial
    void addSort(boolean ignoreCase, String attribute, boolean descending) {
        Set<String> names = this.entityInfo.idClassAttributeAccessors != null && "#id".equalsIgnoreCase(attribute) ? this.entityInfo.idClassAttributeAccessors.keySet() : Set.of(attribute);
        for (String name : names) {
            name = this.entityInfo.getAttributeName(name, true);
            this.sorts.add((Sort<Object>)(ignoreCase ? (descending ? Sort.descIgnoreCase((String)name) : Sort.ascIgnoreCase((String)name)) : (descending ? Sort.desc((String)name) : Sort.asc((String)name))));
        }
    }

    private StringBuilder appendWithIdentifierName(String ql, int startAt, int endBefore, StringBuilder q) {
        boolean isLiteral = false;
        boolean isNamedParamOrEmbedded = false;
        for (int i = startAt; i < endBefore; ++i) {
            char ch = ql.charAt(i);
            if (!(isLiteral || ch != ':' && ch != '.')) {
                q.append(ch);
                isNamedParamOrEmbedded = true;
                continue;
            }
            if (ch == '\'') {
                q.append(ch);
                if (isLiteral) {
                    if (i + 1 < endBefore && ql.charAt(i + 1) == '\'') {
                        q.append('\'');
                        ++i;
                        continue;
                    }
                    isLiteral = false;
                    continue;
                }
                isLiteral = true;
                isNamedParamOrEmbedded = false;
                continue;
            }
            if (Character.isLetter(ch)) {
                if (isNamedParamOrEmbedded || isLiteral) {
                    q.append(ch);
                    continue;
                }
                StringBuilder s = new StringBuilder();
                s.append(ch);
                for (int j = i + 1; j < endBefore && Character.isJavaIdentifierPart(ch = ql.charAt(j)); ++j) {
                    s.append(ch);
                }
                i += s.length();
                String str = s.toString();
                if ("id".equalsIgnoreCase(str) && ql.regionMatches(true, --i + 1, "(THIS)", 0, 6)) {
                    q.append(this.entityVar_).append(this.entityInfo.getAttributeName("#id", true));
                    i += 6;
                    continue;
                }
                if ("this".equalsIgnoreCase(str)) {
                    q.append(this.entityVar);
                    continue;
                }
                if (this.entityInfo.getAttributeName(str, false) == null) {
                    q.append(str);
                    continue;
                }
                q.append(this.entityVar_).append(str);
                continue;
            }
            if (Character.isDigit(ch)) {
                q.append(ch);
                continue;
            }
            q.append(ch);
            if (isLiteral) continue;
            isNamedParamOrEmbedded = false;
        }
        return q;
    }

    @Trivial
    List<Sort<Object>> combineSorts(List<Sort<Object>> combined, Iterable<Sort<Object>> additional) {
        boolean hasIdClass;
        Iterator<Sort<Object>> addIt = additional.iterator();
        boolean bl = hasIdClass = this.entityInfo.idClassAttributeAccessors != null;
        if (combined == null && addIt.hasNext()) {
            List<Sort<Object>> list = combined = this.sorts == null ? new ArrayList<Sort<Object>>() : new ArrayList<Sort<Object>>(this.sorts);
        }
        while (addIt.hasNext()) {
            Sort<Object> sort = addIt.next();
            if (sort == null) {
                throw new IllegalArgumentException("Sort: null");
            }
            if (hasIdClass && "#id".equals(sort.property())) {
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    combined.add(this.entityInfo.getWithAttributeName(this.entityInfo.getAttributeName(name, true), sort));
                }
                continue;
            }
            combined.add(this.entityInfo.getWithAttributeName(sort.property(), sort));
        }
        return combined;
    }

    @Trivial
    List<Sort<Object>> combineSorts(List<Sort<Object>> combined, Sort<Object> ... additional) {
        boolean hasIdClass;
        boolean bl = hasIdClass = this.entityInfo.idClassAttributeAccessors != null;
        if (combined == null && additional.length > 0) {
            combined = this.sorts == null ? new ArrayList<Sort<Object>>() : new ArrayList<Sort<Object>>(this.sorts);
        }
        for (Sort<Object> sort : additional) {
            if (sort == null) {
                throw new IllegalArgumentException("Sort: null");
            }
            if (hasIdClass && "#id".equals(sort.property())) {
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    combined.add(this.entityInfo.getWithAttributeName(this.entityInfo.getAttributeName(name, true), sort));
                }
                continue;
            }
            combined.add(this.entityInfo.getWithAttributeName(sort.property(), sort));
        }
        return combined;
    }

    @Trivial
    EntityInfo getEntityInfo(Class<?> entityType, Map<String, CompletableFuture<EntityInfo>> entityInfos) {
        if (entityType != null) {
            CompletableFuture<EntityInfo> failedFuture = null;
            for (CompletableFuture<EntityInfo> future : entityInfos.values()) {
                if (future.isCompletedExceptionally()) {
                    failedFuture = future;
                    continue;
                }
                EntityInfo info = future.join();
                if (!entityType.equals(info.entityClass)) continue;
                return info;
            }
            if (failedFuture != null) {
                failedFuture.join();
            }
        }
        throw new MappingException("The " + this.method.getName() + " method of the " + this.method.getDeclaringClass().getName() + " repository does not specify an entity class. To correct this, have the repository interface extend DataRepository or another built-in repository interface and supply the entity class as the first type variable.");
    }

    @Trivial
    EntityInfo getEntityInfo(String entityName, Map<String, CompletableFuture<EntityInfo>> entityInfos) {
        CompletableFuture<EntityInfo> future = entityInfos.get(entityName);
        if (future == null) {
            for (String name : entityInfos.keySet()) {
                if (!entityName.equalsIgnoreCase(name)) continue;
                throw new MappingException("The " + this.method.getName() + " method of the " + this.method.getDeclaringClass().getName() + " repository specifies query language that requires a " + entityName + " entity that is not found but is a close match for the " + name + " entity. Review the query language to ensure the correct entity name is used.");
            }
            future = entityInfos.get("ERROR!");
            if (future == null) {
                throw new MappingException("The " + this.method.getName() + " method of the " + this.method.getDeclaringClass().getName() + " repository specifies query language that requires a " + entityName + " entity that is not found. Check if " + entityName + " is the name of a valid entity. To enable the entity to be found, give the repository a life cycle method that is annotated with one of (Insert, Save, Update, Delete) and supply the entity as its parameter or have the repository extend DataRepository or another built-in repository interface with the entity class as the first type variable.");
            }
        }
        return future.join();
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    Object[] getKeysetValues(Object entity) {
        if (!this.entityInfo.getType().isInstance(entity)) {
            throw new MappingException("Unable to obtain keyset values from the " + (entity == null ? null : entity.getClass().getName()) + " type query result. Queries that use keyset pagination must return results of the same type as the entity type, which is " + this.entityInfo.getType().getName() + ".");
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (Sort<Object> keyInfo : this.sorts) {
            try {
                List<Member> accessors = this.entityInfo.attributeAccessors.get(keyInfo.property());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("getKeysetValues for " + entity), (Object[])new Object[]{accessors});
                }
                Object value = entity;
                for (Member accessor : accessors) {
                    if (accessor instanceof Method) {
                        value = ((Method)accessor).invoke(value, new Object[0]);
                        continue;
                    }
                    value = ((Field)accessor).get(value);
                }
                keyValues.add(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException accessors) {
                void x;
                FFDCFilter.processException((Throwable)accessors, (String)"io.openliberty.data.internal.persistence.QueryInfo", (String)"493", (Object)this, (Object[])new Object[]{entity});
                throw new DataException((Throwable)(x instanceof InvocationTargetException ? x.getCause() : x));
            }
        }
        return keyValues.toArray();
    }

    @Trivial
    Class<?> getMultipleResultType() {
        Class<?> type = null;
        int depth = this.returnTypeAtDepth.size();
        for (int d = 0; d < depth - 1 && type == null; ++d) {
            type = this.returnTypeAtDepth.get(d);
            if (!Optional.class.equals(type) && !CompletionStage.class.equals(type) && !CompletableFuture.class.equals(type)) continue;
            type = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getMultipleResultType: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        return type;
    }

    @Trivial
    Class<?> getOptionalResultType() {
        Class<?> type = null;
        int depth = this.returnTypeAtDepth.size();
        for (int d = 0; d < depth - 1; ++d) {
            type = this.returnTypeAtDepth.get(d);
            if (Optional.class.equals(type)) {
                type = this.returnTypeAtDepth.get(d + 1);
                break;
            }
            type = null;
            if (!CompletionStage.class.equals(type) || !CompletableFuture.class.equals(type)) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getOptionalResultType: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        return type;
    }

    @Trivial
    Class<?> getSingleResultType() {
        Class<?> type = this.returnTypeAtDepth.get(this.returnTypeAtDepth.size() - 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getSingleResultType: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        return type;
    }

    @Trivial
    boolean hasDynamicSortCriteria() {
        boolean hasDynamicSort = false;
        Class<?>[] paramTypes = this.method.getParameterTypes();
        for (int i = this.paramCount - this.paramAddedCount; i < paramTypes.length && !hasDynamicSort; ++i) {
            hasDynamicSort = PageRequest.class.equals(paramTypes[i]) || Order.class.equals(paramTypes[i]) || Sort[].class.equals(paramTypes[i]) || Sort.class.equals(paramTypes[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("hasDynamicSortCriteria? " + hasDynamicSort), (Object[])new Object[0]);
        }
        return hasDynamicSort;
    }

    private static int indexOfAfterWhitespace(String text, String ql, int startAt) {
        int length = ql.length();
        while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
            ++startAt;
        }
        return ql.regionMatches(true, startAt, text, 0, 2) ? startAt : -1;
    }

    void init(Class<? extends Annotation> annoClass, Type operationType) {
        this.type = operationType;
        if (this.entityParamType == null) {
            throw new UnsupportedOperationException("Repository @" + annoClass.getSimpleName() + " operations must have exactly 1 parameter, which can be the entity or a collection or array of entities. The " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + " method has " + this.method.getParameterCount() + " parameters.");
        }
    }

    void initForQuery(String ql, Class<?> multiType, Map<String, CompletableFuture<EntityInfo>> entityInfos) {
        int startAt;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        boolean isCursoredPage = CursoredPage.class.equals(multiType);
        boolean countPages = isCursoredPage || Page.class.equals(multiType);
        int length = ql.length();
        int firstChar = 32;
        for (startAt = 0; startAt < length; ++startAt) {
            char c = ql.charAt(startAt);
            firstChar = c;
            if (!Character.isWhitespace(c)) break;
        }
        if (firstChar == 68 || firstChar == 100) {
            if (startAt + 12 < length && ql.regionMatches(true, startAt + 1, "ELETE", 0, 5) && Character.isWhitespace(ql.charAt(startAt + 6))) {
                this.type = Type.DELETE;
                this.jpql = ql;
                startAt += 7;
                while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
                    ++startAt;
                }
                if (startAt + 6 < length && ql.regionMatches(true, startAt, "FROM", 0, 4) && Character.isWhitespace(ql.charAt(startAt + 4))) {
                    char ch;
                    startAt += 5;
                    while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
                        ++startAt;
                    }
                    StringBuilder entityName = new StringBuilder();
                    while (startAt < length && Character.isJavaIdentifierPart(ch = ql.charAt(startAt))) {
                        entityName.append(ch);
                        ++startAt;
                    }
                    if (entityName.length() > 0) {
                        this.entityInfo = this.getEntityInfo(entityName.toString(), entityInfos);
                        while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
                            ++startAt;
                        }
                        if (startAt >= length) {
                            this.entityVar = "o";
                            this.entityVar_ = "o.";
                            this.jpql = new StringBuilder(entityName.length() + 14).append("DELETE FROM ").append((CharSequence)entityName).append(" o").toString();
                        } else if (startAt + 6 < length && ql.regionMatches(true, startAt, "WHERE", 0, 5) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 5))) {
                            this.hasWhere = true;
                            this.entityVar = "o";
                            this.entityVar_ = "o.";
                            StringBuilder q = new StringBuilder(ql.length() * 3 / 2).append("DELETE FROM ").append((CharSequence)entityName).append(" o WHERE");
                            this.jpql = this.appendWithIdentifierName(ql, startAt + 5, ql.length(), q).toString();
                        }
                    }
                }
            }
        } else if (firstChar == 85 || firstChar == 117) {
            if (startAt + 13 < length && ql.regionMatches(true, startAt + 1, "PDATE", 0, 5) && Character.isWhitespace(ql.charAt(startAt + 6))) {
                char ch;
                this.type = Type.UPDATE;
                this.jpql = ql;
                startAt += 7;
                while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
                    ++startAt;
                }
                StringBuilder entityName = new StringBuilder();
                while (startAt < length && Character.isJavaIdentifierPart(ch = ql.charAt(startAt))) {
                    entityName.append(ch);
                    ++startAt;
                }
                if (entityName.length() > 0) {
                    this.entityInfo = this.getEntityInfo(entityName.toString(), entityInfos);
                } else if (this.entityInfo == null) {
                    throw new MappingException("@Repository " + this.method.getDeclaringClass().getName() + " does not specify an entity class. To correct this, have the repository interface extend DataRepository or another built-in repository interface and supply the entity class as the first parameter.");
                }
                if (startAt + 1 < length && entityName.length() > 0 && Character.isWhitespace(ql.charAt(startAt))) {
                    ++startAt;
                    while (startAt < length && Character.isWhitespace(ql.charAt(startAt))) {
                        ++startAt;
                    }
                    if (startAt + 4 < length && ql.regionMatches(true, startAt, "SET", 0, 3) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 3))) {
                        this.entityVar = "o";
                        this.entityVar_ = "o.";
                        StringBuilder q = new StringBuilder(ql.length() * 3 / 2).append("UPDATE ").append((CharSequence)entityName).append(" o SET");
                        this.jpql = this.appendWithIdentifierName(ql, startAt + 3, ql.length(), q).toString();
                    }
                }
            }
        } else {
            boolean lacksEntityVar;
            int select0 = -1;
            int selectLen = 0;
            int from0 = -1;
            int fromLen = 0;
            int where0 = -1;
            int whereLen = 0;
            int order0 = -1;
            int orderLen = 0;
            if (length > startAt + 6 && ql.regionMatches(true, startAt, "SELECT", 0, 6) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 6))) {
                select0 = startAt += 6;
            }
            boolean isLiteral = false;
            boolean isNamedParamOrEmbedded = false;
            while (startAt < length) {
                char ch = ql.charAt(startAt);
                if (!(isLiteral || ch != ':' && ch != '.')) {
                    isNamedParamOrEmbedded = true;
                } else if (ch == '\'') {
                    if (isLiteral) {
                        if (startAt + 1 < length && ql.charAt(startAt + 1) == '\'') {
                            ++startAt;
                        } else {
                            isLiteral = false;
                        }
                    } else {
                        isLiteral = true;
                        isNamedParamOrEmbedded = false;
                    }
                } else if (Character.isLetter(ch)) {
                    if (!isNamedParamOrEmbedded && !isLiteral) {
                        int by;
                        if (from0 < 0 && where0 < 0 && length > startAt + 4 && ql.regionMatches(true, startAt, "FROM", 0, 4) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 4))) {
                            if (select0 >= 0 && selectLen == 0) {
                                selectLen = startAt - select0;
                            }
                            from0 = startAt + 4;
                            startAt = from0 - 1;
                        } else if (length > startAt + 5 && ql.regionMatches(true, startAt, "WHERE", 0, 5) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 5))) {
                            if (select0 >= 0 && selectLen == 0) {
                                selectLen = startAt - select0;
                            } else if (from0 >= 0 && fromLen == 0) {
                                fromLen = startAt - from0;
                            }
                            where0 = startAt + 5;
                            startAt = where0 - 1;
                            whereLen = 0;
                        } else if (length > startAt + 8 && ql.regionMatches(true, startAt, "GROUP", 0, 5) && (by = QueryInfo.indexOfAfterWhitespace("BY", ql, startAt + 5)) > 0) {
                            if (select0 >= 0 && selectLen == 0) {
                                selectLen = startAt - select0;
                            } else if (from0 >= 0 && fromLen == 0) {
                                fromLen = startAt - from0;
                            } else if (where0 >= 0 && whereLen == 0) {
                                whereLen = startAt - where0;
                            }
                            startAt = by + 2 - 1;
                        } else if (length > startAt + 6 && ql.regionMatches(true, startAt, "HAVING", 0, 6) && !Character.isJavaIdentifierPart(ql.charAt(startAt + 6))) {
                            if (select0 >= 0 && selectLen == 0) {
                                selectLen = startAt - select0;
                            } else if (from0 >= 0 && fromLen == 0) {
                                fromLen = startAt - from0;
                            } else if (where0 >= 0 && whereLen == 0) {
                                whereLen = startAt - where0;
                            }
                            startAt += 5;
                        } else if (length > startAt + 8 && ql.regionMatches(true, startAt, "ORDER", 0, 5) && (by = QueryInfo.indexOfAfterWhitespace("BY", ql, startAt + 5)) > 0) {
                            if (select0 >= 0 && selectLen == 0) {
                                selectLen = startAt - select0;
                            } else if (from0 >= 0 && fromLen == 0) {
                                fromLen = startAt - from0;
                            } else if (where0 >= 0 && whereLen == 0) {
                                whereLen = startAt - where0;
                            }
                            order0 = startAt;
                            startAt = by + 2 - 1;
                        } else {
                            while (length > startAt + 1 && Character.isJavaIdentifierPart(ql.charAt(startAt + 1))) {
                                ++startAt;
                            }
                        }
                    }
                } else if (!Character.isDigit(ch) && !isLiteral) {
                    isNamedParamOrEmbedded = false;
                }
                ++startAt;
            }
            if (select0 >= 0 && selectLen == 0) {
                selectLen = length - select0;
            } else if (from0 >= 0 && fromLen == 0) {
                fromLen = length - from0;
            } else if (where0 >= 0 && whereLen == 0) {
                whereLen = length - where0;
            } else if (order0 >= 0 && orderLen == 0) {
                orderLen = length - order0;
            }
            this.type = Type.FIND;
            this.entityVar = "this";
            this.entityVar_ = "";
            this.hasWhere = whereLen > 0;
            for (startAt = from0; startAt < from0 + fromLen && Character.isWhitespace(ql.charAt(startAt)); ++startAt) {
            }
            if (startAt < from0 + fromLen) {
                int entityName0 = startAt;
                int entityNameLen = 0;
                while (startAt < from0 + fromLen && Character.isJavaIdentifierPart(ql.charAt(startAt))) {
                    ++startAt;
                }
                entityNameLen = startAt - entityName0;
                if (entityNameLen > 0) {
                    String entityName = ql.substring(entityName0, entityName0 + entityNameLen);
                    this.entityInfo = this.getEntityInfo(entityName, entityInfos);
                    while (startAt < from0 + fromLen && Character.isWhitespace(ql.charAt(startAt))) {
                        ++startAt;
                    }
                    if (startAt < from0 + fromLen) {
                        int idVar0 = startAt;
                        int idVarLen = 0;
                        while (startAt < from0 + fromLen && Character.isJavaIdentifierPart(ql.charAt(startAt))) {
                            ++startAt;
                        }
                        idVarLen = startAt - idVar0;
                        if (idVarLen > 0) {
                            if (!(idVarLen != 2 || ql.charAt(idVar0) != 'A' && ql.charAt(idVar0) != 'a' || ql.charAt(idVar0 + 1) != 'S' && ql.charAt(idVar0 + 1) != 's')) {
                                while (startAt < from0 + fromLen && Character.isWhitespace(ql.charAt(startAt))) {
                                    ++startAt;
                                }
                                idVar0 = startAt;
                                while (startAt < from0 + fromLen && Character.isJavaIdentifierPart(ql.charAt(startAt))) {
                                    ++startAt;
                                }
                            }
                            if (startAt > idVar0) {
                                this.entityVar = ql.substring(idVar0, startAt);
                                this.entityVar_ = this.entityVar + ".";
                            }
                        }
                    }
                }
            }
            if (this.entityInfo == null) {
                this.entityInfo = this.getEntityInfo(this.getSingleResultType(), entityInfos);
            }
            String entityName = this.entityInfo.name;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)ql, (Object[])new Object[]{"JDQL query parts", "  SELECT [" + (selectLen > 0 ? ql.substring(select0, select0 + selectLen) : "") + "]", "    FROM [" + (fromLen > 0 ? ql.substring(from0, from0 + fromLen) : "") + "]", "   WHERE [" + (whereLen > 0 ? ql.substring(where0, where0 + whereLen) : "") + "]", "  [" + (orderLen > 0 ? ql.substring(order0, order0 + orderLen) : "") + "]", "  entity [" + entityName + "] [" + this.entityVar + "]"});
            }
            if (lacksEntityVar = "this".equals(this.entityVar)) {
                this.entityVar = "o";
                this.entityVar_ = "o.";
            }
            if (countPages) {
                StringBuilder c = new StringBuilder("SELECT COUNT(");
                if (lacksEntityVar || selectLen <= 0 || ql.substring(select0, select0 + selectLen).indexOf(44) >= 0) {
                    c.append(this.entityVar);
                } else {
                    this.appendWithIdentifierName(ql, select0, select0 + selectLen, c);
                }
                c.append(") FROM");
                if (from0 >= 0 && !lacksEntityVar) {
                    c.append(ql.substring(from0, from0 + fromLen));
                } else {
                    c.append(' ').append(entityName).append(' ').append(this.entityVar).append(' ');
                }
                if (whereLen > 0) {
                    c.append("WHERE");
                    this.appendWithIdentifierName(ql, where0, where0 + whereLen, c);
                }
                this.jpqlCount = c.toString();
            }
            if (isCursoredPage) {
                if (order0 >= 0) {
                    throw new UnsupportedOperationException("The " + ql + " query that is supplied to the " + this.method.getName() + " method of the " + this.method.getDeclaringClass().getName() + " repository cannot include an ORDER BY clause because the method returns a CursoredPage. Remove the ORDER BY clause and instead use the OrderBy annotation to specify static sort criteria.");
                }
                if (where0 + whereLen != length) {
                    throw new UnsupportedOperationException("The " + ql + " query that is supplied to the " + this.method.getName() + " method of the " + this.method.getDeclaringClass().getName() + " repository must end in a WHERE clause because the method returns a CursoredPage. There WHERE clause ends at position " + (where0 + whereLen) + " but the length of the query is " + length + ".");
                }
                boolean addSpace = ql.charAt(where0) != ' ';
                ql = new StringBuilder(ql.length() + 2).append(ql.substring(0, where0)).append(" (").append(ql.substring(where0 + (addSpace ? 0 : 1), where0 + whereLen)).append(")").toString();
                whereLen += 2 + (addSpace ? 1 : 0);
            }
            StringBuilder q = new StringBuilder(ql.length() + (selectLen >= 0 ? 0 : 50) + (fromLen >= 0 ? 0 : 50) + 2);
            q.append("SELECT");
            if (selectLen > 0) {
                this.appendWithIdentifierName(ql, select0, select0 + selectLen, q);
            } else {
                q.append(' ').append(this.entityVar).append(' ');
            }
            q.append("FROM");
            if (fromLen > 0 && !lacksEntityVar) {
                q.append(ql.substring(from0, from0 + fromLen));
            } else {
                q.append(' ').append(entityName).append(' ').append(this.entityVar).append(' ');
            }
            if (whereLen > 0) {
                q.append("WHERE");
                this.appendWithIdentifierName(ql, where0, where0 + whereLen, q);
            }
            if (orderLen > 0) {
                this.appendWithIdentifierName(ql, order0, order0 + orderLen, q);
            }
            this.jpql = q.toString();
        }
    }

    @Trivial
    boolean isFindAndDelete() {
        boolean isMultiple;
        boolean isOptional;
        boolean isFindAndDelete = true;
        int d = 0;
        Class<?> type = this.returnTypeAtDepth.get(0);
        if (CompletionStage.class.equals(type) || CompletableFuture.class.equals(type)) {
            type = this.returnTypeAtDepth.get(++d);
        }
        if (isOptional = Optional.class.equals(type)) {
            type = this.returnTypeAtDepth.get(++d);
        }
        if (isMultiple = d < this.returnTypeAtDepth.size() - 1) {
            type = this.returnTypeAtDepth.get(++d);
        }
        boolean bl = isFindAndDelete = isOptional || isMultiple || !RETURN_TYPES_FOR_DELETE_ONLY.contains(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isFindAndDelete? " + isFindAndDelete + " isOptional? " + isOptional + " isMultiple? " + isMultiple + " type: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        if (!(!isFindAndDelete || type == null || type.equals(this.entityInfo.entityClass) || type.equals(this.entityInfo.recordClass) || type.equals(Object.class) || QueryInfo.wrapperClassIfPrimitive(type).equals(QueryInfo.wrapperClassIfPrimitive(this.entityInfo.idType)))) {
            throw new MappingException("Results for find-and-delete repository queries must be the entity class (" + (this.entityInfo.recordClass == null ? this.entityInfo.entityClass : this.entityInfo.recordClass).getName() + ") or the id class (" + this.entityInfo.idType + "), not the " + type.getName() + " class.");
        }
        return isFindAndDelete;
    }

    @Trivial
    private void keysetSizeMismatchError(PageRequest.Cursor keysetCursor) {
        ArrayList<String> keyTypes = new ArrayList<String>();
        for (int i = 0; i < keysetCursor.size(); ++i) {
            keyTypes.add(keysetCursor.get(i) == null ? null : keysetCursor.get(i).getClass().getName());
        }
        throw new MappingException("The keyset cursor with key types " + keyTypes + " cannot be used with sort criteria of " + this.sorts + " because they have different numbers of elements. The keyset size is " + keysetCursor.size() + " and the sort criteria size is " + this.sorts.size() + ".");
    }

    void setKeysetParameters(jakarta.persistence.Query query, PageRequest.Cursor keysetCursor) throws Exception {
        int paramNum = this.paramCount;
        if (this.paramNames == null) {
            for (int i = 0; i < keysetCursor.size(); ++i) {
                Object value = keysetCursor.get(i);
                if (this.entityInfo.idClassAttributeAccessors != null && this.entityInfo.idType.isInstance(value)) {
                    for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                        Object v;
                        Object object = v = accessor instanceof Field ? ((Field)accessor).get(value) : ((Method)accessor).invoke(value, new Object[0]);
                        if (++paramNum - this.paramCount > this.sorts.size()) {
                            this.keysetSizeMismatchError(keysetCursor);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter ?" + paramNum + " " + value.getClass().getName() + "-->" + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
                        }
                        query.setParameter(paramNum, v);
                    }
                    continue;
                }
                if (++paramNum - this.paramCount > this.sorts.size()) {
                    this.keysetSizeMismatchError(keysetCursor);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter ?" + paramNum + " " + (value == null ? null : value.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter(paramNum, value);
            }
        } else {
            for (int i = 0; i < keysetCursor.size(); ++i) {
                Object value = keysetCursor.get(i);
                if (this.entityInfo.idClassAttributeAccessors != null && this.entityInfo.idType.isInstance(value)) {
                    for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                        Object v;
                        Object object = v = accessor instanceof Field ? ((Field)accessor).get(value) : ((Method)accessor).invoke(value, new Object[0]);
                        if (++paramNum - this.paramCount > this.sorts.size()) {
                            this.keysetSizeMismatchError(keysetCursor);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter :keyset" + paramNum + " " + value.getClass().getName() + "-->" + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
                        }
                        query.setParameter("keyset" + paramNum, v);
                    }
                    continue;
                }
                if (++paramNum - this.paramCount > this.sorts.size()) {
                    this.keysetSizeMismatchError(keysetCursor);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter :keyset" + paramNum + " " + (value == null ? null : value.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter("keyset" + paramNum, value);
            }
        }
        if (this.sorts.size() > paramNum - this.paramCount) {
            this.keysetSizeMismatchError(keysetCursor);
        }
    }

    @Trivial
    static void setParameter(int p, jakarta.persistence.Query query, Object entity, List<Member> accessors) throws Exception {
        Object v = entity;
        for (Member accessor : accessors) {
            v = accessor instanceof Method ? ((Method)accessor).invoke(v, new Object[0]) : ((Field)accessor).get(v);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
        }
        query.setParameter(p, v);
    }

    void setParameters(jakarta.persistence.Query query, Object ... args) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int methodParamForQueryCount = this.paramCount - this.paramAddedCount;
        if (args != null && args.length < methodParamForQueryCount) {
            throw new MappingException("The " + this.method.getName() + " repository method has " + args.length + " parameters, but requires " + methodParamForQueryCount + " method parameters. The generated JPQL query is: " + this.jpql + ".");
        }
        int namedParamCount = this.paramNames == null ? 0 : this.paramNames.size();
        int p = 0;
        for (int i = 0; i < methodParamForQueryCount; ++i) {
            Object arg = args[i];
            if (arg == null || this.entityInfo.idClassAttributeAccessors == null || !this.entityInfo.idType.isInstance(arg)) {
                if (p < namedParamCount) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("set :" + this.paramNames.get(p) + " " + (arg == null ? null : arg.getClass().getSimpleName())), (Object[])new Object[0]);
                    }
                    query.setParameter(this.paramNames.get(p++), arg);
                    continue;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + (arg == null ? null : arg.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter(++p, arg);
                continue;
            }
            for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                Object param;
                Object object = param = accessor instanceof Method ? ((Method)accessor).invoke(arg, new Object[0]) : ((Field)accessor).get(arg);
                if (p < namedParamCount) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("set :" + this.paramNames.get(p) + " " + (param == null ? null : param.getClass().getSimpleName())), (Object[])new Object[0]);
                    }
                    query.setParameter(this.paramNames.get(p++), param);
                    continue;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + (param == null ? null : param.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter(++p, param);
            }
        }
    }

    void setParametersFromIdClassAndVersion(jakarta.persistence.Query query, Object entity, Object version) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int p = 0;
        for (String idClassAttr : this.entityInfo.idClassAttributeAccessors.keySet()) {
            QueryInfo.setParameter(++p, query, entity, this.entityInfo.attributeAccessors.get(this.entityInfo.getAttributeName(idClassAttr, true)));
        }
        if (version != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + version), (Object[])new Object[0]);
            }
            query.setParameter(++p, version);
        }
    }

    @Trivial
    public String toString() {
        StringBuilder b = new StringBuilder("QueryInfo@").append(Integer.toHexString(this.hashCode())).append(' ').append(this.method.getReturnType().getSimpleName()).append(' ').append(this.method.getName());
        boolean first = true;
        for (Class<?> p : this.method.getParameterTypes()) {
            b.append(first ? "(" : ", ").append(p.getSimpleName());
            first = false;
        }
        b.append(first ? "() " : ") ");
        if (this.jpql != null) {
            b.append(this.jpql);
        }
        if (this.paramCount > 0) {
            b.append(" [").append(this.paramCount).append(this.paramNames == null ? " positional params" : " named params");
            if (this.paramAddedCount != 0) {
                b.append(", ").append(this.paramCount - this.paramAddedCount).append(" method params");
            }
            b.append(']');
        }
        return b.toString();
    }

    @Trivial
    Annotation validateAnnotationCombinations(Delete delete, Insert insert, Update update, Save save, Find find, Query query, OrderBy[] orderBy, Count count, Exists exists, Select select) {
        int o = orderBy.length == 0 ? 0 : 1;
        int f = find == null ? 0 : 1;
        int q = query == null ? 0 : 1;
        int s = select == null ? 0 : 1;
        int ius = (insert == null ? 0 : 1) + (update == null ? 0 : 1) + (save == null ? 0 : 1);
        int iusdce = ius + (delete == null ? 0 : 1) + (count == null ? 0 : 1) + (exists == null ? 0 : 1);
        if (iusdce + f > 1 || iusdce + o > 1 || iusdce + q + s > 1) {
            ArrayList<String> annoClassNames = new ArrayList<String>();
            for (Annotation anno : Arrays.asList(count, delete, exists, find, insert, query, save, select, update)) {
                if (anno == null) continue;
                annoClassNames.add(anno.annotationType().getName());
            }
            if (orderBy.length > 0) {
                annoClassNames.add(OrderBy.class.getName());
            }
            throw new UnsupportedOperationException("The " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + " repository method cannot be annotated with the following combination of annotations: " + annoClassNames);
        }
        return ius == 1 ? (insert != null ? insert : (update != null ? update : save)) : (iusdce == 1 ? (delete != null ? delete : (count != null ? count : exists)) : (q == 1 ? query : (f == 1 ? find : null)));
    }

    QueryInfo withJPQL(String jpql, List<Sort<Object>> sorts) {
        QueryInfo q = new QueryInfo(this.method, this.entityParamType, this.returnArrayType, this.returnTypeAtDepth);
        q.entityInfo = this.entityInfo;
        q.entityVar = this.entityVar;
        q.entityVar_ = this.entityVar_;
        q.hasWhere = this.hasWhere;
        q.jpql = jpql;
        q.jpqlAfterKeyset = this.jpqlAfterKeyset;
        q.jpqlBeforeKeyset = this.jpqlBeforeKeyset;
        q.jpqlCount = this.jpqlCount;
        q.jpqlDelete = this.jpqlDelete;
        q.maxResults = this.maxResults;
        q.paramCount = this.paramCount;
        q.paramAddedCount = this.paramAddedCount;
        q.paramNames = this.paramNames;
        q.sorts = sorts;
        q.type = this.type;
        q.validateParams = this.validateParams;
        q.validateParams = this.validateResult;
        return q;
    }

    @Trivial
    static final Class<?> wrapperClassIfPrimitive(Class<?> c) {
        Class<?> w = WRAPPER_CLASSES.get(c);
        return w == null ? c : w;
    }

    public static enum Type {
        COUNT,
        DELETE,
        DELETE_WITH_ENTITY_PARAM,
        EXISTS,
        FIND,
        FIND_AND_DELETE,
        INSERT,
        SAVE,
        RESOURCE_ACCESS,
        UPDATE,
        UPDATE_WITH_ENTITY_PARAM,
        UPDATE_WITH_ENTITY_PARAM_AND_RESULT;

    }
}

