/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.cdi.DataExtensionProvider;
import io.openliberty.data.internal.persistence.cdi.RepositoryProducer;
import io.openliberty.data.internal.persistence.provider.PUnitEMBuilder;
import io.openliberty.data.internal.persistence.service.DBStoreEMBuilder;
import jakarta.annotation.Generated;
import jakarta.data.exceptions.MappingException;
import jakarta.data.metamodel.StaticMetamodel;
import jakarta.data.repository.By;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Insert;
import jakarta.data.repository.Query;
import jakarta.data.repository.Repository;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.data.spi.EntityDefining;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Qualifier;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DataExtension
implements Extension,
PrivilegedAction<DataExtensionProvider> {
    private static final TraceComponent tc = Tr.register(DataExtension.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final DataExtensionProvider provider = AccessController.doPrivileged(this);
    private final ConcurrentHashMap<jakarta.enterprise.inject.spi.AnnotatedType<?>, Repository> repositoryAnnos = new ConcurrentHashMap();
    private final Map<Class<?>, List<Class<?>>> staticMetamodels = new HashMap();
    static final long serialVersionUID = 1353122087596194510L;

    @Trivial
    public <T> void annotatedRepository(@Observes @WithAnnotations(value={Repository.class}) ProcessAnnotatedType<T> event) {
        boolean provide;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        jakarta.enterprise.inject.spi.AnnotatedType type = event.getAnnotatedType();
        Repository repository = (Repository)type.getAnnotation(Repository.class);
        String dataProvider = repository.provider();
        boolean bl = provide = "".equals(dataProvider) || "OpenLiberty".equalsIgnoreCase(dataProvider);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedRepository to " + (provide ? "provide" : "ignore")), (Object[])new Object[]{repository.toString(), type.getJavaClass().getName()});
        }
        if (provide) {
            this.repositoryAnnos.put(type, repository);
        }
    }

    @Trivial
    public <T> void annotatedStaticMetamodel(@Observes @WithAnnotations(value={StaticMetamodel.class}) ProcessAnnotatedType<T> event) {
        jakarta.enterprise.inject.spi.AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(Generated.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedStaticMetamodel ignoring generated " + type.getJavaClass().getName()), (Object[])new Object[0]);
            }
        } else {
            StaticMetamodel staticMetamodel = (StaticMetamodel)type.getAnnotation(StaticMetamodel.class);
            Class entityClass = staticMetamodel.value();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedStaticMetamodel for " + entityClass.getName()), (Object[])new Object[]{type.getJavaClass().getName()});
            }
            LinkedList<Class> newList = new LinkedList<Class>();
            newList.add(type.getJavaClass());
            List existingList = this.staticMetamodels.putIfAbsent(entityClass, newList);
            if (existingList != null) {
                existingList.add(type.getJavaClass());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={NamingException.class})
    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanMgr) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        HashMap<EntityManagerBuilder, EntityManagerBuilder> entityGroups = new HashMap<EntityManagerBuilder, EntityManagerBuilder>();
        Iterator it = ((ConcurrentHashMap.KeySetView)this.repositoryAnnos.keySet()).iterator();
        while (true) {
            Class[] primaryEntityClassReturnValue;
            HashMap queriesPerEntityClass;
            boolean isJNDIName;
            boolean isConfigDisplayId;
            Object dataStore;
            EntityManagerBuilder emBuilder;
            ClassLoader loader;
            Class repositoryInterface;
            jakarta.enterprise.inject.spi.AnnotatedType repositoryType;
            block24: {
                int n;
                Method[] methodArray;
                block27: {
                    block25: {
                        block26: {
                            if (!it.hasNext()) break block25;
                            repositoryType = (jakarta.enterprise.inject.spi.AnnotatedType)it.next();
                            it.remove();
                            Repository repository = (Repository)repositoryType.getAnnotation(Repository.class);
                            repositoryInterface = repositoryType.getJavaClass();
                            loader = repositoryInterface.getClassLoader();
                            emBuilder = null;
                            dataStore = repository.dataStore();
                            if (((String)dataStore).length() != 0) break block26;
                            dataStore = "defaultDatabaseStore";
                            isConfigDisplayId = false;
                            isJNDIName = false;
                            methodArray = repositoryInterface.getMethods();
                            n = methodArray.length;
                            break block27;
                        }
                        isConfigDisplayId = false;
                        isJNDIName = ((String)dataStore).startsWith("java:");
                        if (isJNDIName) {
                            try {
                                Object resource = InitialContext.doLookup((String)dataStore);
                                if (resource instanceof EntityManagerFactory) {
                                    emBuilder = new PUnitEMBuilder((EntityManagerFactory)resource, (String)dataStore, loader);
                                }
                                if (trace && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)((String)dataStore + " is the JNDI name for " + resource), (Object[])new Object[0]);
                                }
                                break block24;
                            }
                            catch (NamingException resource) {}
                            break block24;
                        } else {
                            String javaCompName = "java:comp/env/" + (String)dataStore;
                            try {
                                Object resource = InitialContext.doLookup(javaCompName);
                                if (resource instanceof EntityManagerFactory) {
                                    emBuilder = new PUnitEMBuilder((EntityManagerFactory)resource, javaCompName, loader);
                                }
                                if (emBuilder != null || resource instanceof DataSource) {
                                    isJNDIName = true;
                                    dataStore = javaCompName;
                                }
                                if (trace && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)((String)dataStore + " is the JNDI name for " + resource), (Object[])new Object[0]);
                                }
                                break block24;
                            }
                            catch (NamingException resource) {
                                // empty catch block
                            }
                        }
                        break block24;
                    }
                    for (EntityManagerBuilder builder : entityGroups.values()) {
                        this.provider.executor.submit(builder);
                    }
                    Iterator iterator = entityGroups.values().iterator();
                    while (true) {
                        EntityManagerBuilder builder;
                        if (!iterator.hasNext()) {
                            return;
                        }
                        builder = (EntityManagerBuilder)iterator.next();
                        builder.populateStaticMetamodelClasses(this.staticMetamodels);
                    }
                }
                for (int i = 0; i < n; ++i) {
                    Annotation[] annos;
                    Class<?> returnType;
                    Method method = methodArray[i];
                    if (method.getParameterCount() != 0 || !DataSource.class.equals(returnType = method.getReturnType()) && !EntityManager.class.equals(returnType)) continue;
                    ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
                    for (Annotation anno : annos = method.getAnnotations()) {
                        if (!anno.annotationType().isAnnotationPresent(Qualifier.class)) continue;
                        qualifiers.add(anno);
                    }
                    int numQualifiers = qualifiers.size();
                    if (numQualifiers <= 0) continue;
                    Annotation[] annotationArray = annos = numQualifiers == annos.length ? annos : qualifiers.toArray(new Annotation[numQualifiers]);
                    if (DataSource.class.equals(returnType)) {
                        Instance instance = CDI.current().select(DataSource.class, annos);
                        DataSource resource = (DataSource)instance.get();
                        isConfigDisplayId = true;
                        isJNDIName = false;
                        try {
                            resource.getLoginTimeout();
                            Object wsJdbcDataSource = resource.getClass().getDeclaredMethod("weld_getTargetInstance", new Class[0]).invoke((Object)resource, new Object[0]);
                            dataStore = (String)wsJdbcDataSource.getClass().getMethod("getDisplayId", new Class[0]).invoke(wsJdbcDataSource, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | SQLException wsJdbcDataSource) {
                            void x;
                            FFDCFilter.processException((Throwable)wsJdbcDataSource, (String)"io.openliberty.data.internal.persistence.cdi.DataExtension", (String)"215", (Object)this, (Object[])new Object[]{event, beanMgr});
                            throw new UnsupportedOperationException("The " + resource.getClass() + " DataSource is not managed by the server. Use @DataSourceDefinition to configure a DataSource in the application  or configure a dataSource in the server configuration, and update the producer to use @Resource. For example: @Produces @MyQualifier @Resource(lookup = \"java:app/jdbc/MyDataSource\") DataSource dataSource; The DataSource is used by the " + method.getName() + " resource accessor method of the " + method.getDeclaringClass().getName() + " repository.", (Throwable)x);
                        }
                        if (emBuilder != null) {
                            throw new UnsupportedOperationException("The " + method.getName() + " resource accessor method of the " + method.getDeclaringClass().getName() + " repository should not be annotated with the " + qualifiers + " qualifier annotations because a repository is only permitted to have one resource accessor method with qualifier annotations.");
                        }
                        emBuilder = new DBStoreEMBuilder((String)dataStore, isConfigDisplayId, isJNDIName, repositoryType, loader, this.provider);
                        continue;
                    }
                    Instance instance = CDI.current().select(EntityManagerFactory.class, annos);
                    EntityManagerFactory emf = (EntityManagerFactory)instance.get();
                    if (emBuilder != null) {
                        throw new UnsupportedOperationException("The " + method.getName() + " resource accessor method of the " + method.getDeclaringClass().getName() + " repository should not be annotated with the " + qualifiers + " qualifier annotations because a repository is only permitted to have one resource accessor method with qualifier annotations.");
                    }
                    emBuilder = new PUnitEMBuilder(emf, loader);
                }
            }
            if (emBuilder == null) {
                emBuilder = new DBStoreEMBuilder((String)dataStore, isConfigDisplayId, isJNDIName, repositoryType, loader, this.provider);
            }
            if (!this.discoverEntityClasses(repositoryType, queriesPerEntityClass = new HashMap(), primaryEntityClassReturnValue = new Class[1])) continue;
            EntityManagerBuilder previous = entityGroups.putIfAbsent(emBuilder, emBuilder);
            emBuilder = previous == null ? emBuilder : previous;
            for (Class entityClass : queriesPerEntityClass.keySet()) {
                if (Query.class.equals((Object)entityClass)) continue;
                emBuilder.add(entityClass);
            }
            BeanAttributes beanAttributes = beanMgr.createBeanAttributes(repositoryType);
            Bean bean = beanMgr.createBean(beanAttributes, repositoryInterface, new RepositoryProducer.Factory(repositoryInterface, beanMgr, this.provider, this, emBuilder, primaryEntityClassReturnValue[0], queriesPerEntityClass));
            event.addBean(bean);
        }
    }

    private boolean discoverEntityClasses(jakarta.enterprise.inject.spi.AnnotatedType<?> repositoryType, Map<Class<?>, List<QueryInfo>> queriesPerEntity, Class<?>[] primaryEntityClassReturnValue) {
        Class repositoryInterface = repositoryType.getJavaClass();
        Class<?> primaryEntityClass = null;
        HashSet lifecycleMethodEntityClasses = new HashSet();
        ArrayList<QueryInfo> queriesWithQueryAnno = new ArrayList<QueryInfo>();
        ArrayList<QueryInfo> additionalQueriesForPrimaryEntity = new ArrayList<QueryInfo>();
        for (AnnotatedType annotatedType : repositoryInterface.getAnnotatedInterfaces()) {
            Type firstParamType;
            if (!(annotatedType instanceof AnnotatedParameterizedType)) continue;
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType[] typeParams = parameterizedType.getAnnotatedActualTypeArguments();
            Type type = firstParamType = typeParams.length > 0 ? typeParams[0].getType() : null;
            if (firstParamType == null || !(firstParamType instanceof Class)) continue;
            primaryEntityClass = (Class<?>)firstParamType;
            if (typeParams.length == 2 && parameterizedType.getType().getTypeName().startsWith(DataRepository.class.getPackageName())) break;
        }
        for (AnnotatedElement annotatedElement : repositoryInterface.getMethods()) {
            List<QueryInfo> queries;
            if (((Method)annotatedElement).isDefault()) continue;
            Class<?> returnType = ((Method)annotatedElement).getReturnType();
            if (((Method)annotatedElement).getParameterCount() == 0 && (EntityManager.class.equals(returnType) || DataSource.class.equals(returnType) || Connection.class.equals(returnType))) {
                QueryInfo queryInfo = new QueryInfo((Method)annotatedElement, QueryInfo.Type.RESOURCE_ACCESS);
                List<QueryInfo> queries2 = queriesPerEntity.get(Void.class);
                if (queries2 == null) {
                    queries2 = new ArrayList<QueryInfo>();
                    queriesPerEntity.put(Void.class, queries2);
                }
                queries2.add(queryInfo);
                continue;
            }
            Class<?> returnArrayComponentType = null;
            ArrayList returnTypeAtDepth = new ArrayList(5);
            Type type = ((Method)annotatedElement).getGenericReturnType();
            for (int depth = 0; depth < 5 && type != null; ++depth) {
                if (type instanceof ParameterizedType) {
                    returnTypeAtDepth.add((Class)((ParameterizedType)type).getRawType());
                    Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
                    type = typeParams.length == 1 ? typeParams[0] : null;
                    continue;
                }
                if (type instanceof Class) {
                    Class c = (Class)type;
                    returnTypeAtDepth.add(c);
                    if (IntStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Integer.TYPE);
                        ++depth;
                    } else if (LongStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Long.TYPE);
                        ++depth;
                    } else if (DoubleStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Double.TYPE);
                        ++depth;
                    } else if (returnArrayComponentType == null && (returnArrayComponentType = c.getComponentType()) != null) {
                        returnTypeAtDepth.add(returnArrayComponentType);
                        ++depth;
                    }
                    type = null;
                    continue;
                }
                if (type instanceof GenericArrayType) {
                    Class<?> arrayComponentType = primaryEntityClass;
                    returnTypeAtDepth.add((Class<?>)arrayComponentType.arrayType());
                    if (returnArrayComponentType == null) {
                        returnArrayComponentType = arrayComponentType;
                        returnTypeAtDepth.add(returnArrayComponentType);
                        ++depth;
                    }
                    type = null;
                    continue;
                }
                returnTypeAtDepth.add(primaryEntityClass);
                type = null;
            }
            Class<?> entityClass = (Class<?>)returnTypeAtDepth.get(returnTypeAtDepth.size() - 1);
            Class<?> entityParamType = null;
            boolean hasQueryAnno = ((AccessibleObject)annotatedElement).isAnnotationPresent(Query.class);
            if (((Method)annotatedElement).getParameterCount() == 1 && !((Method)annotatedElement).isDefault() && !hasQueryAnno && (((AccessibleObject)annotatedElement).isAnnotationPresent(Insert.class) || ((AccessibleObject)annotatedElement).isAnnotationPresent(Update.class) || ((AccessibleObject)annotatedElement).isAnnotationPresent(Save.class) || ((AccessibleObject)annotatedElement).isAnnotationPresent(Delete.class))) {
                String packageName;
                Class<?> c = ((Method)annotatedElement).getParameterTypes()[0];
                if (Iterable.class.isAssignableFrom(c) || Stream.class.isAssignableFrom(c)) {
                    type = ((Method)annotatedElement).getGenericParameterTypes()[0];
                    if (type instanceof ParameterizedType) {
                        Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
                        if (typeParams.length == 1 && typeParams[0] instanceof Class) {
                            c = (Class<?>)typeParams[0];
                        } else {
                            entityParamType = c;
                            c = null;
                        }
                    } else {
                        c = null;
                    }
                } else if (c.isArray()) {
                    c = c.getComponentType();
                }
                if (Object.class.equals(c)) {
                    boolean isEntity = true;
                    for (Annotation anno : ((Method)annotatedElement).getParameterAnnotations()[0]) {
                        if (!By.class.equals(anno.annotationType())) continue;
                        isEntity = false;
                    }
                    if (isEntity) {
                        entityParamType = c;
                    }
                } else if (!(c == null || c.isPrimitive() || c.isInterface() || (packageName = c.getPackageName()).startsWith("java.") || packageName.startsWith("jakarta."))) {
                    Parameter param = ((Executable)annotatedElement).getParameters()[0];
                    entityParamType = param.getType();
                    for (Annotation anno : param.getAnnotations()) {
                        if (!anno.annotationType().getPackageName().startsWith("jakarta.data")) continue;
                        entityParamType = null;
                    }
                    if (entityParamType != null) {
                        entityClass = c;
                        lifecycleMethodEntityClasses.add(c);
                    }
                }
            }
            if (entityClass == null) {
                queries = hasQueryAnno ? queriesWithQueryAnno : additionalQueriesForPrimaryEntity;
            } else {
                String packageName = entityClass.getPackageName();
                if (packageName.startsWith("java.") || packageName.startsWith("jakarta.") || entityClass.isPrimitive() || entityClass.isInterface()) {
                    queries = hasQueryAnno ? queriesWithQueryAnno : additionalQueriesForPrimaryEntity;
                } else {
                    queries = queriesPerEntity.get(entityClass);
                    if (queries == null) {
                        queries = new ArrayList();
                        queriesPerEntity.put(entityClass, queries);
                    }
                    if (hasQueryAnno) {
                        queries = queriesWithQueryAnno;
                    }
                }
            }
            queries.add(new QueryInfo((Method)annotatedElement, entityParamType, returnArrayComponentType, returnTypeAtDepth));
        }
        boolean supportsAllEntities = true;
        HashSet allEntityClasses = new HashSet();
        if (primaryEntityClass != null) {
            allEntityClasses.add(primaryEntityClass);
            supportsAllEntities &= this.supportsEntity(primaryEntityClass, repositoryType);
        }
        for (Class clazz : lifecycleMethodEntityClasses) {
            if (!allEntityClasses.add(clazz)) continue;
            supportsAllEntities &= this.supportsEntity(clazz, repositoryType);
        }
        Iterator<Map.Entry<Class<?>, List<QueryInfo>>> it = queriesPerEntity.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class<?>, List<QueryInfo>> entry = it.next();
            Class<?> c = entry.getKey();
            if (allEntityClasses.contains(c)) continue;
            if (c.getAnnotation(Entity.class) == null) {
                supportsAllEntities &= this.supportsEntity(c, repositoryType);
                for (QueryInfo queryInfo : entry.getValue()) {
                    additionalQueriesForPrimaryEntity.add(queryInfo);
                }
                it.remove();
                continue;
            }
            allEntityClasses.add(c);
        }
        if (supportsAllEntities) {
            if (primaryEntityClass == null) {
                if (lifecycleMethodEntityClasses.size() == 1) {
                    primaryEntityClass = (Class)lifecycleMethodEntityClasses.iterator().next();
                } else if (lifecycleMethodEntityClasses.isEmpty()) {
                    if (queriesPerEntity.size() == 1) {
                        primaryEntityClass = queriesPerEntity.keySet().iterator().next();
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to determine primary entity class because there are multiple entity classes: ", (Object[])new Object[]{queriesPerEntity.keySet()});
                    }
                }
            } else if (!queriesPerEntity.containsKey(primaryEntityClass)) {
                queriesPerEntity.put(primaryEntityClass, new ArrayList());
            }
            if (!additionalQueriesForPrimaryEntity.isEmpty()) {
                if (primaryEntityClass == null) {
                    throw new MappingException("@Repository " + repositoryInterface.getName() + " does not specify an entity class. To correct this, have the repository interface extend DataRepository or another built-in repository interface and supply the entity class as the first parameter.");
                }
                List<QueryInfo> queries = queriesPerEntity.get(primaryEntityClass);
                if (queries == null) {
                    queriesPerEntity.put(primaryEntityClass, additionalQueriesForPrimaryEntity);
                } else {
                    queries.addAll(additionalQueriesForPrimaryEntity);
                }
            }
            if (!queriesWithQueryAnno.isEmpty()) {
                queriesPerEntity.put(Query.class, queriesWithQueryAnno);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(repositoryInterface.getName() + " has primary entity class " + primaryEntityClass), (Object[])new Object[]{"and methods that use the following entities:", queriesPerEntity});
        }
        primaryEntityClassReturnValue[0] = primaryEntityClass;
        return supportsAllEntities;
    }

    @Override
    @Trivial
    public DataExtensionProvider run() {
        BundleContext bundleContext = FrameworkUtil.getBundle(DataExtensionProvider.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(DataExtensionProvider.class);
        return (DataExtensionProvider)bundleContext.getService(ref);
    }

    private boolean supportsEntity(Class<?> entityClass, jakarta.enterprise.inject.spi.AnnotatedType<?> repositoryType) {
        Repository repository;
        boolean isSupported;
        Object[] entityClassAnnos = entityClass.getAnnotations();
        boolean hasEntityAnnos = false;
        for (Annotation annotation : entityClassAnnos) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (annoClass.equals(Entity.class)) {
                return true;
            }
            if (!annoClass.getSimpleName().endsWith("Entity") && !annoClass.isAnnotationPresent(EntityDefining.class)) continue;
            hasEntityAnnos = true;
        }
        boolean bl = isSupported = !hasEntityAnnos;
        if (hasEntityAnnos && !"".equals((repository = (Repository)repositoryType.getAnnotation(Repository.class)).provider())) {
            throw new MappingException("Open Liberty's built-in Jakarta Data provider cannot provide the " + repositoryType.getJavaClass().getName() + " repository because the repository's " + entityClass.getName() + " entity class includes an unrecognized entity annotation.  The following annotations are found on the entity class: " + Arrays.toString(entityClassAnnos) + ". Supported entity annotations are: " + Entity.class.getName() + ".");
        }
        return isSupported;
    }
}

