/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.provider;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Objects;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PUnitEMBuilder
extends EntityManagerBuilder {
    private final String application;
    private final String module;
    private final String component;
    private final EntityManagerFactory emf;
    private final String persistenceUnitRef;
    static final long serialVersionUID = 2201089366520380405L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PUnitEMBuilder(EntityManagerFactory emf, ClassLoader repositoryClassLoader) {
        super(repositoryClassLoader);
        this.emf = emf;
        this.persistenceUnitRef = emf.toString();
        this.application = null;
        this.module = null;
        this.component = null;
    }

    public PUnitEMBuilder(EntityManagerFactory emf, String persistenceUnitRef, ClassLoader repositoryClassLoader) {
        super(repositoryClassLoader);
        boolean javaComp;
        this.emf = emf;
        this.persistenceUnitRef = persistenceUnitRef;
        boolean javaApp = persistenceUnitRef.regionMatches(5, "app", 0, 3);
        boolean javaModule = !javaApp && persistenceUnitRef.regionMatches(5, "module", 0, 6);
        boolean bl = javaComp = !javaApp && !javaModule && persistenceUnitRef.regionMatches(5, "comp", 0, 4);
        if (javaApp || javaModule || javaComp) {
            ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            J2EEName jeeName = cData == null ? null : cData.getJ2EEName();
            this.application = jeeName == null ? null : jeeName.getApplication();
            this.module = jeeName == null || javaApp ? null : jeeName.getModule();
            this.component = jeeName == null || javaApp || javaModule ? null : jeeName.getComponent();
        } else {
            this.application = null;
            this.module = null;
            this.component = null;
        }
    }

    @Override
    public EntityManager createEntityManager() {
        return this.emf.createEntityManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PUnitEMBuilder)) return false;
        PUnitEMBuilder b = (PUnitEMBuilder)o;
        if (!this.persistenceUnitRef.equals(b.persistenceUnitRef)) return false;
        if (!Objects.equals(this.application, b.application)) return false;
        if (!Objects.equals(this.module, b.module)) return false;
        if (!Objects.equals(this.component, b.component)) return false;
        if (!Objects.equals(this.getRepositoryClassLoader(), b.getRepositoryClassLoader())) return false;
        return true;
    }

    @Trivial
    public int hashCode() {
        return this.persistenceUnitRef.hashCode();
    }

    @Override
    @Trivial
    protected void initialize() throws Exception {
    }

    @Trivial
    public String toString() {
        return new StringBuilder(27 + this.persistenceUnitRef.length() + (this.application == null ? 4 : this.application.length()) + (this.module == null ? 4 : this.module.length()) + (this.component == null ? 4 : this.component.length())).append("PUnitEMBuilder@").append(Integer.toHexString(this.hashCode())).append(":").append(this.persistenceUnitRef).append(' ').append(this.application).append('#').append(this.module).append('#').append(this.component).toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.data.internal.persistence.provider.PUnitEMBuilder", PUnitEMBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    }
}

