/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.service;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.cdi.DataExtensionProvider;
import io.openliberty.data.internal.persistence.service.ClassDefiner;
import io.openliberty.data.internal.persistence.service.DelegatingResourceFactory;
import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DBStoreEMBuilder
extends EntityManagerBuilder {
    private static final String EOLN = String.format("%n", new Object[0]);
    private static final TraceComponent tc = Tr.register(DBStoreEMBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final ClassDefiner classDefiner = new ClassDefiner();
    private final String databaseStoreId;
    private final Map<Class<?>, Class<?>> generatedToRecordClass = new HashMap();
    private PersistenceServiceUnit persistenceServiceUnit;
    static final long serialVersionUID = -5138537436059256557L;

    /*
     * WARNING - void declaration
     */
    public DBStoreEMBuilder(String dataStore, boolean isConfigDisplayId, boolean isJNDIName, AnnotatedType<?> type, ClassLoader repositoryClassLoader, DataExtensionProvider provider) {
        super(repositoryClassLoader);
        Object dbStoreId;
        ConcurrentHashMap<String, Configuration> dbStoreConfigurations;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName jeeName = cData == null ? null : cData.getJ2EEName();
        String application = jeeName == null ? null : jeeName.getApplication();
        String module = jeeName == null ? null : jeeName.getModule();
        String component = jeeName == null ? null : jeeName.getComponent();
        String qualifiedName = null;
        boolean javaApp = false;
        boolean javaModule = false;
        boolean javaComp = false;
        if (isJNDIName) {
            javaApp = dataStore.regionMatches(5, "app", 0, 3);
            javaModule = !javaApp && dataStore.regionMatches(5, "module", 0, 6);
            javaComp = !javaApp && !javaModule && dataStore.regionMatches(5, "comp", 0, 4);
            StringBuilder s = new StringBuilder(dataStore.length() + 80);
            if (application != null && (javaApp || javaModule || javaComp)) {
                s.append("application[").append(application).append(']').append('/');
                if (module != null && (javaModule || javaComp)) {
                    s.append("module[").append(module).append(']').append('/');
                    if (component != null && javaComp) {
                        s.append("component[").append(component).append(']').append('/');
                    }
                }
            }
            qualifiedName = s.append("databaseStore[").append(dataStore).append(']').toString();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("computed qualified dataStore name from JNDI name as " + qualifiedName), (Object[])new Object[0]);
            }
        }
        Configuration dbStoreConfig = (dbStoreConfigurations = provider.dbStoreConfigAllApps.get(application)) == null ? null : dbStoreConfigurations.get(isJNDIName ? qualifiedName : dataStore);
        Object object = dbStoreId = dbStoreConfig == null ? null : (String)dbStoreConfig.getProperties().get("id");
        if (dbStoreId == null) {
            try {
                BundleContext bc = FrameworkUtil.getBundle(DatabaseStore.class).getBundleContext();
                ServiceReference dsRef = null;
                if (isConfigDisplayId) {
                    dbStoreId = dataStore + "/databaseStore";
                } else if (isJNDIName) {
                    filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + (javaApp || javaModule || javaComp ? FilterUtils.createPropertyFilter((String)"application", (String)application) : "") + (javaModule || javaComp ? FilterUtils.createPropertyFilter((String)"module", (String)module) : "") + (javaComp ? FilterUtils.createPropertyFilter((String)"component", (String)component) : "") + FilterUtils.createPropertyFilter((String)"jndiName", (String)dataStore) + ")";
                    Collection dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                    if (!dsRefs.isEmpty()) {
                        dbStoreId = qualifiedName;
                        dsRef = (ServiceReference)dsRefs.iterator().next();
                    }
                } else {
                    filter = FilterUtils.createPropertyFilter((String)"id", (String)dataStore);
                    Collection dbStoreRefs = bc.getServiceReferences(DatabaseStore.class, (String)filter);
                    if (!dbStoreRefs.isEmpty()) {
                        dbStoreId = dataStore;
                    } else {
                        filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + FilterUtils.createPropertyFilter((String)"id", (String)dataStore) + ")";
                        Collection dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                        if (!dsRefs.isEmpty()) {
                            dbStoreId = "application[" + application + "]/databaseStore[" + dataStore + "]";
                            dsRef = (ServiceReference)dsRefs.iterator().next();
                        } else {
                            filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + FilterUtils.createPropertyFilter((String)"jndiName", (String)dataStore) + ")";
                            dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                            if (!dsRefs.isEmpty()) {
                                dbStoreId = "application[" + application + "]/databaseStore[" + dataStore + "]";
                                dsRef = (ServiceReference)dsRefs.iterator().next();
                            }
                        }
                    }
                }
                if (dbStoreId == null) {
                    ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>> empty;
                    DelegatingResourceFactory delegator = new DelegatingResourceFactory(dataStore, cData);
                    Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
                    dbStoreId = isJNDIName ? qualifiedName : "application[" + application + "]/databaseStore[" + dataStore + "]";
                    String id = (String)dbStoreId + "/ResourceFactory";
                    svcProps.put("id", id);
                    svcProps.put("config.displayId", id);
                    if (application != null) {
                        svcProps.put("application", application);
                    }
                    ServiceRegistration reg = bc.registerService(ResourceFactory.class, (Object)delegator, svcProps);
                    dsRef = reg.getReference();
                    ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>> registrations = provider.delegatorsAllApps.get(application);
                    if (registrations == null && (registrations = (ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>>)provider.delegatorsAllApps.putIfAbsent(application, empty = new ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>>())) == null) {
                        registrations = empty;
                    }
                    registrations.add((ServiceRegistration<ResourceFactory>)reg);
                }
                if (dbStoreId != dataStore) {
                    ConcurrentHashMap<String, Configuration> empty;
                    if (dbStoreConfigurations == null && (dbStoreConfigurations = (ConcurrentHashMap<String, Configuration>)provider.dbStoreConfigAllApps.putIfAbsent(application, empty = new ConcurrentHashMap<String, Configuration>())) == null) {
                        dbStoreConfigurations = empty;
                    }
                    String dataSourceId = (String)dsRef.getProperty("id");
                    boolean nonJTA = Boolean.FALSE.equals(dsRef.getProperty("transactional"));
                    Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
                    svcProps.put("id", dbStoreId);
                    svcProps.put("config.displayId", dbStoreId);
                    if (isConfigDisplayId) {
                        svcProps.put("DataSourceFactory.target", "(config.displayId=" + dataStore + ")");
                    } else if (dataSourceId == null) {
                        svcProps.put("DataSourceFactory.target", "(jndiName=" + dsRef.getProperty("jndiName") + ")");
                    } else {
                        svcProps.put("DataSourceFactory.target", "(id=" + dataSourceId + ")");
                    }
                    svcProps.put("AuthData.target", "(service.pid=${authDataRef})");
                    svcProps.put("AuthData.cardinality.minimum", 0);
                    svcProps.put("NonJTADataSourceFactory.cardinality.minimum", nonJTA ? 1 : 0);
                    if (nonJTA) {
                        svcProps.put("NonJTADataSourceFactory.target", svcProps.get("DataSourceFactory.target"));
                    } else {
                        svcProps.put("NonJTADataSourceFactory.target", "(&(service.pid=${nonTransactionalDataSourceRef})(transactional=false))");
                    }
                    svcProps.put("createTables", !"FALSE".equalsIgnoreCase((String)dsRef.getProperty("properties.0.data.createTables")));
                    svcProps.put("dropTables", !"TRUE".equalsIgnoreCase((String)dsRef.getProperty("properties.0.data.dropTables")));
                    svcProps.put("tablePrefix", Objects.requireNonNullElse((String)dsRef.getProperty("properties.0.data.tablePrefix"), "DATA"));
                    svcProps.put("keyGenerationStrategy", Objects.requireNonNullElse((String)dsRef.getProperty("properties.0.data.keyGenerationStrategy"), "AUTO"));
                    dbStoreConfig = provider.configAdmin.createFactoryConfiguration("com.ibm.ws.persistence.databaseStore", bc.getBundle().getLocation());
                    dbStoreConfig.update(svcProps);
                    dbStoreConfigurations.put(isJNDIName ? qualifiedName : dataStore, dbStoreConfig);
                }
            }
            catch (IOException | InvalidSyntaxException bc) {
                void x;
                FFDCFilter.processException((Throwable)bc, (String)"io.openliberty.data.internal.persistence.service.DBStoreEMBuilder", (String)"262", (Object)this, (Object[])new Object[]{dataStore, isConfigDisplayId, isJNDIName, type, repositoryClassLoader, provider});
                throw new RuntimeException((Throwable)x);
            }
            catch (Error | RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"io.openliberty.data.internal.persistence.service.DBStoreEMBuilder", (String)"264", (Object)this, (Object[])new Object[]{dataStore, isConfigDisplayId, isJNDIName, type, repositoryClassLoader, provider});
                throw x;
            }
        }
        this.databaseStoreId = dbStoreId;
    }

    private static void addDefaultCtor(ClassWriter cw, String parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"    adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addRecordCtor(Class<?> recordClass, String internalEntityClassName, ClassWriter cw, String parent) {
        Method constructor = Method.getMethod((String)("void <init> (" + recordClass.getTypeName() + ")"));
        GeneratorAdapter mg = new GeneratorAdapter(1, constructor, null, null, (ClassVisitor)cw);
        mg.loadThis();
        mg.invokeConstructor(org.objectweb.asm.Type.getType(Object.class), Method.getMethod((String)"void <init> ()"));
        for (RecordComponent component : recordClass.getRecordComponents()) {
            String componentName = component.getName();
            String typeDesc = component.getType().getTypeName();
            String methodName = "set" + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
            int componentValue = mg.newLocal(org.objectweb.asm.Type.getType(component.getType()));
            mg.loadArg(0);
            mg.invokeVirtual(org.objectweb.asm.Type.getType(recordClass), Method.getMethod((String)(typeDesc + " " + componentName + " ()")));
            mg.storeLocal(componentValue);
            mg.loadThis();
            mg.loadLocal(componentValue);
            mg.invokeVirtual(org.objectweb.asm.Type.getObjectType((String)internalEntityClassName), Method.getMethod((String)("void " + methodName + " (" + typeDesc + ")")));
        }
        mg.returnValue();
        mg.endMethod();
    }

    @Override
    public EntityManager createEntityManager() {
        return this.persistenceServiceUnit.createEntityManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DBStoreEMBuilder)) return false;
        DBStoreEMBuilder b = (DBStoreEMBuilder)o;
        if (!this.databaseStoreId.equals(b.databaseStoreId)) return false;
        if (!this.getRepositoryClassLoader().equals(b.getRepositoryClassLoader())) return false;
        return true;
    }

    @ManualTrace
    private byte[] generateEntityClassBytes(Class<?> recordClass, String entityClassName) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ClassWriter cw = new ClassWriter(1);
        String internal_entityClassName = entityClassName.replace('.', '/');
        cw.visit(61, 33, internal_entityClassName, null, "java/lang/Object", null);
        String sourceFileName = entityClassName.substring(entityClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        DBStoreEMBuilder.addDefaultCtor(cw, null);
        for (RecordComponent component : recordClass.getRecordComponents()) {
            String componentName = component.getName();
            String typeDesc = org.objectweb.asm.Type.getDescriptor(component.getType());
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     adding field : " + componentName + " " + typeDesc), (Object[])new Object[0]);
            }
            FieldVisitor fv = cw.visitField(1, componentName, typeDesc, null, null);
            fv.visitEnd();
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     adding field : " + component.getName() + " " + component.getType().descriptorString()), (Object[])new Object[0]);
            }
            String methodName = "set" + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
            MethodVisitor mv = cw.visitMethod(1, methodName, "(" + typeDesc + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(org.objectweb.asm.Type.getType(component.getType()).getOpcode(21), 1);
            mv.visitFieldInsn(181, internal_entityClassName, componentName, typeDesc);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            methodName = "get" + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
            mv = cw.visitMethod(1, methodName, "()" + typeDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internal_entityClassName, componentName, typeDesc);
            mv.visitInsn(org.objectweb.asm.Type.getType(component.getType()).getOpcode(172));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        DBStoreEMBuilder.addRecordCtor(recordClass, internal_entityClassName, cw, null);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (trace && tc.isEntryEnabled()) {
            Object classByteString = "";
            for (int i = 0; i < classBytes.length; ++i) {
                classByteString = (String)classByteString + (i % 8 == 0 ? "\t" : "");
                classByteString = (String)classByteString + (i % 32 == 0 ? System.lineSeparator() : "");
                classByteString = (String)classByteString + String.format("%02X", classBytes[i]) + " ";
            }
            Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes" + (String)classByteString));
        }
        return classBytes;
    }

    @Trivial
    private Class<?> getEntityClass(Type type) {
        Class c = null;
        if (type instanceof ParameterizedType) {
            Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
            Type type2 = type = typeParams.length == 1 ? typeParams[0] : null;
            if (type instanceof Class && ((Class)type).isAnnotationPresent(Entity.class)) {
                c = (Class)type;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("getEntityClass from parameterized " + type + ": " + c), (Object[])new Object[0]);
            }
        }
        return c;
    }

    @Override
    @Trivial
    protected Class<?> getRecordClass(Class<?> generatedEntityClass) {
        return this.generatedToRecordClass.get(generatedEntityClass);
    }

    @Trivial
    public int hashCode() {
        return this.databaseStoreId.hashCode();
    }

    @Override
    protected void initialize() throws Exception {
        Class c;
        Object type;
        StringBuilder xml;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        BundleContext bc = FrameworkUtil.getBundle(DatabaseStore.class).getBundleContext();
        Collection refs = bc.getServiceReferences(DatabaseStore.class, FilterUtils.createPropertyFilter((String)"id", (String)this.databaseStoreId));
        if (refs.isEmpty()) {
            throw new RuntimeException("Not found: " + this.databaseStoreId);
        }
        ServiceReference ref = (ServiceReference)refs.iterator().next();
        String tablePrefix = (String)ref.getProperty("tablePrefix");
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(this.databaseStoreId + " databaseStore reference"), (Object[])new Object[]{ref});
        }
        HashSet<String> entityClassNames = new HashSet<String>(this.entities.size() * 2);
        ArrayList<InMemoryMappingFile> generatedEntities = new ArrayList<InMemoryMappingFile>();
        LinkedList annotatedEntityClassQueue = new LinkedList();
        ArrayList<String> entityClassInfo = new ArrayList<String>(this.entities.size());
        LinkedList embeddableTypesQueue = new LinkedList();
        HashSet<Class> converterTypes = new HashSet<Class>();
        for (Class<?> c2 : this.entities) {
            if (c2.isAnnotationPresent(Entity.class)) {
                annotatedEntityClassQueue.add(c2);
                for (Field field : c2.getFields()) {
                    Convert convert = field.getAnnotation(Convert.class);
                    if (convert == null) continue;
                    converterTypes.add(convert.converter());
                }
                for (AccessibleObject accessibleObject : c2.getMethods()) {
                    Convert convert = ((java.lang.reflect.Method)accessibleObject).getAnnotation(Convert.class);
                    if (convert == null) continue;
                    converterTypes.add(convert.converter());
                }
                continue;
            }
            if (c2.isRecord()) {
                String entityClassName = c2.getName() + "Entity";
                byte[] generatedEntityBytes = this.generateEntityClassBytes(c2, entityClassName);
                generatedEntities.add(new InMemoryMappingFile(generatedEntityBytes, entityClassName.replace('.', '/') + ".class"));
                Class<?> generatedEntity = this.classDefiner.findLoadedOrDefineClass(this.getRepositoryClassLoader(), entityClassName, generatedEntityBytes);
                this.generatedToRecordClass.put(generatedEntity, c2);
                c2 = generatedEntity;
            }
            xml = new StringBuilder(500).append(" <entity class=\"").append(c2.getName()).append("\">").append(EOLN);
            xml.append("  <table name=\"").append(tablePrefix).append(c2.getSimpleName()).append("\"/>").append(EOLN);
            this.writeAttributes(xml, c2, false, embeddableTypesQueue);
            xml.append(" </entity>").append(EOLN);
            entityClassInfo.add(xml.toString());
        }
        HashSet<Class> embeddableTypes = new HashSet<Class>();
        while ((type = (Class)embeddableTypesQueue.poll()) != null) {
            if (!embeddableTypes.add((Class)type)) continue;
            xml = new StringBuilder(500).append(" <embeddable class=\"").append(((Class)type).getName()).append("\">").append(EOLN);
            this.writeAttributes(xml, (Class<?>)type, true, embeddableTypesQueue);
            xml.append(" </embeddable>").append(EOLN);
            entityClassInfo.add(xml.toString());
        }
        for (Class type2 : converterTypes) {
            StringBuilder xml2 = new StringBuilder(500).append(" <converter class=\"").append(type2.getName()).append("\"></converter>").append(EOLN);
            entityClassInfo.add(xml2.toString());
        }
        while ((c = (Class)annotatedEntityClassQueue.poll()) != null) {
            Class<?> e;
            if (!entityClassNames.add(c.getName())) continue;
            for (Field field : c.getFields()) {
                if (field.getType().isAnnotationPresent(Entity.class)) {
                    annotatedEntityClassQueue.add(field.getType());
                    continue;
                }
                e = this.getEntityClass(field.getGenericType());
                if (e == null) continue;
                annotatedEntityClassQueue.add(e);
            }
            for (AccessibleObject accessibleObject : c.getMethods()) {
                if (((java.lang.reflect.Method)accessibleObject).getReturnType().isAnnotationPresent(Entity.class)) {
                    annotatedEntityClassQueue.add(((java.lang.reflect.Method)accessibleObject).getReturnType());
                    continue;
                }
                e = this.getEntityClass(((java.lang.reflect.Method)accessibleObject).getGenericReturnType());
                if (e == null) continue;
                annotatedEntityClassQueue.add(e);
            }
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("io.openliberty.persistence.internal.entityClassInfo", entityClassInfo.toArray(new String[entityClassInfo.size()]));
        if (!generatedEntities.isEmpty()) {
            properties.put("io.openliberty.persistence.internal.generatedEntities", generatedEntities);
        }
        DatabaseStore dbstore = (DatabaseStore)bc.getService(ref);
        this.persistenceServiceUnit = dbstore.createPersistenceServiceUnit(this.getRepositoryClassLoader(), properties, entityClassNames.toArray(new String[entityClassNames.size()]));
    }

    @Trivial
    public String toString() {
        return new StringBuilder(26 + this.databaseStoreId.length()).append("DBStoreEMBuilder@").append(Integer.toHexString(this.hashCode())).append(":").append(this.databaseStoreId).toString();
    }

    /*
     * WARNING - void declaration
     */
    private void writeAttributes(StringBuilder xml, Class<?> c, boolean isEmbeddable, Queue<Class<?>> embeddableTypesQueue) {
        TreeMap attributes = new TreeMap();
        for (Field f : c.getFields()) {
            attributes.putIfAbsent(f.getName(), f.getType());
        }
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(c).getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (PropertyDescriptor p : propertyDescriptors) {
                    java.lang.reflect.Method setter = p.getWriteMethod();
                    if (setter == null) continue;
                    attributes.putIfAbsent(p.getName(), p.getPropertyType());
                }
            }
        }
        catch (IntrospectionException propertyDescriptors) {
            void x;
            FFDCFilter.processException((Throwable)propertyDescriptors, (String)"io.openliberty.data.internal.persistence.service.DBStoreEMBuilder", (String)"640", (Object)this, (Object[])new Object[]{xml, c, isEmbeddable, embeddableTypesQueue});
            throw new MappingException((Throwable)x);
        }
        String keyAttributeName = null;
        if (!isEmbeddable) {
            int precedence = 10;
            for (Map.Entry attribute : attributes.entrySet()) {
                String name = (String)attribute.getKey();
                Class type = (Class)attribute.getValue();
                if (name.length() > 2) {
                    if (precedence <= 2) continue;
                    char i = name.charAt(name.length() - 2);
                    if (i == 'I') {
                        char d = name.charAt(name.length() - 1);
                        if (d == 'd') {
                            keyAttributeName = name;
                            precedence = 2;
                            continue;
                        }
                        if (d != 'D' || precedence <= 3) continue;
                        keyAttributeName = name;
                        precedence = 3;
                        continue;
                    }
                    if (i != 'i' || precedence <= 5 || name.charAt(name.length() - 1) != 'd') continue;
                    keyAttributeName = name;
                    precedence = 5;
                    continue;
                }
                if (name.equalsIgnoreCase("ID")) {
                    keyAttributeName = name;
                    precedence = 1;
                    break;
                }
                if (precedence <= 4 || !UUID.class.equals((Object)type)) continue;
                keyAttributeName = name;
                precedence = 4;
            }
            if (keyAttributeName == null) {
                throw new MappingException("Entity class " + c.getName() + " lacks a public field of the form *ID or public method of the form get*ID.");
            }
        }
        xml.append("  <attributes>").append(EOLN);
        for (Map.Entry attributeInfo : attributes.entrySet()) {
            String columnType;
            String attributeName = (String)attributeInfo.getKey();
            Class attributeType = (Class)attributeInfo.getValue();
            boolean isCollection = Collection.class.isAssignableFrom(attributeType);
            boolean isPrimitive = attributeType.isPrimitive();
            if (isPrimitive || attributeType.isInterface() || Serializable.class.isAssignableFrom(attributeType)) {
                columnType = keyAttributeName != null && keyAttributeName.equalsIgnoreCase(attributeName) ? "id" : ("version".equalsIgnoreCase(attributeName) ? "version" : (isCollection ? "element-collection" : "basic"));
            } else {
                columnType = "embedded";
                embeddableTypesQueue.add(attributeType);
            }
            xml.append("   <" + columnType + " name=\"" + attributeName + "\">").append(EOLN);
            if (isEmbeddable) {
                if (!"embedded".equals(columnType)) {
                    xml.append("    <column name=\"").append(c.getSimpleName().toUpperCase()).append(attributeName.toUpperCase()).append("\"/>").append(EOLN);
                }
            } else if (isPrimitive) {
                xml.append("    <column nullable=\"false\"/>").append(EOLN);
            }
            xml.append("   </" + columnType + ">").append(EOLN);
        }
        xml.append("  </attributes>").append(EOLN);
    }
}

