/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.util.internal.UtilImpl_Factory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.util.Util_InternMap;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class UtilImpl_InternMap
implements Util_InternMap {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.util");
    private static final Logger stateLogger = Logger.getLogger("com.ibm.ws.annocache.util.state");
    public static final String CLASS_NAME = "UtilImpl_InternMap";
    public static final int DEFAULT_LOG_THRESHHOLD = 4096;
    protected final int logThreshHold;
    protected final UtilImpl_Factory factory;
    protected final Util_InternMap.ValueType valueType;
    protected boolean checkValues;
    protected final String name;
    protected final Map<String, String> internMap;
    protected int lastReportedLength;
    protected int totalLength;
    static final long serialVersionUID = -1074462789641188197L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + this.name + ")";
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getLogThreshHold() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getLogThreshHold", new Object[0]);
        }
        int n = this.logThreshHold;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getLogThreshHold", n);
        }
        return n;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String doValidate(String value, Util_InternMap.ValueType valueType) {
        String vMsg = null;
        switch (valueType) {
            case VT_CLASS_RESOURCE: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_EXPECTED_CLASS";
                break;
            }
            case VT_CLASS_REFERENCE: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_CLASS_NAME: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.contains("/")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_FORWARD_SLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_FIELD_NAME: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.contains("/")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_FORWARD_SLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_METHOD_NAME: {
                if (value.contains("\\")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_BACKSLASH";
                    break;
                }
                if (value.contains("/")) {
                    vMsg = "ANNO_UTIL_UNEXPECTED_FORWARD_SLASH";
                    break;
                }
                if (!value.endsWith(".class")) break;
                vMsg = "ANNO_UTIL_UNEXPECTED_CLASS";
                break;
            }
            case VT_OTHER: {
                break;
            }
            default: {
                vMsg = "ANNO_UTIL_UNRECOGNIZED_TYPE";
            }
        }
        return vMsg;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String validate(String useValue, Util_InternMap.ValueType useValueType) {
        return UtilImpl_InternMap.doValidate(useValue, useValueType);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap(UtilImpl_Factory factory, Util_InternMap.ValueType valueType, String name) {
        this(factory, valueType, 4096, name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_InternMap(UtilImpl_Factory factory, Util_InternMap.ValueType valueType, int logThreshHold, String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "<init>", new Object[]{factory, valueType, logThreshHold, name});
        }
        String methodName = "<init>";
        this.factory = factory;
        this.logThreshHold = logThreshHold;
        this.name = name;
        this.valueType = valueType;
        this.checkValues = logger.isLoggable(Level.FINER);
        this.internMap = new HashMap<String, String>();
        this.lastReportedLength = 0;
        this.totalLength = 0;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Value type [ {1} ] Log threshhold [ {2} ]", new Object[]{this.getHashText(), this.valueType, this.logThreshHold});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "<init>", this);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Util_InternMap.ValueType getValueType() {
        return this.valueType;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean getCheckValues() {
        return this.checkValues;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getName() {
        return this.name;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Map<String, String> getInternMap() {
        return this.internMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected synchronized int getLastReportedLength() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getLastReportedLength", new Object[0]);
        }
        int n = this.lastReportedLength;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getLastReportedLength", n);
        }
        return n;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized Collection<String> getValues() {
        return this.getInternMap().values();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized int getSize() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getSize", new Object[0]);
        }
        int n = this.getInternMap().size();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getSize", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized int getTotalLength() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getTotalLength", new Object[0]);
        }
        int n = this.totalLength;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "getTotalLength", n);
        }
        return n;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String intern(String useName) {
        return this.intern(useName, true);
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized String intern(String useName, boolean doForce) {
        String priorIntern;
        String vMsg;
        String methodName = "intern";
        if (useName == null) {
            return useName;
        }
        if (this.checkValues && (vMsg = this.validate(useName, this.valueType)) != null) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, vMsg, new Object[]{this.getHashText(), useName, this.valueType});
        }
        if ((priorIntern = this.internMap.get(useName)) != null || !doForce) {
            return priorIntern;
        }
        priorIntern = useName;
        this.internMap.put(useName, useName);
        this.totalLength += useName.length();
        if (this.totalLength - this.lastReportedLength > this.logThreshHold) {
            this.lastReportedLength = this.totalLength;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Total [ {1} ]", new Object[]{this.getHashText(), this.totalLength});
            }
        }
        return priorIntern;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized boolean contains(String useName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "contains", new Object[]{useName});
        }
        boolean bl = this.internMap.containsKey(useName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.util.internal.UtilImpl_InternMap", "contains", bl);
        }
        return bl;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logState() {
        if (!stateLogger.isLoggable(Level.FINER)) {
            return;
        }
        this.log(logger);
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Intern Map: BEGIN [ {0} ]:", this.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Log threshhold[ {0} ]", this.getLogThreshHold());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Size [ {0} ]", this.getSize());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Total Length [ {0} ]", this.getTotalLength());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Intern Map: END [ {0} ]:", this.getHashText());
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent useLogger) {
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("BEGIN Intern Map [ {0} ]:", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Log threshhold[ {0} ]", this.getLogThreshHold()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Size [ {0} ]", this.getSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Total Length [ {0} ]", this.getTotalLength()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)"END Intern Map", (Object[])new Object[0]);
    }
}

