/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.NodeVisitorWithTypeTracking;
import graphql.analysis.QueryReducer;
import graphql.analysis.QueryTraversalContext;
import graphql.analysis.QueryVisitor;
import graphql.analysis.QueryVisitorFieldEnvironment;
import graphql.analysis.QueryVisitorStub;
import graphql.execution.CoercedVariables;
import graphql.execution.RawVariables;
import graphql.execution.ValuesResolver;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class QueryTraverser {
    private final Collection<? extends Node> roots;
    private final GraphQLSchema schema;
    private final Map<String, FragmentDefinition> fragmentsByName;
    private CoercedVariables coercedVariables;
    private final GraphQLCompositeType rootParentType;

    private QueryTraverser(GraphQLSchema schema, Document document, String operation, CoercedVariables coercedVariables) {
        this.schema = schema;
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operation);
        this.fragmentsByName = getOperationResult.fragmentsByName;
        this.roots = Collections.singletonList(getOperationResult.operationDefinition);
        this.rootParentType = this.getRootTypeFromOperation(getOperationResult.operationDefinition);
        this.coercedVariables = coercedVariables;
    }

    private QueryTraverser(GraphQLSchema schema, Document document, String operation, RawVariables rawVariables) {
        this.schema = schema;
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, operation);
        List<VariableDefinition> variableDefinitions = getOperationResult.operationDefinition.getVariableDefinitions();
        this.fragmentsByName = getOperationResult.fragmentsByName;
        this.roots = Collections.singletonList(getOperationResult.operationDefinition);
        this.rootParentType = this.getRootTypeFromOperation(getOperationResult.operationDefinition);
        this.coercedVariables = ValuesResolver.coerceVariableValues(schema, variableDefinitions, rawVariables);
    }

    private QueryTraverser(GraphQLSchema schema, Node root, GraphQLCompositeType rootParentType, Map<String, FragmentDefinition> fragmentsByName, CoercedVariables coercedVariables) {
        this.schema = schema;
        this.roots = Collections.singleton(root);
        this.rootParentType = rootParentType;
        this.fragmentsByName = fragmentsByName;
        this.coercedVariables = coercedVariables;
    }

    public Object visitDepthFirst(QueryVisitor queryVisitor) {
        return this.visitImpl(queryVisitor, null);
    }

    public void visitPostOrder(QueryVisitor visitor) {
        this.visitImpl(visitor, false);
    }

    public void visitPreOrder(QueryVisitor visitor) {
        this.visitImpl(visitor, true);
    }

    public <T> T reducePostOrder(final QueryReducer<T> queryReducer, T initialValue) {
        final Object[] acc = new Object[]{initialValue};
        this.visitPostOrder(new QueryVisitorStub(){

            @Override
            public void visitField(QueryVisitorFieldEnvironment env) {
                acc[0] = queryReducer.reduceField(env, acc[0]);
            }
        });
        return (T)acc[0];
    }

    public <T> T reducePreOrder(final QueryReducer<T> queryReducer, T initialValue) {
        final Object[] acc = new Object[]{initialValue};
        this.visitPreOrder(new QueryVisitorStub(){

            @Override
            public void visitField(QueryVisitorFieldEnvironment env) {
                acc[0] = queryReducer.reduceField(env, acc[0]);
            }
        });
        return (T)acc[0];
    }

    private GraphQLObjectType getRootTypeFromOperation(OperationDefinition operationDefinition) {
        switch (operationDefinition.getOperation()) {
            case MUTATION: {
                return Assert.assertNotNull(this.schema.getMutationType());
            }
            case QUERY: {
                return Assert.assertNotNull(this.schema.getQueryType());
            }
            case SUBSCRIPTION: {
                return Assert.assertNotNull(this.schema.getSubscriptionType());
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen();
    }

    private List<Node> childrenOf(Node<?> node) {
        if (!(node instanceof FragmentSpread)) {
            return node.getChildren();
        }
        FragmentSpread fragmentSpread = (FragmentSpread)node;
        return Collections.singletonList(this.fragmentsByName.get(fragmentSpread.getName()));
    }

    private Object visitImpl(QueryVisitor visitFieldCallback, Boolean preOrder) {
        QueryVisitor postOrderCallback;
        QueryVisitor preOrderCallback;
        LinkedHashMap rootVars = new LinkedHashMap();
        rootVars.put(QueryTraversalContext.class, new QueryTraversalContext(this.rootParentType, null, null));
        if (preOrder == null) {
            preOrderCallback = visitFieldCallback;
            postOrderCallback = visitFieldCallback;
        } else {
            QueryVisitorStub noOp = new QueryVisitorStub();
            preOrderCallback = preOrder != false ? visitFieldCallback : noOp;
            postOrderCallback = preOrder == false ? visitFieldCallback : noOp;
        }
        NodeTraverser nodeTraverser = new NodeTraverser(rootVars, this::childrenOf);
        NodeVisitorWithTypeTracking nodeVisitorWithTypeTracking = new NodeVisitorWithTypeTracking(preOrderCallback, postOrderCallback, this.coercedVariables.toMap(), this.schema, this.fragmentsByName);
        return nodeTraverser.depthFirst((NodeVisitor)nodeVisitorWithTypeTracking, this.roots);
    }

    public static Builder newQueryTraverser() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private GraphQLSchema schema;
        private Document document;
        private String operation;
        private CoercedVariables coercedVariables = CoercedVariables.emptyVariables();
        private RawVariables rawVariables;
        private Node root;
        private GraphQLCompositeType rootParentType;
        private Map<String, FragmentDefinition> fragmentsByName;

        public Builder schema(GraphQLSchema schema) {
            this.schema = Assert.assertNotNull(schema, () -> "schema can't be null");
            return this;
        }

        public Builder operationName(String operationName) {
            this.operation = operationName;
            return this;
        }

        public Builder document(Document document) {
            this.document = Assert.assertNotNull(document, () -> "document can't be null");
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            Assert.assertNotNull(variables, () -> "variables can't be null");
            this.rawVariables = RawVariables.of(variables);
            return this;
        }

        public Builder coercedVariables(CoercedVariables coercedVariables) {
            Assert.assertNotNull(coercedVariables, () -> "coercedVariables can't be null");
            this.coercedVariables = coercedVariables;
            return this;
        }

        public Builder root(Node root) {
            this.root = Assert.assertNotNull(root, () -> "root can't be null");
            return this;
        }

        public Builder rootParentType(GraphQLCompositeType rootParentType) {
            this.rootParentType = Assert.assertNotNull(rootParentType, () -> "rootParentType can't be null");
            return this;
        }

        public Builder fragmentsByName(Map<String, FragmentDefinition> fragmentsByName) {
            this.fragmentsByName = Assert.assertNotNull(fragmentsByName, () -> "fragmentsByName can't be null");
            return this;
        }

        public QueryTraverser build() {
            this.checkState();
            if (this.document != null) {
                if (this.rawVariables != null) {
                    return new QueryTraverser(this.schema, this.document, this.operation, this.rawVariables);
                }
                return new QueryTraverser(this.schema, this.document, this.operation, this.coercedVariables);
            }
            if (this.rawVariables != null) {
                return new QueryTraverser(this.schema, this.root, this.rootParentType, this.fragmentsByName, CoercedVariables.of(this.rawVariables.toMap()));
            }
            return new QueryTraverser(this.schema, this.root, this.rootParentType, this.fragmentsByName, this.coercedVariables);
        }

        private void checkState() {
            if (!(this.document == null && this.operation == null || this.root == null && this.rootParentType == null && this.fragmentsByName == null)) {
                throw new IllegalStateException("ambiguous builder");
            }
        }
    }
}

