/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.ClientMessageObserver;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.HTTPConduit;

public class ClientConfiguration
implements InterceptorProvider,
ConduitSelectorHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientConfiguration.class);
    private List<Interceptor<? extends Message>> inInterceptors = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> outInterceptors = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> outFault = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> inFault = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    private ConduitSelector conduitSelector;
    private Bus bus;
    private Map<String, Object> requestContext = new HashMap<String, Object>();
    private Map<String, Object> responseContext = new HashMap<String, Object>();
    private long synchronousTimeout = 60000L;
    private boolean shutdownBusOnClose;
    private boolean resetThreadLocalStateImmediately;

    public long getSynchronousTimeout() {
        Conduit conduit = this.getConduit();
        if (conduit instanceof HTTPConduit) {
            return ((HTTPConduit)conduit).getClient().getReceiveTimeout();
        }
        return this.synchronousTimeout;
    }

    public void setSynchronousTimeout(long synchronousTimeout) {
        this.synchronousTimeout = synchronousTimeout;
    }

    public boolean isResponseExpectedForOneway() {
        return this.getConduit() instanceof HTTPConduit;
    }

    @Override
    public void setConduitSelector(ConduitSelector cs) {
        this.conduitSelector = cs;
    }

    @Override
    public ConduitSelector getConduitSelector() {
        return this.conduitSelector;
    }

    void prepareConduitSelector(Message message) {
        try {
            this.getConduitSelector().prepare(message);
        }
        catch (Fault ex) {
            LOG.fine("Failure to prepare a message from conduit selector");
        }
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Override
    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.inFault;
    }

    @Override
    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.inInterceptors;
    }

    @Override
    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.outFault;
    }

    @Override
    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.outInterceptors;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inInterceptors = interceptors;
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outInterceptors = interceptors;
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.inFault = interceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.outFault = interceptors;
    }

    public Conduit getConduit() {
        MessageImpl message = new MessageImpl();
        ExchangeImpl exchange = new ExchangeImpl();
        message.setExchange(exchange);
        exchange.put(MessageObserver.class, new ClientMessageObserver(this));
        if (this.conduitSelector != null) {
            exchange.put(Endpoint.class, this.conduitSelector.getEndpoint());
        }
        exchange.put(Bus.class, this.bus);
        this.prepareConduitSelector(message);
        return this.getConduitSelector().selectConduit(message);
    }

    public HTTPConduit getHttpConduit() {
        Conduit conduit = this.getConduit();
        return conduit instanceof HTTPConduit ? (HTTPConduit)conduit : null;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    public Map<String, Object> getRequestContext() {
        return this.requestContext;
    }

    public Endpoint getEndpoint() {
        return this.conduitSelector == null ? null : this.conduitSelector.getEndpoint();
    }

    public boolean isShutdownBusOnClose() {
        return this.shutdownBusOnClose;
    }

    public void setShutdownBusOnClose(boolean shutdownBusOnClose) {
        this.shutdownBusOnClose = shutdownBusOnClose;
    }

    public boolean isResetThreadLocalStateImmediately() {
        return this.resetThreadLocalStateImmediately;
    }

    public void setResetThreadLocalStateImmediately(boolean reset) {
        this.resetThreadLocalStateImmediately = reset;
    }
}

