/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.Constants;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaValidator
extends TypeValidator<Schema> {
    private static final TraceComponent tc = Tr.register(SchemaValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final SchemaValidator INSTANCE = new SchemaValidator();
    static final long serialVersionUID = -4473352753159848123L;

    public static SchemaValidator getInstance() {
        return INSTANCE;
    }

    private SchemaValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Schema t) {
        if (t != null) {
            String message;
            String message2;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            if (t.getType() != null && Constants.SCHEMA_TYPE_ARRAY.equals(t.getType().toString()) && t.getItems() == null) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaTypeArrayNullItems", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
            if (t.getReadOnly() != null && t.getWriteOnly() != null && t.getReadOnly().booleanValue() && t.getWriteOnly().booleanValue()) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaReadOnlyOrWriteOnly", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
            if (t.getMultipleOf() != null && t.getMultipleOf().compareTo(BigDecimal.ZERO) <= 0) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"schemaMultipleOfNotGreaterThanZero", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
            }
            String type = t.getType() != null ? t.getType().toString() : "null";
            ArrayList<String> propertiesInvalidValue = new ArrayList<String>();
            ArrayList<String> propertiesNotForSchemaType = new ArrayList<String>();
            if (t.getMaxLength() != null) {
                if (t.getMaxLength() < 0) {
                    propertiesInvalidValue.add("maxLength");
                }
                if (!type.equals(Constants.SCHEMA_TYPE_STRING)) {
                    propertiesNotForSchemaType.add("maxLength");
                }
            }
            if (t.getMinLength() != null) {
                if (t.getMinLength() < 0) {
                    propertiesInvalidValue.add("minLength");
                }
                if (!type.equals(Constants.SCHEMA_TYPE_STRING)) {
                    propertiesNotForSchemaType.add("minLength");
                }
            }
            if (t.getMinItems() != null) {
                if (t.getMinItems() < 0) {
                    propertiesInvalidValue.add("minItems");
                }
                if (!type.equals(Constants.SCHEMA_TYPE_ARRAY)) {
                    propertiesNotForSchemaType.add("minItems");
                }
            }
            if (t.getMaxItems() != null) {
                if (t.getMaxItems() < 0) {
                    propertiesInvalidValue.add("maxItems");
                }
                if (!type.equals(Constants.SCHEMA_TYPE_ARRAY)) {
                    propertiesNotForSchemaType.add("maxItems");
                }
            }
            if (t.getUniqueItems() != null && !type.equals(Constants.SCHEMA_TYPE_ARRAY)) {
                propertiesNotForSchemaType.add("uniqueItems");
            }
            if (t.getMinProperties() != null) {
                if (t.getMinProperties() < 0) {
                    propertiesInvalidValue.add("minProperties");
                }
                if (!type.equals(Constants.SCHEMA_TYPE_OBJECT)) {
                    propertiesNotForSchemaType.add("minProperties");
                }
            }
            if (t.getMaxProperties() != null) {
                if (t.getMaxProperties() < 0) {
                    propertiesInvalidValue.add("maxProperties");
                }
                if (!type.equals(Constants.SCHEMA_TYPE_OBJECT)) {
                    propertiesNotForSchemaType.add("maxProperties");
                }
            }
            if (!propertiesInvalidValue.isEmpty()) {
                for (String s : propertiesInvalidValue) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"schemaPropertyLessThanZero", (Object[])new Object[]{s});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
            }
            if (!propertiesNotForSchemaType.isEmpty()) {
                for (String s : propertiesNotForSchemaType) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"schemaTypeDoesNotMatchProperty", (Object[])new Object[]{s, type});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
            }
        }
    }
}

