/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.XML;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class XMLValidator
extends TypeValidator<XML> {
    private static final TraceComponent tc = Tr.register(XMLValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final XMLValidator INSTANCE = new XMLValidator();
    static final long serialVersionUID = -3641054005424446403L;

    public static XMLValidator getInstance() {
        return INSTANCE;
    }

    private XMLValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, XML t) {
        String namespace;
        if (t != null && StringUtils.isNotBlank((CharSequence)t.getNamespace()) && !ValidatorUtils.isValidURI(namespace = t.getNamespace())) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"invalidUri", (Object[])new Object[]{namespace});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }
}

