/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.MavenRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArtifactDownloaderUtils {
    private static final Logger logger = InstallLogUtils.getInstallLogger();
    private static final Integer DEFAULT_THREAD_NUM = 8;
    public static final int THREAD_SLEEP = 300;
    private static int thread_num = 0;

    public static int getNumThreads() {
        if (thread_num == 0) {
            try {
                String num_thread = System.getProperty("com.ibm.ws.install.featureUtility.artifactThreads", DEFAULT_THREAD_NUM.toString());
                thread_num = Integer.parseInt(num_thread);
            }
            catch (NumberFormatException e) {
                logger.warning("Could not convert com.ibm.ws.install.featureUtility.artifactThreads to integer value: " + e.getMessage());
                thread_num = DEFAULT_THREAD_NUM;
            }
            logger.info("Using " + thread_num + " threads to download artifacts.");
        }
        return thread_num;
    }

    public static List<String> getMissingFiles(Set<String> featureURLs, Map<String, Object> envMap, MavenRepository repository) throws InterruptedException, ExecutionException, InstallException {
        Vector<String> result = new Vector<String>();
        logger.fine("number of missing features: " + featureURLs.size());
        int numThreads = ArtifactDownloaderUtils.getNumThreads();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        ArrayList futures = new ArrayList();
        for (String url : featureURLs) {
            Future<?> future = executor.submit(() -> {
                try {
                    if (ArtifactDownloaderUtils.exists(url, envMap, repository) != 200) {
                        result.add(url);
                    }
                }
                catch (IOException e) {
                    logger.fine(e.getMessage());
                }
            });
            futures.add(future);
        }
        while (!futures.isEmpty()) {
            Iterator iter = futures.iterator();
            while (iter.hasNext()) {
                Future future = (Future)iter.next();
                if (!future.isDone()) continue;
                future.get();
                iter.remove();
            }
            logger.fine("Finding " + futures.size() + " maven artifacts.. ");
            Thread.sleep(300L);
        }
        executor.shutdown();
        return result;
    }

    public static boolean fileIsMissing(String url, Map<String, Object> envMap, MavenRepository repository) throws IOException {
        return ArtifactDownloaderUtils.exists(url, envMap, repository) != 200;
    }

    public static int exists(String URLName, Map<String, Object> envMap, MavenRepository repository) throws IOException {
        try {
            Proxy proxy;
            URL url = new URL(URLName);
            String proxyEncodedAuth = "";
            if (envMap.get("https.proxyHost") != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("https.proxyHost"), Integer.parseInt((String)envMap.get("https.proxyPort"))));
                proxyEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication((String)envMap.get("https.proxyUser"), (String)envMap.get("https.proxyPassword"));
            } else if (envMap.get("http.proxyHost") != null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)envMap.get("http.proxyHost"), Integer.parseInt((String)envMap.get("http.proxyPort"))));
                proxyEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication((String)envMap.get("http.proxyUser"), (String)envMap.get("http.proxyPassword"));
            } else {
                proxy = Proxy.NO_PROXY;
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
            String repoEncodedAuth = ArtifactDownloaderUtils.getBasicAuthentication(repository.getUserId(), repository.getPassword());
            if (!repoEncodedAuth.isEmpty()) {
                conn.setRequestProperty("Authorization", repoEncodedAuth);
            }
            if (!proxyEncodedAuth.isEmpty()) {
                conn.setRequestProperty("Proxy-Authorization", proxyEncodedAuth);
            }
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(10000);
            conn.setInstanceFollowRedirects(true);
            conn.connect();
            return conn.getResponseCode();
        }
        catch (ConnectException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public static void acquireFeatureURLs(List<String> mavenCoords, String repo, Map<String, String> urltoMavenCoord, InstallConstants.VerifyOption verifyOption, boolean downloadSignaturesOnly) {
        for (String coord : mavenCoords) {
            String url = ArtifactDownloaderUtils.getUrlLocation(repo, coord);
            if (downloadSignaturesOnly) {
                urltoMavenCoord.put(url + ".esa.asc", coord);
                urltoMavenCoord.put(url + ".pom.asc", coord);
                continue;
            }
            if (verifyOption == null || verifyOption == InstallConstants.VerifyOption.skip) {
                urltoMavenCoord.put(url + ".esa", coord);
                urltoMavenCoord.put(url + ".pom", coord);
                continue;
            }
            urltoMavenCoord.put(url + ".esa", coord);
            urltoMavenCoord.put(url + ".pom", coord);
            urltoMavenCoord.put(url + ".esa.asc", coord);
            urltoMavenCoord.put(url + ".pom.asc", coord);
        }
    }

    public static String getChecksum(String filename, String format) throws NoSuchAlgorithmException, IOException {
        if (format.equals("SHA256")) {
            format = "SHA-256";
        }
        byte[] b = ArtifactDownloaderUtils.createChecksum(filename, format);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static byte[] createChecksum(String filename, String format) throws IOException, NoSuchAlgorithmException {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance(format);
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String getChecksumFromURL(URL url) throws IOException {
        String inputLine;
        String result = "";
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((inputLine = in.readLine()) != null) {
            result = result + inputLine;
        }
        in.close();
        return result;
    }

    public static String getPrimaryChecksum(String url, String format) throws IOException {
        URL urlLocation = new URL(url + "." + format.toLowerCase());
        return ArtifactDownloaderUtils.getChecksumFromURL(urlLocation);
    }

    public static void deleteFiles(List<File> fileList, String dLocation, File mavenArtifact) {
        for (File f : fileList) {
            f.delete();
        }
        File file = mavenArtifact.getParentFile();
        while (!(file.toString() + "/").equals(dLocation)) {
            File[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.equals(".DS_Store");
                }
            });
            File newFile = file.getParentFile();
            if (files.length == 0) {
                file.delete();
            }
            file = newFile;
        }
    }

    public static String getGroupId(String mavenCoords) {
        return mavenCoords.split(":")[0];
    }

    public static String getartifactId(String mavenCoords) {
        return mavenCoords.split(":")[1];
    }

    public static String getVersion(String mavenCoords) {
        return mavenCoords.split(":")[2];
    }

    public static String getfilename(String mavenCoords) {
        return ArtifactDownloaderUtils.getartifactId(mavenCoords) + "-" + ArtifactDownloaderUtils.getVersion(mavenCoords);
    }

    public static String getUrlLocation(String repo, String groupId, String artifactId, String version, String filename) {
        return repo + groupId + artifactId + "/" + version + "/" + filename;
    }

    public static String getUrlLocation(String repo, String mavenCoords) {
        String[] coordSplit = mavenCoords.split(":");
        return repo + coordSplit[0].replace(".", "/") + "/" + coordSplit[1] + "/" + coordSplit[2] + "/" + coordSplit[1] + "-" + coordSplit[2];
    }

    public static String getFileLocation(String dLocation, String groupId, String artifactId, String version, String filename) {
        return dLocation + groupId + artifactId + "/" + version + "/" + filename;
    }

    public static String getFileNameFromURL(String str) {
        String[] pathSplit = str.split("/");
        return pathSplit[pathSplit.length - 1];
    }

    public static void checkResponseCode(int repoResponseCode, String repo) throws InstallException {
        if (repoResponseCode != 200) {
            if (repoResponseCode == 407) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", new Object[0]);
            }
            if (repoResponseCode == 401 || repoResponseCode == 403) {
                throw ExceptionUtils.createByKey("ERROR_INVALID_MAVEN_CREDENTIALS", repo);
            }
            throw ExceptionUtils.createByKey("ERROR_FAILED_TO_CONNECT_MAVEN", new Object[0]);
        }
    }

    public static String getMavenCoordFromPath(String coordPath, String groupID) {
        String result = coordPath.replace("\\", "/");
        String[] resSplit = result.split("/");
        String artifactID = resSplit[resSplit.length - 3];
        String version = resSplit[resSplit.length - 2];
        result = groupID + ":" + artifactID + ":" + version;
        return result;
    }

    public static String getBasicAuthentication(String userId, String password) {
        if (userId != null && password != null) {
            return "Basic " + ArtifactDownloaderUtils.base64Encode(userId + ":" + PasswordUtil.passwordDecode((String)password));
        }
        return "";
    }

    private static String base64Encode(String userInfo) {
        try {
            return Base64.getEncoder().encodeToString(userInfo.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException encodingException) {
            throw new RuntimeException("Failed to get bytes for user info using UTF-8.", encodingException);
        }
    }

    public static void checkValidProxy(Map<String, Object> envMap) throws InstallException {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        String protocol = null;
        if (envMap.get("https.proxyUser") != null) {
            protocol = "https";
        } else if (envMap.get("http.proxyUser") != null) {
            protocol = "http";
        }
        String proxyPort = (String)envMap.get(protocol + ".proxyPort");
        if (protocol != null) {
            int proxyPortnum = Integer.parseInt(proxyPort);
            if (((String)envMap.get(protocol + ".proxyHost")).isEmpty()) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_HOST_MISSING", new Object[0]);
            }
            if (proxyPortnum < 0 || proxyPortnum > 65535) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_INVALID_PROXY_PORT", proxyPort);
            }
            if (((String)envMap.get(protocol + ".proxyPassword")).isEmpty() || envMap.get(protocol + ".proxyPassword") == null) {
                throw ExceptionUtils.createByKey("ERROR_TOOL_PROXY_PWD_MISSING", new Object[0]);
            }
            ArtifactDownloaderUtils.verifyPassword((String)envMap.get(protocol) + ".proxyPassword");
        }
    }

    protected static void verifyPassword(String pwd) throws InstallException {
        String crypto_algorithm;
        if (!PasswordUtil.isEncrypted((String)pwd)) {
            logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_NOT_ENCRYPTED", new Object[0]) + InstallUtils.NEWLINE);
        }
        if ((crypto_algorithm = PasswordUtil.getCryptoAlgorithm((String)pwd)) == null) {
            return;
        }
        if (PasswordUtil.passwordDecode((String)pwd) == null) {
            if (!PasswordUtil.isValidCryptoAlgorithm((String)crypto_algorithm)) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_CRYPTO_UNSUPPORTED", new Object[0]));
            }
            throw new InstallException(InstallLogUtils.Messages.PASSWORD_UTIL_MESSAGES.getLogMessage("PASSWORDUTIL_CYPHER_EXCEPTION", new Object[0]));
        }
    }
}

