/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.runtime.util.StreamHandlerUtils;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.LibertySSLContext;
import com.ibm.ws.ssl.LibertySSLContextSpi;
import com.ibm.ws.ssl.LibertySSLSocketFactoryWrapper;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import com.ibm.ws.ssl.core.WSX509KeyManager;
import com.ibm.ws.ssl.core.WSX509TrustManager;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractJSSEProvider
implements JSSEProvider {
    private static final TraceComponent tc = Tr.register(AbstractJSSEProvider.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private static final Map<SSLConfig, SSLContext> sslContextCacheJAVAX = new HashMap<SSLConfig, SSLContext>();
    private static final String PKGNAME_DELIMITER = "|";
    public static String IBM_JCE_Plus_FIPS_PROVIDER = "com.ibm.crypto.provider.IBMJCEPlusFIPS";
    private static boolean handlersInitialized = false;
    private static Object _lockObj = new Object();
    private String keyManager = null;
    private String trustManager = null;
    private String contextProvider = null;
    private String keyStoreProvider = null;
    private String socketFactory = null;
    private final String protocolPackageHandler;
    private String defaultProtocol = null;
    private static final PrivilegedAction<ClassLoader> getCtxClassLoader = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public AbstractJSSEProvider() {
        this.protocolPackageHandler = null;
    }

    protected void initialize(String keyMgr, String trustMgr, String cxtProvider, String keyProvider, String factory, String packageHandler, String protocolType) {
        block8: {
            this.keyManager = keyMgr;
            this.trustManager = trustMgr;
            this.contextProvider = cxtProvider;
            this.keyStoreProvider = keyProvider;
            this.socketFactory = factory;
            this.defaultProtocol = protocolType;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("defaultProtocol: " + this.defaultProtocol), (Object[])new Object[0]);
            }
            if (JavaInfo.isSystemClassAvailable((String)IBM_JCE_Plus_FIPS_PROVIDER)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"jce plus fips available", (Object[])new Object[0]);
                }
                try {
                    JSSEProviderFactory.initializeFips();
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"Exception caught initializing FIPS.", (Object[])new Object[]{e});
                }
            }
        }
        if (!handlersInitialized && System.getProperty("os.name").equalsIgnoreCase("z/OS") && JavaInfo.majorVersion() < 11) {
            AbstractJSSEProvider.addHandlers();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handlers already initialized ", (Object[])new Object[0]);
        }
    }

    @Override
    public String getSSLProtocolPackageHandler() {
        return this.protocolPackageHandler;
    }

    @Override
    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    @Override
    public String getKeyManager() {
        return this.keyManager;
    }

    @Override
    public String getTrustManager() {
        return this.trustManager;
    }

    @Override
    public String getContextProvider() {
        return this.contextProvider;
    }

    @Override
    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @Override
    public String getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public String[] getCiphersForSecurityLevel(boolean isClient, String securityLevel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCiphersForSecurityLevel: ", (Object[])new Object[]{isClient, securityLevel});
        }
        String[] supportedCiphers = null;
        if (isClient) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            supportedCiphers = factory.getSupportedCipherSuites();
        } else {
            SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            supportedCiphers = factory.getSupportedCipherSuites();
        }
        return Constants.adjustSupportedCiphersToSecurityLevel(supportedCiphers, securityLevel);
    }

    @Override
    public SSLContext getSSLContext(Map<String, Object> connectionInfo, SSLConfig sslConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContext", (Object[])new Object[]{connectionInfo});
        }
        SSLContext sslContext = sslContextCacheJAVAX.get(sslConfig);
        this.setOutboundConnectionInfoInternal(connectionInfo);
        if (sslContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSSLContext -> (from cache)");
            }
            return sslContext;
        }
        String direction = "outbound";
        if (connectionInfo != null) {
            direction = (String)connectionInfo.get("com.ibm.ssl.direction");
        }
        sslContext = this.getSSLContextInstance(sslConfig);
        ArrayList<KeyManager> keyMgrs = new ArrayList<KeyManager>();
        ArrayList<TrustManager> trustMgrs = new ArrayList<TrustManager>();
        this.getWSKeyManager(keyMgrs, connectionInfo, sslConfig);
        this.getWSTrustmanager(trustMgrs, connectionInfo, sslConfig);
        if (!keyMgrs.isEmpty() && !trustMgrs.isEmpty()) {
            KeyManager[] keyManagers = keyMgrs.toArray(new KeyManager[keyMgrs.size()]);
            TrustManager[] trustManagers = trustMgrs.toArray(new TrustManager[trustMgrs.size()]);
            sslContext.init(keyManagers, trustManagers, null);
        } else {
            if (keyMgrs.isEmpty() && direction != null && direction.equals("inbound")) {
                String message = TraceNLSHelper.getInstance().getString("ssl.config.error.CWPKI0835E", "An SSL/TLS configuration cannot be created for inbound connection due to no key manager being created.");
                throw new SSLException(message);
            }
            if (keyMgrs.isEmpty() && !trustMgrs.isEmpty()) {
                TrustManager[] trustManagers = trustMgrs.toArray(new TrustManager[trustMgrs.size()]);
                sslContext.init(null, trustManagers, null);
            } else {
                String message = TraceNLSHelper.getInstance().getString("ssl.config.error.CWPKI0836E", "An SSL/TLS configuration cannot created due to no key and trust managers being created.");
                throw new SSLException(message);
            }
        }
        if (sslContextCacheJAVAX.size() > 100) {
            SSLConfig[] victims;
            Iterator<SSLConfig> keys = sslContextCacheJAVAX.keySet().iterator();
            for (SSLConfig victim : victims = new SSLConfig[]{keys.next(), keys.next(), keys.next(), keys.next(), keys.next()}) {
                sslContextCacheJAVAX.remove(victim);
            }
        }
        LibertySSLContextSpi libertySSLContextSpi = new LibertySSLContextSpi(sslContext, sslConfig.getProperty("com.ibm.ssl.alias"));
        LibertySSLContext libertySSLContext = new LibertySSLContext(libertySSLContextSpi, sslContext.getProvider(), sslContext.getProtocol());
        sslContextCacheJAVAX.put(sslConfig, libertySSLContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSLContext cache size: " + sslContextCacheJAVAX.size()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLContext -> (new)");
        }
        return libertySSLContext;
    }

    private void getWSTrustmanager(List<TrustManager> tmHolder, Map<String, Object> connectionInfo, SSLConfig sslConfig) throws Exception {
        KeyStore trustStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContext", (Object[])new Object[]{tmHolder, connectionInfo, sslConfig});
        }
        String direction = "unknown";
        String ctxtProvider = this.getSSLContextProperty("com.ibm.ssl.contextProvider", sslConfig);
        String clientAuthentication = this.getSSLContextProperty("com.ibm.ssl.clientAuthentication", sslConfig);
        String trustStoreName = this.getSSLContextProperty("com.ibm.ssl.trustStoreName", sslConfig);
        String trustStoreLocation = this.getSSLContextProperty("com.ibm.ssl.trustStore", sslConfig);
        String trustMgr = this.getSSLContextProperty("com.ibm.ssl.trustManager", sslConfig);
        if (connectionInfo != null) {
            direction = (String)connectionInfo.get("com.ibm.ssl.direction");
        }
        if ((trustStore = this.getKeyStoreForManager(sslConfig, "com.ibm.ssl.trustStoreName")) == null && trustStoreLocation != null) {
            String type = this.getSSLContextProperty("com.ibm.ssl.trustStoreType", sslConfig);
            String password = WSKeyStore.decodePassword(this.getSSLContextProperty("com.ibm.ssl.trustStorePassword", sslConfig));
            String provider = this.getSSLContextProperty("com.ibm.ssl.trustStoreProvider", sslConfig);
            trustStore = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
            trustStore.load(new FileInputStream(new File(trustStoreLocation)), password.toCharArray());
        }
        if (trustStore != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using trust store: " + trustStoreLocation), (Object[])new Object[0]);
            }
        } else if (direction.equals("inbound") && clientAuthentication.equals("false")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"trust store permitted to be null since this is inbound and client auth is false", (Object[])new Object[0]);
            }
        } else {
            throw new IllegalArgumentException("Invalid trust file name of null");
        }
        try {
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactoryInstance(trustMgr, ctxtProvider);
            trustManagerFactory.init(trustStore);
            TrustManager[] defaultTMArray = trustManagerFactory.getTrustManagers();
            WSX509TrustManager wsTrustManager = new WSX509TrustManager(defaultTMArray, connectionInfo, sslConfig, trustStoreName, trustStoreLocation);
            tmHolder.add(wsTrustManager);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught during trustmanager init, " + e), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getWSTrustmanager", (Object)this);
            throw e;
        }
    }

    private KeyStore getKeyStoreForManager(SSLConfig sslConfig, String ksProp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyStoreForManager", (Object[])new Object[]{sslConfig, ksProp});
        }
        KeyStore ks = null;
        String keystoreFileName = this.getSSLContextProperty(ksProp, sslConfig);
        WSKeyStore wsts = null;
        if (keystoreFileName != null) {
            wsts = KeyStoreManager.getInstance().getKeyStore(keystoreFileName);
        }
        if (wsts != null) {
            try {
                ks = wsts.getKeyStore(false, false);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught getting keystore, " + e), (Object[])new Object[0]);
                }
                return null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKeyStoreForManager", (Object)new Object[]{ks});
        }
        return ks;
    }

    public static TrustManager[] getDefaultTrustManager() throws Exception {
        String tsFileName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultTrustManager", (Object[])new Object[0]);
        }
        if ((tsFileName = System.getProperty("javax.net.ssl.trustStore")) != null && !tsFileName.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The javax.net.ssl.trustStore property is set to " + tsFileName + " it will used as the JDK default truststore"), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The default truststore will likely be the jssecacerts or cacerts file.", (Object[])new Object[0]);
        }
        try {
            String trustMgr = JSSEProviderFactory.getTrustManagerFactoryAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustMgr);
            if (null != trustManagerFactory) {
                trustManagerFactory.init((KeyStore)null);
            }
            TrustManager[] cacertTMArray = trustManagerFactory.getTrustManagers();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDefaultTrustManager");
            }
            return cacertTMArray;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception caught while trying to initialize default trustmanager: " + e), (Object[])new Object[0]);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWSKeyManager(List<KeyManager> kmHolder, Map<String, Object> connectionInfo, SSLConfig sslConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWSKeyManager", (Object[])new Object[]{kmHolder, connectionInfo, sslConfig});
        }
        KeyManagerFactory keyManagerFactory = null;
        String ctxtProvider = this.getSSLContextProperty("com.ibm.ssl.contextProvider", sslConfig);
        String keyStoreName = this.getSSLContextProperty("com.ibm.ssl.keyStoreName", sslConfig);
        String keyStoreLocation = this.getSSLContextProperty("com.ibm.ssl.keyStore", sslConfig);
        String clientAliasName = this.getSSLContextProperty("com.ibm.ssl.keyStoreClientAlias", sslConfig);
        String serverAliasName = this.getSSLContextProperty("com.ibm.ssl.keyStoreServerAlias", sslConfig);
        String keyMgr = this.getSSLContextProperty("com.ibm.ssl.keyManager", sslConfig);
        KeyStore keyStore = this.getKeyStoreForManager(sslConfig, "com.ibm.ssl.keyStoreName");
        if (keyStore != null) {
            WSKeyStore wsks = KeyStoreManager.getInstance().getWSKeyStore(keyStoreName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using software keystore: " + keyStoreLocation), (Object[])new Object[0]);
            }
            keyManagerFactory = this.getKeyManagerFactoryInstance(keyMgr, ctxtProvider);
            SerializableProtectedString keypass = wsks.getKeyPassword();
            if (keypass != null && !keypass.isEmpty()) {
                try {
                    String decodedPass = WSKeyStore.decodePassword(new String(keypass.getChars()));
                    Object object = _lockObj;
                    synchronized (object) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Entering synchronized block around key manager factory init.", (Object[])new Object[0]);
                        }
                        keyManagerFactory.init(keyStore, decodedPass.toCharArray());
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exiting synchronized block around key manager factory init.", (Object[])new Object[0]);
                        }
                    }
                }
                catch (UnrecoverableKeyException exc) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Error initializing key manager, the password can not be used to recover all keys", (Object[])new Object[0]);
                    }
                    Tr.error((TraceComponent)tc, (String)"ssl.unrecoverablekey.error.CWPKI0813E", (Object[])new Object[]{keyStoreLocation, exc.getMessage()});
                    throw new UnrecoverableKeyException(exc.getMessage() + ": invalid password for key in file '" + keyStoreLocation + "'");
                }
                WSX509KeyManager wsKeyManager = new WSX509KeyManager(keyStore, null, keyManagerFactory, sslConfig, null);
                if (serverAliasName != null && serverAliasName.length() > 0) {
                    wsKeyManager.setServerAlias(serverAliasName);
                }
                if (clientAliasName != null && clientAliasName.length() > 0) {
                    wsKeyManager.setClientAlias(clientAliasName);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Initializing WSX509KeyManager.", (Object[])new Object[]{serverAliasName, clientAliasName});
                }
                kmHolder.add(wsKeyManager);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No password provide so do not create a keymanager", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No key store specified and no hardware crypto defined", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWSKeyManager");
        }
    }

    private String getSSLContextProperty(String propertyName, Properties prop) {
        String value = null;
        if (prop != null) {
            value = prop.getProperty(propertyName);
        } else {
            value = System.getProperty(propertyName);
            if (value == null) {
                value = SSLConfigManager.getInstance().getGlobalProperty(propertyName);
            }
        }
        return value;
    }

    @Override
    public URLStreamHandler getURLStreamHandler(SSLConfig config) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getURLStreamHandler", (Object[])new Object[0]);
        }
        URLStreamHandler urlStreamHandler = null;
        Properties existingProps = null;
        try {
            existingProps = ThreadManager.getInstance().getPropertiesOnThread();
            ThreadManager.getInstance().setPropertiesOnThread(config);
            urlStreamHandler = this.getHandler();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getURLStreamHandler");
            }
            URLStreamHandler uRLStreamHandler = urlStreamHandler;
            return uRLStreamHandler;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getURLStreamHandler", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getURLStreamHandler().", (Object)new Object[]{e});
            }
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        finally {
            ThreadManager.getInstance().setPropertiesOnThread(existingProps);
        }
    }

    @Override
    public SSLServerSocketFactory getSSLServerSocketFactory(SSLConfig config) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLServerSocketFactory", (Object[])new Object[0]);
        }
        try {
            SSLContext context = this.getSSLContext(null, config);
            if (context != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSSLServerSocketFactory");
                }
                return context.getServerSocketFactory();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getSSLServerSocketFactory", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"The following exception occurred in getSSLServerSocketFactory().", (Object)new Object[]{e});
            }
            if (e instanceof SSLException) {
                throw (SSLException)e;
            }
            throw new SSLException(e);
        }
        throw new SSLException("SSLContext could not be created to return an SSLServerSocketFactory.");
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(Map<String, Object> connectionInfo, SSLConfig config) throws Exception {
        SSLContext context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLSocketFactory", (Object[])new Object[]{connectionInfo});
        }
        if ((context = this.getSSLContext(connectionInfo, config)) != null) {
            SSLSocketFactory factory = context.getSocketFactory();
            LibertySSLSocketFactoryWrapper wrapper = new LibertySSLSocketFactoryWrapper(factory, config.getProperty("com.ibm.ssl.alias"));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getSSLSocketFactory -> " + factory.getClass().getName()));
            }
            return wrapper;
        }
        throw new SSLException("SSLContext could not be created to return an SSLSocketFactory.");
    }

    @Override
    public SSLContext getSSLContextInstance(SSLConfig config) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLContextInstance", (Object[])new Object[0]);
        }
        if (config == null) {
            throw new IllegalArgumentException("SSL configuration is not specified.");
        }
        final String ctxtProvider = config.getProperty("com.ibm.ssl.contextProvider");
        String alias = config.getProperty("com.ibm.ssl.alias");
        String configURL = config.getProperty("com.ibm.ssl.configURLLoadedFrom");
        String protocolVal = config.getProperty("com.ibm.ssl.protocol");
        SSLContext sslContext = null;
        if (protocolVal == null) {
            throw new IllegalArgumentException("Protocol is not specified.");
        }
        String[] protocols = protocolVal.split(",");
        if (protocols.length > 1) {
            protocolVal = this.defaultProtocol;
        }
        final String protocol = protocolVal;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("protocol:  " + protocolVal), (Object[])new Object[0]);
        }
        try {
            sslContext = AccessController.doPrivileged(new PrivilegedExceptionAction<SSLContext>(){

                @Override
                public SSLContext run() throws NoSuchAlgorithmException, NoSuchProviderException {
                    if (ctxtProvider != null) {
                        return SSLContext.getInstance(protocol, ctxtProvider);
                    }
                    return SSLContext.getInstance(protocol);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting SSL context.", (Object[])new Object[]{ex});
            }
            if (ex instanceof NoSuchAlgorithmException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.no.such.algorithm.CWPKI0028E", new Object[]{protocol, alias, configURL, ex.getMessage()}, "CWPKI0028E: SSL handshake protocol " + protocol + " is not valid.  This protocol is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error((TraceComponent)tc, (String)"ssl.no.such.algorithm.CWPKI0028E", (Object[])new Object[]{protocol, alias, configURL, ex.getMessage()});
                throw new SSLException(message, ex);
            }
            if (ex instanceof NoSuchProviderException) {
                String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.invalid.context.provider.CWPKI0029E", new Object[]{"IBMJSSE2", alias, configURL, ex.getMessage()}, "CWPKI0029E: SSL context provider IBMJSSE2 is not valid.  This provider is specified in the SSL configuration alias " + alias + " loaded from SSL configuration file " + configURL + ".  The extended error message is: " + ex.getMessage() + ".");
                Tr.error((TraceComponent)tc, (String)"ssl.invalid.context.provider.CWPKI0029E", (Object[])new Object[]{"IBMJSSE2", alias, configURL, ex.getMessage()});
                throw new SSLException(message, ex);
            }
            throw new SSLException(ex);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Throwable occurred getting SSL context.", (Object[])new Object[]{cause});
            }
            throw new SSLException(cause.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLContextInstance");
        }
        return sslContext;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getTrustManagerFactoryInstance(this.getTrustManager(), this.getContextProvider());
    }

    public TrustManagerFactory getTrustManagerFactoryInstance(String trustMgr, String ctxtProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] trustManagerArray;
        String mgr = trustMgr;
        String provider = ctxtProvider;
        if (mgr.indexOf(124) != -1 && (trustManagerArray = mgr.split("\\|")) != null && trustManagerArray.length == 2) {
            mgr = trustManagerArray[0];
            provider = trustManagerArray[1];
        }
        TrustManagerFactory rc = TrustManagerFactory.getInstance(mgr, provider);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTrustManagerFactory.getInstance(" + mgr + ", " + provider + ")" + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public KeyManagerFactory getKeyManagerFactoryInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getKeyManagerFactoryInstance(this.getKeyManager(), this.getContextProvider());
    }

    public KeyManagerFactory getKeyManagerFactoryInstance(String keyMgr, String ctxtProvider) throws NoSuchAlgorithmException, NoSuchProviderException {
        String[] keyManagerArray;
        String mgr = keyMgr;
        String provider = ctxtProvider;
        if (mgr.indexOf(124) != -1 && (keyManagerArray = mgr.split("\\|")) != null && keyManagerArray.length == 2) {
            mgr = keyManagerArray[0];
            provider = keyManagerArray[1];
        }
        KeyManagerFactory rc = KeyManagerFactory.getInstance(mgr, provider);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getKeyManagerFactory.getInstance(" + mgr + ", " + provider + ") " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public KeyStore getKeyStoreInstance(String type, String ksProvider) throws KeyStoreException, NoSuchProviderException {
        String provider;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyStore.getInstance(" + type + ", " + ksProvider + ")"), (Object[])new Object[0]);
        }
        if (null == (provider = ksProvider)) {
            provider = this.getKeyStoreProvider();
        }
        if (null == provider) {
            return KeyStore.getInstance(type);
        }
        return KeyStore.getInstance(type, provider);
    }

    @Override
    public void setServerDefaultSSLContext(SSLConfig defaultSSLConfig) throws Exception {
        SSLContext context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServerDefaultSSLContext", (Object[])new Object[0]);
        }
        if ((context = this.getSSLContext(null, defaultSSLConfig)) != null) {
            SSLContext.setDefault(context);
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Default SSLContext set to " + defaultSSLConfig.getProperty("com.ibm.ssl.alias")), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerDefaultSSLContext");
        }
    }

    public URLStreamHandler getHandler() throws Exception {
        String handlerString = this.getSSLProtocolPackageHandler() + ".https.Handler";
        URLStreamHandler streamHandler = null;
        try {
            ClassLoader cl = AccessController.doPrivileged(getCtxClassLoader);
            streamHandler = cl != null ? (URLStreamHandler)cl.loadClass(handlerString).newInstance() : (URLStreamHandler)Class.forName(handlerString).newInstance();
            return streamHandler;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getHandler", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading https stream handler.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"ssl.load.https.stream.handler.CWPKI0025E", (Object[])new Object[]{handlerString, e.getMessage()});
            throw e;
        }
    }

    protected static void addHandlers() {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"addHandlers", (Object[])new Object[0]);
            }
            if (!handlersInitialized) {
                try {
                    StreamHandlerUtils.create();
                    if (!AbstractJSSEProvider.queryProvider("safkeyring")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding handler:  com.ibm.crypto.provider.safkeyring.Handler", (Object[])new Object[0]);
                        }
                        AbstractJSSEProvider.addProvider("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
                    }
                    if (!AbstractJSSEProvider.queryProvider("safkeyringhw")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding handler: com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler", (Object[])new Object[0]);
                        }
                        AbstractJSSEProvider.addProvider("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
                    }
                    if (!AbstractJSSEProvider.queryProvider("safkeyringhybrid")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Adding handler: com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler", (Object[])new Object[0]);
                        }
                        AbstractJSSEProvider.addProvider("safkeyringhybrid", "com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler");
                    }
                    handlersInitialized = true;
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)AbstractJSSEProvider.class.getName(), (String)"addHandlers");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)"Unable to set safkeyring stream handler", (Object[])new Object[]{t});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addHandlers");
        }
    }

    private X509KeyManager loadCustomKeyManager(String kmClass) throws Exception {
        X509KeyManager km = null;
        try {
            ClassLoader cl = AccessController.doPrivileged(getCtxClassLoader);
            if (cl != null) {
                try {
                    km = (X509KeyManager)cl.loadClass(kmClass).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (km == null) {
                km = (X509KeyManager)Class.forName(kmClass).newInstance();
            }
            return km;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"loadCustomKeyManager", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading custom KeyManager.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"ssl.load.keymanager.error.CWPKI0021E", (Object[])new Object[]{kmClass, e.getMessage()});
            throw e;
        }
    }

    private X509TrustManager loadCustomTrustManager(String tmClass) throws Exception {
        X509TrustManager tm = null;
        try {
            ClassLoader cl = AccessController.doPrivileged(getCtxClassLoader);
            if (cl != null) {
                try {
                    tm = (X509TrustManager)cl.loadClass(tmClass).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (tm == null) {
                tm = (X509TrustManager)Class.forName(tmClass).newInstance();
            }
            return tm;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"loadCustomTrustManager", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception loading custom TrustManager.", (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"ssl.load.trustmanager.error.CWPKI0020E", (Object[])new Object[]{tmClass, e.getMessage()});
            throw e;
        }
    }

    private static boolean queryProvider(String provider) {
        return StreamHandlerUtils.queryProvider(provider);
    }

    private static void addProvider(String provider, String handler) {
        block2: {
            try {
                StreamHandlerUtils.addProvider(provider, handler);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)AbstractJSSEProvider.class.getName(), (String)"addProvider");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    public static void clearSSLContextCache() {
        if (sslContextCacheJAVAX != null && sslContextCacheJAVAX.size() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Clearing standard javax.net.ssl.SSLContext cache.", (Object[])new Object[0]);
            }
            sslContextCacheJAVAX.clear();
        }
    }

    public static void clearSSLContextCache(Collection<File> modifiedFiles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing standard javax.net.ssl.SSLContext cached object containing keystores: " + new Object[]{modifiedFiles}), (Object[])new Object[0]);
        }
        for (File modifiedKeystoreFile : modifiedFiles) {
            String filePath = null;
            try {
                filePath = modifiedKeystoreFile.getCanonicalPath();
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception comparing file path.", (Object[])new Object[0]);
                continue;
            }
            AbstractJSSEProvider.removeEntryFromSSLContextMap(filePath);
        }
    }

    public static void removeEntryFromSSLContextMap(String keyStorePath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeEntryFromSSLContextMap: " + new Object[]{keyStorePath}), (Object[])new Object[0]);
        }
        ArrayList<SSLConfig> removeList = new ArrayList<SSLConfig>();
        for (Map.Entry<SSLConfig, SSLContext> entry : sslContextCacheJAVAX.entrySet()) {
            SSLConfig cachedConfig = entry.getKey();
            if (cachedConfig == null) continue;
            String ksPropValue = cachedConfig.getProperty("com.ibm.ssl.keyStore", null);
            boolean ksFileBased = Boolean.parseBoolean(cachedConfig.getProperty("com.ibm.ssl.keyStoreFileBased"));
            String tsPropValue = cachedConfig.getProperty("com.ibm.ssl.trustStore", null);
            boolean tsFileBased = Boolean.parseBoolean(cachedConfig.getProperty("com.ibm.ssl.trustStoreFileBased"));
            if ((ksPropValue == null || !keyStorePath.equals(WSKeyStore.getCannonicalPath(ksPropValue, ksFileBased))) && (tsPropValue == null || !keyStorePath.equals(WSKeyStore.getCannonicalPath(tsPropValue, tsFileBased)))) continue;
            removeList.add(cachedConfig);
        }
        if (!removeList.isEmpty()) {
            for (SSLConfig removeEntry : removeList) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removing from sslContext cache: " + removeEntry.toString()), (Object[])new Object[0]);
                }
                sslContextCacheJAVAX.remove(removeEntry);
            }
        }
    }

    private void setOutboundConnectionInfoInternal(Map<String, Object> connectionInfo) {
        String direction;
        Map<String, Object> outbound = null;
        if (connectionInfo != null && (direction = (String)connectionInfo.get("com.ibm.ssl.direction")) != null && direction.length() > 0 && direction.equalsIgnoreCase("outbound")) {
            outbound = connectionInfo;
        }
        ThreadManager.getInstance().setOutboundConnectionInfoInternal(outbound);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("outboundConnectionInfo: " + outbound), (Object[])new Object[0]);
        }
    }
}

