/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jaxws.wssecurity;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.wssecurity.WSSecurityFeatureHelperService;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.store.DefaultElementValueComparator;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WSSecurityFeatureHelperService.class}, name="WSSecurityFeatureHelperService", immediate=true, property={"service.vendor=IBM"})
public class WSSecurityFeatureHelperServiceImpl
implements WSSecurityFeatureHelperService {
    public static final String CACHE_CONFIG_FILE = "ws-security.cache.config.file";
    public static final TraceComponent tc = Tr.register(WSSecurityFeatureHelperServiceImpl.class, null, null);
    static final long serialVersionUID = -409864612920344140L;

    public void handleEhcache2Mapping(String key, URL url, @Sensitive SoapMessage message) {
        this.parseehcachefile(key, url, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={Exception.class})
    private void parseehcachefile(String instanceKey, URL configfile, @Sensitive SoapMessage message) {
        CacheManager cacheManager = null;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DefaultElementValueComparator.class.getClassLoader());
            cacheManager = CacheManager.create((URL)configfile);
            CacheConfiguration cc = null;
            Configuration config = null;
            config = cacheManager.getConfiguration();
            if (config != null) {
                String cacheKey = instanceKey;
                cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(cacheKey);
            }
            if (cc == null) {
                cc = cacheManager.getConfiguration().getDefaultCacheConfiguration();
            }
            if (cc != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"success getting cache using oldconfig!!!", (Object[])new Object[0]);
                }
                this.updateMessageCacheMap(instanceKey, message, cc, config);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing the cache config file property from the message : ", (Object[])new Object[]{CACHE_CONFIG_FILE});
                }
                message.remove((Object)CACHE_CONFIG_FILE);
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cannot parse the file using the old cache apis, instancekey = " + instanceKey + ", url = " + configfile.getFile()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Exception parsing the old ehcache config format = ", (Object[])new Object[]{e.getMessage()});
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void updateMessageCacheMap(String instanceKey, @Sensitive SoapMessage message, CacheConfiguration cc, Configuration config) {
        String key = "liberty:".concat(instanceKey);
        if (cc != null) {
            HashMap<String, Object> configmap = new HashMap<String, Object>();
            configmap.put("getTimeToLiveSeconds", cc.getTimeToLiveSeconds());
            configmap.put("getTimeToIdleSeconds", cc.getTimeToIdleSeconds());
            configmap.put("getMaxEntriesLocalHeap", cc.getMaxEntriesLocalHeap());
            configmap.put("getMaxBytesLocalDisk", cc.getMaxBytesLocalDisk());
            configmap.put("isEternal", cc.isEternal());
            configmap.put("isOverflowToDisk", cc.isOverflowToDisk());
            configmap.put("getMaxElementsOnDisk", cc.getMaxElementsOnDisk());
            configmap.put("isDiskPersistent", cc.isDiskPersistent());
            configmap.put("getDiskExpiryThreadIntervalSeconds", cc.getDiskExpiryThreadIntervalSeconds());
            configmap.put("getMemoryStoreEvictionPolicy", cc.getMemoryStoreEvictionPolicy());
            String path = config.getDiskStoreConfiguration().getOriginalPath();
            if ("java.io.tmpdir".equals(path)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"updating diskstorepath, before the update = ", (Object[])new Object[]{path});
                }
                Bus bus = message.getExchange().getBus();
                path = path + File.separator + bus.getId();
                config.getDiskStoreConfiguration().setPath(path);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"updating diskstorepath, after the update = ", (Object[])new Object[]{path});
                }
            }
            configmap.put("getDiskStorePath", path);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updating message using oldconfig, key =  ", (Object[])new Object[]{key});
                Tr.debug((TraceComponent)tc, (String)"updating message using oldconfig, ttl, tti =  ", (Object[])new Object[]{configmap.get("getTimeToLiveSeconds"), configmap.get("getTimeToIdleSeconds")});
                Tr.debug((TraceComponent)tc, (String)"updating message using oldconfig, diskstorepath = ", (Object[])new Object[]{configmap.get("getDiskStorePath")});
                Tr.debug((TraceComponent)tc, (String)"updating message using oldconfig, diskelements = ", (Object[])new Object[]{configmap.get("getMaxElementsOnDisk")});
                Tr.debug((TraceComponent)tc, (String)"updating message using oldconfig, diskbytes = ", (Object[])new Object[]{configmap.get("getMaxBytesLocalDisk")});
            }
            String[] ignored = new String[]{"getDiskExpiryThreadIntervalSeconds", "getMemoryStoreEvictionPolicy", "isOverflowToDisk"};
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("using an old ehcache configuration and these properties will be ignored, " + ignored[0] + "= " + (Long)configmap.get("getDiskExpiryThreadIntervalSeconds") + ", " + ignored[1] + "= " + configmap.get("getMemoryStoreEvictionPolicy") + ", " + ignored[2] + "= " + configmap.get("isOverflowToDisk")), (Object[])new Object[0]);
            }
            message.setContextualProperty(key, configmap);
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSSecurityFeatureHelperService (impl) is activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSSecurityFeatureHelperService (impl) is deactivated", (Object[])new Object[0]);
        }
    }
}

