/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.backchannellogout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.openidconnect.server.internal.OidcServerConfigImpl;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.ssl.SSLSupport;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BackchannelLogoutRequest
implements Callable<BackchannelLogoutRequest> {
    private static TraceComponent tc = Tr.register(BackchannelLogoutRequest.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String LOGOUT_TOKEN_PARAM_NAME = "logout_token";
    private final OidcServerConfigImpl oidcServerConfig;
    private final String url;
    private final String logoutToken;
    private HttpResponse response = null;
    private final HttpUtils httpUtils = new HttpUtils();
    static final long serialVersionUID = -357293202991672271L;

    public BackchannelLogoutRequest(OidcServerConfig oidcServerConfig, String url, String logoutToken) {
        this.oidcServerConfig = (OidcServerConfigImpl)oidcServerConfig;
        this.url = url;
        this.logoutToken = logoutToken;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLogoutToken() {
        return this.logoutToken;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BackchannelLogoutRequest call() throws Exception {
        try {
            HttpClient httpClient = this.createHttpClient();
            if (httpClient == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed to create an HttpClient for back-channel logout request to " + this.url + " with logout token " + this.logoutToken), (Object[])new Object[0]);
                }
                return this;
            }
            HttpPost httpPost = this.createHttpPost();
            this.response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception httpClient) {
            void e;
            FFDCFilter.processException((Throwable)httpClient, (String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequest", (String)"80", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"ERROR_BUILDING_OR_SENDING_BACKCHANNEL_LOGOUT_REQUEST", (Object[])new Object[]{this.oidcServerConfig.getProviderId(), this.url, e});
            throw e;
        }
        return this;
    }

    HttpClient createHttpClient() {
        SSLSocketFactory sslSocketFactory = null;
        if (this.url.startsWith("https:")) {
            SSLSupport sslSupportService = this.oidcServerConfig.getSSLSupportService();
            if (sslSupportService == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SSLSupport service cannot be found", (Object[])new Object[0]);
                }
                return null;
            }
            sslSocketFactory = sslSupportService.getSSLSocketFactory();
        }
        return this.httpUtils.createHttpClient(sslSocketFactory, this.url, false);
    }

    HttpPost createHttpPost() {
        HttpPost httpPost = this.httpUtils.createHttpPostMethod(this.url, null);
        HttpEntity entity = this.getHttpEntity();
        httpPost.setEntity(entity);
        return httpPost;
    }

    private HttpEntity getHttpEntity() {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair(LOGOUT_TOKEN_PARAM_NAME, this.logoutToken));
        return new UrlEncodedFormEntity(parameters, Charset.forName("UTF-8"));
    }
}

