/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.reactive.messaging.Message;

public class AcknowledgementCoordinator {
    private final Message<?> input;
    private volatile boolean done;
    private final List<Tracker> tracked = new ArrayList<Tracker>();
    private final ReentrantLock lock = new ReentrantLock();

    public AcknowledgementCoordinator(Message<?> input) {
        this.input = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> track(Message<?> msg) {
        this.lock.lock();
        try {
            Tracker tracker = new Tracker();
            this.tracked.add(tracker);
            Message message = msg.withAck(() -> {
                this.onAck(tracker);
                return CompletableFuture.completedFuture(null);
            }).withNack(reason -> {
                this.onNack((Throwable)reason, tracker);
                return CompletableFuture.completedFuture(null);
            });
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onAck(Tracker id) {
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (this.tracked.remove(id) && this.tracked.isEmpty() && !this.done) {
                this.done = true;
                this.input.ack();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onNack(Throwable reason, Tracker id) {
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            if (this.tracked.remove(id)) {
                this.done = true;
                this.tracked.clear();
                this.input.nack(reason);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static class Tracker {
        Tracker() {
        }
    }
}

