/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest;

import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jbatch.rest.utils.WSSearchConstants;
import com.ibm.ws.jbatch.rest.utils.WSSearchObject;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.persistence.TypedQuery;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JPAQueryHelperImpl
implements IJPAQueryHelper {
    private final String BASE_QUERY = "SELECT x from JobInstanceEntity x";
    private StringBuilder query;
    private StringBuilder whereClause;
    private boolean addAND;
    StringBuilder orderClause;
    private final WSSearchObject wsso;
    private int instanceVersion = 1;
    Map<String, Object> parameterMap = new HashMap<String, Object>();
    static final long serialVersionUID = 7726449754878806088L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JPAQueryHelperImpl(WSSearchObject wsso) {
        this.wsso = wsso;
    }

    private void processParameters() {
        this.query = new StringBuilder().append("SELECT x from JobInstanceEntity x");
        this.whereClause = new StringBuilder();
        this.addAND = false;
        this.orderClause = new StringBuilder();
        this.processInstanceIdParams();
        this.processCreateTimeParams();
        this.processInstanceStateParams();
        this.processExitStatusParams();
        this.processSubmitterParams();
        this.processSecurityFilters();
        this.processLastUpdatedTimeParams();
        this.processAppNameParams();
        this.processJobNameParams();
        this.processJobParameter();
        this.processSortParams();
        if (this.whereClause.length() != 0) {
            this.query.append(" WHERE " + this.whereClause);
        }
        if (this.orderClause.length() != 0) {
            this.query.append(" ORDER BY " + this.orderClause);
        }
    }

    private void handleSQLForAND() {
        if (this.addAND) {
            this.whereClause.append(" AND ");
        }
        this.addAND = true;
    }

    private void processSortParams() {
        List<String> sortList = this.wsso.getSortList();
        if (sortList != null) {
            String delim = "";
            for (String field : sortList) {
                boolean desc = false;
                if (field.startsWith("-")) {
                    field = field.substring(1);
                    desc = true;
                }
                if (!WSSearchConstants.VALID_SORT_FIELDS.contains(field)) continue;
                this.orderClause.append(delim);
                this.orderClause.append("x." + field);
                if (desc) {
                    this.orderClause.append(" DESC");
                }
                delim = ",";
                if (!field.equals("lastUpdatedTime")) continue;
                this.instanceVersion = 2;
            }
        }
    }

    private void processLastUpdatedTimeParams() {
        if (this.wsso.getStartLastUpdatedTime() != null && this.wsso.getEndLastUpdatedTime() != null) {
            this.instanceVersion = 2;
            this.handleSQLForAND();
            this.whereClause.append("x.lastUpdatedTime BETWEEN :startLastUpdatedTime AND :endLastUpdatedTime");
            this.parameterMap.put("startLastUpdatedTime", this.wsso.getStartLastUpdatedTime());
            this.parameterMap.put("endLastUpdatedTime", this.wsso.getEndLastUpdatedTime());
        } else if (this.wsso.getSpecificLastUpdatedTime() != null) {
            this.instanceVersion = 2;
            this.handleSQLForAND();
            this.whereClause.append("x.lastUpdatedTime BETWEEN :specificLastUpdatedTimeStart AND :specificLastUpdatedTimeEnd");
            this.parameterMap.put("specificLastUpdatedTimeStart", JPAQueryHelperImpl.setDayStartForDate(this.wsso.getSpecificLastUpdatedTime()));
            this.parameterMap.put("specificLastUpdatedTimeEnd", JPAQueryHelperImpl.setDayEndForDate(this.wsso.getSpecificLastUpdatedTime()));
        } else if (this.wsso.getLessThanLastUpdatedTime() != null) {
            this.instanceVersion = 2;
            this.handleSQLForAND();
            this.whereClause.append("x.lastUpdatedTime <= :lessThanLastUpdatedTime");
            this.parameterMap.put("lessThanLastUpdatedTime", JPAQueryHelperImpl.setDayEndForDate(JPAQueryHelperImpl.subtractDaysFromCurrentDate(new Integer(this.wsso.getLessThanLastUpdatedTime()))));
        } else if (this.wsso.getGreaterThanLastUpdatedTime() != null) {
            this.instanceVersion = 2;
            this.handleSQLForAND();
            this.whereClause.append("x.lastUpdatedTime >= :greaterThanLastUpdatedTime");
            this.parameterMap.put("greaterThanLastUpdatedTime", JPAQueryHelperImpl.setDayStartForDate(JPAQueryHelperImpl.subtractDaysFromCurrentDate(new Integer(this.wsso.getGreaterThanLastUpdatedTime()))));
        }
    }

    private void processCreateTimeParams() {
        if (this.wsso.getStartCreateTime() != null && this.wsso.getEndCreateTime() != null) {
            this.handleSQLForAND();
            this.whereClause.append("x.createTime BETWEEN :startCreateTime AND :endCreateTime");
            this.parameterMap.put("startCreateTime", this.wsso.getStartCreateTime());
            this.parameterMap.put("endCreateTime", this.wsso.getEndCreateTime());
        } else if (this.wsso.getSpecificCreateTime() != null) {
            this.handleSQLForAND();
            this.whereClause.append("x.createTime BETWEEN :specificCreateTimeStart AND :specificCreateTimeEnd");
            this.parameterMap.put("specificCreateTimeStart", JPAQueryHelperImpl.setDayStartForDate(this.wsso.getSpecificCreateTime()));
            this.parameterMap.put("specificCreateTimeEnd", JPAQueryHelperImpl.setDayEndForDate(this.wsso.getSpecificCreateTime()));
        } else if (this.wsso.getLessThanCreateTime() != null) {
            this.handleSQLForAND();
            this.whereClause.append("x.createTime <= :lessThanCreateTime");
            this.parameterMap.put("lessThanCreateTime", JPAQueryHelperImpl.setDayEndForDate(JPAQueryHelperImpl.subtractDaysFromCurrentDate(new Integer(this.wsso.getLessThanCreateTime()))));
        } else if (this.wsso.getGreaterThanCreateTime() != null) {
            this.handleSQLForAND();
            this.whereClause.append("x.createTime >= :greaterThanCreateTime");
            this.parameterMap.put("greaterThanCreateTime", JPAQueryHelperImpl.setDayStartForDate(JPAQueryHelperImpl.subtractDaysFromCurrentDate(new Integer(this.wsso.getGreaterThanCreateTime()))));
        }
    }

    private void processInstanceIdParams() {
        if (this.wsso.getStartInstanceId() != -1L && this.wsso.getEndInstanceId() != -1L) {
            this.handleSQLForAND();
            this.whereClause.append("x.instanceId BETWEEN :startInstanceId AND :endInstanceId");
            this.parameterMap.put("startInstanceId", this.wsso.getStartInstanceId());
            this.parameterMap.put("endInstanceId", this.wsso.getEndInstanceId());
        } else if (this.wsso.getLessThanInstanceId() != -1L) {
            this.handleSQLForAND();
            this.whereClause.append("x.instanceId <= :lessThanInstanceId");
            this.parameterMap.put("lessThanInstanceId", this.wsso.getLessThanInstanceId());
        } else if (this.wsso.getGreaterThanInstanceId() != -1L) {
            this.handleSQLForAND();
            this.whereClause.append("x.instanceId >= :greaterThanInstanceId");
            this.parameterMap.put("greaterThanInstanceId", this.wsso.getGreaterThanInstanceId());
        } else if (this.wsso.getInstanceIdList() != null && this.wsso.getInstanceIdList().size() > 0) {
            this.handleSQLForAND();
            this.whereClause.append("x.instanceId IN :instanceIdList");
            this.parameterMap.put("instanceIdList", this.wsso.getInstanceIdList());
        }
    }

    private void processInstanceStateParams() {
        if (this.wsso.getInstanceState() != null && this.wsso.getInstanceState().size() > 0) {
            this.handleSQLForAND();
            this.whereClause.append("x.instanceState IN :instanceStateList");
            this.parameterMap.put("instanceStateList", this.wsso.getInstanceState());
        }
    }

    private void processExitStatusParams() {
        String wildcard = null;
        if (this.wsso.getExitStatusList() != null && !this.wsso.getExitStatusList().isEmpty()) {
            this.handleSQLForAND();
            this.whereClause.append("(");
            int i = 1;
            for (String status : this.wsso.getExitStatusList()) {
                if (i > 1) {
                    this.whereClause.append(" OR ");
                }
                wildcard = status.replaceAll("\\*", "%");
                this.whereClause.append(this.doIgnoreCase("x.exitStatus") + " like " + this.doIgnoreCase(":exitStatus" + i));
                this.parameterMap.put("exitStatus" + i, wildcard);
                ++i;
            }
            this.whereClause.append(")");
        }
    }

    private void processSubmitterParams() {
        if (this.wsso.getSubmitterList() != null && !this.wsso.getSubmitterList().isEmpty()) {
            this.handleSQLForAND();
            this.whereClause.append("(");
            int i = 1;
            for (String submitter : this.wsso.getSubmitterList()) {
                if (i > 1) {
                    this.whereClause.append(" OR ");
                }
                String wildcard = submitter.replaceAll("\\*", "%");
                this.whereClause.append(this.doIgnoreCase("x.submitter") + " like " + this.doIgnoreCase(":submitter" + i));
                this.parameterMap.put("submitter" + i, wildcard);
                ++i;
            }
            this.whereClause.append(")");
        }
    }

    private void processSecurityFilters() {
        if (this.wsso.getQueryIssuer() != null && this.wsso.getGroupsForGroupSecurity() != null) {
            this.handleSQLForAND();
            this.whereClause.append(" (( ");
            this.whereClause.append("x.submitter = :queryIssuer");
            this.whereClause.append(" ) OR (( ");
            this.whereClause.append("x.instanceId IN (SELECT DISTINCT v3.instanceId FROM JobInstanceEntityV3 v3 JOIN v3.groupNames g WHERE g IN :groups");
            this.whereClause.append("))))");
            this.parameterMap.put("queryIssuer", this.wsso.getQueryIssuer());
            this.parameterMap.put("groups", this.wsso.getGroupsForGroupSecurity());
        } else if (this.wsso.getQueryIssuer() != null) {
            this.handleSQLForAND();
            this.whereClause.append("x.submitter = :queryIssuer");
            this.parameterMap.put("queryIssuer", this.wsso.getQueryIssuer());
        }
    }

    private void processAppNameParams() {
        if (this.wsso.getAppNameList() != null && !this.wsso.getAppNameList().isEmpty()) {
            this.handleSQLForAND();
            this.whereClause.append("(");
            int i = 1;
            for (String appName : this.wsso.getAppNameList()) {
                String wildcard;
                if (i > 1) {
                    this.whereClause.append(" OR ");
                }
                if (!(wildcard = appName.replaceAll("\\*", "%")).contains("#")) {
                    wildcard = wildcard.concat("#%");
                }
                this.whereClause.append(this.doIgnoreCase("x.amcName") + " like " + this.doIgnoreCase(":appName" + i));
                this.parameterMap.put("appName" + i, wildcard);
                ++i;
            }
            this.whereClause.append(")");
        }
    }

    private void processJobNameParams() {
        if (this.wsso.getJobNameList() != null && !this.wsso.getJobNameList().isEmpty()) {
            this.handleSQLForAND();
            this.whereClause.append("(");
            int i = 1;
            for (String jobName : this.wsso.getJobNameList()) {
                if (i > 1) {
                    this.whereClause.append(" OR ");
                }
                String wildcard = jobName.replaceAll("\\*", "%");
                this.whereClause.append(this.doIgnoreCase("x.jobName") + " like " + this.doIgnoreCase(":jobName" + i));
                this.parameterMap.put("jobName" + i, wildcard);
                ++i;
            }
            this.whereClause.append(")");
        }
    }

    private void processJobParameter() {
        Map<String, String> jobParams = this.wsso.getJobParameters();
        if (jobParams == null || jobParams.isEmpty()) {
            return;
        }
        int i = 0;
        StringBuilder subquery1 = new StringBuilder();
        StringBuilder subquery2 = new StringBuilder();
        for (String paramName : jobParams.keySet()) {
            String paramValue = jobParams.get(paramName);
            if (paramName == null) continue;
            paramName = paramName.replaceAll("\\*", "%");
            paramValue = paramValue != null ? paramValue.replaceAll("\\*", "%") : "%";
            String queryParam = "jobParamName" + (i == 0 ? "" : Integer.valueOf(i));
            String queryValue = "jobParamValue" + (i == 0 ? "" : Integer.valueOf(i));
            if (i == 0) {
                subquery1.append("(SELECT e from JobExecutionEntityV2 e JOIN e.jobParameterElements p");
                subquery2.append(" WHERE " + this.doIgnoreCase("p.name") + " like " + this.doIgnoreCase(":" + queryParam) + " AND " + this.doIgnoreCase("p.value") + " like " + this.doIgnoreCase(":" + queryValue) + " AND e.jobInstance = x");
            } else {
                String pnum = "p" + i;
                subquery1.append(" JOIN e.jobParameterElements " + pnum);
                subquery2.append(" AND " + this.doIgnoreCase(pnum + ".name") + " like " + this.doIgnoreCase(":" + queryParam) + " AND " + this.doIgnoreCase(pnum + ".value") + " like " + this.doIgnoreCase(":" + queryValue));
            }
            this.parameterMap.put(queryParam, paramName);
            this.parameterMap.put(queryValue, paramValue);
            ++i;
        }
        this.handleSQLForAND();
        this.whereClause.append("EXISTS " + subquery1.toString() + subquery2.toString() + ")");
    }

    private static Date subtractDaysFromCurrentDate(int days) {
        Calendar cal = Calendar.getInstance();
        Date date = new Date();
        cal.setTime(date);
        cal.add(5, -days);
        return cal.getTime();
    }

    private static Date setDayEndForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        cal.set(11, 24);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis() - 1L);
    }

    private static Date setDayStartForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    public String getQuery() {
        this.processParameters();
        if (this.instanceVersion == 2) {
            return this.query.toString().replace("JobInstanceEntity", "JobInstanceEntityV2");
        }
        return this.query.toString();
    }

    public void setQueryParameters(TypedQuery<JobInstanceEntity> query) {
        for (String name : this.parameterMap.keySet()) {
            Object value = this.parameterMap.get(name);
            query.setParameter(name, value);
        }
    }

    public void setAuthSubmitter(String submitter) {
        this.wsso.setQueryIssuer(submitter);
    }

    public void setQueryIssuer(String queryIssuer) {
        this.wsso.setQueryIssuer(queryIssuer);
    }

    private String doIgnoreCase(String input) {
        if (this.wsso.getIgnoreCase()) {
            return "UPPER(" + input + ")";
        }
        return input;
    }

    public void setGroups(Set<String> groupsForSubject) {
        this.wsso.setGroupsForGroupSecurity(groupsForSubject);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.JPAQueryHelperImpl", JPAQueryHelperImpl.class, (String)"wsbatch", null);
    }
}

