/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.oauth20.AuthnContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthnContextImpl
implements AuthnContext {
    private final String accessToken;
    private String[] grantedScopes;
    private final long createdAt;
    private final long expiresIn;
    private final String userName;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Map<String, String[]> properties;
    static final long serialVersionUID = -5388395646494230028L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AuthnContextImpl(HttpServletRequest request, HttpServletResponse response, String accessToken, String[] grantedScopes, long createdAt, long expiresIn, String userName, Map<String, String[]> properties) {
        this.accessToken = accessToken;
        this.grantedScopes = Arrays.copyOf(grantedScopes, grantedScopes.length);
        this.createdAt = createdAt;
        this.expiresIn = expiresIn;
        this.userName = userName;
        this.request = request;
        this.response = response;
        this.properties = properties;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String[] getGrantedScopes() {
        if (this.grantedScopes == null) {
            return null;
        }
        return (String[])this.grantedScopes.clone();
    }

    @Override
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public Map<String, String[]> getProperties() {
        return this.properties;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.internal.AuthnContextImpl", AuthnContextImpl.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    }
}

