/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.custom;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.oauth20.store.OAuthClient;
import com.ibm.websphere.security.oauth20.store.OAuthStore;
import com.ibm.websphere.security.oauth20.store.OAuthStoreException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.error.impl.BrowserAndServerLogMessage;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator;
import com.ibm.ws.security.oauth20.util.HashSecretUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.RegistrationEndpointServices;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OauthClientStore
implements OidcOAuth20ClientProvider {
    private static TraceComponent tc = Tr.register(OauthClientStore.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private final OAuthStore oauthStore;
    private final String componentId;
    private final boolean updateXORtoHash = true;
    private String hashType = "xor";
    private final int numIterations = 2048;
    private final int keylength = 32;
    static final long serialVersionUID = 4338658427820836653L;

    public OauthClientStore(String componentId, OAuthStore oauthStore) {
        this.componentId = componentId;
        this.oauthStore = oauthStore;
    }

    public OauthClientStore(String componentId, OAuthStore oauthStore, String hashType) {
        this.componentId = componentId;
        this.oauthStore = oauthStore;
        this.hashType = hashType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Client secret hash type is " + hashType), (Object[])new Object[0]);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OidcBaseClient put(OidcBaseClient newClient) throws OidcServerException {
        OidcBaseClient returnClient = null;
        try {
            OAuthClient oauthClient = this.getOauthClient(newClient);
            this.oauthStore.create(oauthClient);
            returnClient = newClient;
        }
        catch (OAuthStoreException oauthClient) {
            void e;
            FFDCFilter.processException((Throwable)oauthClient, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"93", (Object)this, (Object[])new Object[]{newClient});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_CREATE_CLIENT", newClient.getClientId());
        }
        return returnClient;
    }

    private OAuthClient getOauthClient(OidcBaseClient client) throws OidcServerException {
        JsonObject clientMetadataAsJson = OidcOAuth20Util.getJsonObj(client);
        String clientSecret = null;
        if (this.isPBKDF2WithHmacSHA512Configured()) {
            HashSecretUtils.processMetatypeForHashInfo(clientMetadataAsJson, client.getClientId(), this.hashType, 2048, 32);
            HashSecretUtils.hashClientMetaTypeSecret(clientMetadataAsJson, client.getClientId(), true);
            clientSecret = HashSecretUtils.hashSecret(client.getClientSecret(), client.getClientId(), true, clientMetadataAsJson);
        } else if (this.isXORConfigured()) {
            String metaClientSecret;
            clientSecret = client.getClientSecret();
            if (clientSecret != null && !clientSecret.isEmpty()) {
                clientSecret = PasswordUtil.passwordEncode((String)clientSecret);
            }
            if (clientMetadataAsJson != null && clientMetadataAsJson.has("client_secret") && (metaClientSecret = clientMetadataAsJson.get("client_secret").getAsString()) != null && !metaClientSecret.isEmpty()) {
                clientMetadataAsJson.addProperty("client_secret", PasswordUtil.passwordEncode((String)metaClientSecret));
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client secret type is unknown, attempt to hash. " + this.hashType), (Object[])new Object[0]);
            }
            OAuthStoreException ie = new OAuthStoreException("Unknown hash type provided, " + this.hashType + ", the new client cannot be registered: " + client.getClientId());
            this.logMessageAndThrowOidcServerException(ie, "ERROR_PERFORMING_OAUTH_STORE_CREATE_CLIENT", client.getClientId());
        }
        String clientMetadata = clientMetadataAsJson.toString();
        return new OAuthClient(this.componentId, client.getClientId(), clientSecret, client.getClientName(), client.isEnabled(), clientMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OidcBaseClient update(OidcBaseClient newClient) throws OidcServerException {
        OidcBaseClient returnClient = null;
        try {
            OAuthClient oauthClient = this.getOauthClient(newClient);
            this.oauthStore.update(oauthClient);
            returnClient = newClient;
        }
        catch (OAuthStoreException oauthClient) {
            void e;
            FFDCFilter.processException((Throwable)oauthClient, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"142", (Object)this, (Object[])new Object[]{newClient});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_UPDATE_CLIENT", newClient.getClientId());
        }
        return returnClient;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OidcBaseClient get(String clientIdentifier) throws OidcServerException {
        OidcBaseClient client = null;
        try {
            client = this.createClient(this.oauthStore.readClient(this.componentId, clientIdentifier));
        }
        catch (OAuthStoreException oAuthStoreException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"156", (Object)this, (Object[])new Object[]{clientIdentifier});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_READ_CLIENT", clientIdentifier);
        }
        return client;
    }

    /*
     * WARNING - void declaration
     */
    private OidcBaseClient getInternal(String clientIdentifier) throws OidcServerException {
        OidcBaseClient client = null;
        try {
            client = this.createClient(this.oauthStore.readClient(this.componentId, clientIdentifier), false);
        }
        catch (OAuthStoreException oAuthStoreException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"174", (Object)this, (Object[])new Object[]{clientIdentifier});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_READ_CLIENT", clientIdentifier);
        }
        return client;
    }

    @Override
    public Collection<OidcBaseClient> getAll() throws OidcServerException {
        return this.getAll(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<OidcBaseClient> getAll(HttpServletRequest request) throws OidcServerException {
        ArrayList<OidcBaseClient> clients = new ArrayList<OidcBaseClient>();
        String attribute = "";
        try {
            Collection<OAuthClient> clientsFromStore = this.oauthStore.readAllClients(this.componentId, attribute);
            if (clientsFromStore != null) {
                for (OAuthClient element : clientsFromStore) {
                    OidcBaseClient client = this.createClient(element);
                    if (request != null) {
                        RegistrationEndpointServices.processClientRegistationUri(client, request);
                    }
                    clients.add(client);
                }
            }
        }
        catch (OAuthStoreException oAuthStoreException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"204", (Object)this, (Object[])new Object[]{request});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_READ_ALL_CLIENTS", new Object[0]);
        }
        return clients;
    }

    private OidcBaseClient createClient(OAuthClient oauthClient) {
        return this.createClient(oauthClient, true);
    }

    private OidcBaseClient createClient(OAuthClient oauthClient, boolean removeHashInfoFromMetadata) {
        OidcBaseClient client = null;
        if (oauthClient != null) {
            String secretType;
            JsonObject clientAsJson = new JsonParser().parse(oauthClient.getClientMetadata()).getAsJsonObject();
            if (removeHashInfoFromMetadata) {
                clientAsJson.remove("hash_alg");
                clientAsJson.remove("salt");
                clientAsJson.remove("hash_itr");
                clientAsJson.remove("hash_len");
            }
            client = (OidcBaseClient)OidcOAuth20Util.GSON_RAW.fromJson((JsonElement)clientAsJson, OidcBaseClient.class);
            client.setComponentId(oauthClient.getProviderId());
            client.setEnabled(oauthClient.isEnabled());
            String storedSecret = client.getClientSecret();
            if (storedSecret != null && !storedSecret.isEmpty() && ((secretType = PasswordUtil.getCryptoAlgorithm((String)storedSecret)) == null || secretType.equals("xor"))) {
                client.setClientSecret(PasswordUtil.passwordDecode((String)storedSecret));
            }
            client = OidcBaseClientValidator.getInstance(client).setDefaultsForOmitted();
        }
        return client;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean exists(String clientIdentifier) throws OidcServerException {
        boolean exists = false;
        try {
            exists = this.oauthStore.readClient(this.componentId, clientIdentifier) != null;
        }
        catch (OAuthStoreException oAuthStoreException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"251", (Object)this, (Object[])new Object[]{clientIdentifier});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_READ_CLIENT", clientIdentifier);
        }
        return exists;
    }

    @Override
    public boolean validateClient(String clientIdentifier, @Sensitive String clientSecret) throws OidcServerException {
        OidcBaseClient client;
        boolean result = false;
        if (clientSecret != null && !clientSecret.trim().isEmpty() && (client = this.getInternal(clientIdentifier)) != null && client.isConfidential()) {
            String storedSecret = client.getClientSecret();
            boolean update = true;
            String secretType = PasswordUtil.getCryptoAlgorithm((String)storedSecret);
            if (secretType != null && secretType.equals("hash")) {
                update = false;
                clientSecret = HashSecretUtils.hashSecret(clientSecret, clientIdentifier, false, client.getSalt(), client.getAlgorithm(), client.getIterations(), client.getLength());
            }
            if (storedSecret != null && storedSecret.equals(clientSecret)) {
                result = true;
                if (update && !this.isXORConfigured()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Converting client secret for " + clientIdentifier + " to hash during a validateClient request"), (Object[])new Object[0]);
                    }
                    this.update(client);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean delete(String clientIdentifier) throws OidcServerException {
        boolean deleted = false;
        try {
            this.oauthStore.deleteClient(this.componentId, clientIdentifier);
            deleted = true;
        }
        catch (OAuthStoreException oAuthStoreException) {
            void e;
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthClientStore", (String)"300", (Object)this, (Object[])new Object[]{clientIdentifier});
            this.logMessageAndThrowOidcServerException((OAuthStoreException)e, "ERROR_PERFORMING_OAUTH_STORE_DELETE_CLIENT", clientIdentifier);
        }
        return deleted;
    }

    void logMessageAndThrowOidcServerException(OAuthStoreException e, String msgKey, Object ... msgArgs) throws OidcServerException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"There was a problem invoking the OAuthStore", (Object[])new Object[]{e.getMessage(), e});
        }
        Object[] updatedMsgArgs = this.appendStringMessageToArgs(e.getLocalizedMessage(), msgArgs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
            Tr.error((TraceComponent)tc, (String)msgKey, (Object[])updatedMsgArgs);
        }
        updatedMsgArgs = this.appendStringMessageToArgs("", msgArgs);
        throw new OidcServerException(new BrowserAndServerLogMessage(tc, msgKey, updatedMsgArgs), "server_error", 500, (Throwable)e);
    }

    Object[] appendStringMessageToArgs(String additionalInsert, Object ... msgArgs) {
        Object[] updatedMsgArgs = new Object[1];
        if (msgArgs != null) {
            updatedMsgArgs = new Object[msgArgs.length + 1];
            for (int i = 0; i < msgArgs.length; ++i) {
                updatedMsgArgs[i] = msgArgs[i];
            }
        }
        updatedMsgArgs[updatedMsgArgs.length - 1] = additionalInsert;
        return updatedMsgArgs;
    }

    private boolean isPBKDF2WithHmacSHA512Configured() {
        return this.hashType.equals("PBKDF2WithHmacSHA512");
    }

    private boolean isXORConfigured() {
        return this.hashType.equals("xor");
    }
}

