/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RestClientDelegateBean
implements Bean<Object>,
PassivationCapable {
    private static final Logger LOGGER;
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_CONNECT_TIMEOUT_FORMAT = "%s/mp-rest/connectTimeout";
    public static final String REST_READ_TIMEOUT_FORMAT = "%s/mp-rest/readTimeout";
    public static final String REST_PROVIDERS = "%s/mp-rest/providers";
    public static final String REST_PROVIDERS_PRIORITY_FORMAT = "/mp-rest/providers/%s/priority";
    public static final String TRUST_STORE = "%s/mp-rest/trustStore";
    public static final String TRUST_STORE_PASSWORD = "%s/mp-rest/trustStorePassword";
    public static final String TRUST_STORE_TYPE = "%s/mp-rest/trustStoreType";
    public static final String KEY_STORE = "%s/mp-rest/keyStore";
    public static final String KEY_STORE_PASSWORD = "%s/mp-rest/keyStorePassword";
    public static final String KEY_STORE_TYPE = "%s/mp-rest/keyStoreType";
    public static final String HOSTNAME_VERIFIER = "%s/mp-rest/hostnameVerifier";
    public static final String REST_FOLLOW_REDIRECTS_FORMAT = "%s/mp-rest/followRedirects";
    public static final String REST_PROXY_ADDRESS_FORMAT = "%s/mp-rest/proxyAddress";
    public static final String QUERY_PARAM_STYLE_FORMAT = "%s/mp-rest/queryParamStyle";
    private static final String PROPERTY_PREFIX = "%s/property/";
    private final Class<?> proxyType;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final Config config;
    private final Optional<String> baseUri;
    private final Optional<String> configKey;
    static final long serialVersionUID = -2901317211254326648L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    RestClientDelegateBean(Class<?> proxyType, BeanManager beanManager, Optional<String> baseUri, Optional<String> configKey) {
        this.proxyType = proxyType;
        this.beanManager = beanManager;
        this.baseUri = baseUri;
        this.configKey = configKey;
        this.config = ConfigProvider.getConfig();
        this.scope = this.resolveScope();
    }

    public String getId() {
        return this.proxyType.getName();
    }

    public Class<?> getBeanClass() {
        return this.proxyType;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        this.configureUri(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.configureSsl(builder);
        this.configureFollowRedirects(builder);
        this.configureQueryParamStyle(builder);
        this.configureProxyAddress(builder);
        this.getConfigProperties().forEach((arg_0, arg_1) -> ((RestClientBuilder)builder).property(arg_0, arg_1));
        return builder.build(this.proxyType);
    }

    private void configureSsl(RestClientBuilder builder) {
        Optional<String> maybeTrustStore = this.getOptionalProperty(TRUST_STORE, String.class);
        maybeTrustStore.ifPresent(trustStore -> this.registerTrustStore((String)trustStore, builder));
        Optional<String> maybeKeyStore = this.getOptionalProperty(KEY_STORE, String.class);
        maybeKeyStore.ifPresent(keyStore -> this.registerKeyStore((String)keyStore, builder));
        Optional<String> maybeHostnameVerifier = this.getOptionalProperty(HOSTNAME_VERIFIER, String.class);
        maybeHostnameVerifier.ifPresent(verifier -> this.registerHostnameVerifier((String)verifier, builder));
    }

    private void registerHostnameVerifier(String verifier, RestClientBuilder builder) {
        try {
            Class<?> verifierClass = Class.forName(verifier, true, Thread.currentThread().getContextClassLoader());
            builder.hostnameVerifier((HostnameVerifier)verifierClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find hostname verifier class" + verifier, e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate hostname verifier class. Make sure it has a public, no-argument constructor", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("The provided hostname verifier " + verifier + " is not an instance of HostnameVerifier", e);
        }
    }

    private void registerKeyStore(String keyStorePath, RestClientBuilder builder) {
        Optional<String> keyStorePassword = this.getOptionalProperty(KEY_STORE_PASSWORD, String.class);
        Optional<String> keyStoreType = this.getOptionalProperty(KEY_STORE_TYPE, String.class);
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType.orElse("JKS"));
            String password = keyStorePassword.orElseThrow(() -> new IllegalArgumentException("No password provided for keystore"));
            try (InputStream input = this.locateStream(keyStorePath);){
                keyStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + keyStorePath, e);
            }
            builder.keyStore(keyStore, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + keyStorePath, e);
        }
    }

    private void registerTrustStore(String trustStorePath, RestClientBuilder builder) {
        Optional<String> maybeTrustStorePassword = this.getOptionalProperty(TRUST_STORE_PASSWORD, String.class);
        Optional<String> maybeTrustStoreType = this.getOptionalProperty(TRUST_STORE_TYPE, String.class);
        try {
            KeyStore trustStore = KeyStore.getInstance(maybeTrustStoreType.orElse("JKS"));
            String password = maybeTrustStorePassword.orElseThrow(() -> new IllegalArgumentException("No password provided for truststore"));
            try (InputStream input = this.locateStream(trustStorePath);){
                trustStore.load(input, password.toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException("Failed to initialize trust store from classpath resource " + trustStorePath, e);
            }
            builder.trustStore(trustStore);
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException("Failed to initialize trust store from " + trustStorePath, e);
        }
    }

    private InputStream locateStream(String path) throws FileNotFoundException {
        File certificateFile;
        if (path.startsWith("classpath:")) {
            path = path.replaceFirst("classpath:", "");
            InputStream resultStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resultStream == null) {
                resultStream = this.getClass().getResourceAsStream(path);
            }
            if (resultStream == null) {
                throw new IllegalArgumentException("Classpath resource " + path + " not found for MicroProfile Rest Client SSL configuration");
            }
            return resultStream;
        }
        if (path.startsWith("file:")) {
            path = path.replaceFirst("file:", "");
        }
        if (!(certificateFile = new File(path)).isFile()) {
            throw new IllegalArgumentException("Certificate file: " + path + " not found for MicroProfile Rest Client SSL configuration");
        }
        return new FileInputStream(certificateFile);
    }

    private void configureProviders(RestClientBuilder builder) {
        Optional<String> maybeProviders = this.getOptionalProperty(REST_PROVIDERS, String.class);
        maybeProviders.ifPresent(providers -> this.registerProviders(builder, (String)providers));
    }

    private void registerProviders(RestClientBuilder builder, String providersAsString) {
        Stream.of(providersAsString.split(",")).map(String::trim).map(providerName -> {
            Class<?> providerClass = this.providerClassForName((String)providerName);
            int priority = this.getConfiguredProviderPriority(providerClass);
            return new AbstractMap.SimpleEntry(providerClass, priority);
        }).forEach(entry -> builder.register((Class)entry.getKey(), ((Integer)entry.getValue()).intValue()));
    }

    private Class<?> providerClassForName(String name) {
        try {
            ClassLoader cl = null;
            if (System.getSecurityManager() != null) {
                try {
                    cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){
                        static final long serialVersionUID = 4232964687269829336L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public ClassLoader run() {
                            return Thread.currentThread().getContextClassLoader();
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.RestClientDelegateBean$1", 1.class, null, null);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Unexpected PrivilegedActionException thrown: " + e);
                }
            } else {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return Class.forName(name, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    private void configureTimeouts(RestClientBuilder builder) {
        Optional<Long> connectTimeout = this.getOptionalProperty(REST_CONNECT_TIMEOUT_FORMAT, Long.class);
        connectTimeout.ifPresent(timeout -> builder.connectTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
        Optional<Long> readTimeout = this.getOptionalProperty(REST_READ_TIMEOUT_FORMAT, Long.class);
        readTimeout.ifPresent(timeout -> builder.readTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
    }

    private void configureUri(RestClientBuilder builder) {
        Optional<String> baseUriFromConfig = this.getOptionalProperty(REST_URI_FORMAT, String.class);
        Optional<String> baseUrlFromConfig = this.getOptionalProperty(REST_URL_FORMAT, String.class);
        if (baseUriFromConfig.isPresent()) {
            builder.baseUri(RestClientDelegateBean.uriFromString(baseUriFromConfig.get()));
        } else if (baseUrlFromConfig.isPresent()) {
            builder.baseUrl(this.urlFromString(baseUrlFromConfig, baseUrlFromConfig.get()));
        } else {
            this.baseUri.ifPresent(uri -> builder.baseUri(RestClientDelegateBean.uriFromString(uri)));
        }
    }

    private <T> Optional<T> getOptionalProperty(String propertyFormat, Class<T> type) {
        Optional value = this.config.getOptionalValue(String.format(propertyFormat, this.proxyType.getName()), type);
        if (value.isPresent() || !this.configKey.isPresent()) {
            return value;
        }
        return this.config.getOptionalValue(String.format(propertyFormat, this.configKey.get()), type);
    }

    private URL urlFromString(Optional<String> baseUrlFromConfig, String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The value of URL was invalid " + baseUrlFromConfig);
        }
    }

    private static URI uriFromString(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The value of URI was invalid " + uriString);
        }
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.proxyType);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){
            static final long serialVersionUID = -449849947683573127L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.RestClientDelegateBean$2", 2.class, null, null);
            }
        });
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){
            static final long serialVersionUID = -211067122326876717L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.RestClientDelegateBean$3", 3.class, null, null);
            }
        });
        qualifiers.add((Annotation)RestClient.LITERAL);
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.proxyType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private Map<String, Integer> getConfigProperties() {
        HashMap<String, Integer> configProperties = new HashMap<String, Integer>();
        if (this.configKey.isPresent()) {
            String configKeyProperty = String.format(PROPERTY_PREFIX, this.configKey.get());
            this.getConfigProperties(configKeyProperty, configProperties);
        }
        String property = String.format(PROPERTY_PREFIX, this.proxyType.getName());
        this.getConfigProperties(property, configProperties);
        return configProperties;
    }

    private void getConfigProperties(String property, Map<String, Integer> configProperties) {
        for (String propertyName : this.config.getPropertyNames()) {
            if (!propertyName.startsWith(property)) continue;
            Integer value = (Integer)this.config.getValue(propertyName, Integer.class);
            String strippedProperty = propertyName.replace(property, "");
            configProperties.put(strippedProperty, value);
        }
    }

    private Class<? extends Annotation> resolveScope() {
        Annotation[] annotations;
        String configuredScope = this.getOptionalProperty(REST_SCOPE_FORMAT, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return Class.forName(configuredScope);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid scope: " + configuredScope, e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.proxyType.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("Ambiguous scope definition on " + this.proxyType + ": " + possibleScopes);
    }

    private void configureFollowRedirects(RestClientBuilder builder) {
        Optional<String> followRedirectsFromConfig = this.getOptionalProperty(REST_FOLLOW_REDIRECTS_FORMAT, String.class);
        if (followRedirectsFromConfig.isPresent()) {
            String followRedirects = followRedirectsFromConfig.get();
            builder.followRedirects("true".equalsIgnoreCase(followRedirects.toString()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("followRedirects set by MP Config: " + followRedirects));
            }
        }
    }

    private void configureQueryParamStyle(RestClientBuilder builder) {
        Optional<String> proxyAddressFromConfig = this.getOptionalProperty(QUERY_PARAM_STYLE_FORMAT, String.class);
        if (proxyAddressFromConfig.isPresent()) {
            String styleString = proxyAddressFromConfig.get();
            builder.queryParamStyle(QueryParamStyle.valueOf((String)styleString));
        }
    }

    private void configureProxyAddress(RestClientBuilder builder) {
        Optional<String> proxyAddressFromConfig = this.getOptionalProperty(REST_PROXY_ADDRESS_FORMAT, String.class);
        if (proxyAddressFromConfig.isPresent()) {
            String address = proxyAddressFromConfig.get();
            String[] split = address.split(":");
            if (split.length != 2) {
                throw new IllegalStateException(String.format("Invalid proxy server address configured for %s", address));
            }
            try {
                String hostname = split[0];
                int port = Integer.parseInt(split[1]);
                builder.proxyAddress(hostname, port);
            }
            catch (Throwable t) {
                throw new IllegalStateException(String.format("Invalid proxy server address configured for %s", address), t);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("proxyAddress set by MP Config: " + address));
            }
        }
    }

    private Integer getConfiguredProviderPriority(Class<?> providerClass) {
        String propertyFormat = "%s" + String.format(REST_PROVIDERS_PRIORITY_FORMAT, providerClass.getName());
        return this.getOptionalProperty(propertyFormat, Integer.class).orElse(RestClientDelegateBean.getPriorityFromClass(providerClass, 5000));
    }

    private static int getPriorityFromClass(Class<?> providerClass, int defaultValue) {
        Priority p = providerClass.getAnnotation(Priority.class);
        return p != null ? p.value() : defaultValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.microprofile.client.RestClientDelegateBean", RestClientDelegateBean.class, null, null);
        LOGGER = Logger.getLogger(RestClientDelegateBean.class);
    }
}

