/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.PkixTrustEngineConfig;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RsSamlConfigImpl
extends PkixTrustEngineConfig
implements SsoConfig {
    public static final TraceComponent tc = Tr.register(RsSamlConfigImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String KEY_ID = "id";
    public static final Object KEY_PROVIDER_ID = "id";
    public static final String KEY_SERVICE_PID = "service.pid";
    public static final String CFG_KEY_AUTH_FILTER_REF = "authFilterRef";
    public static final String KEY_clockSkew = "clockSkew";
    public static final String KEY_authnRequestTime = "authnRequestTime";
    private String providerId = null;
    private Map<String, Object> props = null;
    private volatile ConfigurationAdmin configAdmin = null;
    private HashMap<String, String> filterIdMap = null;
    static final String KEY_wantAssertionsSigned = "wantAssertionsSigned";
    static final String KEY_includeX509InSPMetadata = "includeX509InSPMetadata";
    static final String KEY_signatureMethodAlgorithm = "signatureMethodAlgorithm";
    static final String KEY_authnRequestsSigned = "authnRequestsSigned";
    static final String KEY_forceAuthn = "forceAuthn";
    static final String KEY_isPassive = "isPassive";
    static final String KEY_allowCreate = "allowCreate";
    static final String KEY_authnContextClassRef = "authnContextClassRef";
    static final String KEY_authnContextComparisonType = "authnContextComparisonType";
    static final String KEY_nameIDFormat = "nameIDFormat";
    static final String KEY_customizeNameIDFormat = "customizeNameIDFormat";
    static final String KEY_idpMetadata = "idpMetadata";
    static final String KEY_keyStoreRef = "keyStoreRef";
    static final String KEY_keyAlias = "keyAlias";
    static final String KEY_keyPassword = "keyPassword";
    static final String KEY_loginPageURL = "loginPageURL";
    static final String KEY_errorPageURL = "errorPageURL";
    static final String KEY_tokenReplayTimeout = "tokenReplayTimeout";
    static final String KEY_sessionNotOnOrAfter = "sessionNotOnOrAfter";
    static final String KEY_userIdentifier = "userIdentifier";
    static final String KEY_groupIdentifier = "groupIdentifier";
    static final String KEY_userUniqueIdentifier = "userUniqueIdentifier";
    static final String KEY_realmIdentifier = "realmIdentifier";
    static final String KEY_includeTokenInSubject = "includeTokenInSubject";
    static final String KEY_mapToUserRegistry = "mapToUserRegistry";
    static final String KEY_disableLtpaCookie = "disableLtpaCookie";
    static final String KEY_spCookieName = "spCookieName";
    static final String KEY_realmName = "realmName";
    static final String KEY_headerName = "headerName";
    static final String KEY_audiences = "audiences";
    static final String KEY_spHostAndPort = "spHostAndPort";
    static final String KEY_trustedIssuers = "trustedIssuers";
    static final String KEY_enabled = "enabled";
    static final String KEY_httpsRequired = "httpsRequired";
    static final String KEY_allowCustomCacheKey = "allowCustomCacheKey";
    static final String KEY_createSession = "createSession";
    static final String KEY_reAuthnOnAssertionExpire = "reAuthnOnAssertionExpire";
    static final String KEY_reAuthnCushion = "reAuthnCushion";
    static final String KEY_targetPageUrl = "targetPageUrl";
    static final String KEY_useRelayStateForTarget = "useRelayStateForTarget";
    static final String KEY_servletRequestLogoutPerformsSamlLogout = "spLogout";
    static final String[] notInUseAttributes = new String[]{"authnRequestsSigned", "forceAuthn", "isPassive", "allowCreate", "authnContextClassRef", "authnContextComparisonType", "nameIDFormat", "customizeNameIDFormat", "idpMetadata", "loginPageURL", "errorPageURL", "tokenReplayTimeout", "sessionNotOnOrAfter", "includeTokenInSubject", "spCookieName", "spHostAndPort", "targetPageUrl", "httpsRequired", "allowCustomCacheKey", "createSession", "reAuthnOnAssertionExpire", "reAuthnCushion"};
    static final String ignoreAttributes;
    boolean bInit = false;
    boolean enabled = true;
    ComponentContext cc = null;
    SsoSamlService parentSsoService = null;
    long clockSkewMilliSeconds = 300000L;
    String keyStoreRef = null;
    String keyAlias = null;
    String keyPassword = null;
    String signatureMethodAlgorithm = "SHA256";
    String userIdentifier = "NameID";
    String groupIdentifier = null;
    String userUniqueIdentifier = "NameID";
    String realmIdentifier = "issuer";
    boolean includeTokenInSubject = true;
    boolean httpsRequired = true;
    Constants.MapToUserRegistry mapToUserRegistry = Constants.MapToUserRegistry.No;
    boolean disableLtpaCookie = true;
    boolean wantAssertionsSigned = true;
    boolean includeX509InSPMetadata = true;
    String realmName = null;
    String headerName = null;
    String[] arrayHeaderNames = null;
    ArrayList<String> headerNames = null;
    String[] audiences = new String[]{"ANY"};
    private final String bundleLocation;
    private boolean servletRequestLogoutPerformsSamlLogout = false;
    static final long serialVersionUID = 8419036333937265075L;

    public RsSamlConfigImpl(ComponentContext cc, Map<String, Object> props, ConfigurationAdmin configAdmin, HashMap<String, String> filterIdMap, SsoSamlService parentSsoService) {
        this.parentSsoService = parentSsoService;
        this.cc = cc;
        this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
        try {
            this.setConfig(props, configAdmin, filterIdMap);
        }
        catch (SamlException samlException) {
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConfigImpl", (String)"163", (Object)this, (Object[])new Object[]{cc, props, configAdmin, filterIdMap, parentSsoService});
        }
    }

    public void setConfig(Map<String, Object> props, ConfigurationAdmin configAdmin, HashMap<String, String> filterIdMap) throws SamlException {
        this.bInit = true;
        this.providerId = (String)props.get(KEY_PROVIDER_ID);
        this.props = props;
        this.filterIdMap = filterIdMap;
        this.setConfigAdmin(configAdmin);
        this.processProps(props);
        if (this.providerId == null || this.providerId.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"SAML20_SP_ID_ATTRIBUTE_EMPTY", (Object[])new Object[0]);
        }
    }

    private void processProps(Map<String, Object> props) {
        Tr.warning((TraceComponent)tc, (String)"SAML_CONFIG_IGNORE_ATTRIBUTES", (Object[])new Object[]{"true", ignoreAttributes, this.providerId});
        this.clockSkewMilliSeconds = (Long)props.get(KEY_clockSkew);
        this.signatureMethodAlgorithm = this.trim((String)props.get(KEY_signatureMethodAlgorithm));
        this.userIdentifier = this.trim((String)props.get(KEY_userIdentifier));
        this.groupIdentifier = this.trim((String)props.get(KEY_groupIdentifier));
        this.userUniqueIdentifier = this.trim((String)props.get(KEY_userUniqueIdentifier));
        if (this.userUniqueIdentifier == null || this.userUniqueIdentifier.isEmpty()) {
            this.userUniqueIdentifier = this.userIdentifier;
        }
        this.realmIdentifier = this.trim((String)props.get(KEY_realmIdentifier));
        this.mapToUserRegistry = Constants.MapToUserRegistry.valueOf((String)props.get(KEY_mapToUserRegistry));
        this.disableLtpaCookie = (Boolean)props.get(KEY_disableLtpaCookie);
        this.wantAssertionsSigned = (Boolean)props.get(KEY_wantAssertionsSigned);
        this.includeX509InSPMetadata = (Boolean)props.get(KEY_includeX509InSPMetadata);
        this.realmName = this.trim((String)props.get(KEY_realmName));
        this.arrayHeaderNames = this.trim((String[])props.get(KEY_headerName));
        if (this.arrayHeaderNames == null || this.arrayHeaderNames.length == 0) {
            this.arrayHeaderNames = new String[]{"Saml", "saml", "SAML"};
        }
        this.headerName = this.Array2String(this.arrayHeaderNames);
        this.audiences = this.trim((String[])props.get(KEY_audiences));
        this.keyStoreRef = this.trim((String)props.get(KEY_keyStoreRef));
        this.keyAlias = this.trim((String)props.get(KEY_keyAlias));
        this.keyPassword = this.getPassword((SerializableProtectedString)props.get(KEY_keyPassword));
        this.enabled = (Boolean)props.get(KEY_enabled);
        this.servletRequestLogoutPerformsSamlLogout = (Boolean)props.get(KEY_servletRequestLogoutPerformsSamlLogout);
        this.processPkixTrustEngine(props);
        if (this.trustedIssuers == null || this.trustedIssuers.length < 1) {
            this.trustedIssuers = new String[]{"ALL_ISSUERS"};
        }
    }

    String Array2String(String[] trustedIssuers) {
        String result = "";
        for (int iI = 0; iI < trustedIssuers.length; ++iI) {
            if (iI > 0) {
                result = result.concat(", ");
            }
            result = result.concat(trustedIssuers[iI]);
        }
        return result;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    @Override
    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    @Override
    public String getUserUniqueIdentifier() {
        return this.userUniqueIdentifier;
    }

    @Override
    public String getRealmIdentifier() {
        return this.realmIdentifier;
    }

    @Override
    public Constants.MapToUserRegistry getMapToUserRegistry() {
        return this.mapToUserRegistry;
    }

    @Override
    public String toString() {
        String result = "Not initialized yet";
        if (this.bInit) {
            result = "\nconfigId:" + this.providerId + "\nuserIdentifier:" + this.userIdentifier + "\ngroupIdentifier:" + this.groupIdentifier + "\nuserUniqueIdentifier:" + this.userUniqueIdentifier + "\nrealmIdentifier:" + this.realmIdentifier + "\nincludeTokenInSubject:" + this.includeTokenInSubject + "\nmapUserIdentifierToUserRegistry:" + (Object)((Object)this.mapToUserRegistry) + "\ndisableLtpaCookie:" + this.disableLtpaCookie + "\nwantAssertionsSigned:" + this.wantAssertionsSigned + "\nrealmName:" + this.realmName + "\nheaderName:" + this.headerName + "\nclockSkew:" + this.clockSkewMilliSeconds + (this.audiences == null || this.audiences.length < 0 ? "\naudiences=null" : "\naudiences(" + this.audiences.length + "):" + this.audiences[0]) + "\nkeyStoreRef:" + this.keyStoreRef + "\nkeyAlias:" + this.keyAlias + "\nkeyPassword exists:" + (this.keyPassword != null) + "\nsignatureMethodAlgorithm:" + this.signatureMethodAlgorithm + "\nSize pkixX509List:" + this.pkixX509List.size() + "\nSize pkixCrlList:" + this.pkixCrlList.size() + "\ntrustAnchorName:" + this.trustAnchorName + "\nincludeX509InSPMetadata:" + this.includeX509InSPMetadata + "\nservletRequestLogoutPerformsSamlLogout: " + this.servletRequestLogoutPerformsSamlLogout;
        }
        return result;
    }

    @Override
    public String getSignatureMethodAlgorithm() {
        if ("SHA256".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
        if ("SHA128".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha128";
        }
        if ("SHA1".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    }

    @Override
    public boolean isDisableLtpaCookie() {
        return this.disableLtpaCookie;
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public ArrayList<String> getHeaderNames() {
        if (this.headerNames == null) {
            this.headerNames = new ArrayList();
            for (int iCnt = 0; iCnt < this.arrayHeaderNames.length; ++iCnt) {
                String nextToken = this.arrayHeaderNames[iCnt].trim();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("headerName(" + iCnt + "):" + nextToken), (Object[])new Object[0]);
                }
                this.headerNames.add(nextToken);
            }
        }
        return (ArrayList)this.headerNames.clone();
    }

    @Override
    public String getHeaderName() {
        return this.headerName;
    }

    @Override
    public long getClockSkew() {
        return this.clockSkewMilliSeconds;
    }

    @Override
    public String[] getAudiences() {
        if (this.audiences == null) {
            return new String[0];
        }
        return (String[])this.audiences.clone();
    }

    @Override
    public String getAuthFilterId() {
        if (this.props != null) {
            String authFilterRef = (String)this.props.get(CFG_KEY_AUTH_FILTER_REF);
            return this.getAuthFilterId(authFilterRef);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getAuthFilterId(String authFilterRef) {
        if (authFilterRef == null || authFilterRef.isEmpty()) {
            return null;
        }
        String id = this.filterIdMap.get(authFilterRef);
        if (id != null) {
            return id;
        }
        Configuration config = null;
        try {
            if (this.configAdmin != null) {
                config = this.configAdmin.getConfiguration(authFilterRef, null);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConfigImpl", (String)"400", (Object)this, (Object[])new Object[]{authFilterRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid authFilterRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"authFilterRef configuration", (Object[])new Object[]{config});
        }
        if (config == null) {
            return null;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return null;
        }
        id = (String)props.get(KEY_ID);
        return id;
    }

    @Override
    public AuthenticationFilter getAuthFilter(ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef) {
        String authFilterRef;
        if (this.props != null && (authFilterRef = (String)this.props.get(CFG_KEY_AUTH_FILTER_REF)) != null && !authFilterRef.isEmpty()) {
            AuthenticationFilter authnFilter;
            if (tc.isDebugEnabled()) {
                String id = this.getAuthFilterId(authFilterRef);
                Tr.debug((TraceComponent)tc, (String)(this.providerId + "> Ref:" + authFilterRef + " id:" + id), (Object[])new Object[0]);
            }
            if ((authnFilter = (AuthenticationFilter)authFilterServiceRef.getService((Object)authFilterRef)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("AuthnFilter Ref:" + authFilterRef + " points to no AuthnFilter, we accept all the requests"), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"SAML20_AUTH_FILTER_NOT_EXISTING", (Object[])new Object[]{this.getAuthFilterId(authFilterRef), this.providerId});
            }
            return authnFilter;
        }
        return null;
    }

    @Override
    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    private void processPkixTrustEngine(Map<String, Object> props) {
        try {
            super.processPkixTrustEngine(props, this.configAdmin, this.bundleLocation);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConfigImpl", (String)"461", (Object)this, (Object[])new Object[]{props});
        }
    }

    @Override
    public List<String> getPkixX509CertificateList() {
        return this.pkixX509List;
    }

    @Override
    public List<String> getPkixCrlList() {
        return this.pkixCrlList;
    }

    @Override
    public Collection<X509Certificate> getPkixTrustAnchors() {
        ArrayList<X509Certificate> pkixTrustAnchors = new ArrayList<X509Certificate>();
        try {
            this.parentSsoService.searchTrustAnchors(pkixTrustAnchors, this.trustAnchorName);
            this.addX509Certs(pkixTrustAnchors);
        }
        catch (SamlException samlException) {
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConfigImpl", (String)"485", (Object)this, (Object[])new Object[0]);
        }
        return pkixTrustAnchors;
    }

    public String getPkixTrustAnchorName() {
        return this.trustAnchorName;
    }

    @Override
    public String getKeyStoreRef() {
        return this.keyStoreRef;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    @Sensitive
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Sensitive
    String getPassword(SerializableProtectedString keyPassword) {
        if (keyPassword == null || keyPassword.isEmpty()) {
            return null;
        }
        String encoded_string = new String(keyPassword.getChars());
        return PasswordUtil.passwordDecode((String)encoded_string);
    }

    @Override
    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    @Override
    public boolean isAuthnRequestsSigned() {
        return this.unexpectedCall(false);
    }

    @Override
    public boolean isForceAuthn() {
        return this.unexpectedCall(false);
    }

    @Override
    public boolean isPassive() {
        return this.unexpectedCall(false);
    }

    @Override
    public Boolean getAllowCreate() {
        return this.unexpectedCall(false);
    }

    @Override
    public String[] getAuthnContextClassRef() {
        return this.unexpectedCall(new String[0]);
    }

    @Override
    public String getAuthnContextComparisonType() {
        return this.unexpectedCall("exact");
    }

    @Override
    public String getNameIDFormat() {
        return this.unexpectedCall(null);
    }

    @Override
    public String getIdpMetadata() {
        return this.unexpectedCall(null);
    }

    @Override
    public AcsDOMMetadataProvider getIdpMetadataProvider() {
        return this.unexpectedCall(null);
    }

    @Override
    public String getLoginPageURL() {
        return this.unexpectedCall(null);
    }

    @Override
    public String getErrorPageURL() {
        return this.unexpectedCall(null);
    }

    @Override
    public long getTokenReplayTimeout() {
        return this.unexpectedCall(1800000).intValue();
    }

    @Override
    public long getSessionNotOnOrAfter() {
        return this.unexpectedCall(0x6DDD00).intValue();
    }

    @Override
    public boolean isIncludeTokenInSubject() {
        return true;
    }

    @Override
    public String getSpCookieName(WsLocationAdmin locationAdmin) {
        return this.unexpectedCall(null);
    }

    @Override
    public boolean isPkixTrustEngineEnabled() {
        return true;
    }

    @Override
    public long getAuthnRequestTime() {
        return this.unexpectedCall(600000).intValue();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isHttpsRequired() {
        return this.unexpectedCall(false);
    }

    @Override
    public boolean isAllowCustomCacheKey() {
        return false;
    }

    @Override
    public String getSpHostAndPort() {
        return this.unexpectedCall(null);
    }

    @Override
    public boolean createSession() {
        return this.unexpectedCall(true);
    }

    @Override
    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        if (this.props != null && tc.isDebugEnabled()) {
            String authFilterRef = (String)this.props.get(CFG_KEY_AUTH_FILTER_REF);
            Tr.debug((TraceComponent)tc, (String)(this.providerId + "> saml AuthenticationFilter Ref:" + authFilterRef + " id:" + this.getAuthFilterId(authFilterRef)), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isReAuthnOnAssertionExpire() {
        return this.unexpectedCall(false);
    }

    @Override
    public long getReAuthnCushion() {
        return this.unexpectedCall(0L);
    }

    @Override
    public String getTargetPageUrl() {
        return null;
    }

    @Override
    public boolean isIncludeX509InSPMetadata() {
        return this.includeX509InSPMetadata;
    }

    @Override
    public boolean getUseRelayStateForTarget() {
        return this.unexpectedCall(true);
    }

    @Override
    public String getPostLogoutRedirectUrl() {
        return null;
    }

    @Override
    public boolean isServletRequestLogoutPerformsSamlLogout() {
        return this.servletRequestLogoutPerformsSamlLogout;
    }

    @Override
    public boolean isDisableInitialRequestCookie() {
        return this.unexpectedCall(false);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        String tmpStr = notInUseAttributes[0];
        for (int iI = 1; iI < notInUseAttributes.length; ++iI) {
            tmpStr = tmpStr.concat(", ").concat(notInUseAttributes[iI]);
        }
        ignoreAttributes = tmpStr;
    }
}

