/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class OAuthUtil {
    private static TraceComponent tc = Tr.register(OAuthUtil.class);
    static final String JCEPROVIDER_IBM = "IBMJCE";
    static final String SECRANDOM_IBM = "IBMSecureRandom";
    static final String SECRANDOM_SHA1PRNG = "SHA1PRNG";
    static final String UTF_ENCODING = "UTF-8";
    private static final List<String> sensitives = Arrays.asList("client_secret", "sharedKey");

    @Sensitive
    public static String getValueFromMap(String key, Map<String, String[]> m) {
        String result = null;
        String[] values = m.get(key);
        if (values != null && values.length > 0) {
            result = values[0];
        }
        if (tc.isDebugEnabled()) {
            if (sensitives.contains(key)) {
                if (result != null) {
                    Tr.debug((TraceComponent)tc, (String)("getValueFromMap(" + key + ") returns [*****]"), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("getValueFromMap(" + key + ") returns [null]"), (Object[])new Object[0]);
                }
            } else {
                Tr.debug((TraceComponent)tc, (String)("getValueFromMap(" + key + ") returns [" + result + "]"), (Object[])new Object[0]);
            }
        }
        return result;
    }

    public static String arrayToSpaceString(String[] array) {
        StringBuffer result = new StringBuffer();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                result.append(array[i]);
                if (i >= array.length - 1) continue;
                result.append(" ");
            }
        }
        return result.toString();
    }

    @Sensitive
    public static String getRandom(int length) {
        StringBuffer result = new StringBuffer(length);
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        Random r = OAuthUtil.getRandom();
        for (int i = 0; i < length; ++i) {
            int n = r.nextInt(62);
            result.append(chars[n]);
        }
        String retVal = result.toString();
        return retVal;
    }

    @FFDCIgnore(value={Exception.class})
    static Random getRandom() {
        SecureRandom result = null;
        try {
            result = Security.getProvider(JCEPROVIDER_IBM) != null ? SecureRandom.getInstance(SECRANDOM_IBM) : SecureRandom.getInstance(SECRANDOM_SHA1PRNG);
        }
        catch (Exception e) {
            result = new SecureRandom();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRandom() returns [" + result.getClass().getName() + "]"), (Object[])new Object[0]);
        }
        return result;
    }

    public static String generateUUID() {
        String retVal = UUID.randomUUID().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("generateUUID returns [" + retVal + "]"), (Object[])new Object[0]);
        }
        return retVal;
    }

    public static boolean validateUri(String strUri) {
        boolean valid = false;
        try {
            URI uri;
            if (strUri != null && (uri = new URI(strUri)).isAbsolute()) {
                valid = true;
            }
        }
        catch (URISyntaxException e) {
            valid = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validateUri(" + strUri + ") returns [" + valid + "]"), (Object[])new Object[0]);
        }
        return valid;
    }

    public static String stripQueryAndFragment(String uri) {
        String result = uri;
        if (OAuthUtil.validateUri(uri)) {
            int hash;
            int query = result.indexOf("?");
            if (query != -1) {
                result = result.substring(0, query);
            }
            if ((hash = result.indexOf("#")) != -1) {
                result = result.substring(0, hash);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stripQueryAndFragment(" + uri + ") returns [" + result + "]"), (Object[])new Object[0]);
        }
        return result;
    }

    public static String getQuery(String uri) {
        String result = uri;
        try {
            URI u = new URI(uri);
            result = u.getQuery();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getQuery(" + uri + ") returns [" + result + "]"), (Object[])new Object[0]);
        }
        return result;
    }

    public static String encodeQuery(String query) {
        String[] queryParams;
        if (query == null) {
            return null;
        }
        StringBuilder rebuiltQuery = new StringBuilder();
        for (String param : queryParams = query.split("&")) {
            try {
                String rebuiltParam = URLEncoder.encode(param, UTF_ENCODING);
                int equalIndex = param.indexOf("=");
                if (equalIndex > -1) {
                    String name = param.substring(0, equalIndex);
                    String value = equalIndex < param.length() - 1 ? param.substring(equalIndex + 1) : "";
                    rebuiltParam = URLEncoder.encode(name, UTF_ENCODING) + "=" + URLEncoder.encode(value, UTF_ENCODING);
                }
                if (rebuiltParam.isEmpty()) continue;
                rebuiltQuery.append(rebuiltParam + "&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (rebuiltQuery.length() > 0 && rebuiltQuery.charAt(rebuiltQuery.length() - 1) == '&') {
            rebuiltQuery.deleteCharAt(rebuiltQuery.length() - 1);
        }
        String retVal = rebuiltQuery.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("encodeQuery(" + query + ") returns [" + retVal + "]"), (Object[])new Object[0]);
        }
        return retVal;
    }

    public static String getCurrentStackTraceString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }
}

