/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersHeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.AcceptLanguageHeader;

public class AcceptLanguageHeaderImpl
extends ParametersHeaderImpl
implements AcceptLanguageHeader {
    private static final long serialVersionUID = -7865142737583561937L;
    private float m_qValue = -1.0f;
    private String m_langRange;

    @Override
    public void setQValue(float qValue) throws SipParseException {
        if ((double)qValue < 0.0) {
            throw new SipParseException("AcceptLangHeader: Q Value < 0", "");
        }
        if ((double)qValue > 1.0) {
            throw new SipParseException("AcceptLangHeader: Q value > 1.0", "");
        }
        this.m_qValue = qValue;
    }

    @Override
    public float getQValue() {
        return this.m_qValue;
    }

    @Override
    public boolean hasQValue() {
        return this.m_qValue != -1.0f;
    }

    @Override
    public void removeQValue() {
        this.m_qValue = -1.0f;
    }

    @Override
    public void setLanguageRange(String languageRange) throws IllegalArgumentException, SipParseException {
        if (languageRange == null) {
            throw new IllegalArgumentException("AcceptLang: null arg");
        }
        this.m_langRange = languageRange;
    }

    @Override
    public String getLanguageRange() {
        return this.m_langRange;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        String language = parser.nextToken(';');
        this.setLanguageRange(language);
        if (parser.LA(1) == ';') {
            parser.match(';');
            parser.lws();
            parser.match('q');
            parser.match('=');
            String qValue = parser.nextToken(';');
            this.setQValue(Float.parseFloat(qValue));
        }
        super.parseValue(parser);
    }

    @Override
    protected void encodeValue(CharsBuffer buffer) {
        if (this.m_langRange != null) {
            buffer.append(this.m_langRange);
        }
        if (this.hasQValue()) {
            buffer.append(';');
            buffer.append("q");
            buffer.append('=');
            buffer.append(this.m_qValue);
        }
        super.encodeValue(buffer);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof AcceptLanguageHeaderImpl)) {
            return false;
        }
        AcceptLanguageHeaderImpl o = (AcceptLanguageHeaderImpl)other;
        if (this.m_qValue != o.m_qValue) {
            return false;
        }
        if (this.m_langRange == null || this.m_langRange.length() == 0) {
            return o.m_langRange == null || o.m_langRange.length() == 0;
        }
        if (o.m_langRange == null || o.m_langRange.length() == 0) {
            return false;
        }
        return this.m_langRange.equals(o.m_langRange);
    }

    @Override
    public String getName() {
        return "Accept-Language";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    protected char getListSeparator() {
        return ';';
    }

    @Override
    protected char getParamSeparator() {
        return ';';
    }
}

