/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.chfw;

import com.ibm.ws.sip.channel.resolver.dns.impl.chfw.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.chfw.ResourceRecord;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class NAPTRRecord
extends ResourceRecord {
    private short _order;
    private short _preference;
    private String _flags;
    private String _service;
    private String _regexp;
    private Name _replacement;

    protected NAPTRRecord() {
        this._order = 0;
        this._preference = 0;
        this._flags = new String();
        this._service = new String();
        this._regexp = new String();
        this._replacement = null;
    }

    protected NAPTRRecord(WsByteBuffer buffer) {
        super(buffer);
        this._order = buffer.getShort();
        this._preference = buffer.getShort();
        byte length = buffer.get();
        byte[] b = new byte[length];
        buffer.get(b);
        this._flags = new String(b);
        length = buffer.get();
        b = new byte[length];
        buffer.get(b);
        this._service = new String(b);
        length = buffer.get();
        b = new byte[length];
        buffer.get(b);
        this._regexp = new String(b);
        this._replacement = new Name(buffer);
    }

    @Override
    protected void toBuffer(WsByteBuffer buffer) {
        super.toBuffer(buffer);
        buffer.putShort(this._order);
        buffer.putShort(this._preference);
        buffer.put((byte)this._flags.length());
        buffer.putString(this._flags);
        buffer.put((byte)this._service.length());
        buffer.putString(this._service);
        buffer.put((byte)this._regexp.length());
        buffer.putString(this._regexp);
        this._replacement.toBuffer(buffer);
    }

    public void setOrder(short s) {
        this._order = s;
    }

    public Short getOrder() {
        return this._order;
    }

    public void setPreference(short s) {
        this._preference = s;
    }

    public Short getPreference() {
        return this._preference;
    }

    public void setFlags(String s) {
        this._flags = s;
    }

    public void setService(String s) {
        this._service = s;
    }

    public String getService() {
        return this._service;
    }

    public void setRegexp(String s) {
        this._regexp = s;
    }

    public void setReplacement(Name name) {
        this._replacement = name;
    }

    public Name getReplacement() {
        return this._replacement;
    }

    public short calcrdLength() {
        int length = 0;
        length = 5 + this._flags.length() + 1 + this._service.length() + 1 + this._regexp.length() + this._replacement.length();
        return (short)length;
    }

    @Override
    public String toString() {
        String s = new String();
        s = s + super.toString();
        s = s + "        order: " + new Short(this._order).toString() + "\n        preference: " + new Short(this._preference).toString() + "\n        flags: " + this._flags.toString() + "\n        service: " + this._service.toString() + "\n        regexp: " + this._regexp.toString() + "\n        replacement: " + this._replacement.toString() + "\n";
        return s;
    }
}

