/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.dns.impl.netty;

import io.netty.buffer.ByteBuf;

public class Name {
    private String _name;
    private String[] _nameArray;
    private static int MAX_NUMBER_LABELS = 255;

    public Name(String name) {
        this._name = name;
    }

    protected Name(ByteBuf buffer) {
        int labels = 0;
        StringBuffer stringBuffer = new StringBuffer(1024);
        this._nameArray = new String[MAX_NUMBER_LABELS];
        this.readLabel(buffer, labels);
        int i = 0;
        while (this._nameArray[i] != null) {
            String s = this._nameArray[i];
            stringBuffer.append(s + ".");
            ++i;
        }
        this._name = stringBuffer.toString();
    }

    private void readLabel(ByteBuf buffer, int labels) {
        byte length = 0;
        while ((length = buffer.readByte()) != 0) {
            int current = buffer.readerIndex();
            if (this.compressionCheck(buffer, length)) {
                this.readLabel(buffer, labels);
                buffer.readerIndex(current + 1);
                break;
            }
            byte[] b = new byte[length];
            buffer.readBytes(b);
            this._nameArray[labels++] = new String(b);
        }
    }

    private boolean compressionCheck(ByteBuf buffer, byte curByte) {
        int MASK = -64;
        int offset = 0;
        if ((curByte & 0xFFFFFFC0) == -64) {
            byte nextByte = buffer.readByte();
            offset |= (curByte & 0x3F) << 8;
            buffer.readerIndex(offset |= nextByte & 0xFF);
            return true;
        }
        return false;
    }

    protected void toBuffer(ByteBuf buffer) {
        if (this._name.equals("")) {
            buffer.writeByte(0);
            return;
        }
        String[] sa = this._name.split("\\.");
        for (int i = 0; i < sa.length; ++i) {
            buffer.writeByte((int)((byte)sa[i].length()));
            buffer.writeBytes(sa[i].getBytes());
        }
        buffer.writeByte(0);
    }

    public String getString() {
        return this._name;
    }

    protected short length() {
        int length = 0;
        String[] sa = this._name.split("\\.");
        for (int i = 0; i < sa.length; ++i) {
            length += 1 + sa[i].length();
        }
        return (short)(++length);
    }

    public String toString() {
        return this._name.toString();
    }
}

