/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ReasonHeaderImpl;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.proxy.BranchManager;
import com.ibm.ws.sip.container.proxy.ProxyBranchTimer;
import com.ibm.ws.sip.container.proxy.ProxyParent;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.proxy.StatefullProxy;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.transaction.ClientTransactionListener;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.ContactHeader;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class ProxyBranchImpl
extends BranchManager
implements ClientTransactionListener,
ProxyBranch {
    private static final LogMgr c_logger = Log.get(ProxyBranchImpl.class);
    private static final int PB_STATE_INIT = 0;
    private static final int PB_STATE_SENT = 1;
    private static final int PB_STATE_TRYING = 2;
    private static final int PB_STATE_TIMED_OUT = 3;
    private static final int PB_STATE_COMPLETED = 4;
    private static final int PB_STATE_CANCEL_PENDING = 5;
    private static final int PB_STATE_CANCELED = 6;
    private static final int PB_STATE_REDIRECTING_REQUEST = 7;
    private static final int PB_STATE_FAILED_T0_BE_SENT = 8;
    private URI _uri;
    private int _state = 0;
    private SipServletRequestImpl _request;
    private SipURL _latestDestination;
    private int _proxyBranchTimeOut = 180;
    private boolean _isCancelled;
    protected StatefullProxy _proxy;
    protected ProxyParent _parent;
    private SipServletResponseImpl _lastResponse;
    private boolean _isStarted = false;
    private boolean _appPath = false;
    ProxyBranchTimer _timer = null;
    boolean _shouldStartTimer = false;
    private boolean _isVirtual = false;
    private int _latestFinalResponseStatus = -1;
    private ArrayList<TransactionUserWrapper> relatedTUs = new ArrayList();
    public boolean _someTUAlredyRelatedToThisBranch = false;
    public TransactionUserWrapper _mainAssociatedTu = null;
    public boolean _amIRecurseBranch = false;
    boolean _removedFromOrigTU = false;

    public ProxyBranchImpl(URI uri, BranchManager parent, StatefullProxy proxyMgr, boolean createdByProxyTo, boolean isVirtual) {
        super((SipServletRequestImpl)proxyMgr.getOriginalRequest(), proxyMgr);
        this._uri = uri;
        if (uri != null) {
            this._uri = uri.clone();
        }
        this._parent = parent;
        this._proxy = proxyMgr;
        this._isStarted = createdByProxyTo;
        this._appPath = proxyMgr.getAddToPath();
        this._isVirtual = isVirtual;
        SipServletRequestImpl request = (SipServletRequestImpl)this._proxy.getOriginalRequest();
        SipServletDesc siplet = request.getTransactionUser().getSipServletDesc();
        if (this._originalReq.getTransactionUser().isRelatedToBranch()) {
            this._originalReq.getTransactionUser().addExtraTransaction();
        } else {
            this.relateTU(this._originalReq.getTransactionUser());
        }
        if (!isVirtual) {
            this._request = ProxyBranchImpl.createOutgoingRequest(this._originalReq);
            this._request.setRequestURI(uri);
            ((OutgoingSipServletRequest)this._request).setProxy(proxyMgr);
            this._request.setTransactionUser(this._originalReq.getTransactionUser());
        }
        if (siplet != null) {
            this._proxyBranchTimeOut = siplet.getSipApp().getProxyTimeout();
        }
        this.setRecordRoute(proxyMgr.getRecordRoute());
        this._preferedOutBoundIfaceIdxUDP = proxyMgr.getPreferedOutboundIface("udp");
        this._preferedOutBoundIfaceIdxTCP = proxyMgr.getPreferedOutboundIface("tcp");
        this._preferedOutBoundIfaceIdxTLS = proxyMgr.getPreferedOutboundIface("tls");
        if (proxyMgr.getRecordRoute()) {
            this._recordRouteURI = proxyMgr.getRecordRouteURI();
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.getMyInfo());
            buff.append("New ProxyBranch created:");
            buff.append(" uri = ");
            buff.append(this._uri);
            buff.append(" parent = ");
            buff.append(this._parent);
            buff.append(" isStarted = ");
            buff.append(this._isStarted);
            buff.append(" appPath = ");
            buff.append(this._appPath);
            buff.append(" ");
            c_logger.traceDebug(this, "ProxyBranchImpl", buff.toString());
        }
    }

    public Iterator<TransactionUserWrapper> getRelatedTUs() {
        return Collections.unmodifiableList(this.relatedTUs).iterator();
    }

    public void relateTU(TransactionUserWrapper tu) {
        this.relatedTUs.remove(tu);
        this.relatedTUs.add(tu);
        if (this._request != null) {
            this._request.setTransactionUser(tu);
        }
        tu.setBranch(this);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "relateTU", "Relating TU= " + tu + " to branch= " + this + ". Current related TUs count to this branch=" + this.relatedTUs.size());
        }
    }

    public void unrelateTU(TransactionUserWrapper tu) {
        this.relatedTUs.remove(tu);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "unrelateTU", "Unrelating TU= " + tu + " from branch= " + this + ". Current related TUs count to this branch=" + this.relatedTUs.size());
        }
    }

    public boolean hasAnyTUGotFinalResponse() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "hasAnyTUGotFinalResponse", (Object)("Related TU number=" + this.relatedTUs.size()));
        }
        boolean result = false;
        for (TransactionUserWrapper tu : this.relatedTUs) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "hasAnyTUGotFinalResponse", "checking for " + tu);
            }
            if (!tu.isProxyReceivedFinalResponse()) continue;
            result = true;
            break;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "hasAnyTUGotFinalResponse", new Boolean(result));
        }
        return result;
    }

    public void incrementTransactionCounters() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "incrementTransactionCounters", (Object)("Related TU number=" + this.relatedTUs.size()));
        }
        for (TransactionUserWrapper tu : this.relatedTUs) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "incrementTransactionCounters", "Incrementing transaction count for " + tu);
            }
            tu.incrementTransactions();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "incrementTransactionCounters");
        }
    }

    public void decrementTransactionCounters() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "decrementTransactionCounters", (Object)("Related TU number=" + this.relatedTUs.size()));
        }
        for (TransactionUserWrapper tu : this.relatedTUs) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "decrementTransactionCounters", "Decrementing transaction count for " + tu);
            }
            tu.decrementTransactions();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "decrementTransactionCounters");
        }
    }

    public void continueAndSend() throws IOException {
        this.proxy((OutgoingSipServletRequest)this._request, this._uri, this);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "continueAndSend", this.getMyInfo() + " ProxyBranch will expired in " + this._proxyBranchTimeOut + "seconds");
        }
    }

    public boolean isActive() {
        if (!this.isInitial()) {
            return false;
        }
        return this._state == 0 || this._state == 1 || this._state == 7 || this._state == 2;
    }

    public boolean isRetransmission() {
        if (!this.isInitial()) {
            return false;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isRetransmission", "branch state: " + this._state);
        }
        return this._state == 0 || this._state == 1 || this._state == 7 || this._state == 2 || this._state == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(SipServletResponseImpl response) {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getMyInfo());
            buffer.append("response is ");
            buffer.append(response.getStatus());
            buffer.append(response.getReasonPhrase());
            c_logger.traceDebug(this, "processResponse", buffer.toString());
        }
        this.updateStatusFromLastResponse(response);
        this._lastResponse = response;
        int status = response.getStatus();
        if (response.getRequest().isInitial() && status >= 200 && ((SipServletRequestImpl)response.getRequest()).isJSR289Application()) {
            response.setIsCommited(false);
            this.associateResponseWithSipSession(response, this);
            if (this.treat2xx6xxAsBestResponse(response.getStatus())) {
                this.notifyIntermediateBranchResponse(response);
            }
        }
        if (!response.getMethod().equals("CANCEL")) {
            if (status < 200) {
                ProxyBranchImpl proxyBranchImpl = this;
                synchronized (proxyBranchImpl) {
                    if (this._state == 5) {
                        this._state = 6;
                        ProxyBranchImpl.cancelRequest(this._request, this, null);
                    } else {
                        this._state = 2;
                        if (this._shouldStartTimer) {
                            this.setupProxyBranchTimer();
                        }
                    }
                }
                this._parent.process1xxResponse(response, this);
            } else if (status >= 300 && status < 400) {
                if (this._isRecurse) {
                    this._state = 7;
                    this.redirectResponse(response);
                    return;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processResponse", this.getMyInfo() + "ProxyBranch is not in recurse mode");
                }
                this._state = 4;
                this._parent.processResponse(this, response);
            } else {
                this.updateBestResponse(this._lastResponse, this);
                this.allBranchesCompleted();
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processResponse", this.getMyInfo() + "Received response to CANCEL request: " + response.getStatus());
        }
    }

    private void updateStatusFromLastResponse(SipServletResponse response) {
        int status = response.getStatus();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "updateStatusFromLatestResponse", "received status= " + status);
        }
        if (status > 199) {
            this._latestFinalResponseStatus = status;
        }
    }

    public int getLatestFinalResponseStatus() {
        return this._latestFinalResponseStatus;
    }

    protected void notifyIntermediateBranchResponse(SipServletResponseImpl response) {
        StatefullProxy root = null;
        ProxyParent node = this;
        do {
            if (!(node instanceof StatefullProxy)) continue;
            root = (StatefullProxy)node;
            break;
        } while ((node = node.getParent()) != null);
        if (root == null) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("error.exception", null, null, (Throwable)new RuntimeException("no root"));
            }
        } else if (root.getSupervised()) {
            TransactionUserWrapper tu = response.getTransactionUser();
            if (tu == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "notifyIntermediateBranchResponse", "no transaction user");
                }
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "notifyIntermediateBranchResponse", "invoking intermediate branch response notification");
                }
                response.setIsBranchResponse(this);
                tu.sendResponseToApplication(response, null);
                response.setIsBranchResponse(null);
            }
        }
    }

    private void setupProxyBranchTimer() {
        if (this._timer != null && !this._timer.isCancelled()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setupProxyBranchTimer", this.getMyInfo() + "Warning. Timer is active.");
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setupProxyBranchTimer", this.getMyInfo());
            }
            this._timer = new ProxyBranchTimer(this);
            SipContainerComponent.getTimerService().schedule(this._timer, false, this._proxyBranchTimeOut * 1000);
            this._shouldStartTimer = false;
        }
    }

    @Override
    public void process1xxResponse(SipServletResponse response, ProxyBranchImpl branch) {
        this._parent.process1xxResponse(response, branch);
    }

    @Override
    public void processResponse(ProxyBranchImpl branch, SipServletResponse response) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processResponse", this.getMyInfo() + "Response from child branch = " + branch + " response " + response);
        }
        this.updateStatusFromLastResponse(response);
        int status = response.getStatus();
        if (status < 200) {
            if (status != 100) {
                this._parent.process1xxResponse(response, branch);
            }
            return;
        }
        if (this.isFinalResponse(status)) {
            this.updateBestResponse(response, this);
            this.cancel();
            this.cancelProxyBranchTimer();
            this.allBranchesCompleted();
            return;
        }
        if (!this._proxy.getParallel()) {
            this.cancelProxyBranchTimer();
        }
        if (branch.isCompleted()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processResponse", this.getMyInfo() + "This branch is completed");
            }
            this.branchCompleted(branch, response);
        }
    }

    private void cancelProxyBranchTimer() {
        if (this._timer != null && !this._timer.isCancelled()) {
            this._timer.cancel();
            this._timer = null;
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "cancelProxyBranchTimer", this.getMyInfo() + "Timer is null or cancelled = " + this._timer);
        }
    }

    protected void redirectResponse(SipServletResponse response) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "redirectResponse", this.getMyInfo() + " response = " + response);
        }
        ContactHeader contact = null;
        List<ContactHeader> contacts = this.getContacts(response);
        if (contacts.size() > 0) {
            SipServletsFactoryImpl factory = SipServletsFactoryImpl.getInstance();
            for (int j = 0; j < contacts.size(); ++j) {
                contact = contacts.get(j);
                URI uri = factory.generateURI(contact.getNameAddress().getAddress());
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "redirectResponse", this.getMyInfo() + "Adding Contact: " + contact);
                }
                this.removeHandledContactFromResponse(response, contact);
                if (this.proxyBranchExists(uri)) continue;
                this.createBranch(uri, true, this._proxy);
            }
            this.send();
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "redirectResponse", "No Contacts to redirect");
            }
            this.updateBestResponse(this._request, 403, this);
            this.allBranchesCompleted();
        }
    }

    private void removeHandledContactFromResponse(SipServletResponse response, ContactHeader contact) {
        Message jainResponse = ((SipServletResponseImpl)response).getMessage();
        HeaderIterator itr = jainResponse.getHeaders("Contact");
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            try {
                if (!itr.next().equals(contact)) continue;
                itr.remove();
                break;
            }
            catch (Exception e2) {
            }
        }
    }

    private List<ContactHeader> getContacts(SipServletResponse response) {
        Response jainResponse = ((SipServletResponseImpl)response).getResponse();
        HeaderIterator hIter = jainResponse.getContactHeaders();
        ArrayList<ContactHeader> contacts = new ArrayList<ContactHeader>(3);
        ContactHeader contact = null;
        while (hIter.hasNext()) {
            try {
                contact = (ContactHeader)hIter.next();
                for (int j = 0; j < contacts.size(); ++j) {
                    float otherQValue;
                    float currentQValue = contact.getQValue();
                    if (currentQValue < 0.0f) {
                        currentQValue = 1.0f;
                    }
                    if ((otherQValue = ((ContactHeader)contacts.get(j)).getQValue()) < 0.0f) {
                        otherQValue = 1.0f;
                    }
                    if (!(currentQValue > otherQValue)) continue;
                    contacts.add(j, contact);
                    contact = null;
                    break;
                }
                if (contact == null) continue;
                contacts.add(contact);
            }
            catch (HeaderParseException e2) {
                ProxyBranchImpl.logException(e2);
            }
            catch (NoSuchElementException e3) {
                ProxyBranchImpl.logException(e3);
            }
        }
        return contacts;
    }

    @Override
    public void processTimeout(SipServletRequestImpl request) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processTimeout", this.getMyInfo() + "request is " + request.getMethod());
        }
        if (request.getMethod().equals(this._request.getMethod())) {
            this.executeTimeOut(true);
        } else {
            IncomingSipServletResponse response = this.generateResponse(request, 408);
            this.processResponse(this, response);
        }
    }

    @Override
    public void processCompositionError(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "processCompositionError");
        }
        this._state = 8;
        this.updateBestResponse(request, 500, this);
        this.allBranchesCompleted();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processCompositionError");
        }
    }

    @Override
    public boolean onSendingRequest(SipServletRequestImpl request) {
        this.setupTimeOut();
        this._state = 1;
        this._parent.onSendingRequest(this, request);
        return true;
    }

    @Override
    SipServletRequest getRequestForInternalUse() {
        return this._request;
    }

    public boolean waitingForResponse() {
        return 0 != this._state && 4 != this._state && 3 != this._state && 5 != this._state && 6 != this._state && 8 != this._state;
    }

    public boolean isCompleted() {
        return !this.waitingForResponse();
    }

    @Override
    public void cancel() {
        this.cancel(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(String[] protocol, int[] reasonCode, String[] reasonText) {
        if (c_logger.isTraceDebugEnabled()) {
            Object[] params = new Object[]{protocol, reasonCode, reasonText, this.getMyInfo()};
            c_logger.traceEntry((Object)this, "cancel", params);
        }
        if (this._isCancelled) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "cancel", this.getMyInfo() + "already cancelled");
            }
            return;
        }
        this.cancelProxyBranchTimer();
        ProxyBranchImpl proxyBranchImpl = this;
        synchronized (proxyBranchImpl) {
            switch (this._state) {
                case 7: {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "cancel", this.getMyInfo() + "This proxy is in recurse mode - cancel all branches");
                    }
                    for (int i = 0; i < this._proxyBranches.size(); ++i) {
                        ProxyBranchImpl branch = (ProxyBranchImpl)this._proxyBranches.get(i);
                        if (!branch.isActive()) continue;
                        branch.cancel(protocol, reasonCode, reasonText);
                    }
                    break;
                }
                case 2: {
                    Vector<ReasonHeaderImpl> reasons = null;
                    if (protocol != null) {
                        reasons = new Vector<ReasonHeaderImpl>(protocol.length);
                        for (int i = 0; i < protocol.length; ++i) {
                            try {
                                ReasonHeaderImpl reason = new ReasonHeaderImpl(protocol[i], reasonCode[i], reasonText[i]);
                                reasons.add(reason);
                                continue;
                            }
                            catch (SipParseException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    this._state = 6;
                    ProxyBranchImpl.cancelRequest(this._request, this, reasons);
                    break;
                }
                case 0: 
                case 1: {
                    this._state = 5;
                    break;
                }
            }
        }
        this._isCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void cancel(String[] origReasons) {
        if (ProxyBranchImpl.c_logger.isTraceDebugEnabled()) {
            params = new Object[]{origReasons, this.getMyInfo()};
            ProxyBranchImpl.c_logger.traceEntry((Object)this, "cancel", params);
        }
        if (this._isCancelled) {
            if (ProxyBranchImpl.c_logger.isTraceDebugEnabled()) {
                ProxyBranchImpl.c_logger.traceDebug(this, "cancel", this.getMyInfo() + "already cancelled");
            }
            return;
        }
        this.cancelProxyBranchTimer();
        var2_2 = this;
        synchronized (var2_2) {
            switch (this._state) {
                case 7: {
                    if (ProxyBranchImpl.c_logger.isTraceDebugEnabled()) {
                        ProxyBranchImpl.c_logger.traceDebug(this, "cancel", this.getMyInfo() + "This proxy is in recurse mode - cancel all branches");
                    }
                    for (i = 0; i < this._proxyBranches.size(); ++i) {
                        branch = (ProxyBranchImpl)this._proxyBranches.get(i);
                        if (!branch.isActive()) continue;
                        branch.cancel(origReasons);
                    }
                    break;
                }
                case 2: {
                    reasons = null;
                    try {
                        reasons = SipUtil.parseReasons(origReasons);
                    }
                    catch (SipParseException e) {
                        if (!ProxyBranchImpl.c_logger.isErrorEnabled()) ** GOTO lbl30
                        ProxyBranchImpl.c_logger.traceDebug(this, "cancel", this.getMyInfo() + e.getLocalizedMessage());
                    }
lbl30:
                    // 3 sources

                    this._state = 6;
                    ProxyBranchImpl.cancelRequest(this._request, this, reasons);
                    break;
                }
                case 0: 
                case 1: {
                    this._state = 5;
                    break;
                }
            }
        }
        this._isCancelled = true;
    }

    public void proxyBranchTimeout() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "proxyBranchTimeout " + this.getMyInfo());
        }
        this.executeTimeOut(false);
    }

    private void executeTimeOut(boolean isTimeout) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "executeTimeOut", (Object)isTimeout);
        }
        this.cancelProxyBranchTimer();
        if (this._state != 7) {
            this.cancel();
            if (isTimeout) {
                this._state = 3;
                this.updateBestResponse(this._request, 408, this);
                this.allBranchesCompleted();
            }
        } else {
            this.timeoutAllChildBranches(isTimeout);
        }
    }

    public void proxyTimedOut(boolean isTimeout) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "proxyTimedOut", this.getMyInfo());
        }
        this._parentTimedOut = true;
        this.executeTimeOut(isTimeout);
    }

    public String getBranchId() throws HeaderParseException, IllegalArgumentException {
        Request req = this._request.getRequest();
        ViaHeader via = (ViaHeader)req.getHeader("Via", true);
        return via.getBranch();
    }

    @Override
    public void clientTransactionTerminated(SipServletRequestImpl request) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "clientTransactionTerminated", "Notify all related TUs");
        }
        for (TransactionUserWrapper toToNotify : this.relatedTUs) {
            toToNotify.clientTransactionTerminated(request);
            if (!c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug(this, "clientTransactionTerminated", "Notify DTU " + toToNotify.getId());
        }
    }

    @Override
    public void setUsedDestination(SipURL lastUsedDestination) {
        this._latestDestination = lastUsedDestination;
    }

    @Override
    public SipURL getUsedDestination() {
        return this._latestDestination;
    }

    @Override
    public int getProxyBranchTimeout() {
        return this._proxyBranchTimeOut;
    }

    @Override
    public void setProxyBranchTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 1) {
            throw new IllegalArgumentException("setProxyBranchTimeout cannot handle value " + seconds);
        }
        if (this._proxy.getParallel()) {
            int proxyTimerTime = this._proxy.getProxyTimeout();
            if (this._proxy.getTimer() != null) {
                proxyTimerTime = this._proxy.getTimer().getTimeRemaining();
            }
            if (proxyTimerTime < seconds) {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append(this.getMyInfo());
                    buff.append("Failed to set timeout for parallels ProxyBranch");
                    buff.append(" Proxy timeout = ");
                    buff.append(proxyTimerTime);
                    buff.append(" requests timeout for this branch");
                    buff.append(seconds);
                    c_logger.traceDebug(this, "setProxyBranchTimeout", buff.toString());
                }
                throw new IllegalArgumentException("Value should be lower than ProxyTimeout in parallel case");
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setProxyBranchTimeout", this.getMyInfo() + "ProxyBranch expiration timeout = " + seconds + "seconds");
        }
        this._proxyBranchTimeOut = seconds;
        if (this._state == 2 || this.isStarted() && this._proxy.getParallel()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setProxyBranchTimeout", this.getMyInfo() + "Reschedule the timer for " + seconds + "from now");
            }
            if (this._timer != null) {
                this._timer.cancel();
            }
            this.setupProxyBranchTimer();
        } else {
            this._shouldStartTimer = true;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setProxyBranchTimeout", "When State will be TRYING or starting in parallel mode timer will start.");
            }
        }
    }

    @Override
    public SipServletResponse getResponse() {
        return this._lastResponse;
    }

    public boolean isInitial() {
        return this._isStarted;
    }

    @Override
    public boolean isStarted() {
        return this._state != 0;
    }

    @Override
    public List<ProxyBranch> getRecursedProxyBranches() {
        List<ProxyBranch> allBranches = Collections.emptyList();
        if (this._proxyBranches == null || this._proxyBranches.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getRecursedProxyBranches", this.getMyInfo() + "No ProxyBranches were created");
            }
            return allBranches;
        }
        for (ProxyBranch branch : this._proxyBranches) {
            if (!branch.getRecurse()) continue;
            if (allBranches.size() == 0) {
                allBranches = new ArrayList<ProxyBranch>();
            }
            allBranches.add(branch);
        }
        return allBranches;
    }

    @Override
    public Proxy getProxy() {
        return this._proxy;
    }

    @Override
    public void setAddToPath(boolean p) {
        this._appPath = p;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setAddToPath", this.getMyInfo() + "Add to path = " + this._appPath);
        }
    }

    @Override
    public boolean getAddToPath() {
        return this._appPath;
    }

    @Override
    public boolean getRecurse() {
        return this._isRecurse;
    }

    @Override
    public void setRecurse(boolean recurse) {
        this._isRecurse = recurse;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setRecurse", this.getMyInfo() + "This ProxyBranch is recurse = " + this._isRecurse);
        }
    }

    public ProxyBranchImpl findRecurseBranch(String branchId) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "findRecurseBranch", this.getMyInfo() + " branchID = " + branchId);
        }
        try {
            ProxyBranchImpl foundProxyBranch = null;
            for (int i = 0; i < this._proxyBranches.size() && foundProxyBranch != null; ++i) {
                ProxyBranchImpl proxyBranch = (ProxyBranchImpl)this._proxyBranches.get(i);
                if (!proxyBranch.isActive()) continue;
                foundProxyBranch = proxyBranch.getBranchId().equals(branchId) ? proxyBranch : proxyBranch.findRecurseBranch(branchId);
            }
        }
        catch (HeaderParseException e2) {
            ProxyBranchImpl.logException(e2);
            e2.printStackTrace();
        }
        return null;
    }

    public ProxyBranchImpl findRecurseBranchByUri(URI uri) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "findRecurseBranchByUri", this.getMyInfo() + "uri = " + uri);
        }
        ProxyBranchImpl foundProxyBranch = null;
        for (int i = 0; i < this._proxyBranches.size() && foundProxyBranch == null; ++i) {
            ProxyBranchImpl branch = (ProxyBranchImpl)this._proxyBranches.get(i);
            foundProxyBranch = branch.getUri().equals(uri) ? branch : branch.findRecurseBranchByUri(uri);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "findRecurseBranchByUri", this.getMyInfo() + "FoundBranch = " + foundProxyBranch);
        }
        return foundProxyBranch;
    }

    @Override
    public void onSendingRequest(ProxyBranchImpl branch, SipServletRequest request) {
        this.setupTimeOut();
        this._parent.onSendingRequest(branch, request);
    }

    @Override
    public void allBranchesCompleted() {
        if (this._state != 4) {
            this.cancelProxyBranchTimer();
            SipServletResponse response = this._bestResponse.getBestResponse();
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append(this.getMyInfo());
                buff.append("Forwarding the Best Response = ");
                buff.append(response);
                buff.append(" to Parent = ");
                buff.append(this._parent);
                c_logger.traceDebug(this, "allBranchesCompleted", buff.toString());
            }
            this._state = 4;
            this._parent.processResponse(this, response);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "allBranchesCompleted", this.getMyInfo() + " parent was already updated about this branch");
        }
    }

    void setupTimeOut() {
        if (this._state == 7 || this._proxy.getParallel() && this._shouldStartTimer) {
            this.setupProxyBranchTimer();
        }
    }

    public URI getUri() {
        return this._uri;
    }

    @Override
    protected Proxy getStatefullProxy() {
        return this.getProxy();
    }

    protected boolean getIsRecordRoute() {
        return this._isRecordRoute;
    }

    @Override
    protected boolean getIsParallel() {
        return this._proxy.getParallel();
    }

    public void failedToSend() {
        this._state = 8;
    }

    public void setStarted() {
        this._isStarted = true;
    }

    @Override
    SipURI getPathAddress(String transport) {
        return this._proxy.getPathAddress(transport);
    }

    @Override
    boolean getAddToPathValue() {
        return this.getAddToPath();
    }

    @Override
    public void setOutboundInterface(InetSocketAddress address) throws IllegalStateException, IllegalArgumentException, NullPointerException {
        if (address != null) {
            this._recordRouteURI = null;
            TransactionUserWrapper tu = this._originalReq.getTransactionUser();
            if (!tu.isValid() || tu.isInvalidating()) {
                throw new IllegalStateException("Session is already invalidated");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setOutboundInterface", "Attempting to set outbound interface to: " + address);
            }
            boolean isSet = false;
            int index = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
            if (index != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxUDP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTCP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTLS = index;
            }
            if (!isSet) {
                throw new IllegalArgumentException("address:" + address + " is not listed as allowed outbound interface.");
            }
        } else {
            throw new NullPointerException("Invalid address = null");
        }
    }

    @Override
    public void setOutboundInterface(InetAddress address) throws IllegalStateException, IllegalArgumentException, NullPointerException {
        if (address != null) {
            this._recordRouteURI = null;
            TransactionUserWrapper tu = this._originalReq.getTransactionUser();
            if (!tu.isValid()) {
                throw new IllegalStateException("Session is already invalidated");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setOutboundInterface", "Attempting to set outbound interface to: " + address);
            }
            boolean isSet = false;
            int index = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
            if (index != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxUDP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTCP = index;
            }
            if ((index = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
                isSet = true;
                this._preferedOutBoundIfaceIdxTLS = index;
            }
            if (!isSet) {
                throw new IllegalArgumentException("address:" + address + " is not listed as allowed outbound interface.");
            }
        } else {
            throw new NullPointerException("Invalid address = null");
        }
    }

    @Override
    public int getPreferedOutboundIface(String transport) {
        int returnValue = -1;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getPreferedOutboundIface", "transport = " + transport);
        }
        if (SIPTransactionStack.instance().getConfiguration().getSentByHost() != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getPreferedOutboundIface", "Return OUTBOUND_INTERFACE_NOT_DEFINED since the sentByHost property is set");
            }
            return -1;
        }
        if (transport == null || transport.equalsIgnoreCase("udp")) {
            returnValue = this._preferedOutBoundIfaceIdxUDP;
        } else if (transport.equalsIgnoreCase("tcp")) {
            returnValue = this._preferedOutBoundIfaceIdxTCP;
        } else if (transport.equalsIgnoreCase("tls")) {
            returnValue = this._preferedOutBoundIfaceIdxTLS;
        }
        return returnValue;
    }

    @Override
    protected boolean proxyBranchExists(URI nextHop) {
        return this._proxy.proxyBranchExists(nextHop);
    }

    public boolean isVirtual() {
        return this._isVirtual;
    }

    @Override
    public SipURI getPathURI() {
        return this._proxy.getPathURI();
    }

    @Override
    public boolean getRecordRoute() {
        return this._isRecordRoute;
    }

    @Override
    public void setRecordRoute(boolean includeRecordRoute) {
        this._isRecordRoute = includeRecordRoute;
    }

    @Override
    public ProxyParent getParent() {
        return this._parent;
    }

    @Override
    public SipServletRequest getRequest() {
        return this._request;
    }

    @Override
    public void addTransaction(String method) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "addTransaction", (Object)(" ProxyBrunch =" + this.getMyInfo()));
        }
        if (method != null && method.equals("CANCEL")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addTransaction", "Do NOT count transaction for CANCEL request ProxyBrunch" + this.getMyInfo());
            }
            return;
        }
        if (this._mainAssociatedTu != null) {
            this._mainAssociatedTu.addTransaction(method);
        } else {
            this._request.getTransactionUser().addTransaction(method);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "addTransaction", " ProxyBrunch =" + this.getMyInfo());
        }
    }

    @Override
    public void removeTransaction(String method) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "removeTransaction", (Object)("From method =" + method + " ProxyBrunch =" + this.getMyInfo()));
        }
        if (method != null && method.equals("CANCEL")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeTransaction", "Do NOT count transaction for CANCEL request ProxyBrunch" + this.getMyInfo());
            }
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeTransaction", "Remove transaction from all related TU for ProxyBranch = " + this.getMyInfo());
        }
        TransactionUserWrapper origTU = this._originalReq.getTransactionUser();
        for (TransactionUserWrapper tuToClose : this.relatedTUs) {
            if (!this._removedFromOrigTU && tuToClose == origTU) {
                this._removedFromOrigTU = true;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeTransaction", "Remove transaction from all related TUs" + tuToClose);
            }
            tuToClose.removeTransaction(method);
            if (!c_logger.isTraceDebugEnabled()) continue;
            c_logger.traceDebug(this, "removeTransaction", "Remove transaction from TU " + tuToClose.getId());
        }
        if (!this._removedFromOrigTU) {
            origTU.removeTransaction(method);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeTransaction", "Remove transaction from Original TU as well. OrigTU = " + origTU.getId());
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "removeTransaction", " ProxyBrunch =" + this.getMyInfo());
        }
    }

    public void setRemoveFromOriginalTU() {
        this._removedFromOrigTU = true;
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }
}

