/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.dar.selector.impl;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.dar.selector.ApplicationSelector;
import com.ibm.ws.sip.dar.util.StateInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class PropertyApplicationSelector
implements ApplicationSelector {
    private static final LogMgr c_logger = Log.get(PropertyApplicationSelector.class);
    private SipApplicationRouterInfo nullApplication = new SipApplicationRouterInfo(null, null, null, null, null, null);
    private HashMap<String, List<SipApplicationRouterInfo>> methodForApplicationMap = null;

    public PropertyApplicationSelector(HashMap<String, List<SipApplicationRouterInfo>> methodForApplicationMap) {
        this.methodForApplicationMap = methodForApplicationMap;
    }

    @Override
    public SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, Serializable stateInfoS) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getNextApplication");
        }
        if (directive.equals((Object)SipApplicationRoutingDirective.NEW)) {
            if (initialRequest == null) {
                return null;
            }
            StateInfo newStateInfo = new StateInfo();
            newStateInfo.setIndex(0);
            List<SipApplicationRouterInfo> appList = this.methodForApplicationMap.get(initialRequest.getMethod());
            if (appList == null) {
                return this.nullApplication;
            }
            if (0 >= appList.size()) {
                return this.nullApplication;
            }
            SipApplicationRouterInfo nextApp = appList.get(0);
            String subscriberURI = this.getURIFromTheRequest(initialRequest, nextApp.getSubscriberURI());
            SipApplicationRouterInfo returnVal = new SipApplicationRouterInfo(nextApp.getNextApplicationName(), nextApp.getRoutingRegion(), subscriberURI, nextApp.getRoutes(), nextApp.getRouteModifier(), newStateInfo);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Default application router, property file strategy, next application has been selected: " + nextApp.getNextApplicationName() + ".");
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "getNextApplication");
            }
            return returnVal;
        }
        if (directive.equals((Object)SipApplicationRoutingDirective.CONTINUE)) {
            if (initialRequest == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Application router insufficient state request is null");
                }
                throw new Error("Application router insufficient state request is null");
            }
            if (stateInfoS == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Application router insufficient state statInfo is null");
                }
                throw new Error("Application router insufficient state statInfo is null");
            }
            StateInfo stateInfo = (StateInfo)stateInfoS;
            stateInfo.increaseLastIndex();
            List<SipApplicationRouterInfo> appList = this.methodForApplicationMap.get(initialRequest.getMethod());
            if (appList == null) {
                return this.nullApplication;
            }
            if (stateInfo.getIndex() >= appList.size()) {
                return this.nullApplication;
            }
            SipApplicationRouterInfo nextApp = appList.get(stateInfo.getIndex());
            String subscriberURI = this.getURIFromTheRequest(initialRequest, nextApp.getSubscriberURI());
            SipApplicationRouterInfo returnVal = new SipApplicationRouterInfo(nextApp.getNextApplicationName(), nextApp.getRoutingRegion(), subscriberURI, nextApp.getRoutes(), nextApp.getRouteModifier(), stateInfo);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Default application router, property file strategy, next application has been selected: " + nextApp.getNextApplicationName() + ", chain index: " + stateInfo.getIndex());
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "getNextApplication");
            }
            return returnVal;
        }
        if (directive.equals((Object)SipApplicationRoutingDirective.REVERSE)) {
            StateInfo stateInfo = (StateInfo)stateInfoS;
            List<SipApplicationRouterInfo> appList = this.methodForApplicationMap.get(initialRequest.getMethod());
            String currentApplicationName = appList.get(stateInfo.getIndex()).getNextApplicationName();
            int newState = 0;
            for (SipApplicationRouterInfo appInfo : appList) {
                ++newState;
                if (!appInfo.getNextApplicationName().equals(currentApplicationName) || appInfo.getRoutingRegion() != SipApplicationRoutingRegion.ORIGINATING_REGION) continue;
                String subscriberURI = this.getURIFromTheRequest(initialRequest, appInfo.getSubscriberURI());
                SipApplicationRouterInfo returnVal = new SipApplicationRouterInfo(appInfo.getNextApplicationName(), appInfo.getRoutingRegion(), subscriberURI, appInfo.getRoutes(), appInfo.getRouteModifier(), Integer.valueOf(newState));
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceExit(this, "getNextApplication");
                }
                return returnVal;
            }
        }
        throw new Error("SipApplicationRoutingDirective is not one of NEW, CONTINUE, REVERSE");
    }

    private String getURIFromTheRequest(SipServletRequest request, String headerName) {
        URI returnVal = null;
        if (headerName != null) {
            String upperCaseHeader = headerName.toUpperCase();
            if (upperCaseHeader.equals("DAR:TO")) {
                returnVal = request.getTo().getURI();
            }
            if (upperCaseHeader.equals("DAR:FROM")) {
                returnVal = request.getFrom().getURI();
            }
        }
        if (returnVal == null) {
            return null;
        }
        return returnVal.toString();
    }

    public String toString() {
        StringBuffer objectString = new StringBuffer();
        Set<String> applications = this.methodForApplicationMap.keySet();
        for (String app : applications) {
            objectString.append(app).append(" = ").append(this.methodForApplicationMap.get(app)).append('\n');
        }
        return objectString.toString();
    }
}

