/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.header.ExtendedHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.CancelRequest;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestLine;
import com.ibm.ws.jain.protocol.ip.sip.message.ResponseImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersion;
import com.ibm.ws.jain.protocol.ip.sip.message.SipVersionFactory;
import com.ibm.ws.jain.protocol.ip.sip.message.StatusLine;
import com.ibm.ws.sip.parser.CharArray;
import com.ibm.ws.sip.parser.HeaderCreator;
import com.ibm.ws.sip.parser.URIParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.ContentLengthHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.HeaderParseException;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.SecurityHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;

public abstract class MessageParser {
    private static final LogMgr s_logger = Log.get(MessageParser.class);
    private static final byte[] INVITE = new byte[]{73, 78, 86, 73, 84, 69};
    private static final byte[] ACK = new byte[]{65, 67, 75};
    private static final byte[] BYE = new byte[]{66, 89, 69};
    private static final byte[] CANCEL = new byte[]{67, 65, 78, 67, 69, 76};
    private static final byte[] OPTIONS = new byte[]{79, 80, 84, 73, 79, 78, 83};
    private static final byte[] INFO = new byte[]{73, 78, 70, 79};
    private static final byte[] PRACK = new byte[]{80, 82, 65, 67, 75};
    private static final byte[] REGISTER = new byte[]{82, 69, 71, 73, 83, 84, 69, 82};
    private static final byte[] SUBSCRIBE = new byte[]{83, 85, 66, 83, 67, 82, 73, 66, 69};
    private static final byte[] NOTIFY = new byte[]{78, 79, 84, 73, 70, 89};
    private static final byte[] PUBLISH = new byte[]{80, 85, 66, 76, 73, 83, 72};
    private static final byte[] MESSAGE = new byte[]{77, 69, 83, 83, 65, 71, 69};
    private static final byte[] REFER = new byte[]{82, 69, 70, 69, 82};
    private static final byte[] UPDATE = new byte[]{85, 80, 68, 65, 84, 69};
    private static final byte[] KEEPALIVE = new byte[]{75, 69, 69, 80, 65, 76, 73, 86, 69};
    private static final byte[] PROXYERROR = new byte[]{80, 82, 79, 88, 89, 69, 82, 82, 79, 82};
    private String m_error = null;
    private int m_errorCode = 0;
    private URIParser m_uriParser = new URIParser();
    protected boolean m_startLineHuntingMode = false;
    private static final boolean s_acceptNonUtf8ByteSequences = ApplicationProperties.getProperties().getBoolean("acceptNonUtf8Bytes");

    public abstract Message parse(SipMessageByteBuffer var1);

    public abstract boolean hasMore();

    protected abstract boolean contentLengthHeaderRequired();

    public String getError() {
        return this.m_error;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void clearError() {
        this.m_error = null;
        this.m_errorCode = 0;
    }

    protected abstract void crlfReceived(boolean var1);

    protected Message parseStartLine(SipMessageByteBuffer buffer, CharsBuffer line) {
        RequestLine requestLine;
        boolean emptyLine;
        boolean isSend400ForWrongRequestUri = ApplicationProperties.getProperties().getBoolean("send400ForWrongRequestLine");
        this.m_error = null;
        this.m_errorCode = 0;
        do {
            line.reset();
            if (!this.readLine(buffer, line)) {
                return null;
            }
            emptyLine = line.getCharCount() == 0;
            this.crlfReceived(emptyLine);
        } while (emptyLine);
        char[] content = line.getCharArray();
        int length = line.getCharCount();
        if (length < 3) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Error: message start-line too short");
            }
            if (!isSend400ForWrongRequestUri) {
                return null;
            }
            this.setError(400, "Bad Request - start line is too short");
            RequestImpl reqImpl = new RequestImpl();
            reqImpl.setRequestLine(new RequestLine(null, "ILLEGAL"));
            return reqImpl;
        }
        if (content[0] == 'S' && content[1] == 'I' && content[2] == 'P') {
            ResponseImpl resImpl = new ResponseImpl();
            try {
                StatusLine statusLine = this.parseStatusLine(content, length);
                resImpl.setStatusLine(statusLine);
            }
            catch (SipParseException e2) {
                this.setError(400, "Bad Start-Line");
            }
            return resImpl;
        }
        String method = null;
        try {
            requestLine = this.parseRequestLine(content, length);
            method = requestLine.getMethod();
        }
        catch (SipParseException e3) {
            this.setError(400, "Bad Request - wrong start line: " + e3.getUnparsable());
            if (!isSend400ForWrongRequestUri) {
                return null;
            }
            requestLine = new RequestLine();
            requestLine.setMethod("ILLEGAL");
        }
        boolean isCancel = method != null && method.equals("CANCEL");
        RequestImpl reqImpl = isCancel ? new CancelRequest() : new RequestImpl();
        reqImpl.setRequestLine(requestLine);
        return reqImpl;
    }

    private StatusLine parseStatusLine(char[] line, int length) throws SipParseException {
        char space;
        int i;
        StatusLine statusLine = new StatusLine();
        int end = length;
        for (i = 0; i < end && line[i] != ' '; ++i) {
        }
        SipVersion version = SipVersionFactory.createSipVersion(line, 0, i);
        statusLine.setSipVersion(version);
        if (i >= end) {
            throw new SipParseException("SP expected after version, found end of line", "");
        }
        if (end - i < 3) {
            throw new SipParseException("Bad status code", "");
        }
        int digit1 = line[++i] - 48;
        int digit2 = line[++i] - 48;
        int digit3 = line[++i] - 48;
        if (0 > digit1 || digit1 > 9 || 0 > digit2 || digit2 > 9 || 0 > digit3 || digit3 > 9) {
            throw new SipParseException("Bad status code", "");
        }
        int code = 100 * digit1 + 10 * digit2 + digit3;
        statusLine.setStatusCode(code);
        if (i >= end) {
            throw new SipParseException("Space expected after status code, found end of line", "");
        }
        if ((space = line[++i]) != ' ') {
            throw new SipParseException("Space expected after status code", "");
        }
        while (++i < end && line[i] == ' ') {
        }
        int start = i;
        int len = end - start;
        if (len > 0) {
            statusLine.setReasonPhrase(code, line, start, len);
        }
        return statusLine;
    }

    private RequestLine parseRequestLine(char[] line, int length) throws SipParseException {
        int i;
        int end = length;
        for (i = 0; i < end && line[i] != ' '; ++i) {
        }
        String method = MessageParser.getMethod(line, 0, i);
        if (i >= end) {
            throw new SipParseException("Space expected after method in request line, found end of line", "");
        }
        int startReqUri = ++i;
        while (++i < end && line[i] != ' ') {
        }
        if (i >= end) {
            throw new SipParseException("Space expected after request URI in request line, found end of line", "");
        }
        URI uri = this.m_uriParser.parse(line, startReqUri, i - startReqUri);
        if (line[++i] != 'S' || line[++i] != 'I' || line[++i] != 'P' || line[++i] != '/' || line[++i] != '2' || line[++i] != '.' || line[++i] != '0') {
            this.setError(505, "Version Not Supported");
        }
        return new RequestLine(uri, method);
    }

    private static String getMethod(char[] array, int offset, int length) {
        byte[] compare;
        String method;
        if (length > 2) {
            block0 : switch (array[offset]) {
                case 'I': {
                    switch (array[offset + 2]) {
                        case 'V': {
                            method = "INVITE";
                            compare = INVITE;
                            break block0;
                        }
                        case 'F': {
                            method = "INFO";
                            compare = INFO;
                            break block0;
                        }
                    }
                    method = null;
                    compare = null;
                    break;
                }
                case 'A': {
                    method = "ACK";
                    compare = ACK;
                    break;
                }
                case 'B': {
                    method = "BYE";
                    compare = BYE;
                    break;
                }
                case 'C': {
                    method = "CANCEL";
                    compare = CANCEL;
                    break;
                }
                case 'K': {
                    method = "KEEPALIVE";
                    compare = KEEPALIVE;
                    break;
                }
                case 'O': {
                    method = "OPTIONS";
                    compare = OPTIONS;
                    break;
                }
                case 'P': {
                    switch (array[offset + 2]) {
                        case 'A': {
                            method = "PRACK";
                            compare = PRACK;
                            break block0;
                        }
                        case 'B': {
                            method = "PUBLISH";
                            compare = PUBLISH;
                            break block0;
                        }
                        case 'O': {
                            method = "PROXYERROR";
                            compare = PROXYERROR;
                            break block0;
                        }
                    }
                    method = null;
                    compare = null;
                    break;
                }
                case 'R': {
                    switch (array[offset + 2]) {
                        case 'G': {
                            method = "REGISTER";
                            compare = REGISTER;
                            break block0;
                        }
                        case 'F': {
                            method = "REFER";
                            compare = REFER;
                            break block0;
                        }
                    }
                    method = null;
                    compare = null;
                    break;
                }
                case 'S': {
                    method = "SUBSCRIBE";
                    compare = SUBSCRIBE;
                    break;
                }
                case 'N': {
                    method = "NOTIFY";
                    compare = NOTIFY;
                    break;
                }
                case 'M': {
                    method = "MESSAGE";
                    compare = MESSAGE;
                    break;
                }
                case 'U': {
                    method = "UPDATE";
                    compare = UPDATE;
                    break;
                }
                default: {
                    method = null;
                    compare = null;
                    break;
                }
            }
        } else {
            method = null;
            compare = null;
        }
        if (compare != null) {
            if (length == compare.length) {
                for (int i = offset + length - 1; i >= 0; --i) {
                    if (array[i] == compare[i]) continue;
                    method = null;
                    break;
                }
            } else {
                method = null;
            }
        }
        if (method == null) {
            method = new String(array, offset, length);
        }
        return method;
    }

    protected boolean parseHeaders(SipMessageByteBuffer source, Message dest, CharsBuffer line) {
        line.reset();
        while (this.readLine(source, line)) {
            if (line.getCharCount() == 0) {
                return true;
            }
            this.parseHeaderLine(line, dest);
            line.reset();
        }
        return false;
    }

    protected boolean parseHeaderLine(CharsBuffer source, Message dest) {
        int i;
        char[] line = source.getCharArray();
        int length = source.getCharCount();
        int headerNameSize = 0;
        for (i = 0; i < length; ++i) {
            char c = line[i];
            if (c == ':') {
                if (headerNameSize != 0) break;
                headerNameSize = i;
                break;
            }
            if (c != ' ' && c != '\t' || headerNameSize != 0) continue;
            headerNameSize = i;
        }
        if (i == length) {
            this.setError(400, "Bad Request. No colon in header line");
            return false;
        }
        if (headerNameSize == 0) {
            this.setError(400, "Bad Request. Expected header name before colon");
            return false;
        }
        HeaderImpl header = HeaderCreator.createHeader(line, headerNameSize);
        ++i;
        while (i < length && (line[i] == ' ' || line[i] == '\t')) {
            ++i;
        }
        int valueLen = length - i;
        boolean extendedHeader = header instanceof ExtendedHeader;
        boolean parseNestedHeader = false;
        if (extendedHeader) {
            parseNestedHeader = ((ExtendedHeader)header).isInCommaSeparated();
        } else if (header.isNested()) {
            parseNestedHeader = true;
        }
        if (parseNestedHeader) {
            this.parseNestedHeader(dest, header, line, i, valueLen);
        } else {
            block13: {
                CharArray hdrValue = this.getCharArray(line, i, valueLen);
                header.setValue(hdrValue);
                try {
                    header.parse();
                    this.validateRequiredHeaders(header, dest);
                }
                catch (Exception e2) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug(this, "parseHeaders", "Failed parsing header: " + header.getName(), e2);
                    }
                    if (MessageParser.parsingOptional(header)) break block13;
                    String headerName = header.getName();
                    this.setError(400, "Bad " + headerName + " header");
                }
            }
            dest.addHeader(header, false);
        }
        return true;
    }

    private void validateRequiredHeaders(HeaderImpl header, Message dest) throws SipParseException {
        CSeqHeader cseq;
        if (header instanceof CSeqHeader && dest instanceof Request && !(cseq = (CSeqHeader)((Object)header)).getMethod().equals(((Request)dest).getMethod())) {
            throw new SipParseException("Bad CSeq", "");
        }
    }

    public static boolean parsingOptional(HeaderImpl header) {
        if (header instanceof NameAddressHeader) {
            return false;
        }
        if (header instanceof SecurityHeader) {
            return false;
        }
        String name = header.getName();
        return name != "Call-ID" && name != "Content-Length" && name != "Content-Type" && name != "CSeq" && name != "Max-Forwards" && name != "RAck" && name != "Require" && name != "RSeq" && name != "Supported" && name != "Via" && name != "Timestamp";
    }

    private void parseNestedHeader(Message message, HeaderImpl header, char[] line, int offset, int length) {
        boolean brackets = false;
        boolean parenths = false;
        int start = offset;
        int end = offset + length;
        boolean endval = false;
        boolean endl = false;
        for (int i = offset; i <= end; ++i) {
            HeaderImpl nextHeader;
            block12: {
                if (i < end) {
                    switch (line[i]) {
                        case '\"': {
                            parenths = !parenths;
                            break;
                        }
                        case '<': {
                            brackets = true;
                            break;
                        }
                        case '>': {
                            brackets = false;
                            break;
                        }
                        case ',': {
                            if (brackets || parenths) break;
                            endval = true;
                        }
                    }
                } else {
                    endl = true;
                    endval = true;
                }
                if (!endval) continue;
                int valLen = i - start;
                CharArray hdrValue = this.getCharArray(line, start, valLen);
                start = i + 1;
                nextHeader = endl ? null : (HeaderImpl)header.clone();
                header.setValue(hdrValue);
                try {
                    header.parse();
                }
                catch (Exception e2) {
                    if (s_logger.isTraceDebugEnabled()) {
                        s_logger.traceDebug(this, "parseNestedHeader", "Failed parsing header: " + header.getName(), e2);
                    }
                    if (MessageParser.parsingOptional(header)) break block12;
                    String headerName = header.getName();
                    this.setError(400, "Bad " + headerName + " header");
                }
            }
            message.addHeader(header, false);
            endval = false;
            header = nextHeader;
        }
    }

    protected boolean parseBody(SipMessageByteBuffer buffer, Message message) {
        block21: {
            ContentTypeHeader contentTypeHeader;
            int contentLength;
            try {
                ContentLengthHeader contentLengthHeader = message.getContentLengthHeader();
                if (contentLengthHeader == null) {
                    if (this.contentLengthHeaderRequired()) {
                        this.setError(400, "Bad Request. Missing Content-Length header");
                        contentLength = 0;
                    } else {
                        contentLength = buffer.getRemaining();
                    }
                } else {
                    contentLength = contentLengthHeader.getContentLength();
                }
            }
            catch (HeaderParseException e2) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "parseBody", "Failed parsing Content-Length header", e2);
                }
                this.setError(400, "Bad Request. Invalid Content-Length");
                contentLength = 0;
            }
            if (contentLength == 0) {
                if (message.hasBody()) {
                    message.removeBody();
                }
                return true;
            }
            int maxContentLength = ApplicationProperties.getProperties().getInt("maxContentLength");
            if (maxContentLength < contentLength ? buffer.getRemaining() < maxContentLength : buffer.getRemaining() < contentLength) {
                return false;
            }
            try {
                contentTypeHeader = message.getContentTypeHeader();
            }
            catch (HeaderParseException e3) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "parseBody", "Failed parsing Content-Type header", e3);
                }
                return true;
            }
            if (contentTypeHeader == null) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("Error: no Content-Type header");
                }
            } else if (maxContentLength < contentLength) {
                int currentPosition = buffer.getReadPos();
                buffer.rewind(currentPosition + maxContentLength);
                this.setError(400, "Bad Request. Content-Length is greater than allowed");
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "parseBody", "Error: Content-Length is greater than allowed");
                }
            } else {
                byte[] body = new byte[contentLength];
                buffer.copyTo(body, 0, contentLength);
                try {
                    message.setBody(body, contentTypeHeader);
                }
                catch (SipParseException e4) {
                    if (!s_logger.isTraceDebugEnabled()) break block21;
                    s_logger.traceDebug(this, "parseBody", "Failed setting body", e4);
                }
            }
        }
        return true;
    }

    private boolean readLine(SipMessageByteBuffer source, CharsBuffer dest) {
        boolean complete;
        int length;
        int offset;
        byte[] bytes = source.getBytes();
        int read = this.readLine(bytes, offset = source.getReadPos(), length = source.getRemaining(), dest);
        boolean bl = complete = read > 0;
        if (complete) {
            source.rewind(offset + read);
        }
        return complete;
    }

    private int readLine(byte[] source, int offset, int length, CharsBuffer dest) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            int dstChar;
            byte ahead;
            int srcChar;
            byte b = source[i];
            if ((b & 0x80) == 128) {
                int value;
                int size = MessageParser.utf8size(b);
                if (size == -1) {
                    if (s_logger.isTraceFailureEnabled()) {
                        s_logger.traceFailure(this, "readLine", "Illegal byte value [" + (b & 0xFF) + ']');
                    }
                    value = b & 0xFF;
                    size = 1;
                    if (!s_acceptNonUtf8ByteSequences) {
                        this.setError(400, "Bad Message. Illegal Character.");
                        return 1;
                    }
                } else {
                    value = MessageParser.utf8(source, i, end - i, size);
                    if (value == -1) {
                        if (s_logger.isTraceFailureEnabled()) {
                            s_logger.traceFailure(this, "readLine", "Illegal byte value, expected utf-8 trail byte following utf-8 lead byte [" + (b & 0xFF) + ']');
                        }
                        if (!s_acceptNonUtf8ByteSequences) {
                            this.setError(400, "Bad Message. Illegal Character.");
                            return 1;
                        }
                        value = b & 0xFF;
                        size = 1;
                    }
                }
                srcChar = (char)value;
                i += size - 1;
            } else {
                srcChar = b;
            }
            boolean endl = false;
            if (srcChar == 13) {
                endl = true;
                if (i >= end - 1) break;
                ahead = source[i + 1];
                if (ahead == 10) {
                    ++i;
                } else if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("Warning: line terminated with CR only");
                }
            } else if (srcChar == 10) {
                endl = true;
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug("Warning: line terminated with LF only");
                }
            }
            if (endl) {
                if (i < end - 1) {
                    if (dest.getCharCount() > 0 && ((ahead = source[i + 1]) == 32 || ahead == 9)) {
                        endl = false;
                        do {
                            if (++i < end - 1) continue;
                            return 0;
                        } while ((ahead = source[i + 1]) == 32 || ahead == 9);
                    }
                    if (endl) {
                        return i - offset + 1;
                    }
                } else {
                    return dest.getCharCount() == 0 ? i - offset + 1 : 0;
                }
                dstChar = 32;
            } else {
                dstChar = srcChar;
            }
            dest.append((char)dstChar);
        }
        return 0;
    }

    public static int utf8size(byte b) {
        if ((b & 0x80) == 0) {
            return 1;
        }
        if ((b & 0xE0) == 192) {
            return 2;
        }
        if ((b & 0xF0) == 224) {
            return 3;
        }
        if ((b & 0xF8) == 240) {
            return 4;
        }
        if ((b & 0xFC) == 248) {
            return 5;
        }
        if ((b & 0xFE) == 252) {
            return 6;
        }
        return -1;
    }

    public static int utf8(byte[] bytes, int offset, int length) {
        byte b = bytes[offset];
        int octets = MessageParser.utf8size(b);
        int value = MessageParser.utf8(bytes, offset, length, octets);
        return value;
    }

    public static int utf8(byte[] bytes, int offset, int length, int octets) {
        int value;
        int b = bytes[offset];
        switch (octets) {
            case 1: {
                value = b;
                break;
            }
            case 2: {
                value = b & 0x1F;
                break;
            }
            case 3: {
                value = b & 0xF;
                break;
            }
            case 4: {
                value = b & 7;
                break;
            }
            case 5: {
                value = b & 3;
                break;
            }
            case 6: {
                value = b & 1;
                break;
            }
            default: {
                return -1;
            }
        }
        if (octets > length) {
            return -1;
        }
        for (int i = 1; i < octets; ++i) {
            b = bytes[offset + i];
            if ((b & 0xC0) != 128) {
                return -1;
            }
            value <<= 6;
            value |= b & 0x3F;
        }
        return value;
    }

    private CharArray getCharArray(char[] source, int offset, int length) {
        int len;
        int off;
        for (off = offset; off < offset + length && source[off] <= ' '; ++off) {
        }
        for (len = length - (off - offset); len >= 0 && source[off + len - 1] <= ' '; --len) {
        }
        CharArray result = CharArray.getFromPool(source, off, len);
        return result;
    }

    protected void setError(int errorCode, String error) {
        if (this.m_error == null) {
            this.m_error = error;
            this.m_errorCode = errorCode;
        }
    }

    public void setStartLineHuntingMode(boolean mode) {
        this.m_startLineHuntingMode = mode;
    }

    public boolean getStartLineHuntingMode() {
        return this.m_startLineHuntingMode;
    }
}

