/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.dispatch.Dispatcher;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transport.sip.netty.SipConnLink;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public abstract class SipInboundConnLink
extends SipConnLink {
    private static final TraceComponent tc = Tr.register(SipInboundConnLink.class);
    private boolean m_initialized = false;

    public SipInboundConnLink(SipInboundChannel sipInboundChannel, Channel channel) {
        super(sipInboundChannel, channel);
    }

    protected void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"init", (Object[])new Object[0]);
        }
        InetAddress remoteAddress = ((InetSocketAddress)this.m_channel.remoteAddress()).getAddress();
        int remotePort = ((InetSocketAddress)this.m_channel.remoteAddress()).getPort();
        InetSocketAddress address = new InetSocketAddress(remoteAddress, remotePort);
        this.setRemoteAddress(address);
        SIPListenningConnection listener = this.getSIPListenningConnection();
        Dispatcher.instance().queueConnectionAcceptedEvent(listener, this);
        this.connectionEstablished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready() {
        if (!this.m_initialized) {
            SipInboundConnLink sipInboundConnLink = this;
            synchronized (sipInboundConnLink) {
                if (!this.m_initialized) {
                    this.m_initialized = true;
                    this.init();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(SipMessageByteBuffer buff) {
        if (!this.m_initialized) {
            SipInboundConnLink sipInboundConnLink = this;
            synchronized (sipInboundConnLink) {
                if (!this.m_initialized) {
                    this.m_initialized = true;
                    this.init();
                }
            }
        }
        super.complete(buff);
    }

    @Override
    public void connect() throws IOException {
        throw new IOException("connect should not be called for inbound connection");
    }
}

