/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.executor.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.faulttolerance.executor.impl.CircuitBreakerImpl;
import com.ibm.ws.microprofile.faulttolerance.executor.impl.RetryImpl;
import com.ibm.ws.microprofile.faulttolerance.executor.impl.TimeoutImpl;
import com.ibm.ws.microprofile.faulttolerance.executor.impl.async.QueuedFuture;
import com.ibm.ws.microprofile.faulttolerance.spi.FTExecutionContext;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryResultCategory;
import com.ibm.ws.microprofile.faulttolerance.utils.FTDebug;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExecutionContextImpl
implements FTExecutionContext {
    private static final TraceComponent tc = Tr.register(ExecutionContextImpl.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    private final Method method;
    private final Object[] params;
    private final TimeoutImpl timeout;
    private final RetryImpl retry;
    private final CircuitBreakerImpl circuitBreaker;
    private final FallbackPolicy fallbackPolicy;
    private final MetricRecorder metricRecorder;
    private volatile int retries = 0;
    private volatile long startTime;
    private volatile long attemptStartTime;
    private volatile long queueStartTime;
    private volatile MetricRecorder.FallbackOccurred fallbackOccurred = MetricRecorder.FallbackOccurred.NO_FALLBACK;
    private volatile Throwable failure = null;
    private final String id;
    private volatile boolean closed = false;
    private boolean mainExecutionComplete = false;
    private QueuedFuture<?> queuedFuture = null;
    static final long serialVersionUID = 6785618331860039520L;

    public ExecutionContextImpl(String id, Method method, Object[] params, TimeoutImpl timeout, CircuitBreakerImpl circuitBreaker, FallbackPolicy fallbackPolicy, RetryImpl retry, MetricRecorder metricRecorder) {
        this.id = id;
        this.method = method;
        this.params = new Object[params.length];
        System.arraycopy(params, 0, this.params, 0, params.length);
        this.timeout = timeout;
        this.circuitBreaker = circuitBreaker;
        this.fallbackPolicy = fallbackPolicy;
        this.retry = retry;
        this.metricRecorder = metricRecorder;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.params;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public QueuedFuture<?> getQueuedFuture() {
        return this.queuedFuture;
    }

    public void setQueuedFuture(QueuedFuture<?> queuedFuture) {
        this.queuedFuture = queuedFuture;
    }

    public void start() {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.attemptStartTime = this.startTime = System.nanoTime();
        this.debugRelativeTime("start");
        if (this.timeout != null) {
            if (this.queuedFuture == null) {
                this.timeout.start(Thread.currentThread());
            } else {
                this.timeout.start(this.queuedFuture);
            }
        }
    }

    public void end() {
        this.debugRelativeTime("end");
        if (this.timeout != null) {
            this.timeout.stop();
            this.metricRecorder.recordTimeoutExecutionTime(System.nanoTime() - this.attemptStartTime);
            this.timeout.check();
        }
    }

    public long check() {
        this.debugRelativeTime("check");
        long remaining = -1L;
        if (this.timeout != null) {
            remaining = this.timeout.check();
        }
        return remaining;
    }

    /*
     * WARNING - void declaration
     */
    public void onRetry(Throwable t) {
        try {
            ++this.retries;
            this.debugRelativeTime("onRetry: " + this.retries);
            this.metricRecorder.incrementRetriesCount();
            if (this.timeout != null) {
                this.timeout.restart();
                this.attemptStartTime = System.nanoTime();
            }
            this.onAttemptComplete(t);
        }
        catch (RuntimeException runtimeException) {
            void e;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.ExecutionContextImpl", (String)"214", (Object)this, (Object[])new Object[]{t});
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMainExecutionComplete(Throwable t) {
        try {
            if (this.mainExecutionComplete) {
                return;
            }
            this.mainExecutionComplete = true;
            this.failure = t;
            this.onAttemptComplete(t);
            if (t instanceof CircuitBreakerOpenException) {
                this.close();
            }
            if (this.retry != null) {
                if (this.retry.canRetryFor(null, t)) {
                    this.metricRecorder.incrementRetryCalls(RetryResultCategory.MAX_RETRIES_REACHED, MetricRecorder.RetriesOccurred.WITH_RETRIES);
                } else if (this.retries > 0) {
                    this.metricRecorder.incrementRetryCalls(RetryResultCategory.NO_EXCEPTION, MetricRecorder.RetriesOccurred.WITH_RETRIES);
                } else {
                    this.metricRecorder.incrementRetryCalls(RetryResultCategory.NO_EXCEPTION, MetricRecorder.RetriesOccurred.NO_RETRIES);
                }
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.ExecutionContextImpl", (String)"259", (Object)this, (Object[])new Object[]{t});
            throw e;
        }
    }

    public void onFullExecutionComplete(Throwable t) {
        if (t == null) {
            this.metricRecorder.incrementInvocationSuccessCount(this.fallbackOccurred);
        } else {
            this.metricRecorder.incrementInvocationFailedCount(this.fallbackOccurred);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onAttemptComplete(Throwable t) {
        try {
            if (this.circuitBreaker != null) {
                if (t instanceof CircuitBreakerOpenException) {
                    this.metricRecorder.incrementCircuitBreakerCallsCircuitOpenCount();
                } else if (this.circuitBreaker.isFailure(null, t)) {
                    this.metricRecorder.incrementCircuitBreakerCallsFailureCount();
                } else {
                    this.metricRecorder.incrementCircuitBreakerCallsSuccessCount();
                }
            }
            if (t instanceof TimeoutException) {
                this.metricRecorder.incrementTimeoutTrueCount();
            } else {
                this.metricRecorder.incrementTimeoutFalseCount();
            }
        }
        catch (RuntimeException runtimeException) {
            void e;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.ExecutionContextImpl", (String)"298", (Object)this, (Object[])new Object[]{t});
            throw e;
        }
    }

    public void onFallback() {
        this.fallbackOccurred = MetricRecorder.FallbackOccurred.WITH_FALLBACK;
    }

    public RetryImpl getRetry() {
        return this.retry;
    }

    public FallbackPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public CircuitBreakerImpl getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public void setNested() {
        if (this.timeout != null && (this.retry.getMaxRetries() != 0 || this.fallbackPolicy != null)) {
            this.timeout.runSyncOnNewThread(Thread.currentThread());
        }
        int retriesRemaining = this.retry.getMaxRetries() - this.retries;
        if (this.retry.getMaxDuration() != null) {
            long delay;
            long maxDuration = this.retry.getMaxDuration().toNanos();
            long now = System.nanoTime();
            long elapsed = now - this.startTime;
            if ((maxDuration -= elapsed) <= (delay = this.retry.getDelay().toNanos())) {
                maxDuration = delay + 1L;
                retriesRemaining = 0;
            }
            this.retry.withMaxDuration(maxDuration, TimeUnit.NANOSECONDS);
        }
        this.retry.withMaxRetries(retriesRemaining);
    }

    public TimeoutImpl getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - void declaration
     */
    public void onQueued() {
        try {
            this.queueStartTime = System.nanoTime();
        }
        catch (RuntimeException runtimeException) {
            void e;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.ExecutionContextImpl", (String)"364", (Object)this, (Object[])new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onUnqueued() {
        try {
            this.metricRecorder.reportQueueWaitTime(System.nanoTime() - this.queueStartTime);
        }
        catch (RuntimeException runtimeException) {
            void e;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.ExecutionContextImpl", (String)"377", (Object)this, (Object[])new Object[0]);
            throw e;
        }
    }

    public void close() {
        if (this.timeout != null) {
            this.timeout.stop();
        }
        this.metricRecorder.recordTimeoutExecutionTime(System.nanoTime() - this.startTime);
        this.closed = true;
    }

    @Trivial
    public String toString() {
        return this.getDescriptor();
    }

    @Trivial
    public String getDescriptor() {
        return "Execution Context[" + this.id + "]";
    }

    @Trivial
    private void debugRelativeTime(String message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            FTDebug.debugRelativeTime((TraceComponent)tc, (String)this.getDescriptor(), (String)message, (long)this.startTime);
        }
    }
}

