/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.sib.api.jms.service.JmsServiceFacade;
import com.ibm.ws.sib.api.jmsra.JmsraConstants;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaDurableSubscriptionSharing;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfigurationProvider;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.SibRaMessageDeletionMode;
import com.ibm.ws.sib.ra.inbound.SibRaReadAhead;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointInvokerImpl;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.ra.SibRaActivationSpec;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;

final class SibRaActivationSpecImpl
implements SibRaActivationSpec,
SibRaEndpointConfigurationProvider,
FFDCSelfIntrospectable {
    private static final String DEFAULT_SHARE_DURABLE_SUBSCRIPTIONS = "InCluster";
    private static final int DEFAULT_RETRY_INTERVAL = 30;
    private static final long DEFAULT_FAILING_MESSAGE_DELAY = 0L;
    private transient ResourceAdapter _resourceAdapter;
    private String _busName = null;
    private String _userName = null;
    private String _password = null;
    private String _destinationType;
    private String _destinationName = null;
    private String _messageSelector = null;
    private String _discriminator = null;
    private String _subscriptionName = null;
    private String _durableSubscriptionHome = null;
    private String _shareDurableSubscriptions = "InCluster";
    private Integer _maxBatchSize = 1;
    private String _messageDeletionMode = "Single";
    private Integer _maxConcurrency = 10;
    private String _target;
    private String _targetType;
    private String _targetSignificance;
    private String _targetTransportChain;
    private String _providerEndpoints;
    private String _targetTransport;
    private Boolean _useServerSubject = Boolean.TRUE;
    private Boolean _alwaysActivateAllMDBs = Boolean.FALSE;
    private Integer _retryInterval = 30;
    private Long _failingMessageDelay = 0L;
    private Integer _maxSequentialMessageFailure = -1;
    private Integer _autoStopSequentialMessageFailure = 0;
    private Boolean _useDestinationWildcard = Boolean.FALSE;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String CLASS_NAME = SibRaActivationSpecImpl.class.getName();
    private static final Map<String, SibRaDurableSubscriptionSharing> SUBSCRIPTION_SHAREABILITY = new HashMap<String, SibRaDurableSubscriptionSharing>(3);
    private static final Map<String, DestinationType> DESTINATION_TYPES;
    private static final Map<String, SibRaMessageDeletionMode> MESSAGE_DELETION_MODES;
    private static final TraceComponent TRACE;
    private static final TraceComponent CONFIG_TRACE;
    private static TraceNLS NLS;

    SibRaActivationSpecImpl() {
    }

    public void setBusName(String busName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"BusName", (Object)busName);
        }
        this._busName = busName;
    }

    public String getBusName() {
        return this._busName;
    }

    public void setUserName(String userName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"UserName", (Object)userName);
        }
        this._userName = userName;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setPassword(String password) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Password", (Object)(password == null ? null : "*****"));
        }
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public void setDestinationType(String destinationType) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"DestinationType", (Object)destinationType);
        }
        this._destinationType = destinationType;
    }

    public String getDestinationType() {
        return this._destinationType;
    }

    public void setDestinationName(String destinationName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"DestinationName", (Object)destinationName);
        }
        this._destinationName = destinationName;
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    public void setMessageSelector(String messageSelector) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MessageSelector", (Object)messageSelector);
        }
        this._messageSelector = messageSelector;
    }

    public String getMessageSelector() {
        return this._messageSelector;
    }

    public void setDiscriminator(String discriminator) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Discriminator", (Object)discriminator);
        }
        this._discriminator = discriminator;
    }

    public String getDiscriminator() {
        return this._discriminator;
    }

    public void setSubscriptionName(String subscriptionName) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"SubscriptionName", (Object)subscriptionName);
        }
        this._subscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public void setDurableSubscriptionHome(String durableSubscriptionHome) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"DurableSubscriptionHome", (Object)durableSubscriptionHome);
        }
        this._durableSubscriptionHome = durableSubscriptionHome;
    }

    public String getDurableSubscriptionHome() {
        return this._durableSubscriptionHome;
    }

    public void setShareDurableSubscriptions(String shareDurableSubscriptions) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"ShareDurableSubscriptions", (Object)shareDurableSubscriptions);
        }
        this._shareDurableSubscriptions = shareDurableSubscriptions;
    }

    public String getShareDurableSubscriptions() {
        return this._shareDurableSubscriptions;
    }

    public void setMaxBatchSize(Integer maxBatchSize) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MaxBatchSize", (Object)maxBatchSize);
        }
        this._maxBatchSize = maxBatchSize;
    }

    public void setMaxBatchSize(String maxBatchSize) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MaxBatchSize", (Object)maxBatchSize);
        }
        this._maxBatchSize = maxBatchSize == null ? null : Integer.valueOf(maxBatchSize);
    }

    public Integer getMaxBatchSize() {
        return this._maxBatchSize;
    }

    public void setMessageDeletionMode(String messageDeletionMode) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MessageDeletionMode", (Object)messageDeletionMode);
        }
        this._messageDeletionMode = messageDeletionMode;
    }

    public String getMessageDeletionMode() {
        return this._messageDeletionMode;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MaxConcurrency", (Object)maxConcurrency);
        }
        this._maxConcurrency = maxConcurrency;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"MaxConcurrency", (Object)maxConcurrency);
        }
        this._maxConcurrency = maxConcurrency == null ? null : Integer.valueOf(maxConcurrency);
    }

    public Integer getMaxConcurrency() {
        return this._maxConcurrency;
    }

    public String getProviderEndpoints() {
        return this._providerEndpoints;
    }

    public void setProviderEndpoints(String providerEndpoints) {
        this._providerEndpoints = providerEndpoints;
    }

    public String getTargetTransport() {
        return this._targetTransport;
    }

    public void setTargetTransport(String targetTransport) {
        this._targetTransport = targetTransport;
    }

    public void validate() throws InvalidPropertyException {
        String methodName = "validate";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
        ArrayList<String> failedPropsMessages = new ArrayList<String>();
        ArrayList<PropertyDescriptor> invalidProperties = new ArrayList<PropertyDescriptor>();
        try {
            if (SibRaActivationSpecImpl.isSet(this._destinationName)) {
                if (!SibRaActivationSpecImpl.isSet(this._busName)) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid BusName - BusName was " + this._busName));
                    }
                    failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_BUSNAME_CWSIV0504", null, null));
                    invalidProperties.add(new PropertyDescriptor("BusName", SibRaActivationSpec.class));
                }
                if (!DESTINATION_TYPES.keySet().contains(this._destinationType)) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination Type - We expected a destination type of Queue or TopicSpace or Port or Service but we got " + this._destinationType));
                    }
                    failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_DESTINATION_TYPE_CWSIV0505", new Object[]{"Queue", "TopicSpace", "Port", "Service", this._destinationType}, null));
                    invalidProperties.add(new PropertyDescriptor("DestinationType", SibRaActivationSpec.class));
                }
                if (Boolean.TRUE.equals(this._useDestinationWildcard) && "TopicSpace".equals(this._destinationType)) {
                    failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_USEDESTWILDCARD_CWSIV0515", null, null));
                    invalidProperties.add(new PropertyDescriptor("UseDestinationWildcard", SibRaActivationSpec.class));
                }
                if ("TopicSpace".equals(this._destinationType) && SibRaActivationSpecImpl.isSet(this._subscriptionName)) {
                    if (!SUBSCRIPTION_SHAREABILITY.keySet().contains(this._shareDurableSubscriptions)) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid shareDurableSubscriptions - We expect a value of " + SibRaDurableSubscriptionSharing.ALWAYS + ", " + SibRaDurableSubscriptionSharing.NEVER + " or " + SibRaDurableSubscriptionSharing.CLUSTER_ONLY + " but we got " + this._shareDurableSubscriptions));
                        }
                        failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_SHARE_DURSUB_CWSIV0506", new Object[]{SibRaDurableSubscriptionSharing.ALWAYS, SibRaDurableSubscriptionSharing.NEVER, SibRaDurableSubscriptionSharing.CLUSTER_ONLY, this._shareDurableSubscriptions}, null));
                        invalidProperties.add(new PropertyDescriptor("ShareDurableSubscriptions", SibRaActivationSpec.class));
                    }
                    if (!SibRaActivationSpecImpl.isSet(this._durableSubscriptionHome)) {
                        failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_DURSUBHOME_CWSIV0507", null, null));
                        invalidProperties.add(new PropertyDescriptor("DurableSubscriptionHome", SibRaActivationSpec.class));
                    }
                }
            } else if (!DESTINATION_TYPES.keySet().contains(this._destinationType) || "TopicSpace".equals(this._destinationType)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination Type - No destination was specified so we expected a destination type of Queue or Port or Service but we got " + this._destinationType));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_DESTINATION_TYPE_CWSIV0508", new Object[]{"Queue", "Port", "Service", this._destinationType}, null));
                invalidProperties.add(new PropertyDescriptor("DestinationType", SibRaActivationSpec.class));
            }
            if (this._maxBatchSize == null || this._maxBatchSize < 1) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_MAXBATCH_CWSIV0509", null, null));
                invalidProperties.add(new PropertyDescriptor("MaxBatchSize", SibRaActivationSpec.class));
            }
            if (!MESSAGE_DELETION_MODES.keySet().contains(this._messageDeletionMode)) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Message Deletion Mode we expected a mode of " + SibRaMessageDeletionMode.SINGLE + " or " + SibRaMessageDeletionMode.BATCH + " or " + SibRaMessageDeletionMode.APPLICATION + " but we got " + this._messageDeletionMode));
                }
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_DELETION_MODE_CWSIV0510", new Object[]{SibRaMessageDeletionMode.SINGLE, SibRaMessageDeletionMode.BATCH, SibRaMessageDeletionMode.APPLICATION, this._messageDeletionMode}, null));
                invalidProperties.add(new PropertyDescriptor("MessageDeletionMode", SibRaActivationSpec.class));
            }
            if (this._maxConcurrency == null || this._maxConcurrency < 1) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_MAXCONC_CWSIV0511", null, null));
                invalidProperties.add(new PropertyDescriptor("MaxConcurrency", SibRaActivationSpec.class));
            }
            if ("".equals(this._targetType)) {
                this._targetType = "BINDING_THEN_CLIENT";
            }
            if ("".equals(this._target)) {
                this._target = JmsraConstants.DEFAULT_TARGET;
            }
            if (null == this._targetType || "".equals(this._targetType)) {
                this._targetType = "ME";
            } else if (!("BusMember".equals(this._targetType) || "ME".equals(this._targetType) || "Custom".equals(this._targetType))) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_TARGET_TYPE_CWSIV0512", new Object[]{"BusMember", "ME", "Custom", this._targetType}, null));
                invalidProperties.add(new PropertyDescriptor("targetType", SibRaActivationSpec.class));
            }
            if (null == this._targetSignificance || "".equals(this._targetSignificance)) {
                this._targetSignificance = "Required";
            } else if (!"Preferred".equals(this._targetSignificance) && !"Required".equals(this._targetSignificance)) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_TARGET_SIGNIFICANCE_CWSIV0513", new Object[]{"Preferred", "Required", this._targetSignificance}, null));
                invalidProperties.add(new PropertyDescriptor("targetSignificance", SibRaActivationSpec.class));
            }
            if (this._useServerSubject.booleanValue() && SibRaActivationSpecImpl.isSet(this._providerEndpoints)) {
                failedPropsMessages.add(NLS.getFormattedMessage("INVALID_PROPERTY_PROVIDER_ENDPOINTS_CWSIV0514", new Object[]{this._providerEndpoints}, null));
                invalidProperties.add(new PropertyDescriptor("providerEndpoints", SibRaActivationSpec.class));
            }
        }
        catch (IntrospectionException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "validate"), (String)FFDC_PROBE_1, (Object)this);
        }
        if (!invalidProperties.isEmpty()) {
            PropertyDescriptor[] invalidPropertyArray = invalidProperties.toArray(new PropertyDescriptor[invalidProperties.size()]);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Invalid properties found:", failedPropsMessages);
            }
            InvalidPropertyException exc = new InvalidPropertyException(NLS.getFormattedMessage("INVALID_PROPERTIES_CWSIV0501", new Object[]{this, failedPropsMessages}, null));
            exc.setInvalidPropertyDescriptors(invalidPropertyArray);
            throw exc;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setResourceAdapter", (Object)resourceAdapter);
        }
        this._resourceAdapter = resourceAdapter;
    }

    public void setTarget(String target) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTarget", (Object)target);
        }
        this._target = target;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTargetType(String targetType) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetType", (Object)targetType);
        }
        this._targetType = targetType;
    }

    public String getTargetType() {
        return this._targetType;
    }

    public void setTargetSignificance(String targetSignificance) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetSignificance", (Object)targetSignificance);
        }
        this._targetSignificance = targetSignificance;
    }

    public void setTargetTransportChain(String targetTransportChain) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetTransportChain", (Object)targetTransportChain);
        }
        this._targetTransportChain = targetTransportChain;
    }

    public String getTargetSignificance() {
        return this._targetSignificance;
    }

    public String getTargetTransportChain() {
        return this._targetTransportChain;
    }

    public void setUseServerSubject(Boolean useServerSubject) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setUseServerSubject", (Object)useServerSubject);
        }
        this._useServerSubject = useServerSubject;
    }

    public Boolean getUseServerSubject() {
        return this._useServerSubject;
    }

    public Integer getMaxSequentialMessageFailure() {
        return this._maxSequentialMessageFailure;
    }

    public void setMaxSequentialMessageFailure(Integer maxSequentialMessageFailure) {
        this._maxSequentialMessageFailure = maxSequentialMessageFailure;
    }

    public void setMaxSequentialMessageFailure(String maxSequentialMessageFailure) {
        this._maxSequentialMessageFailure = maxSequentialMessageFailure == null ? null : Integer.valueOf(maxSequentialMessageFailure);
    }

    public Integer getAutoStopSequentialMessageFailure() {
        return this._autoStopSequentialMessageFailure;
    }

    public void setAutoStopSequentialMessageFailure(Integer autoStopSequentialMessageFailure) {
        this._autoStopSequentialMessageFailure = autoStopSequentialMessageFailure;
    }

    public void setAutoStopSequentialMessageFailure(String autoStopSequentialMessageFailure) {
        this._autoStopSequentialMessageFailure = autoStopSequentialMessageFailure == null ? null : Integer.valueOf(autoStopSequentialMessageFailure);
    }

    public void setAlwaysActivateAllMDBs(Boolean alwaysActivateAllMDBs) {
        this._alwaysActivateAllMDBs = alwaysActivateAllMDBs;
    }

    public Boolean getAlwaysActivateAllMDBs() {
        return this._alwaysActivateAllMDBs;
    }

    public void setRetryInterval(Integer retryInterval) {
        this._retryInterval = retryInterval;
    }

    public void setRetryInterval(String retryInterval) {
        this._retryInterval = retryInterval == null ? null : Integer.valueOf(retryInterval);
    }

    public Integer getRetryInterval() {
        return this._retryInterval;
    }

    public Long getFailingMessageDelay() {
        return this._failingMessageDelay;
    }

    public void setFailingMessageDelay(Long delay) {
        this._failingMessageDelay = delay;
    }

    public void setUseDestinationWildcard(Boolean useDestinationWildcard) {
        this._useDestinationWildcard = useDestinationWildcard;
    }

    public Boolean getUseDestinationWildcard() {
        return this._useDestinationWildcard;
    }

    public String toString() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addParent("resourceAdapter", this._resourceAdapter);
        generator.addField("busName", this._busName);
        generator.addField("userName", this._userName);
        generator.addPasswordField("password", this._password);
        generator.addField("destinationType", this._destinationType);
        generator.addField("destinationName", this._destinationName);
        generator.addField("messageSelector", this._messageSelector);
        generator.addField("discriminators", this._discriminator);
        generator.addField("subscriptionName", this._subscriptionName);
        generator.addField("durableSubscriptionHome", this._durableSubscriptionHome);
        generator.addField("shareDurableSubscriptions", this._shareDurableSubscriptions);
        generator.addField("maxBatchSize", this._maxBatchSize);
        generator.addField("messageDeletionMode", this._messageDeletionMode);
        generator.addField("maxConcurrency", this._maxConcurrency);
        generator.addField("target", this._target);
        generator.addField("targetType", this._targetType);
        generator.addField("targetSignificance", this._targetSignificance);
        generator.addField("useServerSubject", this._useServerSubject);
        generator.addField("providerEndpoints", this._providerEndpoints);
        generator.addField("alwaysActivateAllMDBs", this._alwaysActivateAllMDBs);
        generator.addField("retryInterval", this._retryInterval);
        generator.addField("useServerSubject", this._useServerSubject);
        generator.addField("failingMessageDelay", this._failingMessageDelay);
        generator.addField("useDestinationWildcard", this._useDestinationWildcard);
        return generator.getStringRepresentation();
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    private static boolean isSet(String string) {
        return string != null && !string.equals("");
    }

    public SibRaEndpointInvoker getEndpointInvoker() throws ResourceAdapterInternalException {
        return new SibRaEndpointInvokerImpl();
    }

    public SibRaEndpointConfiguration getEndpointConfiguration() throws InvalidPropertyException, ResourceAdapterInternalException {
        String methodName = "getEndpointConfiguration";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration");
        }
        SibRaEndpointConfigurationImpl configuration = new SibRaEndpointConfigurationImpl();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration", (Object)configuration);
        }
        return configuration;
    }

    static {
        SUBSCRIPTION_SHAREABILITY.put(DEFAULT_SHARE_DURABLE_SUBSCRIPTIONS, SibRaDurableSubscriptionSharing.CLUSTER_ONLY);
        SUBSCRIPTION_SHAREABILITY.put("AlwaysShared", SibRaDurableSubscriptionSharing.ALWAYS);
        SUBSCRIPTION_SHAREABILITY.put("NeverShared", SibRaDurableSubscriptionSharing.NEVER);
        DESTINATION_TYPES = new HashMap<String, DestinationType>(4);
        DESTINATION_TYPES.put("Queue", DestinationType.QUEUE);
        DESTINATION_TYPES.put("TopicSpace", DestinationType.TOPICSPACE);
        DESTINATION_TYPES.put("Port", DestinationType.PORT);
        DESTINATION_TYPES.put("Service", DestinationType.SERVICE);
        MESSAGE_DELETION_MODES = new HashMap<String, SibRaMessageDeletionMode>(3);
        MESSAGE_DELETION_MODES.put("Single", SibRaMessageDeletionMode.SINGLE);
        MESSAGE_DELETION_MODES.put("Batch", SibRaMessageDeletionMode.BATCH);
        MESSAGE_DELETION_MODES.put("Application", SibRaMessageDeletionMode.APPLICATION);
        TRACE = SibRaUtils.getTraceComponent(SibRaActivationSpecImpl.class);
        CONFIG_TRACE = SibRaUtils.getTraceComponent(SibRaEndpointConfigurationImpl.class);
        NLS = SibRaUtils.getTraceNls();
    }

    private class SibRaEndpointConfigurationImpl
    implements SibRaEndpointConfiguration {
        private final SIDestinationAddressFactory _destinationAddressFactory;

        private SibRaEndpointConfigurationImpl() throws InvalidPropertyException, ResourceAdapterInternalException {
            String methodName = "SibRaEndpointConfigurationImpl";
            if (TraceComponent.isAnyTracingEnabled() && CONFIG_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)CONFIG_TRACE, (String)"SibRaEndpointConfigurationImpl");
            }
            SibRaActivationSpecImpl.this.validate();
            try {
                this._destinationAddressFactory = JmsServiceFacade.getSIDestinationAddressFactory();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".SibRaEndpointConfigurationImpl." + "SibRaEndpointConfigurationImpl"), (String)SibRaActivationSpecImpl.FFDC_PROBE_2, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && CONFIG_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)CONFIG_TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("DEST_FACTORY_CWSIV0502", new Object[]{exception}, null), (Throwable)exception);
            }
            if (TraceComponent.isAnyTracingEnabled() && CONFIG_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)CONFIG_TRACE, (String)"SibRaEndpointConfigurationImpl");
            }
        }

        public SIDestinationAddress getDestination() {
            String methodName = "getDestination";
            if (TraceComponent.isAnyTracingEnabled() && CONFIG_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)CONFIG_TRACE, (String)"getDestination");
            }
            SIDestinationAddress destination = SibRaActivationSpecImpl.this._destinationName == null ? null : this._destinationAddressFactory.createSIDestinationAddress(SibRaActivationSpecImpl.this._destinationName, false);
            if (TraceComponent.isAnyTracingEnabled() && CONFIG_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)CONFIG_TRACE, (String)"getDestination", (Object)destination);
            }
            return destination;
        }

        public String getAllowMessageGathering() {
            return null;
        }

        public String getDestinationName() {
            return SibRaActivationSpecImpl.this._destinationName;
        }

        public DestinationType getDestinationType() {
            return (DestinationType)DESTINATION_TYPES.get(SibRaActivationSpecImpl.this._destinationType);
        }

        public String getDiscriminator() {
            return SibRaActivationSpecImpl.this._discriminator;
        }

        public int getMaxConcurrency() {
            return SibRaActivationSpecImpl.this._maxConcurrency;
        }

        public int getMaxBatchSize() {
            return SibRaActivationSpecImpl.this._maxBatchSize;
        }

        public String getBusName() {
            return SibRaActivationSpecImpl.this._busName;
        }

        public String getUserName() {
            return SibRaActivationSpecImpl.this._userName;
        }

        public String getPassword() {
            return SibRaActivationSpecImpl.this._password;
        }

        public String getMessageSelector() {
            return SibRaActivationSpecImpl.this._messageSelector;
        }

        public String getDurableSubscriptionName() {
            return SibRaActivationSpecImpl.this._subscriptionName;
        }

        public String getDurableSubscriptionHome() {
            return SibRaActivationSpecImpl.this._durableSubscriptionHome;
        }

        public SibRaDurableSubscriptionSharing getShareDurableSubscriptions() {
            return (SibRaDurableSubscriptionSharing)SUBSCRIPTION_SHAREABILITY.get(SibRaActivationSpecImpl.this._shareDurableSubscriptions);
        }

        public SibRaMessageDeletionMode getMessageDeletionMode() {
            return (SibRaMessageDeletionMode)MESSAGE_DELETION_MODES.get(SibRaActivationSpecImpl.this._messageDeletionMode);
        }

        public boolean isDurableSubscription() {
            return "TopicSpace".equals(SibRaActivationSpecImpl.this._destinationType) && SibRaActivationSpecImpl.isSet(SibRaActivationSpecImpl.this._subscriptionName);
        }

        public SelectorDomain getSelectorDomain() {
            return SelectorDomain.SIMESSAGE;
        }

        public boolean getShareDataSourceWithCMP() {
            return false;
        }

        public String getTargetTransportChain() {
            return SibRaActivationSpecImpl.this._targetTransportChain;
        }

        public SibRaReadAhead getReadAhead() {
            return SibRaReadAhead.DEFAULT;
        }

        public String getTarget() {
            return SibRaActivationSpecImpl.this._target;
        }

        public String getTargetType() {
            return SibRaActivationSpecImpl.this._targetType;
        }

        public String getTargetSignificance() {
            return SibRaActivationSpecImpl.this._targetSignificance;
        }

        public ActivationSpec getActivationSpec() {
            return SibRaActivationSpecImpl.this;
        }

        public int getMaxSequentialMessageFailure() {
            return SibRaActivationSpecImpl.this._maxSequentialMessageFailure;
        }

        public int getAutoStopSequentialMessageFailure() {
            return SibRaActivationSpecImpl.this._autoStopSequentialMessageFailure;
        }

        public String toString() {
            SibRaStringGenerator generator = new SibRaStringGenerator(this);
            generator.addField("SibRaActivationSpecImpl.this", SibRaActivationSpecImpl.this);
            return generator.getStringRepresentation();
        }

        public boolean isJMSRa() {
            return false;
        }

        public String getProviderEndpoints() {
            return SibRaActivationSpecImpl.this._providerEndpoints;
        }

        public Boolean getAlwaysActivateAllMDBs() {
            return SibRaActivationSpecImpl.this._alwaysActivateAllMDBs;
        }

        public int getRetryInterval() {
            return SibRaActivationSpecImpl.this._retryInterval;
        }

        public Boolean getUseDestinationWildcard() {
            return SibRaActivationSpecImpl.this._useDestinationWildcard;
        }

        public boolean getUseServerSubject() {
            return SibRaActivationSpecImpl.this._useServerSubject;
        }

        public Long getFailingMessageDelay() {
            return SibRaActivationSpecImpl.this._failingMessageDelay;
        }

        public String getTargetTransport() {
            return SibRaActivationSpecImpl.this._targetTransport;
        }

        public String getSubscriptionDurability() {
            return null;
        }
    }
}

