/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

import jakarta.data.Sort;
import jakarta.data.page.PageRequest;
import java.util.Iterator;
import java.util.List;

public class Order<T>
implements Iterable<Sort<? super T>> {
    private final List<Sort<? super T>> sortBy;

    private Order(List<Sort<? super T>> sortBy) {
        this.sortBy = sortBy;
    }

    @SafeVarargs
    public static <T> Order<T> by(Sort<? super T> ... sortBy) {
        return new Order<T>(List.of(sortBy));
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Order && this.sortBy.equals(((Order)other).sortBy);
    }

    public List<Sort<? super T>> sorts() {
        return this.sortBy;
    }

    public int hashCode() {
        return this.sortBy.hashCode();
    }

    @Override
    public Iterator<Sort<? super T>> iterator() {
        return this.sortBy.iterator();
    }

    public PageRequest<T> page(long pageNumber) {
        return PageRequest.ofPage(pageNumber).sortBy(this.sortBy);
    }

    public PageRequest<T> pageSize(int size) {
        return PageRequest.ofSize(size).sortBy(this.sortBy);
    }

    public String toString() {
        return this.sortBy.toString();
    }
}

