/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data;

import jakarta.data.Direction;

public record Sort<T>(String property, boolean isAscending, boolean ignoreCase) {
    public Sort {
        if (property == null) {
            throw new NullPointerException("property is required");
        }
    }

    public static <T> Sort<T> asc(String property) {
        return new Sort<T>(property, true, false);
    }

    public static <T> Sort<T> ascIgnoreCase(String property) {
        return new Sort<T>(property, true, true);
    }

    public static <T> Sort<T> desc(String property) {
        return new Sort<T>(property, false, false);
    }

    public static <T> Sort<T> descIgnoreCase(String property) {
        return new Sort<T>(property, false, true);
    }

    public static <T> Sort<T> of(String property, Direction direction, boolean ignoreCase) {
        if (direction == null) {
            throw new NullPointerException("direction is required");
        }
        return new Sort<T>(property, direction.equals((Object)Direction.ASC), ignoreCase);
    }

    public boolean isDescending() {
        return !this.isAscending;
    }
}

